/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestEntriesTable;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetricsUtil;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestEntriesMetadataTable
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestEntriesMetadataTable(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testEntriesTable() {
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        ManifestEntriesTable entriesTable = new ManifestEntriesTable((Table)this.table);
        Schema readSchema = ManifestEntry.getSchema((Types.StructType)this.table.spec().partitionType());
        Schema expectedSchema = TypeUtil.join((Schema)readSchema, (Schema)MetricsUtil.readableMetricsSchema((Schema)this.table.schema(), (Schema)readSchema));
        Assert.assertEquals((String)"A tableScan.select() should prune the schema", (Object)expectedSchema.asStruct(), (Object)entriesTable.schema().asStruct());
    }

    @Test
    public void testEntriesTableScan() {
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        ManifestEntriesTable entriesTable = new ManifestEntriesTable((Table)this.table);
        TableScan scan = entriesTable.newScan();
        Schema readSchema = ManifestEntry.getSchema((Types.StructType)this.table.spec().partitionType());
        Schema expectedSchema = TypeUtil.join((Schema)readSchema, (Schema)MetricsUtil.readableMetricsSchema((Schema)this.table.schema(), (Schema)readSchema));
        Assert.assertEquals((String)"A tableScan.select() should prune the schema", (Object)expectedSchema.asStruct(), (Object)scan.schema().asStruct());
        FileScanTask file = (FileScanTask)Iterables.getOnlyElement((Iterable)scan.planFiles());
        Assert.assertEquals((String)"Data file should be the table's manifest", (Object)((ManifestFile)Iterables.getOnlyElement((Iterable)this.table.currentSnapshot().allManifests(this.table.io()))).path(), (Object)((DataFile)file.file()).path());
        Assert.assertEquals((String)"Should contain 2 data file records", (long)2L, (long)((DataFile)file.file()).recordCount());
    }

    @Test
    public void testSplitPlanningWithMetadataSplitSizeProperty() {
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.newAppend().appendFile(FILE_C).appendFile(FILE_D).commit();
        this.table.updateProperties().set("read.split.metadata-target-size", String.valueOf(0x8000000)).commit();
        ManifestEntriesTable entriesTable = new ManifestEntriesTable((Table)this.table);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)entriesTable.newScan().planTasks()));
        this.table.updateProperties().set("read.split.metadata-target-size", String.valueOf(1)).commit();
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)entriesTable.newScan().planTasks()));
        TableScan scan = (TableScan)entriesTable.newScan().option("read.split.target-size", String.valueOf(0x8000000));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)scan.planTasks()));
    }

    @Test
    public void testSplitPlanningWithDefaultMetadataSplitSize() {
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        int splitSize = 0x2000000;
        ManifestEntriesTable entriesTable = new ManifestEntriesTable((Table)this.table);
        Assert.assertEquals((long)1L, (long)entriesTable.currentSnapshot().allManifests(this.table.io()).size());
        int expectedSplits = ((int)((ManifestFile)entriesTable.currentSnapshot().allManifests(this.table.io()).get(0)).length() + splitSize - 1) / splitSize;
        TableScan scan = entriesTable.newScan();
        Assert.assertEquals((long)expectedSplits, (long)Iterables.size((Iterable)scan.planTasks()));
    }

    @Test
    public void testEntriesTableWithDeleteManifests() {
        Assume.assumeTrue((String)"Only V2 Tables Support Deletes", (this.formatVersion >= 2 ? 1 : 0) != 0);
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.newRowDelta().addDeletes(FILE_A_DELETES).commit();
        ManifestEntriesTable entriesTable = new ManifestEntriesTable((Table)this.table);
        TableScan scan = entriesTable.newScan();
        Schema readSchema = ManifestEntry.getSchema((Types.StructType)this.table.spec().partitionType());
        Schema expectedSchema = TypeUtil.join((Schema)readSchema, (Schema)MetricsUtil.readableMetricsSchema((Schema)this.table.schema(), (Schema)readSchema));
        Assert.assertEquals((String)"A tableScan.select() should prune the schema", (Object)expectedSchema.asStruct(), (Object)scan.schema().asStruct());
        ImmutableList files = ImmutableList.copyOf((Iterable)scan.planFiles());
        Assert.assertEquals((String)"Data file should be the table's manifest", (Object)((ManifestFile)Iterables.getOnlyElement((Iterable)this.table.currentSnapshot().dataManifests(this.table.io()))).path(), (Object)((DataFile)((FileScanTask)files.get(0)).file()).path());
        Assert.assertEquals((String)"Should contain 2 data file records", (long)2L, (long)((DataFile)((FileScanTask)files.get(0)).file()).recordCount());
        Assert.assertEquals((String)"Delete file should be in the table manifest", (Object)((ManifestFile)Iterables.getOnlyElement((Iterable)this.table.currentSnapshot().deleteManifests(this.table.io()))).path(), (Object)((DataFile)((FileScanTask)files.get(1)).file()).path());
        Assert.assertEquals((String)"Should contain 1 delete file record", (long)1L, (long)((DataFile)((FileScanTask)files.get(1)).file()).recordCount());
    }
}

