/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.StructLikeWrapper;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestDeleteFiles
extends TableTestBase {
    private static final DataFile DATA_FILE_BUCKET_0_IDS_0_2 = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-1.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=0").withMetrics(new Metrics(Long.valueOf(5L), null, (Map)ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)5L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)0L), null, (Map)ImmutableMap.of((Object)1, (Object)TestDeleteFiles.longToBuffer(0L)), (Map)ImmutableMap.of((Object)1, (Object)TestDeleteFiles.longToBuffer(2L)))).build();
    private static final DataFile DATA_FILE_BUCKET_0_IDS_8_10 = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-2.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=0").withMetrics(new Metrics(Long.valueOf(5L), null, (Map)ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)5L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)0L), null, (Map)ImmutableMap.of((Object)1, (Object)TestDeleteFiles.longToBuffer(8L)), (Map)ImmutableMap.of((Object)1, (Object)TestDeleteFiles.longToBuffer(10L)))).build();
    private final String branch;

    @Parameterized.Parameters(name="formatVersion = {0}, branch = {1}")
    public static Object[] parameters() {
        return new Object[][]{{1, "main"}, {1, "testBranch"}, {2, "main"}, {2, "testBranch"}};
    }

    public TestDeleteFiles(int formatVersion, String branch) {
        super(formatVersion);
        this.branch = branch;
    }

    @Test
    public void testMultipleDeletes() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).appendFile(FILE_C), this.branch);
        Snapshot append = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch);
        Assert.assertEquals((String)"Metadata should be at version 1", (long)1L, (long)this.version().intValue());
        this.validateSnapshot(null, append, FILE_A, FILE_B, FILE_C);
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFile(FILE_A), this.branch);
        Snapshot delete1 = SnapshotUtil.latestSnapshot((TableMetadata)this.readMetadata(), (String)this.branch);
        Assert.assertEquals((String)"Metadata should be at version 2", (long)2L, (long)this.version().intValue());
        Assert.assertEquals((String)"Should have 1 manifest", (long)1L, (long)delete1.allManifests(FILE_IO).size());
        TestDeleteFiles.validateManifestEntries((ManifestFile)delete1.allManifests(this.table.io()).get(0), TestDeleteFiles.ids(delete1.snapshotId(), append.snapshotId(), append.snapshotId()), TestDeleteFiles.files(FILE_A, FILE_B, FILE_C), TestDeleteFiles.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
        Snapshot delete2 = this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFile(FILE_B), this.branch);
        Assert.assertEquals((String)"Metadata should be at version 3", (long)3L, (long)this.version().intValue());
        Assert.assertEquals((String)"Should have 1 manifest", (long)1L, (long)delete2.allManifests(FILE_IO).size());
        TestDeleteFiles.validateManifestEntries((ManifestFile)delete2.allManifests(FILE_IO).get(0), TestDeleteFiles.ids(delete2.snapshotId(), append.snapshotId()), TestDeleteFiles.files(FILE_B, FILE_C), TestDeleteFiles.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
    }

    @Test
    public void testAlreadyDeletedFilesAreIgnoredDuringDeletesByRowFilter() {
        PartitionSpec spec = this.table.spec();
        DataFile firstDataFile = DataFiles.builder((PartitionSpec)spec).withPath("/path/to/data-2.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=0").withMetrics(new Metrics(Long.valueOf(5L), null, (Map)ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)5L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)0L), null, (Map)ImmutableMap.of((Object)1, (Object)TestDeleteFiles.longToBuffer(0L)), (Map)ImmutableMap.of((Object)1, (Object)TestDeleteFiles.longToBuffer(10L)))).build();
        DataFile secondDataFile = DataFiles.builder((PartitionSpec)spec).withPath("/path/to/data-1.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=0").withMetrics(new Metrics(Long.valueOf(5L), null, (Map)ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)5L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)0L), null, (Map)ImmutableMap.of((Object)1, (Object)TestDeleteFiles.longToBuffer(0L)), (Map)ImmutableMap.of((Object)1, (Object)TestDeleteFiles.longToBuffer(4L)))).build();
        Snapshot initialSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(firstDataFile).appendFile(secondDataFile), this.branch);
        Assert.assertEquals((String)"Should have 1 manifest", (long)1L, (long)initialSnapshot.allManifests(FILE_IO).size());
        TestDeleteFiles.validateManifestEntries((ManifestFile)initialSnapshot.allManifests(FILE_IO).get(0), TestDeleteFiles.ids(initialSnapshot.snapshotId(), initialSnapshot.snapshotId()), TestDeleteFiles.files(firstDataFile, secondDataFile), TestDeleteFiles.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        Snapshot deleteSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFile(firstDataFile), this.branch);
        Assert.assertEquals((String)"Should have 1 manifest", (long)1L, (long)deleteSnapshot.allManifests(FILE_IO).size());
        TestDeleteFiles.validateManifestEntries((ManifestFile)deleteSnapshot.allManifests(FILE_IO).get(0), TestDeleteFiles.ids(deleteSnapshot.snapshotId(), initialSnapshot.snapshotId()), TestDeleteFiles.files(firstDataFile, secondDataFile), TestDeleteFiles.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING));
        Snapshot finalSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFromRowFilter((Expression)Expressions.lessThan((String)"id", (Object)7)), this.branch);
        Assert.assertEquals((String)"Should have 1 manifest", (long)1L, (long)finalSnapshot.allManifests(FILE_IO).size());
        TestDeleteFiles.validateManifestEntries((ManifestFile)finalSnapshot.allManifests(FILE_IO).get(0), TestDeleteFiles.ids(finalSnapshot.snapshotId()), TestDeleteFiles.files(secondDataFile), TestDeleteFiles.statuses(ManifestEntry.Status.DELETED));
    }

    @Test
    public void testDeleteSomeFilesByRowFilterWithoutPartitionPredicates() {
        Snapshot initialSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(DATA_FILE_BUCKET_0_IDS_0_2).appendFile(DATA_FILE_BUCKET_0_IDS_8_10), this.branch);
        Assert.assertEquals((String)"Should have 1 manifest", (long)1L, (long)initialSnapshot.allManifests(FILE_IO).size());
        TestDeleteFiles.validateManifestEntries((ManifestFile)initialSnapshot.allManifests(FILE_IO).get(0), TestDeleteFiles.ids(initialSnapshot.snapshotId(), initialSnapshot.snapshotId()), TestDeleteFiles.files(DATA_FILE_BUCKET_0_IDS_0_2, DATA_FILE_BUCKET_0_IDS_8_10), TestDeleteFiles.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        Snapshot deleteSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFromRowFilter((Expression)Expressions.greaterThan((String)"id", (Object)5)), this.branch);
        Assert.assertEquals((String)"Should have 1 manifest", (long)1L, (long)deleteSnapshot.allManifests(FILE_IO).size());
        TestDeleteFiles.validateManifestEntries((ManifestFile)deleteSnapshot.allManifests(FILE_IO).get(0), TestDeleteFiles.ids(initialSnapshot.snapshotId(), deleteSnapshot.snapshotId()), TestDeleteFiles.files(DATA_FILE_BUCKET_0_IDS_0_2, DATA_FILE_BUCKET_0_IDS_8_10), TestDeleteFiles.statuses(ManifestEntry.Status.EXISTING, ManifestEntry.Status.DELETED));
    }

    @Test
    public void testDeleteSomeFilesByRowFilterWithCombinedPredicates() {
        Snapshot initialSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(DATA_FILE_BUCKET_0_IDS_0_2).appendFile(DATA_FILE_BUCKET_0_IDS_8_10), this.branch);
        Assert.assertEquals((String)"Should have 1 manifest", (long)1L, (long)initialSnapshot.allManifests(FILE_IO).size());
        TestDeleteFiles.validateManifestEntries((ManifestFile)initialSnapshot.allManifests(FILE_IO).get(0), TestDeleteFiles.ids(initialSnapshot.snapshotId(), initialSnapshot.snapshotId()), TestDeleteFiles.files(DATA_FILE_BUCKET_0_IDS_0_2, DATA_FILE_BUCKET_0_IDS_8_10), TestDeleteFiles.statuses(ManifestEntry.Status.ADDED, ManifestEntry.Status.ADDED));
        UnboundPredicate partPredicate = Expressions.equal((UnboundTerm)Expressions.bucket((String)"data", (int)16), (Object)0);
        UnboundPredicate rowPredicate = Expressions.greaterThan((String)"id", (Object)5);
        Expression predicate = Expressions.and((Expression)partPredicate, (Expression)rowPredicate);
        Snapshot deleteSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFromRowFilter(predicate), this.branch);
        Assert.assertEquals((String)"Should have 1 manifest", (long)1L, (long)deleteSnapshot.allManifests(FILE_IO).size());
        TestDeleteFiles.validateManifestEntries((ManifestFile)deleteSnapshot.allManifests(FILE_IO).get(0), TestDeleteFiles.ids(initialSnapshot.snapshotId(), deleteSnapshot.snapshotId()), TestDeleteFiles.files(DATA_FILE_BUCKET_0_IDS_0_2, DATA_FILE_BUCKET_0_IDS_8_10), TestDeleteFiles.statuses(ManifestEntry.Status.EXISTING, ManifestEntry.Status.DELETED));
    }

    @Test
    public void testCannotDeleteFileWhereNotAllRowsMatchPartitionFilter() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.truncate((String)"data", (int)2)).commit();
        PartitionSpec spec = this.table.spec();
        DataFile dataFile = DataFiles.builder((PartitionSpec)spec).withPath("/path/to/data-1.parquet").withRecordCount(10L).withFileSizeInBytes(10L).withPartitionPath("data_trunc_2=aa").build();
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(dataFile), this.branch);
        AssertHelpers.assertThrows((String)"Should reject as not all rows match filter", ValidationException.class, (String)"Cannot delete file where some, but not all, rows match filter", () -> this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFromRowFilter((Expression)Expressions.equal((String)"data", (Object)"aa")), this.branch));
    }

    @Test
    public void testDeleteCaseSensitivity() {
        this.commit((Table)this.table, (SnapshotUpdate)this.table.newFastAppend().appendFile(DATA_FILE_BUCKET_0_IDS_0_2), this.branch);
        UnboundPredicate rowFilter = Expressions.lessThan((String)"iD", (Object)5);
        AssertHelpers.assertThrows((String)"Should use case sensitive binding by default", ValidationException.class, (String)"Cannot find field 'iD'", () -> this.lambda$testDeleteCaseSensitivity$1((Expression)rowFilter));
        AssertHelpers.assertThrows((String)"Should fail with case sensitive binding", ValidationException.class, (String)"Cannot find field 'iD'", () -> this.lambda$testDeleteCaseSensitivity$2((Expression)rowFilter));
        Snapshot deleteSnapshot = this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFromRowFilter((Expression)rowFilter).caseSensitive(false), this.branch);
        Assert.assertEquals((String)"Should have 1 manifest", (long)1L, (long)deleteSnapshot.allManifests(FILE_IO).size());
        TestDeleteFiles.validateManifestEntries((ManifestFile)deleteSnapshot.allManifests(FILE_IO).get(0), TestDeleteFiles.ids(deleteSnapshot.snapshotId()), TestDeleteFiles.files(DATA_FILE_BUCKET_0_IDS_0_2), TestDeleteFiles.statuses(ManifestEntry.Status.DELETED));
    }

    @Test
    public void testDeleteFilesOnIndependentBranches() {
        String testBranch = "testBranch";
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).appendFile(FILE_C).commit();
        Snapshot initialSnapshot = this.table.currentSnapshot();
        ((DeleteFiles)this.table.newDelete().deleteFile(FILE_A).toBranch(testBranch)).commit();
        Snapshot testBranchTip = this.table.snapshot(testBranch);
        this.table.newDelete().deleteFile(FILE_B).deleteFile(FILE_C).commit();
        Snapshot delete2 = this.table.currentSnapshot();
        TestDeleteFiles.validateManifestEntries((ManifestFile)Iterables.getOnlyElement((Iterable)testBranchTip.allManifests(FILE_IO)), TestDeleteFiles.ids(testBranchTip.snapshotId(), initialSnapshot.snapshotId(), initialSnapshot.snapshotId()), TestDeleteFiles.files(FILE_A, FILE_B, FILE_C), TestDeleteFiles.statuses(ManifestEntry.Status.DELETED, ManifestEntry.Status.EXISTING, ManifestEntry.Status.EXISTING));
        TestDeleteFiles.validateManifestEntries((ManifestFile)Iterables.getOnlyElement((Iterable)delete2.allManifests(FILE_IO)), TestDeleteFiles.ids(initialSnapshot.snapshotId(), delete2.snapshotId(), delete2.snapshotId()), TestDeleteFiles.files(FILE_A, FILE_B, FILE_C), TestDeleteFiles.statuses(ManifestEntry.Status.EXISTING, ManifestEntry.Status.DELETED, ManifestEntry.Status.DELETED));
    }

    @Test
    public void testDeleteWithCollision() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.of((int)0, (boolean)false, (String)"x", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).identity("x").build();
        TestTables.TestTable collisionTable = TestTables.create(this.tableDir, "hashcollision", schema, spec, this.formatVersion);
        PartitionData partitionOne = new PartitionData(spec.partitionType());
        partitionOne.set(0, (Object)"Aa");
        PartitionData partitionTwo = new PartitionData(spec.partitionType());
        partitionTwo.set(0, (Object)"BB");
        Assert.assertEquals((long)StructLikeWrapper.forType((Types.StructType)spec.partitionType()).set((StructLike)partitionOne).hashCode(), (long)StructLikeWrapper.forType((Types.StructType)spec.partitionType()).set((StructLike)partitionTwo).hashCode());
        DataFile testFileOne = DataFiles.builder((PartitionSpec)spec).withPartition((StructLike)partitionOne).withPath("/g1.parquet").withFileSizeInBytes(100L).withRecordCount(1L).build();
        DataFile testFileTwo = DataFiles.builder((PartitionSpec)spec).withPartition((StructLike)partitionTwo).withRecordCount(1L).withFileSizeInBytes(100L).withPath("/g2.parquet").build();
        collisionTable.newFastAppend().appendFile(testFileOne).appendFile(testFileTwo).commit();
        List beforeDeletePartitions = Lists.newArrayList((Iterator)collisionTable.newScan().planFiles().iterator()).stream().map(s -> ((PartitionData)s.partition()).copy()).collect(Collectors.toList());
        Assert.assertEquals((String)"We should have both partitions", (Object)ImmutableList.of((Object)partitionOne, (Object)partitionTwo), beforeDeletePartitions);
        collisionTable.newDelete().deleteFromRowFilter((Expression)Expressions.equal((String)"x", (Object)"BB")).commit();
        List afterDeletePartitions = Lists.newArrayList((Iterator)collisionTable.newScan().planFiles().iterator()).stream().map(s -> ((PartitionData)s.partition()).copy()).collect(Collectors.toList());
        Assert.assertEquals((String)"We should have deleted partitionTwo", (Object)ImmutableList.of((Object)partitionOne), afterDeletePartitions);
    }

    private static ByteBuffer longToBuffer(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, value);
    }

    private /* synthetic */ Object lambda$testDeleteCaseSensitivity$2(Expression rowFilter) throws Exception {
        return this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFromRowFilter(rowFilter).caseSensitive(true), this.branch);
    }

    private /* synthetic */ Object lambda$testDeleteCaseSensitivity$1(Expression rowFilter) throws Exception {
        return this.commit((Table)this.table, (SnapshotUpdate)this.table.newDelete().deleteFromRowFilter(rowFilter), this.branch);
    }
}

