/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.iceberg.BaseFile;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.DeleteFileIndex;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.StructLikeWrapper;
import org.junit.Assert;
import org.junit.Test;

public class TestDeleteFileIndex
extends TableTestBase {
    static final DeleteFile FILE_A_POS_1 = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofPositionDeletes().withPath("/path/to/data-a-pos-deletes.parquet").withFileSizeInBytes(10L).withPartition(FILE_A.partition()).withRecordCount(1L).build();
    static final DeleteFile FILE_A_POS_2 = (DeleteFile)FILE_A_POS_1.copy();
    static final DeleteFile FILE_A_EQ_1 = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofEqualityDeletes(new int[0]).withPath("/path/to/data-a-eq-deletes.parquet").withFileSizeInBytes(10L).withPartition(FILE_A.partition()).withRecordCount(1L).build();
    static final DeleteFile FILE_A_EQ_2 = (DeleteFile)FILE_A_EQ_1.copy();
    static final DeleteFile[] DELETE_FILES = new DeleteFile[]{FILE_A_POS_1, FILE_A_EQ_1, FILE_A_POS_2, FILE_A_EQ_2};

    public TestDeleteFileIndex() {
        super(2);
    }

    private static DataFile unpartitionedFile(PartitionSpec spec) {
        return DataFiles.builder((PartitionSpec)spec).withPath("/path/to/data-unpartitioned.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
    }

    private static DeleteFile unpartitionedPosDeletes(PartitionSpec spec) {
        return FileMetadata.deleteFileBuilder((PartitionSpec)spec).ofPositionDeletes().withPath("/path/to/data-unpartitioned-pos-deletes.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
    }

    private static DeleteFile unpartitionedEqDeletes(PartitionSpec spec) {
        return FileMetadata.deleteFileBuilder((PartitionSpec)spec).ofEqualityDeletes(new int[0]).withPath("/path/to/data-unpartitioned-eq-deletes.parquet").withFileSizeInBytes(10L).withRecordCount(1L).build();
    }

    @Test
    public void testUnpartitionedDeletes() {
        PartitionSpec partSpec = PartitionSpec.unpartitioned();
        DeleteFileIndex index = new DeleteFileIndex((Map)ImmutableMap.of((Object)partSpec.specId(), (Object)partSpec, (Object)1, (Object)SPEC), new long[]{3L, 5L, 5L, 6L}, DELETE_FILES, (Map)ImmutableMap.of());
        DataFile unpartitionedFile = TestDeleteFileIndex.unpartitionedFile(partSpec);
        Assert.assertArrayEquals((String)"All deletes should apply to seq 0", (Object[])DELETE_FILES, (Object[])index.forDataFile(0L, unpartitionedFile));
        Assert.assertArrayEquals((String)"All deletes should apply to seq 3", (Object[])DELETE_FILES, (Object[])index.forDataFile(3L, unpartitionedFile));
        Assert.assertArrayEquals((String)"Last 3 deletes should apply to seq 4", (Object[])Arrays.copyOfRange(DELETE_FILES, 1, 4), (Object[])index.forDataFile(4L, unpartitionedFile));
        Assert.assertArrayEquals((String)"Last 3 deletes should apply to seq 5", (Object[])Arrays.copyOfRange(DELETE_FILES, 1, 4), (Object[])index.forDataFile(5L, unpartitionedFile));
        Assert.assertArrayEquals((String)"Last delete should apply to seq 6", (Object[])Arrays.copyOfRange(DELETE_FILES, 3, 4), (Object[])index.forDataFile(6L, unpartitionedFile));
        Assert.assertArrayEquals((String)"No deletes should apply to seq 7", (Object[])new DataFile[0], (Object[])index.forDataFile(7L, unpartitionedFile));
        Assert.assertArrayEquals((String)"No deletes should apply to seq 10", (Object[])new DataFile[0], (Object[])index.forDataFile(10L, unpartitionedFile));
        DataFile partitionedFileA = (DataFile)FILE_A.copy();
        ((BaseFile)partitionedFileA).setSpecId(1);
        Assert.assertArrayEquals((String)"All global deletes should apply to a partitioned file", (Object[])DELETE_FILES, (Object[])index.forDataFile(0L, partitionedFileA));
    }

    @Test
    public void testPartitionedDeleteIndex() {
        DeleteFileIndex index = new DeleteFileIndex((Map)ImmutableMap.of((Object)SPEC.specId(), (Object)SPEC, (Object)1, (Object)PartitionSpec.unpartitioned()), null, null, (Map)ImmutableMap.of((Object)Pair.of((Object)SPEC.specId(), (Object)StructLikeWrapper.forType((Types.StructType)SPEC.partitionType()).set(FILE_A.partition())), (Object)Pair.of((Object)new long[]{3L, 5L, 5L, 6L}, (Object)DELETE_FILES), (Object)Pair.of((Object)SPEC.specId(), (Object)StructLikeWrapper.forType((Types.StructType)SPEC.partitionType()).set(FILE_C.partition())), (Object)Pair.of((Object)new long[0], (Object)new DeleteFile[0])));
        Assert.assertArrayEquals((String)"All deletes should apply to seq 0", (Object[])DELETE_FILES, (Object[])index.forDataFile(0L, FILE_A));
        Assert.assertArrayEquals((String)"All deletes should apply to seq 3", (Object[])DELETE_FILES, (Object[])index.forDataFile(3L, FILE_A));
        Assert.assertArrayEquals((String)"Last 3 deletes should apply to seq 4", (Object[])Arrays.copyOfRange(DELETE_FILES, 1, 4), (Object[])index.forDataFile(4L, FILE_A));
        Assert.assertArrayEquals((String)"Last 3 deletes should apply to seq 5", (Object[])Arrays.copyOfRange(DELETE_FILES, 1, 4), (Object[])index.forDataFile(5L, FILE_A));
        Assert.assertArrayEquals((String)"Last delete should apply to seq 6", (Object[])Arrays.copyOfRange(DELETE_FILES, 3, 4), (Object[])index.forDataFile(6L, FILE_A));
        Assert.assertArrayEquals((String)"No deletes should apply to seq 7", (Object[])new DataFile[0], (Object[])index.forDataFile(7L, FILE_A));
        Assert.assertArrayEquals((String)"No deletes should apply to seq 10", (Object[])new DataFile[0], (Object[])index.forDataFile(10L, FILE_A));
        Assert.assertEquals((String)"No deletes should apply to FILE_B, partition not in index", (long)0L, (long)index.forDataFile(0L, FILE_B).length);
        Assert.assertEquals((String)"No deletes should apply to FILE_C, no indexed delete files", (long)0L, (long)index.forDataFile(0L, FILE_C).length);
        DataFile unpartitionedFileA = (DataFile)FILE_A.copy();
        ((BaseFile)unpartitionedFileA).setSpecId(1);
        Assert.assertEquals((String)"No deletes should apply to FILE_A with a different specId", (long)0L, (long)index.forDataFile(0L, unpartitionedFileA).length);
    }

    @Test
    public void testUnpartitionedTableScan() throws IOException {
        File location = this.temp.newFolder();
        Assert.assertTrue((boolean)location.delete());
        TestTables.TestTable unpartitioned = TestTables.create(location, "unpartitioned", SCHEMA, PartitionSpec.unpartitioned(), 2);
        DataFile unpartitionedFile = TestDeleteFileIndex.unpartitionedFile(unpartitioned.spec());
        unpartitioned.newAppend().appendFile(unpartitionedFile).commit();
        DeleteFile unpartitionedPosDeletes = TestDeleteFileIndex.unpartitionedPosDeletes(unpartitioned.spec());
        unpartitioned.newRowDelta().addDeletes(unpartitionedPosDeletes).commit();
        ArrayList tasks = Lists.newArrayList((Iterator)unpartitioned.newScan().planFiles().iterator());
        Assert.assertEquals((String)"Should have one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have the correct data file path", (Object)unpartitionedFile.path(), (Object)((DataFile)task.file()).path());
        Assert.assertEquals((String)"Should have one associated delete file", (long)1L, (long)task.deletes().size());
        Assert.assertEquals((String)"Should have expected delete file", (Object)unpartitionedPosDeletes.path(), (Object)((DeleteFile)task.deletes().get(0)).path());
        DeleteFile unpartitionedEqDeletes = TestDeleteFileIndex.unpartitionedEqDeletes(unpartitioned.spec());
        unpartitioned.newRowDelta().addDeletes(unpartitionedEqDeletes).commit();
        tasks = Lists.newArrayList((Iterator)unpartitioned.newScan().planFiles().iterator());
        task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have the correct data file path", (Object)unpartitionedFile.path(), (Object)((DataFile)task.file()).path());
        Assert.assertEquals((String)"Should have two associated delete files", (long)2L, (long)task.deletes().size());
        Assert.assertEquals((String)"Should have expected delete files", (Object)Sets.newHashSet((Object[])new CharSequence[]{unpartitionedPosDeletes.path(), unpartitionedEqDeletes.path()}), (Object)Sets.newHashSet((Iterable)Iterables.transform((Iterable)task.deletes(), ContentFile::path)));
    }

    @Test
    public void testPartitionedTableWithPartitionPosDeletes() {
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newRowDelta().addDeletes(FILE_A_POS_1).commit();
        ArrayList tasks = Lists.newArrayList((Iterator)this.table.newScan().planFiles().iterator());
        Assert.assertEquals((String)"Should have one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have the correct data file path", (Object)FILE_A.path(), (Object)((DataFile)task.file()).path());
        Assert.assertEquals((String)"Should have one associated delete file", (long)1L, (long)task.deletes().size());
        Assert.assertEquals((String)"Should have only pos delete file", (Object)FILE_A_POS_1.path(), (Object)((DeleteFile)task.deletes().get(0)).path());
    }

    @Test
    public void testPartitionedTableWithPartitionEqDeletes() {
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newRowDelta().addDeletes(FILE_A_EQ_1).commit();
        ArrayList tasks = Lists.newArrayList((Iterator)this.table.newScan().planFiles().iterator());
        Assert.assertEquals((String)"Should have one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have the correct data file path", (Object)FILE_A.path(), (Object)((DataFile)task.file()).path());
        Assert.assertEquals((String)"Should have one associated delete file", (long)1L, (long)task.deletes().size());
        Assert.assertEquals((String)"Should have only pos delete file", (Object)FILE_A_EQ_1.path(), (Object)((DeleteFile)task.deletes().get(0)).path());
    }

    @Test
    public void testPartitionedTableWithUnrelatedPartitionDeletes() {
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.newRowDelta().addDeletes(FILE_A_POS_1).addDeletes(FILE_A_EQ_1).commit();
        ArrayList tasks = Lists.newArrayList((Iterator)this.table.newScan().planFiles().iterator());
        Assert.assertEquals((String)"Should have one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have the correct data file path", (Object)FILE_B.path(), (Object)((DataFile)task.file()).path());
        Assert.assertEquals((String)"Should have no delete files to apply", (long)0L, (long)task.deletes().size());
    }

    @Test
    public void testPartitionedTableWithOlderPartitionDeletes() {
        this.table.newRowDelta().addDeletes(FILE_A_POS_1).addDeletes(FILE_A_EQ_1).commit();
        this.table.newAppend().appendFile(FILE_A).commit();
        ArrayList tasks = Lists.newArrayList((Iterator)this.table.newScan().planFiles().iterator());
        Assert.assertEquals((String)"Should have one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have the correct data file path", (Object)FILE_A.path(), (Object)((DataFile)task.file()).path());
        Assert.assertEquals((String)"Should have no delete files to apply", (long)0L, (long)task.deletes().size());
    }

    @Test
    public void testPartitionedTableScanWithGlobalDeletes() {
        this.table.newAppend().appendFile(FILE_A).commit();
        TableMetadata base = this.table.ops().current();
        this.table.ops().commit(base, base.updatePartitionSpec(PartitionSpec.unpartitioned()));
        DeleteFile unpartitionedEqDeletes = TestDeleteFileIndex.unpartitionedEqDeletes(this.table.spec());
        this.table.newRowDelta().addDeletes(TestDeleteFileIndex.unpartitionedPosDeletes(this.table.spec())).addDeletes(unpartitionedEqDeletes).commit();
        ArrayList tasks = Lists.newArrayList((Iterator)this.table.newScan().planFiles().iterator());
        Assert.assertEquals((String)"Should have one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have the correct data file path", (Object)FILE_A.path(), (Object)((DataFile)task.file()).path());
        Assert.assertEquals((String)"Should have one associated delete file", (long)1L, (long)task.deletes().size());
        Assert.assertEquals((String)"Should have expected delete file", (Object)unpartitionedEqDeletes.path(), (Object)((DeleteFile)task.deletes().get(0)).path());
    }

    @Test
    public void testPartitionedTableScanWithGlobalAndPartitionDeletes() {
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newRowDelta().addDeletes(FILE_A_EQ_1).commit();
        TableMetadata base = this.table.ops().current();
        this.table.ops().commit(base, base.updatePartitionSpec(PartitionSpec.unpartitioned()));
        DeleteFile unpartitionedEqDeletes = TestDeleteFileIndex.unpartitionedEqDeletes(this.table.spec());
        this.table.newRowDelta().addDeletes(TestDeleteFileIndex.unpartitionedPosDeletes(this.table.spec())).addDeletes(unpartitionedEqDeletes).commit();
        ArrayList tasks = Lists.newArrayList((Iterator)this.table.newScan().planFiles().iterator());
        Assert.assertEquals((String)"Should have one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have the correct data file path", (Object)FILE_A.path(), (Object)((DataFile)task.file()).path());
        Assert.assertEquals((String)"Should have two associated delete files", (long)2L, (long)task.deletes().size());
        Assert.assertEquals((String)"Should have expected delete files", (Object)Sets.newHashSet((Object[])new CharSequence[]{unpartitionedEqDeletes.path(), FILE_A_EQ_1.path()}), (Object)Sets.newHashSet((Iterable)Iterables.transform((Iterable)task.deletes(), ContentFile::path)));
    }

    @Test
    public void testPartitionedTableSequenceNumbers() {
        this.table.newRowDelta().addRows(FILE_A).addDeletes(FILE_A_EQ_1).addDeletes(FILE_A_POS_1).commit();
        ArrayList tasks = Lists.newArrayList((Iterator)this.table.newScan().planFiles().iterator());
        Assert.assertEquals((String)"Should have one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have the correct data file path", (Object)FILE_A.path(), (Object)((DataFile)task.file()).path());
        Assert.assertEquals((String)"Should have one associated delete file", (long)1L, (long)task.deletes().size());
        Assert.assertEquals((String)"Should have only pos delete file", (Object)FILE_A_POS_1.path(), (Object)((DeleteFile)task.deletes().get(0)).path());
    }

    @Test
    public void testUnpartitionedTableSequenceNumbers() throws IOException {
        File location = this.temp.newFolder();
        Assert.assertTrue((boolean)location.delete());
        TestTables.TestTable unpartitioned = TestTables.create(location, "unpartitioned", SCHEMA, PartitionSpec.unpartitioned(), 2);
        DataFile unpartitionedFile = TestDeleteFileIndex.unpartitionedFile(unpartitioned.spec());
        DeleteFile unpartitionedPosDeleteFile = TestDeleteFileIndex.unpartitionedPosDeletes(unpartitioned.spec());
        unpartitioned.newRowDelta().addRows(unpartitionedFile).addDeletes(unpartitionedPosDeleteFile).addDeletes(TestDeleteFileIndex.unpartitionedEqDeletes(unpartitioned.spec())).commit();
        Assert.assertEquals((String)"Table should contain 2 delete files", (long)2L, (long)((ManifestFile)unpartitioned.currentSnapshot().deleteManifests(unpartitioned.io()).get(0)).addedFilesCount().intValue());
        ArrayList tasks = Lists.newArrayList((Iterator)unpartitioned.newScan().planFiles().iterator());
        Assert.assertEquals((String)"Should have one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have the correct data file path", (Object)unpartitionedFile.path(), (Object)((DataFile)task.file()).path());
        Assert.assertEquals((String)"Should have one associated delete file", (long)1L, (long)task.deletes().size());
        Assert.assertEquals((String)"Should have only pos delete file", (Object)unpartitionedPosDeleteFile.path(), (Object)((DeleteFile)task.deletes().get(0)).path());
    }

    @Test
    public void testPartitionedTableWithExistingDeleteFile() {
        this.table.updateProperties().set("commit.manifest-merge.enabled", "false").commit();
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newRowDelta().addDeletes(FILE_A_EQ_1).commit();
        this.table.newRowDelta().addDeletes(FILE_A_POS_1).commit();
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "1").set("commit.manifest-merge.enabled", "true").commit();
        Assert.assertEquals((String)"Should have two delete manifests", (long)2L, (long)this.table.currentSnapshot().deleteManifests(this.table.io()).size());
        this.table.newAppend().appendFile(FILE_B).commit();
        Assert.assertEquals((String)"Should have one delete manifest", (long)1L, (long)this.table.currentSnapshot().deleteManifests(this.table.io()).size());
        Assert.assertEquals((String)"Should have zero added delete file", (long)0L, (long)((ManifestFile)this.table.currentSnapshot().deleteManifests(this.table.io()).get(0)).addedFilesCount().intValue());
        Assert.assertEquals((String)"Should have zero deleted delete file", (long)0L, (long)((ManifestFile)this.table.currentSnapshot().deleteManifests(this.table.io()).get(0)).deletedFilesCount().intValue());
        Assert.assertEquals((String)"Should have two existing delete files", (long)2L, (long)((ManifestFile)this.table.currentSnapshot().deleteManifests(this.table.io()).get(0)).existingFilesCount().intValue());
        ArrayList tasks = Lists.newArrayList((Iterator)((TableScan)this.table.newScan().filter((Expression)Expressions.equal((UnboundTerm)Expressions.bucket((String)"data", (int)16), (Object)0))).planFiles().iterator());
        Assert.assertEquals((String)"Should have one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have the correct data file path", (Object)FILE_A.path(), (Object)((DataFile)task.file()).path());
        Assert.assertEquals((String)"Should have two associated delete files", (long)2L, (long)task.deletes().size());
        Assert.assertEquals((String)"Should have expected delete files", (Object)Sets.newHashSet((Object[])new CharSequence[]{FILE_A_EQ_1.path(), FILE_A_POS_1.path()}), (Object)Sets.newHashSet((Iterable)Iterables.transform((Iterable)task.deletes(), ContentFile::path)));
    }
}

