/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ScanTestBase;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestDataTableScan
extends ScanTestBase<TableScan, FileScanTask, CombinedScanTask> {
    public TestDataTableScan(int formatVersion) {
        super(formatVersion);
    }

    @Override
    protected TableScan newScan() {
        return this.table.newScan();
    }

    @Test
    public void testTaskRowCounts() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        DataFile dataFile1 = this.newDataFile("data_bucket=0");
        this.table.newFastAppend().appendFile(dataFile1).commit();
        DataFile dataFile2 = this.newDataFile("data_bucket=1");
        this.table.newFastAppend().appendFile(dataFile2).commit();
        DeleteFile deleteFile1 = this.newDeleteFile("data_bucket=0");
        this.table.newRowDelta().addDeletes(deleteFile1).commit();
        DeleteFile deleteFile2 = this.newDeleteFile("data_bucket=1");
        this.table.newRowDelta().addDeletes(deleteFile2).commit();
        TableScan scan = (TableScan)this.table.newScan().option("read.split.target-size", "50");
        ArrayList fileScanTasks = Lists.newArrayList((Iterable)scan.planFiles());
        Assert.assertEquals((String)"Must have 2 FileScanTasks", (long)2L, (long)fileScanTasks.size());
        for (FileScanTask task : fileScanTasks) {
            Assert.assertEquals((String)"Rows count must match", (long)10L, (long)task.estimatedRowsCount());
        }
        ArrayList combinedScanTasks = Lists.newArrayList((Iterable)scan.planTasks());
        Assert.assertEquals((String)"Must have 4 CombinedScanTask", (long)4L, (long)combinedScanTasks.size());
        for (CombinedScanTask task : combinedScanTasks) {
            Assert.assertEquals((String)"Rows count must match", (long)5L, (long)task.estimatedRowsCount());
        }
    }

    @Override
    protected DataFile newDataFile(String partitionPath) {
        return DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data-" + UUID.randomUUID() + ".parquet").withFormat(FileFormat.PARQUET).withFileSizeInBytes(100L).withPartitionPath(partitionPath).withRecordCount(10L).build();
    }

    protected DeleteFile newDeleteFile(String partitionPath) {
        return FileMetadata.deleteFileBuilder((PartitionSpec)this.table.spec()).ofPositionDeletes().withPath("/path/to/delete-" + UUID.randomUUID() + ".parquet").withFormat(FileFormat.PARQUET).withFileSizeInBytes(100L).withPartitionPath(partitionPath).withRecordCount(10L).build();
    }

    @Test
    public void testScanFromBranchTip() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        ((AppendFiles)this.table.newFastAppend().appendFile(FILE_B).appendFile(FILE_C).toBranch("testBranch")).commit();
        this.table.newFastAppend().appendFile(FILE_D).commit();
        TableScan testBranchScan = this.table.newScan().useRef("testBranch");
        this.validateExpectedFileScanTasks(testBranchScan, (List<CharSequence>)ImmutableList.of((Object)FILE_A.path(), (Object)FILE_B.path(), (Object)FILE_C.path()));
        TableScan mainScan = this.table.newScan();
        this.validateExpectedFileScanTasks(mainScan, (List<CharSequence>)ImmutableList.of((Object)FILE_A.path(), (Object)FILE_D.path()));
    }

    @Test
    public void testScanFromTag() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.manageSnapshots().createTag("tagB", this.table.currentSnapshot().snapshotId()).commit();
        this.table.newFastAppend().appendFile(FILE_C).commit();
        TableScan tagScan = this.table.newScan().useRef("tagB");
        this.validateExpectedFileScanTasks(tagScan, (List<CharSequence>)ImmutableList.of((Object)FILE_A.path(), (Object)FILE_B.path()));
        TableScan mainScan = this.table.newScan();
        this.validateExpectedFileScanTasks(mainScan, (List<CharSequence>)ImmutableList.of((Object)FILE_A.path(), (Object)FILE_B.path(), (Object)FILE_C.path()));
    }

    @Test
    public void testScanFromRefWhenSnapshotSetFails() {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.manageSnapshots().createTag("tagB", this.table.currentSnapshot().snapshotId()).commit();
        AssertHelpers.assertThrows((String)"Should throw when attempting to use a ref for scanning when a snapshot is set", IllegalArgumentException.class, (String)"Cannot override ref, already set snapshot id=1", () -> this.table.newScan().useSnapshot(this.table.currentSnapshot().snapshotId()).useRef("tagB"));
    }

    @Test
    public void testSettingSnapshotWhenRefSetFails() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Snapshot snapshotA = this.table.currentSnapshot();
        this.table.newFastAppend().appendFile(FILE_B).commit();
        this.table.manageSnapshots().createTag("tagB", this.table.currentSnapshot().snapshotId()).commit();
        AssertHelpers.assertThrows((String)"Should throw when attempting to use a snapshot for scanning when a ref is set", IllegalArgumentException.class, (String)"Cannot override snapshot, already set snapshot id=2", () -> this.table.newScan().useRef("tagB").useSnapshot(snapshotA.snapshotId()));
    }

    @Test
    public void testBranchTimeTravelFails() {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        this.table.manageSnapshots().createBranch("testBranch", this.table.currentSnapshot().snapshotId()).commit();
        AssertHelpers.assertThrows((String)"Should throw when attempting to use a snapshot for scanning when a ref is set", IllegalArgumentException.class, (String)"Cannot override snapshot, already set snapshot id=1", () -> this.table.newScan().useRef("testBranch").asOfTime(System.currentTimeMillis()));
    }

    @Test
    public void testSettingMultipleRefsFails() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.manageSnapshots().createTag("tagA", this.table.currentSnapshot().snapshotId()).commit();
        this.table.newFastAppend().appendFile(FILE_B).commit();
        this.table.manageSnapshots().createTag("tagB", this.table.currentSnapshot().snapshotId()).commit();
        AssertHelpers.assertThrows((String)"Should throw when attempting to use multiple refs", IllegalArgumentException.class, (String)"Cannot override ref, already set snapshot id=2", () -> this.table.newScan().useRef("tagB").useRef("tagA"));
    }

    @Test
    public void testSettingInvalidRefFails() {
        AssertHelpers.assertThrows((String)"Should throw when attempting to use an invalid ref for scanning", IllegalArgumentException.class, (String)"Cannot find ref nonexisting", () -> this.table.newScan().useRef("nonexisting"));
    }

    private void validateExpectedFileScanTasks(TableScan scan, List<CharSequence> expectedFileScanPaths) throws IOException {
        try (CloseableIterable scanTasks = scan.planFiles();){
            Assert.assertEquals((long)expectedFileScanPaths.size(), (long)Iterables.size((Iterable)scanTasks));
            ArrayList actualFiles = Lists.newArrayList();
            scanTasks.forEach(task -> actualFiles.add(((DataFile)task.file()).path()));
            Assert.assertTrue((boolean)actualFiles.containsAll(expectedFileScanPaths));
        }
    }

    @Test
    public void testSequenceNumbersThroughPlanFiles() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        DataFile dataFile1 = this.newDataFile("data_bucket=0");
        this.table.newFastAppend().appendFile(dataFile1).commit();
        DataFile dataFile2 = this.newDataFile("data_bucket=1");
        this.table.newFastAppend().appendFile(dataFile2).commit();
        DeleteFile deleteFile1 = this.newDeleteFile("data_bucket=0");
        this.table.newRowDelta().addDeletes(deleteFile1).commit();
        DeleteFile deleteFile2 = this.newDeleteFile("data_bucket=1");
        this.table.newRowDelta().addDeletes(deleteFile2).commit();
        TableScan scan = this.table.newScan();
        ArrayList fileScanTasks = Lists.newArrayList((Iterable)scan.planFiles());
        Assert.assertEquals((String)"Must have 2 FileScanTasks", (long)2L, (long)fileScanTasks.size());
        for (FileScanTask task : fileScanTasks) {
            DataFile file = (DataFile)task.file();
            long expectedDataSequenceNumber = 0L;
            long expectedDeleteSequenceNumber = 0L;
            if (file.path().equals(dataFile1.path())) {
                expectedDataSequenceNumber = 1L;
                expectedDeleteSequenceNumber = 3L;
            }
            if (file.path().equals(dataFile2.path())) {
                expectedDataSequenceNumber = 2L;
                expectedDeleteSequenceNumber = 4L;
            }
            Assert.assertEquals((String)"Data sequence number mismatch", (long)expectedDataSequenceNumber, (long)file.dataSequenceNumber());
            Assert.assertEquals((String)"File sequence number mismatch", (long)expectedDataSequenceNumber, (long)file.fileSequenceNumber());
            List deleteFiles = task.deletes();
            Assert.assertEquals((String)"Must have 1 delete file", (long)1L, (long)Iterables.size((Iterable)deleteFiles));
            DeleteFile deleteFile = (DeleteFile)Iterables.getOnlyElement((Iterable)deleteFiles);
            Assert.assertEquals((String)"Data sequence number mismatch", (long)expectedDeleteSequenceNumber, (long)deleteFile.dataSequenceNumber());
            Assert.assertEquals((String)"File sequence number mismatch", (long)expectedDeleteSequenceNumber, (long)deleteFile.fileSequenceNumber());
        }
    }
}

