/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.BaseTransaction;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestCreateTransaction
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestCreateTransaction(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testCreateTransaction() throws IOException {
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        Transaction txn = TestTables.beginCreate(tableDir, "test_create", SCHEMA, PartitionSpec.unpartitioned());
        Assert.assertNull((String)"Starting a create transaction should not commit metadata", (Object)TestTables.readMetadata("test_create"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("test_create"));
        txn.commitTransaction();
        TableMetadata meta = TestTables.readMetadata("test_create");
        Assert.assertNotNull((String)"Table metadata should be created after transaction commits", (Object)meta);
        Assert.assertEquals((String)"Should have metadata version 0", (long)0L, (long)TestTables.metadataVersion("test_create").intValue());
        Assert.assertEquals((String)"Should have 0 manifest files", (long)0L, (long)this.listManifestFiles(tableDir).size());
        Assert.assertEquals((String)"Table schema should match with reassigned IDs", (Object)TypeUtil.assignIncreasingFreshIds((Schema)SCHEMA).asStruct(), (Object)meta.schema().asStruct());
        Assert.assertEquals((String)"Table spec should match", (Object)PartitionSpec.unpartitioned(), (Object)meta.spec());
        Assert.assertEquals((String)"Table should not have any snapshots", (long)0L, (long)meta.snapshots().size());
    }

    @Test
    public void testCreateTransactionAndUpdateSchema() throws IOException {
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        Transaction txn = TestTables.beginCreate(tableDir, "test_create", SCHEMA, PartitionSpec.unpartitioned());
        Assert.assertNull((String)"Starting a create transaction should not commit metadata", (Object)TestTables.readMetadata("test_create"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("test_create"));
        txn.updateSchema().allowIncompatibleChanges().addRequiredColumn("col", (Type)Types.StringType.get()).setIdentifierFields(new String[]{"id", "col"}).commit();
        txn.commitTransaction();
        TableMetadata meta = TestTables.readMetadata("test_create");
        Assert.assertNotNull((String)"Table metadata should be created after transaction commits", (Object)meta);
        Assert.assertEquals((String)"Should have metadata version 0", (long)0L, (long)TestTables.metadataVersion("test_create").intValue());
        Assert.assertEquals((String)"Should have 0 manifest files", (long)0L, (long)this.listManifestFiles(tableDir).size());
        Schema resultSchema = new Schema((List)Lists.newArrayList((Object[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"col", (Type)Types.StringType.get())}), (Set)Sets.newHashSet((Object[])new Integer[]{1, 3}));
        Assert.assertEquals((String)"Table schema should match with reassigned IDs", (Object)resultSchema.asStruct(), (Object)meta.schema().asStruct());
        Assert.assertEquals((String)"Table schema identifier should match", (Object)resultSchema.identifierFieldIds(), (Object)meta.schema().identifierFieldIds());
        Assert.assertEquals((String)"Table spec should match", (Object)PartitionSpec.unpartitioned(), (Object)meta.spec());
        Assert.assertEquals((String)"Table should not have any snapshots", (long)0L, (long)meta.snapshots().size());
    }

    @Test
    public void testCreateAndAppendWithTransaction() throws IOException {
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        Transaction txn = TestTables.beginCreate(tableDir, "test_append", SCHEMA, PartitionSpec.unpartitioned());
        Assert.assertNull((String)"Starting a create transaction should not commit metadata", (Object)TestTables.readMetadata("test_append"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("test_append"));
        txn.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertNull((String)"Appending in a transaction should not commit metadata", (Object)TestTables.readMetadata("test_append"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("test_append"));
        txn.commitTransaction();
        TableMetadata meta = TestTables.readMetadata("test_append");
        Assert.assertNotNull((String)"Table metadata should be created after transaction commits", (Object)meta);
        Assert.assertEquals((String)"Should have metadata version 0", (long)0L, (long)TestTables.metadataVersion("test_append").intValue());
        Assert.assertEquals((String)"Should have 1 manifest file", (long)1L, (long)this.listManifestFiles(tableDir).size());
        Assert.assertEquals((String)"Table schema should match with reassigned IDs", (Object)TypeUtil.assignIncreasingFreshIds((Schema)SCHEMA).asStruct(), (Object)meta.schema().asStruct());
        Assert.assertEquals((String)"Table spec should match", (Object)PartitionSpec.unpartitioned(), (Object)meta.spec());
        Assert.assertEquals((String)"Table should have one snapshot", (long)1L, (long)meta.snapshots().size());
        this.validateSnapshot(null, meta.currentSnapshot(), FILE_A, FILE_B);
    }

    @Test
    public void testCreateAndAppendWithTable() throws IOException {
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        Transaction txn = TestTables.beginCreate(tableDir, "test_append", SCHEMA, PartitionSpec.unpartitioned());
        Assert.assertNull((String)"Starting a create transaction should not commit metadata", (Object)TestTables.readMetadata("test_append"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("test_append"));
        Assert.assertTrue((String)"Should return a transaction table", (boolean)(txn.table() instanceof BaseTransaction.TransactionTable));
        txn.table().newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertNull((String)"Appending in a transaction should not commit metadata", (Object)TestTables.readMetadata("test_append"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("test_append"));
        txn.commitTransaction();
        TableMetadata meta = TestTables.readMetadata("test_append");
        Assert.assertNotNull((String)"Table metadata should be created after transaction commits", (Object)meta);
        Assert.assertEquals((String)"Should have metadata version 0", (long)0L, (long)TestTables.metadataVersion("test_append").intValue());
        Assert.assertEquals((String)"Should have 1 manifest file", (long)1L, (long)this.listManifestFiles(tableDir).size());
        Assert.assertEquals((String)"Table schema should match with reassigned IDs", (Object)TypeUtil.assignIncreasingFreshIds((Schema)SCHEMA).asStruct(), (Object)meta.schema().asStruct());
        Assert.assertEquals((String)"Table spec should match", (Object)PartitionSpec.unpartitioned(), (Object)meta.spec());
        Assert.assertEquals((String)"Table should have one snapshot", (long)1L, (long)meta.snapshots().size());
        this.validateSnapshot(null, meta.currentSnapshot(), FILE_A, FILE_B);
    }

    @Test
    public void testCreateAndUpdatePropertiesWithTransaction() throws IOException {
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        Transaction txn = TestTables.beginCreate(tableDir, "test_properties", SCHEMA, PartitionSpec.unpartitioned());
        Assert.assertNull((String)"Starting a create transaction should not commit metadata", (Object)TestTables.readMetadata("test_properties"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("test_properties"));
        txn.updateProperties().set("test-property", "test-value").commit();
        Assert.assertNull((String)"Adding properties in a transaction should not commit metadata", (Object)TestTables.readMetadata("test_properties"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("test_properties"));
        txn.commitTransaction();
        TableMetadata meta = TestTables.readMetadata("test_properties");
        Assert.assertNotNull((String)"Table metadata should be created after transaction commits", (Object)meta);
        Assert.assertEquals((String)"Should have metadata version 0", (long)0L, (long)TestTables.metadataVersion("test_properties").intValue());
        Assert.assertEquals((String)"Should have 0 manifest files", (long)0L, (long)this.listManifestFiles(tableDir).size());
        Assert.assertEquals((String)"Table schema should match with reassigned IDs", (Object)TypeUtil.assignIncreasingFreshIds((Schema)SCHEMA).asStruct(), (Object)meta.schema().asStruct());
        Assert.assertEquals((String)"Table spec should match", (Object)PartitionSpec.unpartitioned(), (Object)meta.spec());
        Assert.assertEquals((String)"Table should not have any snapshots", (long)0L, (long)meta.snapshots().size());
        Assert.assertEquals((String)"Should have one table property", (long)1L, (long)meta.properties().size());
        Assert.assertEquals((String)"Should have correct table property value", (Object)"test-value", meta.properties().get("test-property"));
    }

    @Test
    public void testCreateAndUpdatePropertiesWithTable() throws IOException {
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        Transaction txn = TestTables.beginCreate(tableDir, "test_properties", SCHEMA, PartitionSpec.unpartitioned());
        Assert.assertNull((String)"Starting a create transaction should not commit metadata", (Object)TestTables.readMetadata("test_properties"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("test_properties"));
        Assert.assertTrue((String)"Should return a transaction table", (boolean)(txn.table() instanceof BaseTransaction.TransactionTable));
        txn.table().updateProperties().set("test-property", "test-value").commit();
        Assert.assertNull((String)"Adding properties in a transaction should not commit metadata", (Object)TestTables.readMetadata("test_properties"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("test_properties"));
        txn.commitTransaction();
        TableMetadata meta = TestTables.readMetadata("test_properties");
        Assert.assertNotNull((String)"Table metadata should be created after transaction commits", (Object)meta);
        Assert.assertEquals((String)"Should have metadata version 0", (long)0L, (long)TestTables.metadataVersion("test_properties").intValue());
        Assert.assertEquals((String)"Should have 0 manifest files", (long)0L, (long)this.listManifestFiles(tableDir).size());
        Assert.assertEquals((String)"Table schema should match with reassigned IDs", (Object)TypeUtil.assignIncreasingFreshIds((Schema)SCHEMA).asStruct(), (Object)meta.schema().asStruct());
        Assert.assertEquals((String)"Table spec should match", (Object)PartitionSpec.unpartitioned(), (Object)meta.spec());
        Assert.assertEquals((String)"Table should not have any snapshots", (long)0L, (long)meta.snapshots().size());
        Assert.assertEquals((String)"Should have one table property", (long)1L, (long)meta.properties().size());
        Assert.assertEquals((String)"Should have correct table property value", (Object)"test-value", meta.properties().get("test-property"));
    }

    @Test
    public void testCreateDetectsUncommittedChange() throws IOException {
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        Transaction txn = TestTables.beginCreate(tableDir, "uncommitted_change", SCHEMA, PartitionSpec.unpartitioned());
        Assert.assertNull((String)"Starting a create transaction should not commit metadata", (Object)TestTables.readMetadata("uncommitted_change"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("uncommitted_change"));
        txn.updateProperties().set("test-property", "test-value");
        AssertHelpers.assertThrows((String)"Should reject commit when last operation has not committed", IllegalStateException.class, (String)"Cannot create new DeleteFiles: last operation has not committed", () -> ((Transaction)txn).newDelete());
    }

    @Test
    public void testCreateDetectsUncommittedChangeOnCommit() throws IOException {
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        Transaction txn = TestTables.beginCreate(tableDir, "uncommitted_change", SCHEMA, PartitionSpec.unpartitioned());
        Assert.assertNull((String)"Starting a create transaction should not commit metadata", (Object)TestTables.readMetadata("uncommitted_change"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("uncommitted_change"));
        txn.updateProperties().set("test-property", "test-value");
        AssertHelpers.assertThrows((String)"Should reject commit when last operation has not committed", IllegalStateException.class, (String)"Cannot commit transaction: last operation has not committed", () -> ((Transaction)txn).commitTransaction());
    }

    @Test
    public void testCreateTransactionConflict() throws IOException {
        File tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)tableDir.delete());
        Transaction txn = TestTables.beginCreate(tableDir, "test_conflict", SCHEMA, SPEC);
        txn.newAppend().appendFile(FILE_A).commit();
        Assert.assertNull((String)"Starting a create transaction should not commit metadata", (Object)TestTables.readMetadata("test_conflict"));
        Assert.assertNull((String)"Should have no metadata version", (Object)TestTables.metadataVersion("test_conflict"));
        TestTables.TestTable conflict = TestTables.create(tableDir, "test_conflict", SCHEMA, PartitionSpec.unpartitioned(), this.formatVersion);
        Assert.assertEquals((String)"Table schema should match with reassigned IDs", (Object)TypeUtil.assignIncreasingFreshIds((Schema)SCHEMA).asStruct(), (Object)conflict.schema().asStruct());
        Assert.assertEquals((String)"Table spec should match conflict table, not transaction table", (Object)PartitionSpec.unpartitioned(), (Object)conflict.spec());
        Assert.assertFalse((String)"Table should not have any snapshots", (boolean)conflict.snapshots().iterator().hasNext());
        AssertHelpers.assertThrows((String)"Transaction commit should fail", CommitFailedException.class, (String)"Commit failed: table was updated", () -> ((Transaction)txn).commitTransaction());
        Assert.assertEquals((String)"Should clean up metadata", (Object)Sets.newHashSet(), (Object)Sets.newHashSet(this.listManifestFiles(tableDir)));
    }
}

