/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.events.CreateSnapshotEvent;
import org.apache.iceberg.events.Listener;
import org.apache.iceberg.events.Listeners;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestCreateSnapshotEvent
extends TableTestBase {
    private CreateSnapshotEvent currentEvent;

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestCreateSnapshotEvent(int formatVersion) {
        super(formatVersion);
        Listeners.register((Listener)new MyListener(), CreateSnapshotEvent.class);
    }

    @Test
    public void testAppendCommitEvent() {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        this.table.newAppend().appendFile(FILE_A).commit();
        Assert.assertNotNull((Object)this.currentEvent);
        Assert.assertEquals((String)"Added records in the table should be 1", (Object)"1", this.currentEvent.summary().get("added-records"));
        Assert.assertEquals((String)"Added files in the table should be 1", (Object)"1", this.currentEvent.summary().get("added-data-files"));
        Assert.assertEquals((String)"Total records in the table should be 1", (Object)"1", this.currentEvent.summary().get("total-records"));
        Assert.assertEquals((String)"Total data files in the table should be 1", (Object)"1", this.currentEvent.summary().get("total-data-files"));
        this.table.newAppend().appendFile(FILE_A).commit();
        Assert.assertNotNull((Object)this.currentEvent);
        Assert.assertEquals((String)"Added records in the table should be 1", (Object)"1", this.currentEvent.summary().get("added-records"));
        Assert.assertEquals((String)"Added files in the table should be 1", (Object)"1", this.currentEvent.summary().get("added-data-files"));
        Assert.assertEquals((String)"Total records in the table should be 2", (Object)"2", this.currentEvent.summary().get("total-records"));
        Assert.assertEquals((String)"Total data files in the table should be 2", (Object)"2", this.currentEvent.summary().get("total-data-files"));
    }

    @Test
    public void testAppendAndDeleteCommitEvent() {
        Assert.assertEquals((String)"Table should start empty", (long)0L, (long)this.listManifestFiles().size());
        this.table.newAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Assert.assertNotNull((Object)this.currentEvent);
        Assert.assertEquals((String)"Added records in the table should be 2", (Object)"2", this.currentEvent.summary().get("added-records"));
        Assert.assertEquals((String)"Added files in the table should be 2", (Object)"2", this.currentEvent.summary().get("added-data-files"));
        Assert.assertEquals((String)"Total records in the table should be 2", (Object)"2", this.currentEvent.summary().get("total-records"));
        Assert.assertEquals((String)"Total data files in the table should be 2", (Object)"2", this.currentEvent.summary().get("total-data-files"));
        this.table.newDelete().deleteFile(FILE_A).commit();
        Assert.assertNotNull((Object)this.currentEvent);
        Assert.assertEquals((String)"Deleted records in the table should be 1", (Object)"1", this.currentEvent.summary().get("deleted-records"));
        Assert.assertEquals((String)"Deleted files in the table should be 1", (Object)"1", this.currentEvent.summary().get("deleted-data-files"));
        Assert.assertEquals((String)"Total records in the table should be 1", (Object)"1", this.currentEvent.summary().get("total-records"));
        Assert.assertEquals((String)"Total data files in the table should be 1", (Object)"1", this.currentEvent.summary().get("total-data-files"));
    }

    class MyListener
    implements Listener<CreateSnapshotEvent> {
        MyListener() {
        }

        public void notify(CreateSnapshotEvent event) {
            TestCreateSnapshotEvent.this.currentEvent = event;
        }
    }
}

