/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.Set;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestScanPlanningAndReporting;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.metrics.CommitMetricsResult;
import org.apache.iceberg.metrics.CommitReport;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestCommitReporting
extends TableTestBase {
    private final TestScanPlanningAndReporting.TestMetricsReporter reporter = new TestScanPlanningAndReporting.TestMetricsReporter();

    public TestCommitReporting() {
        super(2);
    }

    @Test
    public void addAndDeleteDataFiles() {
        String tableName = "add-and-delete-data-files";
        TestTables.TestTable table = TestTables.create(this.tableDir, tableName, SCHEMA, SPEC, SortOrder.unsorted(), this.formatVersion, this.reporter);
        table.newAppend().appendFile(FILE_A).appendFile(FILE_D).commit();
        CommitReport report = this.reporter.lastCommitReport();
        Assertions.assertThat((Object)report).isNotNull();
        Assertions.assertThat((String)report.operation()).isEqualTo("append");
        Assertions.assertThat((long)report.snapshotId()).isEqualTo(1L);
        Assertions.assertThat((long)report.sequenceNumber()).isEqualTo(1L);
        Assertions.assertThat((String)report.tableName()).isEqualTo(tableName);
        CommitMetricsResult metrics = report.commitMetrics();
        Assertions.assertThat((long)metrics.addedDataFiles().value()).isEqualTo(2L);
        Assertions.assertThat((long)metrics.totalDataFiles().value()).isEqualTo(2L);
        Assertions.assertThat((long)metrics.addedRecords().value()).isEqualTo(2L);
        Assertions.assertThat((long)metrics.totalRecords().value()).isEqualTo(2L);
        Assertions.assertThat((long)metrics.addedFilesSizeInBytes().value()).isEqualTo(20L);
        Assertions.assertThat((long)metrics.totalFilesSizeInBytes().value()).isEqualTo(20L);
        table.newDelete().deleteFile(FILE_A).deleteFile(FILE_D).commit();
        report = this.reporter.lastCommitReport();
        Assertions.assertThat((Object)report).isNotNull();
        Assertions.assertThat((String)report.operation()).isEqualTo("delete");
        Assertions.assertThat((long)report.snapshotId()).isEqualTo(2L);
        Assertions.assertThat((long)report.sequenceNumber()).isEqualTo(2L);
        Assertions.assertThat((String)report.tableName()).isEqualTo(tableName);
        metrics = report.commitMetrics();
        Assertions.assertThat((long)metrics.removedDataFiles().value()).isEqualTo(2L);
        Assertions.assertThat((long)metrics.totalDeleteFiles().value()).isEqualTo(0L);
        Assertions.assertThat((long)metrics.removedRecords().value()).isEqualTo(2L);
        Assertions.assertThat((long)metrics.totalRecords().value()).isEqualTo(0L);
        Assertions.assertThat((long)metrics.removedFilesSizeInBytes().value()).isEqualTo(20L);
        Assertions.assertThat((long)metrics.totalFilesSizeInBytes().value()).isEqualTo(0L);
    }

    @Test
    public void addAndDeleteDeleteFiles() {
        String tableName = "add-and-delete-delete-files";
        TestTables.TestTable table = TestTables.create(this.tableDir, tableName, SCHEMA, SPEC, SortOrder.unsorted(), this.formatVersion, this.reporter);
        table.newRowDelta().addDeletes(FILE_A_DELETES).addDeletes(FILE_B_DELETES).addDeletes(FILE_C2_DELETES).commit();
        CommitReport report = this.reporter.lastCommitReport();
        Assertions.assertThat((Object)report).isNotNull();
        Assertions.assertThat((String)report.operation()).isEqualTo("overwrite");
        Assertions.assertThat((long)report.snapshotId()).isEqualTo(1L);
        Assertions.assertThat((long)report.sequenceNumber()).isEqualTo(1L);
        Assertions.assertThat((String)report.tableName()).isEqualTo(tableName);
        CommitMetricsResult metrics = report.commitMetrics();
        Assertions.assertThat((long)metrics.addedDeleteFiles().value()).isEqualTo(3L);
        Assertions.assertThat((long)metrics.totalDeleteFiles().value()).isEqualTo(3L);
        Assertions.assertThat((long)metrics.addedPositionalDeleteFiles().value()).isEqualTo(2L);
        Assertions.assertThat((long)metrics.addedEqualityDeleteFiles().value()).isEqualTo(1L);
        Assertions.assertThat((long)metrics.addedPositionalDeletes().value()).isEqualTo(2L);
        Assertions.assertThat((long)metrics.totalPositionalDeletes().value()).isEqualTo(2L);
        Assertions.assertThat((long)metrics.addedEqualityDeletes().value()).isEqualTo(1L);
        Assertions.assertThat((long)metrics.totalEqualityDeletes().value()).isEqualTo(1L);
        Assertions.assertThat((long)metrics.addedFilesSizeInBytes().value()).isEqualTo(30L);
        Assertions.assertThat((long)metrics.totalFilesSizeInBytes().value()).isEqualTo(30L);
        table.newRewrite().rewriteFiles((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)FILE_A_DELETES, (Object)FILE_B_DELETES, (Object)FILE_C2_DELETES), (Set)ImmutableSet.of(), (Set)ImmutableSet.of()).commit();
        report = this.reporter.lastCommitReport();
        Assertions.assertThat((Object)report).isNotNull();
        Assertions.assertThat((String)report.operation()).isEqualTo("replace");
        Assertions.assertThat((long)report.snapshotId()).isEqualTo(2L);
        Assertions.assertThat((long)report.sequenceNumber()).isEqualTo(2L);
        Assertions.assertThat((String)report.tableName()).isEqualTo(tableName);
        metrics = report.commitMetrics();
        Assertions.assertThat((long)metrics.removedDeleteFiles().value()).isEqualTo(3L);
        Assertions.assertThat((long)metrics.totalDeleteFiles().value()).isEqualTo(0L);
        Assertions.assertThat((long)metrics.removedPositionalDeleteFiles().value()).isEqualTo(2L);
        Assertions.assertThat((long)metrics.removedEqualityDeleteFiles().value()).isEqualTo(1L);
        Assertions.assertThat((long)metrics.removedPositionalDeletes().value()).isEqualTo(2L);
        Assertions.assertThat((long)metrics.totalPositionalDeletes().value()).isEqualTo(0L);
        Assertions.assertThat((long)metrics.removedEqualityDeletes().value()).isEqualTo(1L);
        Assertions.assertThat((long)metrics.totalEqualityDeletes().value()).isEqualTo(0L);
        Assertions.assertThat((long)metrics.removedFilesSizeInBytes().value()).isEqualTo(30L);
        Assertions.assertThat((long)metrics.totalFilesSizeInBytes().value()).isEqualTo(0L);
    }

    @Test
    public void addAndDeleteManifests() throws IOException {
        String tableName = "add-and-delete-manifests";
        TestTables.TestTable table = TestTables.create(this.tableDir, tableName, SCHEMA, SPEC, SortOrder.unsorted(), this.formatVersion, this.reporter);
        table.newAppend().appendFile(FILE_A).commit();
        Snapshot snap1 = table.currentSnapshot();
        table.newAppend().appendFile(FILE_B).commit();
        Snapshot snap2 = table.currentSnapshot();
        ManifestFile newManifest = this.writeManifest("manifest-file.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, snap1.snapshotId(), FILE_A), this.manifestEntry(ManifestEntry.Status.EXISTING, snap2.snapshotId(), FILE_B));
        RewriteManifests rewriteManifests = table.rewriteManifests();
        for (ManifestFile manifest : snap2.dataManifests(table.io())) {
            rewriteManifests.deleteManifest(manifest);
        }
        rewriteManifests.addManifest(newManifest).commit();
        CommitReport report = this.reporter.lastCommitReport();
        Assertions.assertThat((Object)report).isNotNull();
        Assertions.assertThat((String)report.operation()).isEqualTo("append");
        Assertions.assertThat((long)report.snapshotId()).isEqualTo(2L);
        Assertions.assertThat((long)report.sequenceNumber()).isEqualTo(2L);
        Assertions.assertThat((String)report.tableName()).isEqualTo(tableName);
        CommitMetricsResult metrics = report.commitMetrics();
        Assertions.assertThat((long)metrics.addedDataFiles().value()).isEqualTo(1L);
        Assertions.assertThat((long)metrics.addedRecords().value()).isEqualTo(1L);
        Assertions.assertThat((long)metrics.addedFilesSizeInBytes().value()).isEqualTo(10L);
    }
}

