/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TestCatalogErrorConstructor;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.metrics.MetricsReport;
import org.apache.iceberg.metrics.MetricsReporter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestCatalogUtil {
    @Test
    public void loadCustomCatalog() {
        HashMap options = Maps.newHashMap();
        options.put("key", "val");
        Configuration hadoopConf = new Configuration();
        String name = "custom";
        Catalog catalog = CatalogUtil.loadCatalog((String)TestCatalog.class.getName(), (String)name, (Map)options, (Object)hadoopConf);
        Assertions.assertThat((Object)catalog).isInstanceOf(TestCatalog.class);
        Assert.assertEquals((Object)name, (Object)((TestCatalog)catalog).catalogName);
        Assert.assertEquals((Object)options, (Object)((TestCatalog)catalog).catalogProperties);
    }

    @Test
    public void loadCustomCatalog_withHadoopConfig() {
        HashMap options = Maps.newHashMap();
        options.put("key", "val");
        Configuration hadoopConf = new Configuration();
        hadoopConf.set("key", "val");
        String name = "custom";
        Catalog catalog = CatalogUtil.loadCatalog((String)TestCatalogConfigurable.class.getName(), (String)name, (Map)options, (Object)hadoopConf);
        Assertions.assertThat((Object)catalog).isInstanceOf(TestCatalogConfigurable.class);
        Assert.assertEquals((Object)name, (Object)((TestCatalogConfigurable)catalog).catalogName);
        Assert.assertEquals((Object)options, (Object)((TestCatalogConfigurable)catalog).catalogProperties);
        Assert.assertEquals((Object)hadoopConf, (Object)((TestCatalogConfigurable)catalog).configuration);
    }

    @Test
    public void loadCustomCatalog_NoArgConstructorNotFound() {
        HashMap options = Maps.newHashMap();
        options.put("key", "val");
        Configuration hadoopConf = new Configuration();
        String name = "custom";
        AssertHelpers.assertThrows((String)"must have no-arg constructor", IllegalArgumentException.class, (String)"NoSuchMethodException: org.apache.iceberg.TestCatalogUtil$TestCatalogBadConstructor.<init>()", () -> CatalogUtil.loadCatalog((String)TestCatalogBadConstructor.class.getName(), (String)name, (Map)options, (Object)hadoopConf));
    }

    @Test
    public void loadCustomCatalog_NotImplementCatalog() {
        HashMap options = Maps.newHashMap();
        options.put("key", "val");
        Configuration hadoopConf = new Configuration();
        String name = "custom";
        AssertHelpers.assertThrows((String)"must implement catalog", IllegalArgumentException.class, (String)"does not implement Catalog", () -> CatalogUtil.loadCatalog((String)TestCatalogNoInterface.class.getName(), (String)name, (Map)options, (Object)hadoopConf));
    }

    @Test
    public void loadCustomCatalog_ConstructorErrorCatalog() {
        HashMap options = Maps.newHashMap();
        options.put("key", "val");
        Configuration hadoopConf = new Configuration();
        String name = "custom";
        String impl = TestCatalogErrorConstructor.class.getName();
        AssertHelpers.assertThrows((String)"must be able to initialize catalog", IllegalArgumentException.class, (String)"NoClassDefFoundError: Error while initializing class", () -> CatalogUtil.loadCatalog((String)impl, (String)name, (Map)options, (Object)hadoopConf));
    }

    @Test
    public void loadCustomCatalog_BadCatalogNameCatalog() {
        HashMap options = Maps.newHashMap();
        options.put("key", "val");
        Configuration hadoopConf = new Configuration();
        String name = "custom";
        String impl = "CatalogDoesNotExist";
        AssertHelpers.assertThrows((String)"catalog must exist", IllegalArgumentException.class, (String)"java.lang.ClassNotFoundException: CatalogDoesNotExist", () -> CatalogUtil.loadCatalog((String)impl, (String)name, (Map)options, (Object)hadoopConf));
    }

    @Test
    public void loadCustomFileIO_noArg() {
        HashMap properties = Maps.newHashMap();
        properties.put("key", "val");
        FileIO fileIO = CatalogUtil.loadFileIO((String)TestFileIONoArg.class.getName(), (Map)properties, null);
        Assertions.assertThat((Object)fileIO).isInstanceOf(TestFileIONoArg.class);
        Assert.assertEquals((Object)properties, (Object)((TestFileIONoArg)fileIO).map);
    }

    @Test
    public void loadCustomFileIO_hadoopConfigConstructor() {
        Configuration configuration = new Configuration();
        configuration.set("key", "val");
        FileIO fileIO = CatalogUtil.loadFileIO((String)HadoopFileIO.class.getName(), (Map)Maps.newHashMap(), (Object)configuration);
        Assertions.assertThat((Object)fileIO).isInstanceOf(HadoopFileIO.class);
        Assert.assertEquals((Object)"val", (Object)((HadoopFileIO)fileIO).conf().get("key"));
    }

    @Test
    public void loadCustomFileIO_configurable() {
        Configuration configuration = new Configuration();
        configuration.set("key", "val");
        FileIO fileIO = CatalogUtil.loadFileIO((String)TestFileIOConfigurable.class.getName(), (Map)Maps.newHashMap(), (Object)configuration);
        Assertions.assertThat((Object)fileIO).isInstanceOf(TestFileIOConfigurable.class);
        Assert.assertEquals((Object)configuration, (Object)((TestFileIOConfigurable)fileIO).configuration);
    }

    @Test
    public void loadCustomFileIO_badArg() {
        AssertHelpers.assertThrows((String)"cannot find constructor", IllegalArgumentException.class, (String)"missing no-arg constructor", () -> CatalogUtil.loadFileIO((String)TestFileIOBadArg.class.getName(), (Map)Maps.newHashMap(), null));
    }

    @Test
    public void loadCustomFileIO_badClass() {
        AssertHelpers.assertThrows((String)"cannot cast", IllegalArgumentException.class, (String)"does not implement FileIO", () -> CatalogUtil.loadFileIO((String)TestFileIONotImpl.class.getName(), (Map)Maps.newHashMap(), null));
    }

    @Test
    public void buildCustomCatalog_withTypeSet() {
        HashMap options = Maps.newHashMap();
        options.put("catalog-impl", "CustomCatalog");
        options.put("type", "hive");
        Configuration hadoopConf = new Configuration();
        String name = "custom";
        AssertHelpers.assertThrows((String)"Should complain about both configs being set", IllegalArgumentException.class, (String)"both type and catalog-impl are set", () -> CatalogUtil.buildIcebergCatalog((String)name, (Map)options, (Object)hadoopConf));
    }

    @Test
    public void loadCustomMetricsReporter_noArg() {
        HashMap properties = Maps.newHashMap();
        properties.put("key", "val");
        properties.put("metrics-reporter-impl", TestMetricsReporterDefault.class.getName());
        MetricsReporter metricsReporter = CatalogUtil.loadMetricsReporter((Map)properties);
        Assertions.assertThat((Object)metricsReporter).isInstanceOf(TestMetricsReporterDefault.class);
    }

    @Test
    public void loadCustomMetricsReporter_badArg() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CatalogUtil.loadMetricsReporter((Map)ImmutableMap.of((Object)"metrics-reporter-impl", (Object)TestMetricsReporterBadArg.class.getName()))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("missing no-arg constructor");
    }

    @Test
    public void loadCustomMetricsReporter_badClass() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CatalogUtil.loadMetricsReporter((Map)ImmutableMap.of((Object)"metrics-reporter-impl", (Object)TestFileIONotImpl.class.getName()))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("does not implement MetricsReporter");
    }

    public static class TestMetricsReporterDefault
    implements MetricsReporter {
        public void report(MetricsReport report) {
        }
    }

    public static class TestMetricsReporterBadArg
    implements MetricsReporter {
        private final String arg;

        public TestMetricsReporterBadArg(String arg) {
            this.arg = arg;
        }

        public void report(MetricsReport report) {
        }
    }

    public static class TestFileIONotImpl {
    }

    public static class TestFileIOBadArg
    implements FileIO {
        private final String arg;

        public TestFileIOBadArg(String arg) {
            this.arg = arg;
        }

        public InputFile newInputFile(String path) {
            return null;
        }

        public OutputFile newOutputFile(String path) {
            return null;
        }

        public void deleteFile(String path) {
        }

        public String getArg() {
            return this.arg;
        }
    }

    public static class TestFileIONoArg
    implements FileIO {
        private Map<String, String> map;

        public InputFile newInputFile(String path) {
            return null;
        }

        public OutputFile newOutputFile(String path) {
            return null;
        }

        public void deleteFile(String path) {
        }

        public Map<String, String> getMap() {
            return this.map;
        }

        public void initialize(Map<String, String> properties) {
            this.map = properties;
        }
    }

    public static class TestFileIOConfigurable
    implements FileIO,
    Configurable {
        private Configuration configuration;

        public void setConf(Configuration conf) {
            this.configuration = conf;
        }

        public Configuration getConf() {
            return this.configuration;
        }

        public InputFile newInputFile(String path) {
            return null;
        }

        public OutputFile newOutputFile(String path) {
            return null;
        }

        public void deleteFile(String path) {
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }
    }

    public static class TestCatalogNoInterface {
    }

    public static class TestCatalogBadConstructor
    extends BaseMetastoreCatalog {
        public TestCatalogBadConstructor(String arg) {
        }

        protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
            return null;
        }

        protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
            return null;
        }

        public List<TableIdentifier> listTables(Namespace namespace) {
            return null;
        }

        public boolean dropTable(TableIdentifier identifier, boolean purge) {
            return false;
        }

        public void renameTable(TableIdentifier from, TableIdentifier to) {
        }

        public void initialize(String name, Map<String, String> properties) {
        }
    }

    public static class TestCatalogConfigurable
    extends BaseMetastoreCatalog
    implements Configurable {
        private String catalogName;
        private Map<String, String> catalogProperties;
        private Configuration configuration;

        public void initialize(String name, Map<String, String> properties) {
            this.catalogName = name;
            this.catalogProperties = properties;
        }

        public void setConf(Configuration conf) {
            this.configuration = conf;
        }

        public Configuration getConf() {
            return this.configuration;
        }

        protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
            return null;
        }

        protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
            return null;
        }

        public List<TableIdentifier> listTables(Namespace namespace) {
            return null;
        }

        public boolean dropTable(TableIdentifier identifier, boolean purge) {
            return false;
        }

        public void renameTable(TableIdentifier from, TableIdentifier to) {
        }
    }

    public static class TestCatalog
    extends BaseMetastoreCatalog {
        private String catalogName;
        private Map<String, String> catalogProperties;

        public void initialize(String name, Map<String, String> properties) {
            this.catalogName = name;
            this.catalogProperties = properties;
        }

        protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
            return null;
        }

        protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
            return null;
        }

        public List<TableIdentifier> listTables(Namespace namespace) {
            return null;
        }

        public boolean dropTable(TableIdentifier identifier, boolean purge) {
            return false;
        }

        public void renameTable(TableIdentifier from, TableIdentifier to) {
        }
    }
}

