/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.FilesTable;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestBatchScans
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestBatchScans(int formatVersion) {
        super(formatVersion);
    }

    @Test
    public void testDataTableScan() {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        if (this.formatVersion > 1) {
            this.table.newRowDelta().addDeletes(FILE_A_DELETES).commit();
        }
        BatchScan scan = this.table.newBatchScan();
        List<ScanTask> tasks = this.planTasks(scan);
        Assert.assertEquals((String)"Expected 2 tasks", (long)2L, (long)tasks.size());
        FileScanTask t1 = tasks.get(0).asFileScanTask();
        Assert.assertEquals((String)"Task file must match", (Object)((DataFile)t1.file()).path(), (Object)FILE_A.path());
        this.V1Assert.assertEquals("Task deletes size must match", 0, t1.deletes().size());
        this.V2Assert.assertEquals("Task deletes size must match", 1, t1.deletes().size());
        FileScanTask t2 = tasks.get(1).asFileScanTask();
        Assert.assertEquals((String)"Task file must match", (Object)((DataFile)t2.file()).path(), (Object)FILE_B.path());
        Assert.assertEquals((String)"Task deletes size must match", (long)0L, (long)t2.deletes().size());
        List<ScanTaskGroup<ScanTask>> taskGroups = this.planTaskGroups(scan);
        Assert.assertEquals((String)"Expected 1 task group", (long)1L, (long)taskGroups.size());
        ScanTaskGroup<ScanTask> tg = taskGroups.get(0);
        Assert.assertEquals((String)"Task number must match", (long)2L, (long)tg.tasks().size());
        this.V1Assert.assertEquals("Files count must match", 2, tg.filesCount());
        this.V2Assert.assertEquals("Files count must match", 3, tg.filesCount());
    }

    @Test
    public void testFilesTableScan() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.newFastAppend().appendFile(FILE_B).commit();
        List manifestPaths = this.table.currentSnapshot().dataManifests(this.table.io()).stream().map(ManifestFile::path).sorted().collect(Collectors.toList());
        Assert.assertEquals((String)"Must have 2 manifests", (long)2L, (long)manifestPaths.size());
        FilesTable filesTable = new FilesTable((Table)this.table);
        BatchScan scan = filesTable.newBatchScan();
        List<ScanTask> tasks = this.planTasks(scan);
        Assert.assertEquals((String)"Expected 2 tasks", (long)2L, (long)tasks.size());
        FileScanTask t1 = tasks.get(0).asFileScanTask();
        Assert.assertEquals((String)"Task file must match", (Object)((DataFile)t1.file()).path(), manifestPaths.get(0));
        FileScanTask t2 = tasks.get(1).asFileScanTask();
        Assert.assertEquals((String)"Task file must match", (Object)((DataFile)t2.file()).path(), manifestPaths.get(1));
        List<ScanTaskGroup<ScanTask>> taskGroups = this.planTaskGroups(scan);
        Assert.assertEquals((String)"Expected 1 task group", (long)1L, (long)taskGroups.size());
        ScanTaskGroup<ScanTask> tg = taskGroups.get(0);
        Assert.assertEquals((String)"Task number must match", (long)2L, (long)tg.tasks().size());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ScanTask> planTasks(BatchScan scan) {
        try (CloseableIterable tasks = scan.planFiles();){
            ArrayList tasksAsList = Lists.newArrayList((Iterable)tasks);
            tasksAsList.sort((t1, t2) -> this.path((ScanTask)t1).compareTo(this.path((ScanTask)t2)));
            ArrayList arrayList = tasksAsList;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ScanTaskGroup<ScanTask>> planTaskGroups(BatchScan scan) {
        try (CloseableIterable taskGroups = scan.planTasks();){
            ArrayList arrayList = Lists.newArrayList((Iterable)taskGroups);
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String path(ScanTask task) {
        return ((ContentScanTask)task).file().path().toString();
    }
}

