/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.AddedRowsScanTask;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.ChangelogScanTask;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeletedDataFileScanTask;
import org.apache.iceberg.IncrementalChangelogScan;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.ScanTestBase;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ComparisonChain;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestBaseIncrementalChangelogScan
extends ScanTestBase<IncrementalChangelogScan, ChangelogScanTask, ScanTaskGroup<ChangelogScanTask>> {
    public TestBaseIncrementalChangelogScan(int formatVersion) {
        super(formatVersion);
    }

    @Override
    protected IncrementalChangelogScan newScan() {
        return this.table.newIncrementalChangelogScan();
    }

    @Test
    public void testDataFilters() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        Snapshot snap1 = this.table.currentSnapshot();
        ManifestFile snap1DataManifest = (ManifestFile)Iterables.getOnlyElement((Iterable)snap1.dataManifests(this.table.io()));
        this.table.newFastAppend().appendFile(FILE_B).commit();
        Snapshot snap2 = this.table.currentSnapshot();
        Assert.assertEquals((String)"Must be 2 data manifests", (long)2L, (long)snap2.dataManifests(this.table.io()).size());
        this.withUnavailableLocations((Iterable<String>)ImmutableList.of((Object)snap1DataManifest.path()), () -> {
            IncrementalChangelogScan scan = (IncrementalChangelogScan)this.newScan().filter((Expression)Expressions.equal((String)"data", (Object)"k"));
            List<ChangelogScanTask> tasks = this.plan(scan);
            Assert.assertEquals((String)"Must have 1 task", (long)1L, (long)tasks.size());
            AddedRowsScanTask t1 = (AddedRowsScanTask)Iterables.getOnlyElement(tasks);
            Assert.assertEquals((String)"Ordinal must match", (long)1L, (long)t1.changeOrdinal());
            Assert.assertEquals((String)"Snapshot must match", (long)snap2.snapshotId(), (long)t1.commitSnapshotId());
            Assert.assertEquals((String)"Data file must match", (Object)FILE_B.path(), (Object)((DataFile)t1.file()).path());
            Assert.assertTrue((String)"Must be no deletes", (boolean)t1.deletes().isEmpty());
        });
    }

    @Test
    public void testOverwrites() {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Snapshot snap1 = this.table.currentSnapshot();
        this.table.newOverwrite().addFile(FILE_A2).deleteFile(FILE_A).commit();
        Snapshot snap2 = this.table.currentSnapshot();
        IncrementalChangelogScan scan = (IncrementalChangelogScan)((IncrementalChangelogScan)this.newScan().fromSnapshotExclusive(snap1.snapshotId())).toSnapshot(snap2.snapshotId());
        List<ChangelogScanTask> tasks = this.plan(scan);
        Assert.assertEquals((String)"Must have 2 tasks", (long)2L, (long)tasks.size());
        AddedRowsScanTask t1 = (AddedRowsScanTask)tasks.get(0);
        Assert.assertEquals((String)"Ordinal must match", (long)0L, (long)t1.changeOrdinal());
        Assert.assertEquals((String)"Snapshot must match", (long)snap2.snapshotId(), (long)t1.commitSnapshotId());
        Assert.assertEquals((String)"Data file must match", (Object)FILE_A2.path(), (Object)((DataFile)t1.file()).path());
        Assert.assertTrue((String)"Must be no deletes", (boolean)t1.deletes().isEmpty());
        DeletedDataFileScanTask t2 = (DeletedDataFileScanTask)tasks.get(1);
        Assert.assertEquals((String)"Ordinal must match", (long)0L, (long)t2.changeOrdinal());
        Assert.assertEquals((String)"Snapshot must match", (long)snap2.snapshotId(), (long)t2.commitSnapshotId());
        Assert.assertEquals((String)"Data file must match", (Object)FILE_A.path(), (Object)((DataFile)t2.file()).path());
        Assert.assertTrue((String)"Must be no deletes", (boolean)t2.existingDeletes().isEmpty());
    }

    @Test
    public void testFileDeletes() {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Snapshot snap1 = this.table.currentSnapshot();
        this.table.newDelete().deleteFile(FILE_A).commit();
        Snapshot snap2 = this.table.currentSnapshot();
        IncrementalChangelogScan scan = (IncrementalChangelogScan)((IncrementalChangelogScan)this.newScan().fromSnapshotExclusive(snap1.snapshotId())).toSnapshot(snap2.snapshotId());
        List<ChangelogScanTask> tasks = this.plan(scan);
        Assert.assertEquals((String)"Must have 1 tasks", (long)1L, (long)tasks.size());
        DeletedDataFileScanTask t1 = (DeletedDataFileScanTask)Iterables.getOnlyElement(tasks);
        Assert.assertEquals((String)"Ordinal must match", (long)0L, (long)t1.changeOrdinal());
        Assert.assertEquals((String)"Snapshot must match", (long)snap2.snapshotId(), (long)t1.commitSnapshotId());
        Assert.assertEquals((String)"Data file must match", (Object)FILE_A.path(), (Object)((DataFile)t1.file()).path());
        Assert.assertTrue((String)"Must be no deletes", (boolean)t1.existingDeletes().isEmpty());
    }

    @Test
    public void testExistingEntriesInNewDataManifestsAreIgnored() {
        this.table.updateProperties().set("commit.manifest.min-count-to-merge", "1").set("commit.manifest-merge.enabled", "true").commit();
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.newAppend().appendFile(FILE_C).commit();
        Snapshot snap3 = this.table.currentSnapshot();
        ManifestFile manifest = (ManifestFile)Iterables.getOnlyElement((Iterable)snap3.dataManifests(this.table.io()));
        Assert.assertTrue((String)"Manifest must have existing files", (boolean)manifest.hasExistingFiles());
        IncrementalChangelogScan scan = (IncrementalChangelogScan)((IncrementalChangelogScan)this.newScan().fromSnapshotInclusive(snap3.snapshotId())).toSnapshot(snap3.snapshotId());
        List<ChangelogScanTask> tasks = this.plan(scan);
        Assert.assertEquals((String)"Must have 1 task", (long)1L, (long)tasks.size());
        AddedRowsScanTask t1 = (AddedRowsScanTask)Iterables.getOnlyElement(tasks);
        Assert.assertEquals((String)"Ordinal must match", (long)0L, (long)t1.changeOrdinal());
        Assert.assertEquals((String)"Snapshot must match", (long)snap3.snapshotId(), (long)t1.commitSnapshotId());
        Assert.assertEquals((String)"Data file must match", (Object)FILE_C.path(), (Object)((DataFile)t1.file()).path());
        Assert.assertTrue((String)"Must be no deletes", (boolean)t1.deletes().isEmpty());
    }

    @Test
    public void testManifestRewritesAreIgnored() throws IOException {
        this.table.newAppend().appendFile(FILE_A).commit();
        Snapshot snap1 = this.table.currentSnapshot();
        this.table.newAppend().appendFile(FILE_B).commit();
        Snapshot snap2 = this.table.currentSnapshot();
        ManifestFile newManifest = this.writeManifest("manifest-file.avro", this.manifestEntry(ManifestEntry.Status.EXISTING, snap1.snapshotId(), FILE_A), this.manifestEntry(ManifestEntry.Status.EXISTING, snap2.snapshotId(), FILE_B));
        RewriteManifests rewriteManifests = this.table.rewriteManifests();
        for (ManifestFile manifest : snap2.dataManifests(this.table.io())) {
            rewriteManifests.deleteManifest(manifest);
        }
        rewriteManifests.addManifest(newManifest);
        rewriteManifests.commit();
        this.table.newAppend().appendFile(FILE_C).commit();
        Snapshot snap4 = this.table.currentSnapshot();
        List<ChangelogScanTask> tasks = this.plan(this.newScan());
        Assert.assertEquals((String)"Must have 3 tasks", (long)3L, (long)tasks.size());
        AddedRowsScanTask t1 = (AddedRowsScanTask)tasks.get(0);
        Assert.assertEquals((String)"Ordinal must match", (long)0L, (long)t1.changeOrdinal());
        Assert.assertEquals((String)"Snapshot must match", (long)snap1.snapshotId(), (long)t1.commitSnapshotId());
        Assert.assertEquals((String)"Data file must match", (Object)FILE_A.path(), (Object)((DataFile)t1.file()).path());
        Assert.assertTrue((String)"Must be no deletes", (boolean)t1.deletes().isEmpty());
        AddedRowsScanTask t2 = (AddedRowsScanTask)tasks.get(1);
        Assert.assertEquals((String)"Ordinal must match", (long)1L, (long)t2.changeOrdinal());
        Assert.assertEquals((String)"Snapshot must match", (long)snap2.snapshotId(), (long)t2.commitSnapshotId());
        Assert.assertEquals((String)"Data file must match", (Object)FILE_B.path(), (Object)((DataFile)t2.file()).path());
        Assert.assertTrue((String)"Must be no deletes", (boolean)t2.deletes().isEmpty());
        AddedRowsScanTask t3 = (AddedRowsScanTask)tasks.get(2);
        Assert.assertEquals((String)"Ordinal must match", (long)2L, (long)t3.changeOrdinal());
        Assert.assertEquals((String)"Snapshot must match", (long)snap4.snapshotId(), (long)t3.commitSnapshotId());
        Assert.assertEquals((String)"Data file must match", (Object)FILE_C.path(), (Object)((DataFile)t3.file()).path());
        Assert.assertTrue((String)"Must be no deletes", (boolean)t3.deletes().isEmpty());
    }

    @Test
    public void testDataFileRewrites() {
        this.table.newAppend().appendFile(FILE_A).commit();
        Snapshot snap1 = this.table.currentSnapshot();
        this.table.newAppend().appendFile(FILE_B).commit();
        Snapshot snap2 = this.table.currentSnapshot();
        this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)FILE_A), (Set)ImmutableSet.of((Object)FILE_A2)).commit();
        List<ChangelogScanTask> tasks = this.plan(this.newScan());
        Assert.assertEquals((String)"Must have 2 tasks", (long)2L, (long)tasks.size());
        AddedRowsScanTask t1 = (AddedRowsScanTask)tasks.get(0);
        Assert.assertEquals((String)"Ordinal must match", (long)0L, (long)t1.changeOrdinal());
        Assert.assertEquals((String)"Snapshot must match", (long)snap1.snapshotId(), (long)t1.commitSnapshotId());
        Assert.assertEquals((String)"Data file must match", (Object)FILE_A.path(), (Object)((DataFile)t1.file()).path());
        Assert.assertTrue((String)"Must be no deletes", (boolean)t1.deletes().isEmpty());
        AddedRowsScanTask t2 = (AddedRowsScanTask)tasks.get(1);
        Assert.assertEquals((String)"Ordinal must match", (long)1L, (long)t2.changeOrdinal());
        Assert.assertEquals((String)"Snapshot must match", (long)snap2.snapshotId(), (long)t2.commitSnapshotId());
        Assert.assertEquals((String)"Data file must match", (Object)FILE_B.path(), (Object)((DataFile)t2.file()).path());
        Assert.assertTrue((String)"Must be no deletes", (boolean)t2.deletes().isEmpty());
    }

    @Test
    public void testDeleteFilesAreNotSupported() {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        this.table.newFastAppend().appendFile(FILE_A2).appendFile(FILE_B).commit();
        this.table.newRowDelta().addDeletes(FILE_A2_DELETES).commit();
        AssertHelpers.assertThrows((String)"Should complain about delete files", UnsupportedOperationException.class, (String)"Delete files are currently not supported", () -> this.plan(this.newScan()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ChangelogScanTask> plan(IncrementalChangelogScan scan) {
        try (CloseableIterable tasks = scan.planFiles();){
            ArrayList tasksAsList = Lists.newArrayList((Iterable)tasks);
            tasksAsList.sort(this.taskComparator());
            ArrayList arrayList = tasksAsList;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Comparator<? super ChangelogScanTask> taskComparator() {
        return (t1, t2) -> ComparisonChain.start().compare(t1.changeOrdinal(), t2.changeOrdinal()).compare((Comparable)((Object)t1.getClass().getName()), (Comparable)((Object)t2.getClass().getName())).compare((Comparable)((Object)this.path((ChangelogScanTask)t1)), (Comparable)((Object)this.path((ChangelogScanTask)t2))).result();
    }

    private String path(ChangelogScanTask task) {
        return ((ContentScanTask)task).file().path().toString();
    }
}

