/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.IncrementalAppendScan;
import org.apache.iceberg.ScanTestBase;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.junit.Assert;
import org.junit.Test;

public class TestBaseIncrementalAppendScan
extends ScanTestBase<IncrementalAppendScan, FileScanTask, CombinedScanTask> {
    public TestBaseIncrementalAppendScan(int formatVersion) {
        super(formatVersion);
    }

    @Override
    protected IncrementalAppendScan newScan() {
        return this.table.newIncrementalAppendScan();
    }

    @Test
    public void testFromSnapshotInclusive() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        long snapshotAId = this.table.currentSnapshot().snapshotId();
        this.table.newFastAppend().appendFile(FILE_B).commit();
        long snapshotBId = this.table.currentSnapshot().snapshotId();
        this.table.newFastAppend().appendFile(FILE_C).commit();
        long snapshotCId = this.table.currentSnapshot().snapshotId();
        IncrementalAppendScan scan = (IncrementalAppendScan)this.newScan().fromSnapshotInclusive(snapshotAId);
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)scan.planFiles()));
        IncrementalAppendScan scanWithToSnapshot = (IncrementalAppendScan)((IncrementalAppendScan)this.newScan().fromSnapshotInclusive(snapshotAId)).toSnapshot(snapshotCId);
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)scanWithToSnapshot.planFiles()));
    }

    @Test
    public void testFromSnapshotExclusive() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        long snapshotAId = this.table.currentSnapshot().snapshotId();
        this.table.newFastAppend().appendFile(FILE_B).commit();
        long snapshotBId = this.table.currentSnapshot().snapshotId();
        this.table.newFastAppend().appendFile(FILE_C).commit();
        long snapshotCId = this.table.currentSnapshot().snapshotId();
        IncrementalAppendScan scan = (IncrementalAppendScan)this.newScan().fromSnapshotExclusive(snapshotAId);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)scan.planFiles()));
        IncrementalAppendScan scanWithToSnapshot = (IncrementalAppendScan)((IncrementalAppendScan)this.newScan().fromSnapshotExclusive(snapshotAId)).toSnapshot(snapshotBId);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)scanWithToSnapshot.planFiles()));
    }

    @Test
    public void testFromSnapshotExclusiveForExpiredParent() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        long snapshotAId = this.table.currentSnapshot().snapshotId();
        long expireTimestampSnapshotA = TestHelpers.waitUntilAfter((long)this.table.currentSnapshot().timestampMillis());
        this.table.newFastAppend().appendFile(FILE_B).commit();
        long snapshotBId = this.table.currentSnapshot().snapshotId();
        this.table.newFastAppend().appendFile(FILE_C).commit();
        long snapshotCId = this.table.currentSnapshot().snapshotId();
        this.table.expireSnapshots().expireOlderThan(expireTimestampSnapshotA).commit();
        IncrementalAppendScan scan = (IncrementalAppendScan)this.newScan().fromSnapshotExclusive(snapshotAId);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)scan.planFiles()));
        IncrementalAppendScan scanWithToSnapshot = (IncrementalAppendScan)((IncrementalAppendScan)this.newScan().fromSnapshotExclusive(snapshotAId)).toSnapshot(snapshotBId);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)scanWithToSnapshot.planFiles()));
    }

    @Test
    public void testToSnapshot() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        long snapshotAId = this.table.currentSnapshot().snapshotId();
        this.table.newFastAppend().appendFile(FILE_B).commit();
        long snapshotBId = this.table.currentSnapshot().snapshotId();
        this.table.newFastAppend().appendFile(FILE_C).commit();
        long snapshotCId = this.table.currentSnapshot().snapshotId();
        IncrementalAppendScan scan = (IncrementalAppendScan)this.newScan().toSnapshot(snapshotBId);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)scan.planFiles()));
    }

    @Test
    public void testMultipleRootSnapshots() throws Exception {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        long snapshotAId = this.table.currentSnapshot().snapshotId();
        long expireTimestampSnapshotA = TestHelpers.waitUntilAfter((long)this.table.currentSnapshot().timestampMillis());
        AppendFiles appendFiles = (AppendFiles)this.table.newFastAppend().appendFile(FILE_B).stageOnly();
        long snapshotBId = ((Snapshot)appendFiles.apply()).snapshotId();
        appendFiles.commit();
        this.table.newFastAppend().appendFile(FILE_C).commit();
        long snapshotCId = this.table.currentSnapshot().snapshotId();
        this.table.newFastAppend().appendFile(FILE_D).commit();
        long snapshotDId = this.table.currentSnapshot().snapshotId();
        this.table.expireSnapshots().expireOlderThan(expireTimestampSnapshotA).commit();
        IncrementalAppendScan scan = (IncrementalAppendScan)this.newScan().toSnapshot(snapshotDId);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)scan.planFiles()));
        IncrementalAppendScan scanShouldFail = (IncrementalAppendScan)((IncrementalAppendScan)this.newScan().fromSnapshotExclusive(snapshotBId)).toSnapshot(snapshotDId);
        AssertHelpers.assertThrows((String)"Should throw exception", IllegalArgumentException.class, (String)String.format("Starting snapshot (exclusive) %d is not a parent ancestor of end snapshot %d", snapshotBId, snapshotDId), () -> Iterables.size((Iterable)scanShouldFail.planFiles()));
        IncrementalAppendScan scanShouldFailInclusive = (IncrementalAppendScan)((IncrementalAppendScan)this.newScan().fromSnapshotInclusive(snapshotBId)).toSnapshot(snapshotDId);
        AssertHelpers.assertThrows((String)"Should throw exception", IllegalArgumentException.class, (String)String.format("Starting snapshot (inclusive) %d is not an ancestor of end snapshot %d", snapshotBId, snapshotDId), () -> Iterables.size((Iterable)scanShouldFailInclusive.planFiles()));
    }
}

