/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.GenericManifestEntry;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotProducer;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.io.Files;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class TableTestBase {
    public static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())});
    protected static final int BUCKETS_NUMBER = 16;
    protected static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).bucket("data", 16).build();
    static final DataFile FILE_A = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=0").withRecordCount(1L).build();
    static final DataFile FILE_A2 = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a-2.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=0").withRecordCount(1L).build();
    static final DeleteFile FILE_A_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofPositionDeletes().withPath("/path/to/data-a-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=0").withRecordCount(1L).build();
    static final DeleteFile FILE_A2_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofEqualityDeletes(new int[]{1}).withPath("/path/to/data-a2-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=0").withRecordCount(1L).build();
    static final DataFile FILE_B = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-b.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=1").withRecordCount(1L).build();
    static final DeleteFile FILE_B_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofPositionDeletes().withPath("/path/to/data-b-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=1").withRecordCount(1L).build();
    static final DataFile FILE_C = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-c.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=2").withRecordCount(1L).build();
    static final DeleteFile FILE_C2_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofEqualityDeletes(new int[]{1}).withPath("/path/to/data-c-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=2").withRecordCount(1L).build();
    static final DataFile FILE_D = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-d.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=3").withRecordCount(1L).build();
    static final DeleteFile FILE_D2_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofEqualityDeletes(new int[]{1}).withPath("/path/to/data-d-deletes.parquet").withFileSizeInBytes(10L).withPartitionPath("data_bucket=3").withRecordCount(1L).build();
    static final DataFile FILE_WITH_STATS = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-with-stats.parquet").withMetrics(new Metrics(Long.valueOf(10L), (Map)ImmutableMap.of((Object)3, (Object)100L, (Object)4, (Object)200L), (Map)ImmutableMap.of((Object)3, (Object)90L, (Object)4, (Object)180L), (Map)ImmutableMap.of((Object)3, (Object)10L, (Object)4, (Object)20L), (Map)ImmutableMap.of((Object)3, (Object)0L, (Object)4, (Object)0L), (Map)ImmutableMap.of((Object)3, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)1), (Object)4, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)2)), (Map)ImmutableMap.of((Object)3, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)5), (Object)4, (Object)Conversions.toByteBuffer((Type)Types.IntegerType.get(), (Object)10)))).withFileSizeInBytes(350L).build();
    static final FileIO FILE_IO = new TestTables.LocalFileIO();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    protected File tableDir = null;
    protected File metadataDir = null;
    public TestTables.TestTable table = null;
    protected final int formatVersion;
    protected final TableAssertions V1Assert;
    protected final TableAssertions V2Assert;

    public TableTestBase(int formatVersion) {
        this.formatVersion = formatVersion;
        this.V1Assert = new TableAssertions(1, formatVersion);
        this.V2Assert = new TableAssertions(2, formatVersion);
    }

    @Before
    public void setupTable() throws Exception {
        this.tableDir = this.temp.newFolder();
        this.tableDir.delete();
        this.metadataDir = new File(this.tableDir, "metadata");
        this.table = this.create(SCHEMA, SPEC);
    }

    @After
    public void cleanupTables() {
        TestTables.clearTables();
    }

    List<File> listManifestFiles() {
        return this.listManifestFiles(this.tableDir);
    }

    List<File> listManifestFiles(File tableDirToList) {
        return Lists.newArrayList((Object[])new File(tableDirToList, "metadata").listFiles((dir, name) -> !name.startsWith("snap") && Files.getFileExtension((String)name).equalsIgnoreCase("avro")));
    }

    List<File> listManifestLists(String tableDirToList) {
        return Lists.newArrayList((Object[])new File(tableDirToList, "metadata").listFiles((dir, name) -> name.startsWith("snap") && Files.getFileExtension((String)name).equalsIgnoreCase("avro")));
    }

    public static long countAllMetadataFiles(File tableDir) {
        return Arrays.stream(new File(tableDir, "metadata").listFiles()).filter(f -> f.isFile()).count();
    }

    protected TestTables.TestTable create(Schema schema, PartitionSpec spec) {
        return TestTables.create(this.tableDir, "test", schema, spec, this.formatVersion);
    }

    TestTables.TestTable load() {
        return TestTables.load(this.tableDir, "test");
    }

    Integer version() {
        return TestTables.metadataVersion("test");
    }

    public TableMetadata readMetadata() {
        return TestTables.readMetadata("test");
    }

    ManifestFile writeManifest(DataFile ... files) throws IOException {
        return this.writeManifest((Long)null, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManifestFile writeManifest(Long snapshotId, DataFile ... files) throws IOException {
        File manifestFile = this.temp.newFile("input.m0.avro");
        Assert.assertTrue((boolean)manifestFile.delete());
        OutputFile outputFile = this.table.ops().io().newOutputFile(manifestFile.getCanonicalPath());
        try (ManifestWriter writer = ManifestFiles.write((int)this.formatVersion, (PartitionSpec)this.table.spec(), (OutputFile)outputFile, (Long)snapshotId);){
            for (DataFile file : files) {
                writer.add((ContentFile)file);
            }
        }
        return writer.toManifestFile();
    }

    ManifestFile writeManifest(String fileName, ManifestEntry<?> ... entries) throws IOException {
        return this.writeManifest(null, fileName, entries);
    }

    ManifestFile writeManifest(Long snapshotId, ManifestEntry<?> ... entries) throws IOException {
        return this.writeManifest(snapshotId, "input.m0.avro", entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <F extends ContentFile<F>> ManifestFile writeManifest(Long snapshotId, String fileName, ManifestEntry<?> ... entries) throws IOException {
        File manifestFile = this.temp.newFile(fileName);
        Assert.assertTrue((boolean)manifestFile.delete());
        OutputFile outputFile = this.table.ops().io().newOutputFile(manifestFile.getCanonicalPath());
        try (ManifestWriter writer = entries[0].file() instanceof DataFile ? ManifestFiles.write((int)this.formatVersion, (PartitionSpec)this.table.spec(), (OutputFile)outputFile, (Long)snapshotId) : ManifestFiles.writeDeleteManifest((int)this.formatVersion, (PartitionSpec)this.table.spec(), (OutputFile)outputFile, (Long)snapshotId);){
            for (ManifestEntry<?> entry : entries) {
                writer.addEntry(entry);
            }
        }
        return writer.toManifestFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManifestFile writeDeleteManifest(int newFormatVersion, Long snapshotId, DeleteFile ... deleteFiles) throws IOException {
        OutputFile manifestFile = org.apache.iceberg.Files.localOutput((String)FileFormat.AVRO.addExtension(this.temp.newFile().toString()));
        try (ManifestWriter writer = ManifestFiles.writeDeleteManifest((int)newFormatVersion, (PartitionSpec)SPEC, (OutputFile)manifestFile, (Long)snapshotId);){
            for (DeleteFile deleteFile : deleteFiles) {
                writer.add((ContentFile)deleteFile);
            }
        }
        return writer.toManifestFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManifestFile writeManifestWithName(String name, DataFile ... files) throws IOException {
        File manifestFile = this.temp.newFile(name + ".avro");
        Assert.assertTrue((boolean)manifestFile.delete());
        OutputFile outputFile = this.table.ops().io().newOutputFile(manifestFile.getCanonicalPath());
        try (ManifestWriter writer = ManifestFiles.write((int)this.formatVersion, (PartitionSpec)this.table.spec(), (OutputFile)outputFile, null);){
            for (DataFile file : files) {
                writer.add((ContentFile)file);
            }
        }
        return writer.toManifestFile();
    }

    ManifestEntry<DataFile> manifestEntry(ManifestEntry.Status status, Long snapshotId, DataFile file) {
        return this.manifestEntry(status, snapshotId, 0L, 0L, file);
    }

    ManifestEntry<DataFile> manifestEntry(ManifestEntry.Status status, Long snapshotId, Long dataSequenceNumber, Long fileSequenceNumber, DataFile file) {
        GenericManifestEntry entry = new GenericManifestEntry(this.table.spec().partitionType());
        switch (status) {
            case ADDED: {
                if (dataSequenceNumber != null && dataSequenceNumber != 0L) {
                    return entry.wrapAppend(snapshotId, dataSequenceNumber, (ContentFile)file);
                }
                return entry.wrapAppend(snapshotId, (ContentFile)file);
            }
            case EXISTING: {
                return entry.wrapExisting(snapshotId, dataSequenceNumber, fileSequenceNumber, (ContentFile)file);
            }
            case DELETED: {
                return entry.wrapDelete(snapshotId, dataSequenceNumber, fileSequenceNumber, (ContentFile)file);
            }
        }
        throw new IllegalArgumentException("Unexpected entry status: " + status);
    }

    void validateSnapshot(Snapshot old, Snapshot snap, DataFile ... newFiles) {
        this.validateSnapshot(old, snap, (Long)null, newFiles);
    }

    void validateSnapshot(Snapshot old, Snapshot snap, long sequenceNumber, DataFile ... newFiles) {
        this.validateSnapshot(old, snap, (Long)sequenceNumber, newFiles);
    }

    Snapshot commit(Table table, SnapshotUpdate snapshotUpdate, String branch) {
        Snapshot snapshot;
        if (branch.equals("main")) {
            snapshotUpdate.commit();
            snapshot = table.currentSnapshot();
        } else {
            ((SnapshotProducer)snapshotUpdate.toBranch(branch)).commit();
            snapshot = table.snapshot(branch);
        }
        return snapshot;
    }

    Snapshot apply(SnapshotUpdate snapshotUpdate, String branch) {
        if (branch.equals("main")) {
            return ((SnapshotProducer)snapshotUpdate).apply();
        }
        return ((SnapshotProducer)snapshotUpdate.toBranch(branch)).apply();
    }

    void validateSnapshot(Snapshot old, Snapshot snap, Long sequenceNumber, DataFile ... newFiles) {
        Assert.assertEquals((String)"Should not change delete manifests", (Object)(old != null ? Sets.newHashSet((Iterable)old.deleteManifests(FILE_IO)) : ImmutableSet.of()), (Object)Sets.newHashSet((Iterable)snap.deleteManifests(FILE_IO)));
        ImmutableList oldManifests = old != null ? old.dataManifests(FILE_IO) : ImmutableList.of();
        ArrayList newManifests = Lists.newArrayList((Iterable)snap.dataManifests(FILE_IO));
        for (ManifestFile oldManifest : oldManifests) {
            Assert.assertTrue((String)"New snapshot should contain old manifests", (boolean)newManifests.remove(oldManifest));
        }
        Assert.assertEquals((String)"Should create 1 new manifest and reuse old manifests", (long)1L, (long)newManifests.size());
        ManifestFile manifest = (ManifestFile)newManifests.get(0);
        long id = snap.snapshotId();
        Iterator<String> newPaths = this.paths(newFiles).iterator();
        for (ManifestEntry entry : ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO).entries()) {
            DataFile file = (DataFile)entry.file();
            if (sequenceNumber != null) {
                this.V1Assert.assertEquals("Data sequence number should default to 0", 0L, entry.dataSequenceNumber());
                this.V1Assert.assertEquals("Data sequence number should default to 0", 0L, ((DataFile)entry.file()).dataSequenceNumber());
                this.V2Assert.assertEquals("Data sequence number should match expected", sequenceNumber, entry.dataSequenceNumber());
                this.V2Assert.assertEquals("Data sequence number should match expected", sequenceNumber, ((DataFile)entry.file()).dataSequenceNumber());
                this.V2Assert.assertEquals("Sequence number should match expected", snap.sequenceNumber(), entry.dataSequenceNumber());
                this.V2Assert.assertEquals("File sequence number should match expected", sequenceNumber, ((DataFile)entry.file()).fileSequenceNumber());
                this.V2Assert.assertEquals("File sequence number should match expected", snap.sequenceNumber(), ((DataFile)entry.file()).fileSequenceNumber());
            }
            Assert.assertEquals((String)"Path should match expected", (Object)newPaths.next(), (Object)file.path().toString());
            Assert.assertEquals((String)"File's snapshot ID should match", (long)id, (long)entry.snapshotId());
        }
        Assert.assertFalse((String)"Should find all files in the manifest", (boolean)newPaths.hasNext());
        Assert.assertEquals((String)"Schema ID should match", (long)this.table.schema().schemaId(), (long)snap.schemaId().intValue());
    }

    void validateTableFiles(Table tbl, DataFile ... expectedFiles) {
        HashSet expectedFilePaths = Sets.newHashSet();
        for (DataFile file : expectedFiles) {
            expectedFilePaths.add(file.path());
        }
        HashSet actualFilePaths = Sets.newHashSet();
        for (FileScanTask task : tbl.newScan().planFiles()) {
            actualFilePaths.add(((DataFile)task.file()).path());
        }
        Assert.assertEquals((String)"Files should match", (Object)expectedFilePaths, (Object)actualFilePaths);
    }

    void validateBranchFiles(Table tbl, String ref, DataFile ... expectedFiles) {
        HashSet expectedFilePaths = Sets.newHashSet();
        for (DataFile file : expectedFiles) {
            expectedFilePaths.add(file.path());
        }
        HashSet actualFilePaths = Sets.newHashSet();
        for (FileScanTask task : tbl.newScan().useRef(ref).planFiles()) {
            actualFilePaths.add(((DataFile)task.file()).path());
        }
        Assert.assertEquals((String)"Files should match", (Object)expectedFilePaths, (Object)actualFilePaths);
    }

    void validateBranchDeleteFiles(Table tbl, String branch, DeleteFile ... expectedFiles) {
        HashSet expectedFilePaths = Sets.newHashSet();
        for (DeleteFile file : expectedFiles) {
            expectedFilePaths.add(file.path());
        }
        HashSet actualFilePaths = Sets.newHashSet();
        for (FileScanTask task : tbl.newScan().useRef(branch).planFiles()) {
            for (DeleteFile file : task.deletes()) {
                actualFilePaths.add(file.path());
            }
        }
        Assert.assertEquals((String)"Delete files should match", (Object)expectedFilePaths, (Object)actualFilePaths);
    }

    List<String> paths(DataFile ... dataFiles) {
        ArrayList paths = Lists.newArrayListWithExpectedSize((int)dataFiles.length);
        for (DataFile file : dataFiles) {
            paths.add(file.path().toString());
        }
        return paths;
    }

    void validateManifest(ManifestFile manifest, Iterator<Long> ids, Iterator<DataFile> expectedFiles) {
        this.validateManifest(manifest, null, null, ids, expectedFiles, null);
    }

    void validateManifest(ManifestFile manifest, Iterator<Long> dataSeqs, Iterator<Long> fileSeqs, Iterator<Long> ids, Iterator<DataFile> expectedFiles) {
        this.validateManifest(manifest, dataSeqs, fileSeqs, ids, expectedFiles, null);
    }

    void validateManifest(ManifestFile manifest, Iterator<Long> dataSeqs, Iterator<Long> fileSeqs, Iterator<Long> ids, Iterator<DataFile> expectedFiles, Iterator<ManifestEntry.Status> statuses) {
        for (ManifestEntry entry : ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO).entries()) {
            DataFile file = (DataFile)entry.file();
            DataFile expected = expectedFiles.next();
            this.validateManifestSequenceNumbers(entry, dataSeqs, fileSeqs);
            Assert.assertEquals((String)"Path should match expected", (Object)expected.path().toString(), (Object)file.path().toString());
            Assert.assertEquals((String)"Snapshot ID should match expected ID", (Object)ids.next(), (Object)entry.snapshotId());
            if (statuses == null) continue;
            Assert.assertEquals((String)"Status should match expected", (Object)statuses.next(), (Object)entry.status());
        }
        Assert.assertFalse((String)"Should find all files in the manifest", (boolean)expectedFiles.hasNext());
    }

    void validateDeleteManifest(ManifestFile manifest, Iterator<Long> dataSeqs, Iterator<Long> fileSeqs, Iterator<Long> ids, Iterator<DeleteFile> expectedFiles, Iterator<ManifestEntry.Status> statuses) {
        for (ManifestEntry entry : ManifestFiles.readDeleteManifest((ManifestFile)manifest, (FileIO)FILE_IO, null).entries()) {
            DeleteFile file = (DeleteFile)entry.file();
            DeleteFile expected = expectedFiles.next();
            this.validateManifestSequenceNumbers(entry, dataSeqs, fileSeqs);
            Assert.assertEquals((String)"Path should match expected", (Object)expected.path().toString(), (Object)file.path().toString());
            Assert.assertEquals((String)"Snapshot ID should match expected ID", (Object)ids.next(), (Object)entry.snapshotId());
            Assert.assertEquals((String)"Status should match expected", (Object)statuses.next(), (Object)entry.status());
        }
        Assert.assertFalse((String)"Should find all files in the manifest", (boolean)expectedFiles.hasNext());
    }

    private <T extends ContentFile<T>> void validateManifestSequenceNumbers(ManifestEntry<T> entry, Iterator<Long> dataSeqs, Iterator<Long> fileSeqs) {
        if (dataSeqs != null) {
            this.V1Assert.assertEquals("Data sequence number should default to 0", 0L, entry.dataSequenceNumber());
            this.V1Assert.assertEquals("Data sequence number should default to 0", 0L, entry.file().dataSequenceNumber());
            Long expectedSequenceNumber = dataSeqs.next();
            this.V2Assert.assertEquals("Data sequence number should match expected", expectedSequenceNumber, entry.dataSequenceNumber());
            this.V2Assert.assertEquals("Data sequence number should match expected", expectedSequenceNumber, entry.file().dataSequenceNumber());
        }
        if (fileSeqs != null) {
            this.V1Assert.assertEquals("File sequence number should default to 0", (Object)0L, entry.fileSequenceNumber());
            this.V1Assert.assertEquals("File sequence number should default to 0", (Object)0L, entry.file().fileSequenceNumber());
            Long expectedFileSequenceNumber = fileSeqs.next();
            this.V2Assert.assertEquals("File sequence number should match", expectedFileSequenceNumber, entry.fileSequenceNumber());
            this.V2Assert.assertEquals("File sequence number should match", expectedFileSequenceNumber, entry.file().fileSequenceNumber());
        }
    }

    protected DataFile newDataFile(String partitionPath) {
        return DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data-" + UUID.randomUUID() + ".parquet").withFileSizeInBytes(10L).withPartitionPath(partitionPath).withRecordCount(1L).build();
    }

    protected DeleteFile newDeleteFile(int specId, String partitionPath) {
        PartitionSpec spec = (PartitionSpec)this.table.specs().get(specId);
        return FileMetadata.deleteFileBuilder((PartitionSpec)spec).ofPositionDeletes().withPath("/path/to/delete-" + UUID.randomUUID() + ".parquet").withFileSizeInBytes(10L).withPartitionPath(partitionPath).withRecordCount(1L).build();
    }

    protected DeleteFile newEqualityDeleteFile(int specId, String partitionPath, int ... fieldIds) {
        PartitionSpec spec = (PartitionSpec)this.table.specs().get(specId);
        return FileMetadata.deleteFileBuilder((PartitionSpec)spec).ofEqualityDeletes(fieldIds).withPath("/path/to/delete-" + UUID.randomUUID() + ".parquet").withFileSizeInBytes(10L).withPartitionPath(partitionPath).withRecordCount(1L).build();
    }

    protected <T> PositionDelete<T> positionDelete(CharSequence path, long pos, T row) {
        PositionDelete positionDelete = PositionDelete.create();
        return positionDelete.set(path, pos, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withUnavailableLocations(Iterable<String> locations, Action action) {
        for (String location : locations) {
            this.move(location, location + "_temp");
        }
        try {
            action.invoke();
        }
        finally {
            for (String location : locations) {
                this.move(location + "_temp", location);
            }
        }
    }

    private void move(String location, String newLocation) {
        Path path = Paths.get(location, new String[0]);
        Path tempPath = Paths.get(newLocation, new String[0]);
        try {
            java.nio.file.Files.move(path, tempPath, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to move: " + location, e);
        }
    }

    static void validateManifestEntries(ManifestFile manifest, Iterator<Long> ids, Iterator<DataFile> expectedFiles, Iterator<ManifestEntry.Status> expectedStatuses) {
        for (ManifestEntry entry : ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO).entries()) {
            DataFile file = (DataFile)entry.file();
            DataFile expected = expectedFiles.next();
            ManifestEntry.Status expectedStatus = expectedStatuses.next();
            Assert.assertEquals((String)"Path should match expected", (Object)expected.path().toString(), (Object)file.path().toString());
            Assert.assertEquals((String)"Snapshot ID should match expected ID", (Object)ids.next(), (Object)entry.snapshotId());
            Assert.assertEquals((String)"Entry status should match expected ID", (Object)expectedStatus, (Object)entry.status());
        }
        Assert.assertFalse((String)"Should find all files in the manifest", (boolean)expectedFiles.hasNext());
    }

    static Iterator<ManifestEntry.Status> statuses(ManifestEntry.Status ... statuses) {
        return Iterators.forArray((Object[])statuses);
    }

    static Iterator<Long> dataSeqs(Long ... seqs) {
        return Iterators.forArray((Object[])seqs);
    }

    static Iterator<Long> fileSeqs(Long ... seqs) {
        return Iterators.forArray((Object[])seqs);
    }

    static Iterator<Long> ids(Long ... ids) {
        return Iterators.forArray((Object[])ids);
    }

    static Iterator<DataFile> files(DataFile ... files) {
        return Iterators.forArray((Object[])files);
    }

    static Iterator<DeleteFile> files(DeleteFile ... files) {
        return Iterators.forArray((Object[])files);
    }

    static Iterator<DataFile> files(ManifestFile manifest) {
        return ManifestFiles.read((ManifestFile)manifest, (FileIO)FILE_IO).iterator();
    }

    @FunctionalInterface
    protected static interface Action {
        public void invoke();
    }

    protected static class TableAssertions {
        private boolean enabled;

        private TableAssertions(int validForVersion, int formatVersion) {
            this.enabled = validForVersion == formatVersion;
        }

        void disable() {
            this.enabled = false;
        }

        void enable() {
            this.enabled = true;
        }

        void assertEquals(String context, int expected, int actual) {
            if (this.enabled) {
                Assert.assertEquals((String)context, (long)expected, (long)actual);
            }
        }

        void assertEquals(String context, long expected, long actual) {
            if (this.enabled) {
                Assert.assertEquals((String)context, (long)expected, (long)actual);
            }
        }

        void assertEquals(String context, Object expected, Object actual) {
            if (this.enabled) {
                Assert.assertEquals((String)context, (Object)expected, (Object)actual);
            }
        }
    }
}

