/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TableMetadataParserTest {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"b", (Type)Types.BooleanType.get())});
    private final String codecName;

    @Parameterized.Parameters(name="codecName = {0}")
    public static Object[] parameters() {
        return new Object[]{"none", "gzip"};
    }

    public TableMetadataParserTest(String codecName) {
        this.codecName = codecName;
    }

    @Test
    public void testCompressionProperty() throws IOException {
        TableMetadataParser.Codec codec = TableMetadataParser.Codec.fromName((String)this.codecName);
        String fileExtension = TableMetadataParser.getFileExtension((TableMetadataParser.Codec)codec);
        String fileName = "v3" + fileExtension;
        OutputFile outputFile = Files.localOutput((String)fileName);
        HashMap properties = Maps.newHashMap();
        properties.put("write.metadata.compression-codec", this.codecName);
        String location = "file://tmp/db/table";
        TableMetadata metadata = TableMetadata.newTableMetadata((Schema)SCHEMA, (PartitionSpec)PartitionSpec.unpartitioned(), (String)location, (Map)properties);
        TableMetadataParser.write((TableMetadata)metadata, (OutputFile)outputFile);
        Assert.assertEquals((Object)(codec == TableMetadataParser.Codec.GZIP ? 1 : 0), (Object)this.isCompressed(fileName));
        TableMetadata actualMetadata = TableMetadataParser.read((FileIO)null, (InputFile)Files.localInput((File)new File(fileName)));
        this.verifyMetadata(metadata, actualMetadata);
    }

    @After
    public void cleanup() throws IOException {
        TableMetadataParser.Codec codec = TableMetadataParser.Codec.fromName((String)this.codecName);
        Path metadataFilePath = Paths.get("v3" + TableMetadataParser.getFileExtension((TableMetadataParser.Codec)codec), new String[0]);
        java.nio.file.Files.deleteIfExists(metadataFilePath);
    }

    private void verifyMetadata(TableMetadata expected, TableMetadata actual) {
        Assert.assertEquals((Object)expected.schema().asStruct(), (Object)actual.schema().asStruct());
        Assert.assertEquals((Object)expected.location(), (Object)actual.location());
        Assert.assertEquals((long)expected.lastColumnId(), (long)actual.lastColumnId());
        Assert.assertEquals((Object)expected.properties(), (Object)actual.properties());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isCompressed(String path) throws IOException {
        try (GZIPInputStream ignored = new GZIPInputStream(new FileInputStream(new File(path)));){
            boolean bl = true;
            return bl;
        }
        catch (ZipException e) {
            if (!e.getMessage().equals("Not in GZIP format")) throw e;
            return false;
        }
    }
}

