/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.TableMetadataParser;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TableMetadataParserCodecTest {
    @Test
    public void testCompressionCodec() {
        Assert.assertEquals((Object)TableMetadataParser.Codec.GZIP, (Object)TableMetadataParser.Codec.fromName((String)"gzip"));
        Assert.assertEquals((Object)TableMetadataParser.Codec.GZIP, (Object)TableMetadataParser.Codec.fromName((String)"gZiP"));
        Assert.assertEquals((Object)TableMetadataParser.Codec.GZIP, (Object)TableMetadataParser.Codec.fromFileName((String)"v3.gz.metadata.json"));
        Assert.assertEquals((Object)TableMetadataParser.Codec.GZIP, (Object)TableMetadataParser.Codec.fromFileName((String)"v3-f326-4b66-a541-7b1c.gz.metadata.json"));
        Assert.assertEquals((Object)TableMetadataParser.Codec.GZIP, (Object)TableMetadataParser.Codec.fromFileName((String)"v3-f326-4b66-a541-7b1c.metadata.json.gz"));
        Assert.assertEquals((Object)TableMetadataParser.Codec.NONE, (Object)TableMetadataParser.Codec.fromName((String)"none"));
        Assert.assertEquals((Object)TableMetadataParser.Codec.NONE, (Object)TableMetadataParser.Codec.fromName((String)"nOnE"));
        Assert.assertEquals((Object)TableMetadataParser.Codec.NONE, (Object)TableMetadataParser.Codec.fromFileName((String)"v3.metadata.json"));
        Assert.assertEquals((Object)TableMetadataParser.Codec.NONE, (Object)TableMetadataParser.Codec.fromFileName((String)"v3-f326-4b66-a541-7b1c.metadata.json"));
    }

    @Test
    public void testInvalidCodecName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableMetadataParser.Codec.fromName((String)"invalid")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid codec name: invalid");
    }

    @Test
    public void testInvalidFileName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableMetadataParser.Codec.fromFileName((String)"path/to/file.parquet")).isInstanceOf(IllegalArgumentException.class)).hasMessage("path/to/file.parquet is not a valid metadata file");
    }
}

