/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Scan;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class ScanTestBase<ScanT extends Scan<ScanT, T, G>, T extends ScanTask, G extends ScanTaskGroup<T>>
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public ScanTestBase(int formatVersion) {
        super(formatVersion);
    }

    protected abstract ScanT newScan();

    @Test
    public void testTableScanHonorsSelect() {
        Scan scan = (Scan)this.newScan().select(Arrays.asList("id"));
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get())});
        Assert.assertEquals((String)"A tableScan.select() should prune the schema", (Object)expectedSchema.asStruct(), (Object)scan.schema().asStruct());
    }

    @Test
    public void testTableBothProjectAndSelect() {
        AssertHelpers.assertThrows((String)"Cannot set projection schema when columns are selected", IllegalStateException.class, () -> (Scan)((Scan)this.newScan().select(Arrays.asList("id"))).project(SCHEMA.select(new String[]{"data"})));
        AssertHelpers.assertThrows((String)"Cannot select columns when projection schema is set", IllegalStateException.class, () -> (Scan)((Scan)this.newScan().project(SCHEMA.select(new String[]{"data"}))).select(Arrays.asList("id")));
    }

    @Test
    public void testTableScanHonorsSelectWithoutCaseSensitivity() {
        Scan scan1 = (Scan)((Scan)this.newScan().caseSensitive(false)).select(Arrays.asList("ID"));
        Scan scan2 = (Scan)((Scan)this.newScan().select(Arrays.asList("ID"))).caseSensitive(false);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get())});
        Assert.assertEquals((String)"A tableScan.select() should prune the schema without case sensitivity", (Object)expectedSchema.asStruct(), (Object)scan1.schema().asStruct());
        Assert.assertEquals((String)"A tableScan.select() should prune the schema regardless of scan refinement order", (Object)expectedSchema.asStruct(), (Object)scan2.schema().asStruct());
    }

    @Test
    public void testTableScanHonorsIgnoreResiduals() throws IOException {
        this.table.newFastAppend().appendFile(FILE_A).appendFile(FILE_B).commit();
        Scan scan1 = (Scan)this.newScan().filter((Expression)Expressions.equal((String)"id", (Object)5));
        try (CloseableIterable groups = scan1.planTasks();){
            Assert.assertTrue((String)"Tasks should not be empty", (Iterables.size((Iterable)groups) > 0 ? 1 : 0) != 0);
            for (ScanTaskGroup group : groups) {
                for (ScanTask task : group.tasks()) {
                    Expression residual = ((ContentScanTask)task).residual();
                    Assert.assertNotEquals((String)"Residuals must be preserved", (Object)Expressions.alwaysTrue(), (Object)residual);
                }
            }
        }
        Scan scan2 = (Scan)((Scan)this.newScan().filter((Expression)Expressions.equal((String)"id", (Object)5))).ignoreResiduals();
        Object object = null;
        try (CloseableIterable groups = scan2.planTasks();){
            Assert.assertTrue((String)"Tasks should not be empty", (Iterables.size((Iterable)groups) > 0 ? 1 : 0) != 0);
            for (ScanTaskGroup group : groups) {
                for (ScanTask task : group.tasks()) {
                    Expression residual = ((ContentScanTask)task).residual();
                    Assert.assertEquals((String)"Residuals must be ignored", (Object)Expressions.alwaysTrue(), (Object)residual);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
    }

    @Test
    public void testTableScanWithPlanExecutor() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.newFastAppend().appendFile(FILE_B).commit();
        AtomicInteger planThreadsIndex = new AtomicInteger(0);
        Scan scan = (Scan)this.newScan().planWith(Executors.newFixedThreadPool(1, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("plan-" + planThreadsIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)scan.planFiles()));
        Assert.assertTrue((String)"Thread should be created in provided pool", (planThreadsIndex.get() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReAddingPartitionField() throws Exception {
        Assume.assumeTrue((this.formatVersion == 2 ? 1 : 0) != 0);
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"b", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"data", (Type)Types.IntegerType.get())});
        PartitionSpec initialSpec = PartitionSpec.builderFor((Schema)schema).identity("a").build();
        File dir = this.temp.newFolder();
        dir.delete();
        this.table = TestTables.create(dir, "test_part_evolution", schema, initialSpec, this.formatVersion);
        this.table.newFastAppend().appendFile(DataFiles.builder((PartitionSpec)initialSpec).withPath("/path/to/data/a.parquet").withFileSizeInBytes(10L).withPartitionPath("a=1").withRecordCount(1L).build()).commit();
        this.table.updateSpec().addField("b").removeField("a").commit();
        this.table.newFastAppend().appendFile(DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data/b.parquet").withFileSizeInBytes(10L).withPartitionPath("b=1").withRecordCount(1L).build()).commit();
        this.table.updateSpec().addField("a").commit();
        this.table.newFastAppend().appendFile(DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data/ab.parquet").withFileSizeInBytes(10L).withPartitionPath("b=1/a=1").withRecordCount(1L).build()).commit();
        this.table.newFastAppend().appendFile(DataFiles.builder((PartitionSpec)this.table.spec()).withPath("/path/to/data/a2b.parquet").withFileSizeInBytes(10L).withPartitionPath("b=1/a=2").withRecordCount(1L).build()).commit();
        TableScan scan1 = (TableScan)this.table.newScan().filter((Expression)Expressions.equal((String)"b", (Object)"1"));
        try (CloseableIterable tasks = scan1.planTasks();){
            Assert.assertTrue((String)"There should be 1 combined task", (Iterables.size((Iterable)tasks) == 1 ? 1 : 0) != 0);
            for (CombinedScanTask combinedScanTask : tasks) {
                Assert.assertEquals((String)"All 4 files should match b=1 filter", (long)4L, (long)combinedScanTask.files().size());
            }
        }
        TableScan scan2 = (TableScan)this.table.newScan().filter((Expression)Expressions.equal((String)"a", (Object)2));
        Object object = null;
        try (CloseableIterable tasks = scan2.planTasks();){
            Assert.assertTrue((String)"There should be 1 combined task", (Iterables.size((Iterable)tasks) == 1 ? 1 : 0) != 0);
            for (CombinedScanTask combinedScanTask : tasks) {
                Assert.assertEquals((String)"a=2 and file without a in spec should match", (long)2L, (long)combinedScanTask.files().size());
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
    }
}

