/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.mockito.Mockito;

public class MockFileScanTask
extends BaseFileScanTask {
    private final long length;

    public MockFileScanTask(long length) {
        super(null, null, null, null, null);
        this.length = length;
    }

    public MockFileScanTask(DataFile file) {
        super(file, null, null, null, null);
        this.length = file.fileSizeInBytes();
    }

    public MockFileScanTask(DataFile file, DeleteFile[] deleteFiles) {
        super(file, deleteFiles, null, null, null);
        this.length = file.fileSizeInBytes();
    }

    public MockFileScanTask(DataFile file, String schemaString, String specString) {
        super(file, null, schemaString, specString, null);
        this.length = file.fileSizeInBytes();
    }

    public static MockFileScanTask mockTask(long length, int sortOrderId) {
        DataFile mockFile = (DataFile)Mockito.mock(DataFile.class);
        Mockito.when((Object)mockFile.fileSizeInBytes()).thenReturn((Object)length);
        Mockito.when((Object)mockFile.sortOrderId()).thenReturn((Object)sortOrderId);
        return new MockFileScanTask(mockFile);
    }

    public static MockFileScanTask mockTaskWithDeletes(long length, int nDeletes) {
        DeleteFile[] mockDeletes = new DeleteFile[nDeletes];
        for (int i = 0; i < nDeletes; ++i) {
            mockDeletes[i] = (DeleteFile)Mockito.mock(DeleteFile.class);
        }
        DataFile mockFile = (DataFile)Mockito.mock(DataFile.class);
        Mockito.when((Object)mockFile.fileSizeInBytes()).thenReturn((Object)length);
        return new MockFileScanTask(mockFile, mockDeletes);
    }

    public long length() {
        return this.length;
    }

    public String toString() {
        return "Mock Scan Task Size: " + this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MockFileScanTask that = (MockFileScanTask)((Object)o);
        return this.length == that.length;
    }

    public int hashCode() {
        return (int)(this.length ^ this.length >>> 32);
    }
}

