/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.iceberg.AllManifestsTable;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PositionDeletesScanTask;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PartitionUtil;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class MetadataTableScanTestBase
extends TableTestBase {
    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public MetadataTableScanTestBase(int formatVersion) {
        super(formatVersion);
    }

    protected Set<String> actualManifestListPaths(TableScan allManifestsTableScan) {
        return StreamSupport.stream(allManifestsTableScan.planFiles().spliterator(), false).map(t -> (AllManifestsTable.ManifestListReadTask)t).map(t -> t.file().path().toString()).collect(Collectors.toSet());
    }

    protected Set<String> expectedManifestListPaths(Iterable<Snapshot> snapshots, Long ... snapshotIds) {
        HashSet snapshotIdSet = Sets.newHashSet((Object[])snapshotIds);
        return StreamSupport.stream(snapshots.spliterator(), false).filter(s -> snapshotIdSet.contains(s.snapshotId())).map(Snapshot::manifestListLocation).collect(Collectors.toSet());
    }

    protected void validateTaskScanResiduals(TableScan scan, boolean ignoreResiduals) throws IOException {
        try (CloseableIterable tasks = scan.planTasks();){
            Assert.assertTrue((String)"Tasks should not be empty", (Iterables.size((Iterable)tasks) > 0 ? 1 : 0) != 0);
            for (CombinedScanTask combinedScanTask : tasks) {
                for (FileScanTask fileScanTask : combinedScanTask.files()) {
                    if (ignoreResiduals) {
                        Assert.assertEquals((String)"Residuals must be ignored", (Object)Expressions.alwaysTrue(), (Object)fileScanTask.residual());
                        continue;
                    }
                    Assert.assertNotEquals((String)"Residuals must be preserved", (Object)Expressions.alwaysTrue(), (Object)fileScanTask.residual());
                }
            }
        }
    }

    protected void validateSingleFieldPartition(CloseableIterable<ContentFile<?>> files, int partitionValue) {
        this.validatePartition(files, 0, partitionValue);
    }

    protected void validatePartition(CloseableIterable<ContentFile<?>> files, int position, int partitionValue) {
        Assert.assertTrue((String)"File scan tasks do not include correct file", (boolean)StreamSupport.stream(files.spliterator(), false).anyMatch(file -> {
            StructLike partition = file.partition();
            if (position >= partition.size()) {
                return false;
            }
            return Objects.equals(partitionValue, partition.get(position, Object.class));
        }));
    }

    protected Map<Integer, ?> constantsMap(PositionDeletesScanTask task, Types.StructType partitionType) {
        return PartitionUtil.constantsMap((ContentScanTask)task, (Types.StructType)partitionType, (type, constant) -> constant);
    }
}

