/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.junit.rules.TemporaryFolder;

class LocalTableOperations
implements TableOperations {
    private final TemporaryFolder temp;
    private final FileIO io;
    private final Map<String, String> createdMetadataFilePaths = Maps.newHashMap();

    LocalTableOperations(TemporaryFolder temp) {
        this.temp = temp;
        this.io = new TestTables.LocalFileIO();
    }

    public TableMetadata current() {
        throw new UnsupportedOperationException("Not implemented for tests");
    }

    public TableMetadata refresh() {
        throw new UnsupportedOperationException("Not implemented for tests");
    }

    public void commit(TableMetadata base, TableMetadata metadata) {
        throw new UnsupportedOperationException("Not implemented for tests");
    }

    public FileIO io() {
        return this.io;
    }

    public String metadataFileLocation(String fileName) {
        return this.createdMetadataFilePaths.computeIfAbsent(fileName, name -> {
            try {
                return this.temp.newFile(name).getAbsolutePath();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        });
    }

    public LocationProvider locationProvider() {
        throw new UnsupportedOperationException("Not implemented for tests");
    }

    public long newSnapshotId() {
        throw new UnsupportedOperationException("Not implemented for tests");
    }
}

