/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.common.model.HoodieDataFile;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.exception.DatasetNotFoundException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.HoodieHiveUtil;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieROTablePathFilter
implements PathFilter,
Serializable {
    private static final transient Logger LOG = LogManager.getLogger(HoodieROTablePathFilter.class);
    private HashMap<String, HashSet<Path>> hoodiePathCache = new HashMap();
    private HashSet<String> nonHoodiePathCache = new HashSet();
    private transient FileSystem fs;

    private Path safeGetParentsParent(Path path) {
        if (path.getParent() != null && path.getParent().getParent() != null && path.getParent().getParent().getParent() != null) {
            return path.getParent().getParent().getParent();
        }
        return null;
    }

    public boolean accept(Path path) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking acceptance for path " + path));
        }
        Path folder = null;
        try {
            Path baseDir;
            if (this.fs == null) {
                this.fs = path.getFileSystem(new Configuration());
            }
            if (this.nonHoodiePathCache.contains((folder = path.getParent()).toString())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Accepting non-hoodie path from cache: " + path));
                }
                return true;
            }
            if (this.hoodiePathCache.containsKey(folder.toString())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("%s Hoodie path checked against cache, accept => %s \n", path, this.hoodiePathCache.get(folder.toString()).contains(path)));
                }
                return this.hoodiePathCache.get(folder.toString()).contains(path);
            }
            String filePath = path.toString();
            if (filePath.contains("/" + HoodieTableMetaClient.METAFOLDER_NAME + "/") || filePath.endsWith("/" + HoodieTableMetaClient.METAFOLDER_NAME)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Skipping Hoodie Metadata file  %s \n", filePath));
                }
                return false;
            }
            if (HoodiePartitionMetadata.hasPartitionMetadata((FileSystem)this.fs, (Path)folder)) {
                HoodiePartitionMetadata metadata = new HoodiePartitionMetadata(this.fs, folder);
                metadata.readFromFS();
                baseDir = HoodieHiveUtil.getNthParent(folder, metadata.getPartitionDepth());
            } else {
                baseDir = this.safeGetParentsParent(folder);
            }
            if (baseDir != null) {
                try {
                    HoodieTableMetaClient metaClient = new HoodieTableMetaClient(this.fs.getConf(), baseDir.toString());
                    HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants(), this.fs.listStatus(folder));
                    List latestFiles = fsView.getLatestDataFiles().collect(Collectors.toList());
                    if (!this.hoodiePathCache.containsKey(folder.toString())) {
                        this.hoodiePathCache.put(folder.toString(), new HashSet());
                    }
                    LOG.info((Object)("Based on hoodie metadata from base path: " + baseDir.toString() + ", caching " + latestFiles.size() + " files under " + folder));
                    for (HoodieDataFile lfile : latestFiles) {
                        this.hoodiePathCache.get(folder.toString()).add(new Path(lfile.getPath()));
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("%s checked after cache population, accept => %s \n", path, this.hoodiePathCache.get(folder.toString()).contains(path)));
                    }
                    return this.hoodiePathCache.get(folder.toString()).contains(path);
                }
                catch (DatasetNotFoundException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("(1) Caching non-hoodie path under %s \n", folder.toString()));
                    }
                    this.nonHoodiePathCache.add(folder.toString());
                    return true;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("(2) Caching non-hoodie path under %s \n", folder.toString()));
            }
            this.nonHoodiePathCache.add(folder.toString());
            return true;
        }
        catch (Exception e) {
            String msg = "Error checking path :" + path + ", under folder: " + folder;
            LOG.error((Object)msg, (Throwable)e);
            throw new HoodieException(msg, (Throwable)e);
        }
    }
}

