/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.List;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseScan;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ParallelIterable;
import org.apache.iceberg.util.PartitionUtil;
import org.apache.iceberg.util.StructLikeMap;
import org.apache.iceberg.util.StructProjection;

public class PartitionsTable
extends BaseMetadataTable {
    private final Schema schema;
    private final boolean unpartitionedTable;

    PartitionsTable(Table table) {
        this(table, table.name() + ".partitions");
    }

    PartitionsTable(Table table, String name) {
        super(table, name);
        this.schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"partition", (Type)Partitioning.partitionType(table)), Types.NestedField.required((int)4, (String)"spec_id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"record_count", (Type)Types.LongType.get(), (String)"Count of records in data files"), Types.NestedField.required((int)3, (String)"file_count", (Type)Types.IntegerType.get(), (String)"Count of data files"), Types.NestedField.required((int)11, (String)"total_data_file_size_in_bytes", (Type)Types.LongType.get(), (String)"Total size in bytes of data files"), Types.NestedField.required((int)5, (String)"position_delete_record_count", (Type)Types.LongType.get(), (String)"Count of records in position delete files"), Types.NestedField.required((int)6, (String)"position_delete_file_count", (Type)Types.IntegerType.get(), (String)"Count of position delete files"), Types.NestedField.required((int)7, (String)"equality_delete_record_count", (Type)Types.LongType.get(), (String)"Count of records in equality delete files"), Types.NestedField.required((int)8, (String)"equality_delete_file_count", (Type)Types.IntegerType.get(), (String)"Count of equality delete files"), Types.NestedField.optional((int)9, (String)"last_updated_at", (Type)Types.TimestampType.withZone(), (String)"Commit time of snapshot that last updated this partition"), Types.NestedField.optional((int)10, (String)"last_updated_snapshot_id", (Type)Types.LongType.get(), (String)"Id of snapshot that last updated this partition")});
        this.unpartitionedTable = Partitioning.partitionType(table).fields().isEmpty();
    }

    public TableScan newScan() {
        return new PartitionsScan(this.table());
    }

    public Schema schema() {
        if (this.unpartitionedTable) {
            return this.schema.select(new String[]{"record_count", "file_count", "total_data_file_size_in_bytes", "position_delete_record_count", "position_delete_file_count", "equality_delete_record_count", "equality_delete_file_count", "last_updated_at", "last_updated_snapshot_id"});
        }
        return this.schema;
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.PARTITIONS;
    }

    private DataTask task(StaticTableScan scan) {
        Iterable<Partition> partitions = PartitionsTable.partitions(this.table(), scan);
        if (this.unpartitionedTable) {
            return StaticDataTask.of(this.io().newInputFile(this.table().operations().current().metadataFileLocation()), this.schema(), scan.schema(), partitions, root -> StaticDataTask.Row.of(root.dataRecordCount, root.dataFileCount, root.dataFileSizeInBytes, root.posDeleteRecordCount, root.posDeleteFileCount, root.eqDeleteRecordCount, root.eqDeleteFileCount, root.lastUpdatedAt, root.lastUpdatedSnapshotId));
        }
        return StaticDataTask.of(this.io().newInputFile(this.table().operations().current().metadataFileLocation()), this.schema(), scan.schema(), partitions, PartitionsTable::convertPartition);
    }

    private static StaticDataTask.Row convertPartition(Partition partition) {
        return StaticDataTask.Row.of(partition.partitionData, partition.specId, partition.dataRecordCount, partition.dataFileCount, partition.dataFileSizeInBytes, partition.posDeleteRecordCount, partition.posDeleteFileCount, partition.eqDeleteRecordCount, partition.eqDeleteFileCount, partition.lastUpdatedAt, partition.lastUpdatedSnapshotId);
    }

    private static Iterable<Partition> partitions(Table table, StaticTableScan scan) {
        Types.StructType partitionType = Partitioning.partitionType(table);
        StructLikeMap<Partition> partitions = StructLikeMap.create(partitionType, new PartitionComparator(partitionType));
        try (CloseableIterable<ManifestEntry<?>> entries = PartitionsTable.planEntries(scan);){
            for (ManifestEntry entry : entries) {
                Snapshot snapshot = table.snapshot(entry.snapshotId().longValue());
                Object file = entry.file();
                StructLike key = PartitionUtil.coercePartition(partitionType, (PartitionSpec)table.specs().get(file.specId()), file.partition());
                partitions.computeIfAbsent(key, () -> new Partition(key, partitionType)).update((ContentFile<?>)file, snapshot);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return partitions.values();
    }

    @VisibleForTesting
    static CloseableIterable<ManifestEntry<?>> planEntries(StaticTableScan scan) {
        Table table = scan.table();
        CloseableIterable<ManifestFile> filteredManifests = PartitionsTable.filteredManifests(scan, table, scan.snapshot().allManifests(table.io()));
        CloseableIterable tasks = CloseableIterable.transform(filteredManifests, manifest -> PartitionsTable.readEntries(manifest, scan));
        return new ParallelIterable((Iterable<Iterable<ManifestEntry<?>>>)tasks, scan.planExecutor());
    }

    private static CloseableIterable<ManifestEntry<?>> readEntries(ManifestFile manifest, StaticTableScan scan) {
        Table table = scan.table();
        return CloseableIterable.transform(ManifestFiles.open(manifest, table.io(), table.specs()).caseSensitive(scan.isCaseSensitive()).select(BaseScan.scanColumns(manifest.content())).liveEntries(), t -> t.copyWithoutStats());
    }

    private static CloseableIterable<ManifestFile> filteredManifests(StaticTableScan scan, Table table, List<ManifestFile> manifestFilesList) {
        CloseableIterable manifestFiles = CloseableIterable.withNoopClose(manifestFilesList);
        LoadingCache evalCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = (PartitionSpec)table.specs().get(specId);
            PartitionSpec transformedSpec = PartitionsTable.transformSpec(scan.tableSchema(), spec);
            return ManifestEvaluator.forRowFilter((Expression)scan.filter(), (PartitionSpec)transformedSpec, (boolean)scan.isCaseSensitive());
        });
        return CloseableIterable.filter((CloseableIterable)manifestFiles, manifest -> ((ManifestEvaluator)evalCache.get((Object)manifest.partitionSpecId())).eval(manifest));
    }

    private class PartitionsScan
    extends StaticTableScan {
        PartitionsScan(Table table) {
            super(table, PartitionsTable.this.schema(), MetadataTableType.PARTITIONS, PartitionsTable.this::task);
        }
    }

    static class Partition {
        private final PartitionData partitionData;
        private int specId;
        private long dataRecordCount;
        private int dataFileCount;
        private long dataFileSizeInBytes;
        private long posDeleteRecordCount;
        private int posDeleteFileCount;
        private long eqDeleteRecordCount;
        private int eqDeleteFileCount;
        private Long lastUpdatedAt;
        private Long lastUpdatedSnapshotId;

        Partition(StructLike key, Types.StructType keyType) {
            this.partitionData = Partition.toPartitionData(key, keyType);
            this.specId = 0;
            this.dataRecordCount = 0L;
            this.dataFileCount = 0;
            this.dataFileSizeInBytes = 0L;
            this.posDeleteRecordCount = 0L;
            this.posDeleteFileCount = 0;
            this.eqDeleteRecordCount = 0L;
            this.eqDeleteFileCount = 0;
        }

        void update(ContentFile<?> file, Snapshot snapshot) {
            if (snapshot != null) {
                long snapshotCommitTime = snapshot.timestampMillis() * 1000L;
                if (this.lastUpdatedAt == null || snapshotCommitTime > this.lastUpdatedAt) {
                    this.specId = file.specId();
                    this.lastUpdatedAt = snapshotCommitTime;
                    this.lastUpdatedSnapshotId = snapshot.snapshotId();
                }
            }
            switch (file.content()) {
                case DATA: {
                    this.dataRecordCount += file.recordCount();
                    ++this.dataFileCount;
                    this.dataFileSizeInBytes += file.fileSizeInBytes();
                    break;
                }
                case POSITION_DELETES: {
                    this.posDeleteRecordCount += file.recordCount();
                    ++this.posDeleteFileCount;
                    break;
                }
                case EQUALITY_DELETES: {
                    this.eqDeleteRecordCount += file.recordCount();
                    ++this.eqDeleteFileCount;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported file content type: " + file.content());
                }
            }
        }

        private static PartitionData toPartitionData(StructLike key, Types.StructType keyType) {
            PartitionData keyTemplate = new PartitionData(keyType);
            return keyTemplate.copyFor(key);
        }
    }

    private static class PartitionComparator
    implements Comparator<StructLike> {
        private Comparator<StructLike> comparator;

        private PartitionComparator(Types.StructType struct) {
            this.comparator = Comparators.forType((Types.StructType)struct);
        }

        @Override
        public int compare(StructLike o1, StructLike o2) {
            int cmp;
            if (o1 instanceof StructProjection && o2 instanceof StructProjection && (cmp = Integer.compare(((StructProjection)o1).projectedFields(), ((StructProjection)o2).projectedFields())) != 0) {
                return cmp;
            }
            return this.comparator.compare(o1, o2);
        }
    }
}

