/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import com.google.common.base.Joiner;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.tools.HMSClient;
import org.apache.thrift.TException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final String DEFAULT_TYPE = "string";
    private static final String TYPE_SEPARATOR = ":";
    private static final String THRIFT_SCHEMA = "thrift";
    static final String DEFAULT_HOST = "localhost";
    private static final String ENV_SERVER = "HMS_HOST";
    private static final String ENV_PORT = "HMS_PORT";
    private static final String PROP_HOST = "hms.host";
    private static final String PROP_PORT = "hms.port";
    private static final String HIVE_INPUT_FORMAT = "org.apache.hadoop.hive.ql.io.HiveInputFormat";
    private static final String HIVE_OUTPUT_FORMAT = "org.apache.hadoop.hive.ql.io.HiveOutputFormat";
    private static final String LAZY_SIMPLE_SERDE = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
    private static final Pattern[] EMPTY_PATTERN = new Pattern[0];
    private static final Pattern[] MATCH_ALL_PATTERN = new Pattern[]{Pattern.compile(".*")};
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);

    private Util() {
    }

    public static <T> T throwingSupplierWrapper(ThrowingSupplier<T, Exception> throwingSupplier) {
        try {
            return throwingSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<FieldSchema> createSchema(@Nullable List<String> params) {
        if (params == null || params.isEmpty()) {
            return Collections.emptyList();
        }
        return params.stream().map(Util::param2Schema).collect(Collectors.toList());
    }

    @Nullable
    public static URI getServerUri(@Nullable String host, @Nullable String portString) throws URISyntaxException {
        if (host == null) {
            host = System.getenv(ENV_SERVER);
        }
        if (host == null) {
            host = System.getProperty(PROP_HOST);
        }
        if (host == null) {
            host = DEFAULT_HOST;
        }
        host = host.trim();
        if ((portString == null || portString.isEmpty() || portString.equals("0")) && !host.contains(TYPE_SEPARATOR) && (portString = System.getenv(ENV_PORT)) == null) {
            portString = System.getProperty(PROP_PORT);
        }
        Integer port = 9083;
        if (portString != null) {
            port = Integer.parseInt(portString);
        }
        HostAndPort hp = HostAndPort.fromString((String)host).withDefaultPort(port.intValue());
        LOG.info("Connecting to {}:{}", (Object)hp.getHost(), (Object)hp.getPort());
        return new URI(THRIFT_SCHEMA, null, hp.getHost(), hp.getPort(), null, null, null);
    }

    private static FieldSchema param2Schema(@NotNull String param) {
        String colType = DEFAULT_TYPE;
        String name = param;
        if (param.contains(TYPE_SEPARATOR)) {
            String[] parts = param.split(TYPE_SEPARATOR);
            name = parts[0];
            colType = parts[1].toLowerCase();
        }
        return new FieldSchema(name, colType, "");
    }

    static List<Partition> createManyPartitions(@NotNull Table table, @Nullable Map<String, String> parameters, @NotNull List<String> arguments, int npartitions) {
        return IntStream.range(0, npartitions).mapToObj(i -> new PartitionBuilder(table).withParameters(parameters).withValues(arguments.stream().map(a -> a + i).collect(Collectors.toList())).build()).collect(Collectors.toList());
    }

    static List<Partition> createManyPartitions(@NotNull Table table, @Nullable Map<String, String> parameters, @NotNull List<List<String>> values) {
        return values.stream().map(vals -> new PartitionBuilder(table).withParameters(parameters).withValues((List<String>)vals).build()).collect(Collectors.toList());
    }

    static Object addManyPartitions(@NotNull HMSClient client, @NotNull String dbName, @NotNull String tableName, @Nullable Map<String, String> parameters, @NotNull List<String> arguments, int npartitions) throws TException {
        Table table = client.getTable(dbName, tableName);
        client.addPartitions(Util.createManyPartitions(table, parameters, arguments, npartitions));
        return null;
    }

    static Object updateManyPartitionsStats(@NotNull HMSClient client, @NotNull String dbName, @NotNull String tableName, @NotNull List<String> partNames) throws TException {
        ArrayList<ColumnStatisticsObj> statsObj = new ArrayList<ColumnStatisticsObj>();
        ColumnStatisticsData statsData = new ColumnStatisticsData(ColumnStatisticsData._Fields.STRING_STATS, (Object)new StringColumnStatsData(100L, 10.1, 20L, 30L));
        statsObj.add(new ColumnStatisticsObj("id", "int", statsData));
        ColumnStatisticsDesc partDesc = new ColumnStatisticsDesc(false, dbName, tableName);
        for (String partName : partNames) {
            partDesc.setPartName(partName);
            ColumnStatistics partColStat = new ColumnStatistics(partDesc, statsObj);
            partColStat.setEngine("hive");
            client.updatePartitionColumnStats(partColStat);
        }
        return null;
    }

    static List<String> generatePartitionNames(@NotNull String prefix, int npartitions) {
        return IntStream.range(0, npartitions).mapToObj(i -> prefix + i).collect(Collectors.toList());
    }

    static void addManyPartitionsNoException(@NotNull HMSClient client, @NotNull String dbName, @NotNull String tableName, @Nullable Map<String, String> parameters, List<String> arguments, int npartitions) {
        Util.throwingSupplierWrapper(() -> Util.addManyPartitions(client, dbName, tableName, parameters, arguments, npartitions));
    }

    static void addManyPartitionsNoException(@NotNull HMSClient client, @NotNull String dbName, @NotNull String tableName, @Nullable Map<String, String> parameters, List<List<String>> values) {
        Util.throwingSupplierWrapper(() -> {
            Table table = client.getTable(dbName, tableName);
            client.addPartitions(Util.createManyPartitions(table, parameters, values));
            return null;
        });
    }

    static void updateManyPartitionsStatsNoException(@NotNull HMSClient client, @NotNull String dbName, @NotNull String tableName, @NotNull List<String> partNames) {
        Util.throwingSupplierWrapper(() -> Util.updateManyPartitionsStats(client, dbName, tableName, partNames));
    }

    public static List<String> filterMatches(@Nullable List<String> candidates, @Nullable Pattern[] positivePatterns, @Nullable Pattern[] negativePatterns) {
        if (candidates == null || candidates.isEmpty()) {
            return Collections.emptyList();
        }
        Pattern[] positive = positivePatterns == null || positivePatterns.length == 0 ? MATCH_ALL_PATTERN : positivePatterns;
        Pattern[] negative = negativePatterns == null ? EMPTY_PATTERN : negativePatterns;
        return candidates.stream().filter(c -> Arrays.stream(positive).anyMatch(p -> p.matcher((CharSequence)c).matches())).filter(c -> Arrays.stream(negative).noneMatch(p -> p.matcher((CharSequence)c).matches())).collect(Collectors.toList());
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T, E extends Exception> {
        public T get() throws E;
    }

    public static class PartitionBuilder {
        private final Table table;
        private List<String> values;
        private String location;
        private Map<String, String> parameters = new HashMap<String, String>();

        private PartitionBuilder() {
            this.table = null;
        }

        PartitionBuilder(Table table) {
            this.table = table;
        }

        PartitionBuilder withValues(List<String> values) {
            this.values = new ArrayList<String>(values);
            return this;
        }

        PartitionBuilder withLocation(String location) {
            this.location = location;
            return this;
        }

        PartitionBuilder withParameter(String name, String value) {
            this.parameters.put(name, value);
            return this;
        }

        PartitionBuilder withParameters(Map<String, String> params) {
            this.parameters = params;
            return this;
        }

        Partition build() {
            Partition partition = new Partition();
            List partitionNames = this.table.getPartitionKeys().stream().map(FieldSchema::getName).collect(Collectors.toList());
            if (partitionNames.size() != this.values.size()) {
                throw new RuntimeException("Partition values do not match table schema");
            }
            List spec = IntStream.range(0, this.values.size()).mapToObj(i -> (String)partitionNames.get(i) + "=" + this.values.get(i)).collect(Collectors.toList());
            partition.setDbName(this.table.getDbName());
            partition.setTableName(this.table.getTableName());
            partition.setParameters(this.parameters);
            partition.setValues(this.values);
            partition.setSd(this.table.getSd().deepCopy());
            if (this.location == null) {
                partition.getSd().setLocation(this.table.getSd().getLocation() + "/" + Joiner.on((String)"/").join(spec));
            } else {
                partition.getSd().setLocation(this.location);
            }
            return partition;
        }
    }

    public static class LockComponentBuilder {
        private LockComponent component = new LockComponent();
        private boolean tableNameSet = false;
        private boolean partNameSet = false;

        public LockComponentBuilder setExclusive() {
            this.component.setType(LockType.EXCLUSIVE);
            return this;
        }

        public LockComponentBuilder setSemiShared() {
            this.component.setType(LockType.SHARED_WRITE);
            return this;
        }

        public LockComponentBuilder setShared() {
            this.component.setType(LockType.SHARED_READ);
            return this;
        }

        public LockComponentBuilder setDbName(String dbName) {
            this.component.setDbname(dbName);
            return this;
        }

        public LockComponentBuilder setIsTransactional(boolean t) {
            this.component.setIsTransactional(t);
            return this;
        }

        public LockComponentBuilder setOperationType(DataOperationType dop) {
            this.component.setOperationType(dop);
            return this;
        }

        public LockComponentBuilder setTableName(String tableName) {
            this.component.setTablename(tableName);
            this.tableNameSet = true;
            return this;
        }

        public LockComponentBuilder setPartitionName(String partitionName) {
            this.component.setPartitionname(partitionName);
            this.partNameSet = true;
            return this;
        }

        public LockComponent build() {
            LockLevel level = LockLevel.DB;
            if (this.tableNameSet) {
                level = LockLevel.TABLE;
            }
            if (this.partNameSet) {
                level = LockLevel.PARTITION;
            }
            this.component.setLevel(level);
            return this.component;
        }

        public LockComponent setLock(LockType type) {
            this.component.setType(type);
            return this.component;
        }
    }

    public static class TableBuilder {
        private final String dbName;
        private final String tableName;
        private TableType tableType = TableType.MANAGED_TABLE;
        private String location;
        private String serde = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
        private String owner;
        private List<FieldSchema> columns;
        private List<FieldSchema> partitionKeys;
        private String inputFormat = "org.apache.hadoop.hive.ql.io.HiveInputFormat";
        private String outputFormat = "org.apache.hadoop.hive.ql.io.HiveOutputFormat";
        private Map<String, String> parameters = new HashMap<String, String>();

        private TableBuilder() {
            this.dbName = null;
            this.tableName = null;
            this.parameters.putIfAbsent("transactional", "true");
        }

        TableBuilder(String dbName, String tableName) {
            this.dbName = dbName;
            this.tableName = tableName;
        }

        static Table buildDefaultTable(String dbName, String tableName) {
            return new TableBuilder(dbName, tableName).build();
        }

        TableBuilder withType(TableType tabeType) {
            this.tableType = tabeType;
            return this;
        }

        TableBuilder withOwner(String owner) {
            this.owner = owner;
            return this;
        }

        TableBuilder withColumns(List<FieldSchema> columns) {
            this.columns = columns;
            return this;
        }

        TableBuilder withPartitionKeys(List<FieldSchema> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        TableBuilder withSerde(String serde) {
            this.serde = serde;
            return this;
        }

        TableBuilder withInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        TableBuilder withOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        TableBuilder withParameter(String name, String value) {
            this.parameters.put(name, value);
            return this;
        }

        TableBuilder withLocation(String location) {
            this.location = location;
            return this;
        }

        Table build() {
            StorageDescriptor sd = new StorageDescriptor();
            if (this.columns == null) {
                sd.setCols(Collections.emptyList());
            } else {
                sd.setCols(this.columns);
            }
            SerDeInfo serdeInfo = new SerDeInfo();
            serdeInfo.setSerializationLib(this.serde);
            serdeInfo.setName(this.tableName);
            sd.setSerdeInfo(serdeInfo);
            sd.setInputFormat(this.inputFormat);
            sd.setOutputFormat(this.outputFormat);
            if (this.location != null) {
                sd.setLocation(this.location);
            }
            Table table = new Table();
            table.setDbName(this.dbName);
            table.setTableName(this.tableName);
            table.setSd(sd);
            table.setParameters(this.parameters);
            table.setOwner(this.owner);
            if (this.partitionKeys != null) {
                table.setPartitionKeys(this.partitionKeys);
            }
            table.setTableType(this.tableType.toString());
            return table;
        }
    }

    public static class DatabaseBuilder {
        private String name;
        private String description;
        private String location;
        private String ownerName;
        private PrincipalType ownerType;
        private Map<String, String> params = null;

        private DatabaseBuilder() {
        }

        public DatabaseBuilder(@NotNull String name) {
            this.name = name;
            this.ownerType = PrincipalType.USER;
        }

        public DatabaseBuilder withDescription(@NotNull String description) {
            this.description = description;
            return this;
        }

        public DatabaseBuilder withLocation(@NotNull String location) {
            this.location = location;
            return this;
        }

        public DatabaseBuilder withParams(@NotNull Map<String, String> params) {
            this.params = params;
            return this;
        }

        public DatabaseBuilder withParam(@NotNull String key, @NotNull String val) {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            this.params.put(key, val);
            return this;
        }

        public DatabaseBuilder withOwnerName(@NotNull String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public DatabaseBuilder withOwnerType(PrincipalType ownerType) {
            this.ownerType = ownerType;
            return this;
        }

        public Database build() {
            Database db = new Database(this.name, this.description, this.location, this.params);
            if (this.ownerName != null) {
                db.setOwnerName(this.ownerName);
            }
            if (this.ownerType != null) {
                db.setOwnerType(this.ownerType);
            }
            return db;
        }
    }
}

