/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesqueesque.common.utils;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadUtils {
    public static ThreadFactory createThreadFactory(final String pattern, final boolean daemon) {
        return new ThreadFactory(){
            private final AtomicLong threadEpoch = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                String threadName = pattern.contains("%d") ? String.format(pattern, this.threadEpoch.addAndGet(1L)) : pattern;
                Thread thread = new Thread(r, threadName);
                thread.setDaemon(daemon);
                return thread;
            }
        };
    }
}

