/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesqueesque.common.requests;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.kafkaesqueesqueesque.common.errors.InvalidRequestException;
import org.apache.kafkaesqueesqueesque.common.message.ApiVersionsRequestData;
import org.apache.kafkaesqueesqueesque.common.network.ClientInformation;
import org.apache.kafkaesqueesqueesque.common.network.ListenerName;
import org.apache.kafkaesqueesqueesque.common.network.Send;
import org.apache.kafkaesqueesqueesque.common.protocol.ApiKeys;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Struct;
import org.apache.kafkaesqueesqueesque.common.requests.AbstractRequest;
import org.apache.kafkaesqueesqueesque.common.requests.AbstractResponse;
import org.apache.kafkaesqueesqueesque.common.requests.ApiVersionsRequest;
import org.apache.kafkaesqueesqueesque.common.requests.RequestAndSize;
import org.apache.kafkaesqueesqueesque.common.requests.RequestHeader;
import org.apache.kafkaesqueesqueesque.common.requests.ResponseHeader;
import org.apache.kafkaesqueesqueesque.common.security.auth.KafkaPrincipal;
import org.apache.kafkaesqueesqueesque.common.security.auth.SecurityProtocol;
import org.apache.kafkaesqueesqueesque.server.authorizer.AuthorizableRequestContext;

public class RequestContext
implements AuthorizableRequestContext {
    public final RequestHeader header;
    public final String connectionId;
    public final InetAddress clientAddress;
    public final KafkaPrincipal principal;
    public final ListenerName listenerName;
    public final SecurityProtocol securityProtocol;
    public final ClientInformation clientInformation;

    public RequestContext(RequestHeader header, String connectionId, InetAddress clientAddress, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation) {
        this.header = header;
        this.connectionId = connectionId;
        this.clientAddress = clientAddress;
        this.principal = principal;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.clientInformation = clientInformation;
    }

    public RequestAndSize parseRequest(ByteBuffer buffer) {
        if (this.isUnsupportedApiVersionsRequest()) {
            ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(new ApiVersionsRequestData(), 0, this.header.apiVersion());
            return new RequestAndSize(apiVersionsRequest, 0);
        }
        ApiKeys apiKey = this.header.apiKey();
        try {
            short apiVersion = this.header.apiVersion();
            Struct struct = apiKey.parseRequest(apiVersion, buffer);
            AbstractRequest body = AbstractRequest.parseRequest(apiKey, apiVersion, struct);
            return new RequestAndSize(body, struct.sizeOf());
        }
        catch (Throwable ex) {
            throw new InvalidRequestException("Error getting request for apiKey: " + (Object)((Object)apiKey) + ", apiVersion: " + this.header.apiVersion() + ", connectionId: " + this.connectionId + ", listenerName: " + this.listenerName + ", principal: " + this.principal, ex);
        }
    }

    public Send buildResponse(AbstractResponse body) {
        ResponseHeader responseHeader = this.header.toResponseHeader();
        return body.toSend(this.connectionId, responseHeader, this.apiVersion());
    }

    private boolean isUnsupportedApiVersionsRequest() {
        return this.header.apiKey() == ApiKeys.API_VERSIONS && !ApiKeys.API_VERSIONS.isVersionSupported(this.header.apiVersion());
    }

    public short apiVersion() {
        if (this.isUnsupportedApiVersionsRequest()) {
            return 0;
        }
        return this.header.apiVersion();
    }

    @Override
    public String listenerName() {
        return this.listenerName.value();
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    @Override
    public KafkaPrincipal principal() {
        return this.principal;
    }

    @Override
    public InetAddress clientAddress() {
        return this.clientAddress;
    }

    @Override
    public int requestType() {
        return this.header.apiKey().id;
    }

    @Override
    public int requestVersion() {
        return this.header.apiVersion();
    }

    @Override
    public String clientId() {
        return this.header.clientId();
    }

    @Override
    public int correlationId() {
        return this.header.correlationId();
    }
}

