/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesqueesque.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafkaesqueesqueesque.common.message.InitProducerIdRequestData;
import org.apache.kafkaesqueesqueesque.common.message.InitProducerIdResponseData;
import org.apache.kafkaesqueesqueesque.common.protocol.ApiKeys;
import org.apache.kafkaesqueesqueesque.common.protocol.Errors;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Struct;
import org.apache.kafkaesqueesqueesque.common.requests.AbstractRequest;
import org.apache.kafkaesqueesqueesque.common.requests.AbstractResponse;
import org.apache.kafkaesqueesqueesque.common.requests.InitProducerIdResponse;

public class InitProducerIdRequest
extends AbstractRequest {
    public final InitProducerIdRequestData data;

    private InitProducerIdRequest(InitProducerIdRequestData data, short version) {
        super(ApiKeys.INIT_PRODUCER_ID, version);
        this.data = data;
    }

    public InitProducerIdRequest(Struct struct, short version) {
        super(ApiKeys.INIT_PRODUCER_ID, version);
        this.data = new InitProducerIdRequestData(struct, version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        InitProducerIdResponseData response = new InitProducerIdResponseData().setErrorCode(Errors.forException(e).code()).setProducerId(-1L).setProducerEpoch((short)-1).setThrottleTimeMs(0);
        return new InitProducerIdResponse(response);
    }

    public static InitProducerIdRequest parse(ByteBuffer buffer, short version) {
        return new InitProducerIdRequest(ApiKeys.INIT_PRODUCER_ID.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<InitProducerIdRequest> {
        private final InitProducerIdRequestData data;

        public Builder(InitProducerIdRequestData data) {
            super(ApiKeys.INIT_PRODUCER_ID);
            this.data = data;
        }

        @Override
        public InitProducerIdRequest build(short version) {
            if (this.data.transactionTimeoutMs() <= 0) {
                throw new IllegalArgumentException("transaction timeout value is not positive: " + this.data.transactionTimeoutMs());
            }
            if (this.data.transactionalId() != null && this.data.transactionalId().isEmpty()) {
                throw new IllegalArgumentException("Must set either a null or a non-empty transactional id.");
            }
            return new InitProducerIdRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

