/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesqueesque.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafkaesqueesqueesque.common.acl.AccessControlEntryFilter;
import org.apache.kafkaesqueesqueesque.common.acl.AclBindingFilter;
import org.apache.kafkaesqueesqueesque.common.acl.AclOperation;
import org.apache.kafkaesqueesqueesque.common.acl.AclPermissionType;
import org.apache.kafkaesqueesqueesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesqueesqueesque.common.message.DeleteAclsRequestData;
import org.apache.kafkaesqueesqueesque.common.message.DeleteAclsResponseData;
import org.apache.kafkaesqueesqueesque.common.protocol.ApiKeys;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Struct;
import org.apache.kafkaesqueesqueesque.common.requests.AbstractRequest;
import org.apache.kafkaesqueesqueesque.common.requests.AbstractResponse;
import org.apache.kafkaesqueesqueesque.common.requests.ApiError;
import org.apache.kafkaesqueesqueesque.common.requests.DeleteAclsResponse;
import org.apache.kafkaesqueesqueesque.common.resource.PatternType;
import org.apache.kafkaesqueesqueesque.common.resource.ResourcePatternFilter;
import org.apache.kafkaesqueesqueesque.common.resource.ResourceType;

public class DeleteAclsRequest
extends AbstractRequest {
    private final DeleteAclsRequestData data;

    private DeleteAclsRequest(short version, DeleteAclsRequestData data) {
        super(ApiKeys.DELETE_ACLS, version);
        this.data = data;
        this.normalizeAndValidate();
    }

    private void normalizeAndValidate() {
        boolean unknown;
        if (this.version() == 0) {
            for (DeleteAclsRequestData.DeleteAclsFilter filter2 : this.data.filters()) {
                PatternType patternType = PatternType.fromCode(filter2.patternTypeFilter());
                if (patternType == PatternType.ANY) {
                    filter2.setPatternTypeFilter(PatternType.LITERAL.code());
                    continue;
                }
                if (patternType == PatternType.LITERAL) continue;
                throw new UnsupportedVersionException("Version 0 does not support pattern type " + (Object)((Object)patternType) + " (only LITERAL and ANY are supported)");
            }
        }
        if (unknown = this.data.filters().stream().anyMatch(filter -> filter.patternTypeFilter() == PatternType.UNKNOWN.code() || filter.resourceTypeFilter() == ResourceType.UNKNOWN.code() || filter.operation() == AclOperation.UNKNOWN.code() || filter.permissionType() == AclPermissionType.UNKNOWN.code())) {
            throw new IllegalArgumentException("Filters contain UNKNOWN elements, filters: " + this.data.filters());
        }
    }

    public DeleteAclsRequest(Struct struct, short version) {
        super(ApiKeys.DELETE_ACLS, version);
        this.data = new DeleteAclsRequestData(struct, version);
    }

    public List<AclBindingFilter> filters() {
        return this.data.filters().stream().map(DeleteAclsRequest::aclBindingFilter).collect(Collectors.toList());
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable throwable) {
        ApiError apiError = ApiError.fromThrowable(throwable);
        List<DeleteAclsResponseData.DeleteAclsFilterResult> filterResults = Collections.nCopies(this.data.filters().size(), new DeleteAclsResponseData.DeleteAclsFilterResult().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
        return new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(throttleTimeMs).setFilterResults(filterResults));
    }

    public static DeleteAclsRequest parse(ByteBuffer buffer, short version) {
        return new DeleteAclsRequest(ApiKeys.DELETE_ACLS.parseRequest(version, buffer), version);
    }

    public static DeleteAclsRequestData.DeleteAclsFilter deleteAclsFilter(AclBindingFilter filter) {
        return new DeleteAclsRequestData.DeleteAclsFilter().setResourceNameFilter(filter.patternFilter().name()).setResourceTypeFilter(filter.patternFilter().resourceType().code()).setPatternTypeFilter(filter.patternFilter().patternType().code()).setHostFilter(filter.entryFilter().host()).setOperation(filter.entryFilter().operation().code()).setPermissionType(filter.entryFilter().permissionType().code()).setPrincipalFilter(filter.entryFilter().principal());
    }

    private static AclBindingFilter aclBindingFilter(DeleteAclsRequestData.DeleteAclsFilter filter) {
        ResourcePatternFilter patternFilter = new ResourcePatternFilter(ResourceType.fromCode(filter.resourceTypeFilter()), filter.resourceNameFilter(), PatternType.fromCode(filter.patternTypeFilter()));
        AccessControlEntryFilter entryFilter = new AccessControlEntryFilter(filter.principalFilter(), filter.hostFilter(), AclOperation.fromCode(filter.operation()), AclPermissionType.fromCode(filter.permissionType()));
        return new AclBindingFilter(patternFilter, entryFilter);
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteAclsRequest> {
        private final DeleteAclsRequestData data;

        public Builder(DeleteAclsRequestData data) {
            super(ApiKeys.DELETE_ACLS);
            this.data = data;
        }

        @Override
        public DeleteAclsRequest build(short version) {
            return new DeleteAclsRequest(version, this.data);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

