/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesqueesque.common.requests;

import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.apache.kafkaesqueesqueesque.common.message.ApiVersionsRequestData;
import org.apache.kafkaesqueesqueesque.common.message.ApiVersionsResponseData;
import org.apache.kafkaesqueesqueesque.common.protocol.ApiKeys;
import org.apache.kafkaesqueesqueesque.common.protocol.Errors;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Struct;
import org.apache.kafkaesqueesqueesque.common.requests.AbstractRequest;
import org.apache.kafkaesqueesqueesque.common.requests.ApiVersionsResponse;
import org.apache.kafkaesqueesqueesque.common.utils.AppInfoParser;

public class ApiVersionsRequest
extends AbstractRequest {
    private static final Pattern SOFTWARE_NAME_VERSION_PATTERN = Pattern.compile("[a-zA-Z0-9](?:[a-zA-Z0-9\\-.]*[a-zA-Z0-9])?");
    private final Short unsupportedRequestVersion;
    public final ApiVersionsRequestData data;

    public ApiVersionsRequest(ApiVersionsRequestData data, short version) {
        this(data, version, null);
    }

    public ApiVersionsRequest(ApiVersionsRequestData data, short version, Short unsupportedRequestVersion) {
        super(ApiKeys.API_VERSIONS, version);
        this.data = data;
        this.unsupportedRequestVersion = unsupportedRequestVersion;
    }

    public ApiVersionsRequest(Struct struct, short version) {
        this(new ApiVersionsRequestData(struct, version), version);
    }

    public boolean hasUnsupportedRequestVersion() {
        return this.unsupportedRequestVersion != null;
    }

    public boolean isValid() {
        if (this.version() >= 3) {
            return SOFTWARE_NAME_VERSION_PATTERN.matcher(this.data.clientSoftwareName()).matches() && SOFTWARE_NAME_VERSION_PATTERN.matcher(this.data.clientSoftwareVersion()).matches();
        }
        return true;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    @Override
    public ApiVersionsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiVersionsResponseData data = new ApiVersionsResponseData().setErrorCode(Errors.forException(e).code());
        if (this.version() >= 1) {
            data.setThrottleTimeMs(throttleTimeMs);
        }
        if (Errors.forException(e) == Errors.UNSUPPORTED_VERSION) {
            ApiVersionsResponseData.ApiVersionsResponseKeyCollection apiKeys = new ApiVersionsResponseData.ApiVersionsResponseKeyCollection();
            apiKeys.add(new ApiVersionsResponseData.ApiVersionsResponseKey().setApiKey(ApiKeys.API_VERSIONS.id).setMinVersion(ApiKeys.API_VERSIONS.oldestVersion()).setMaxVersion(ApiKeys.API_VERSIONS.latestVersion()));
            data.setApiKeys(apiKeys);
        }
        return new ApiVersionsResponse(data);
    }

    public static ApiVersionsRequest parse(ByteBuffer buffer, short version) {
        return new ApiVersionsRequest(ApiKeys.API_VERSIONS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ApiVersionsRequest> {
        private static final String DEFAULT_CLIENT_SOFTWARE_NAME = "apache-kafka-java";
        private static final ApiVersionsRequestData DATA = new ApiVersionsRequestData().setClientSoftwareName("apache-kafka-java").setClientSoftwareVersion(AppInfoParser.getVersion());

        public Builder() {
            super(ApiKeys.API_VERSIONS);
        }

        public Builder(short version) {
            super(ApiKeys.API_VERSIONS, version);
        }

        @Override
        public ApiVersionsRequest build(short version) {
            return new ApiVersionsRequest(DATA, version);
        }

        public String toString() {
            return DATA.toString();
        }
    }
}

