/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesqueesque.common.replica;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafkaesqueesqueesque.common.TopicPartition;
import org.apache.kafkaesqueesqueesque.common.replica.ClientMetadata;
import org.apache.kafkaesqueesqueesque.common.replica.PartitionView;
import org.apache.kafkaesqueesqueesque.common.replica.ReplicaSelector;
import org.apache.kafkaesqueesqueesque.common.replica.ReplicaView;

public class RackAwareReplicaSelector
implements ReplicaSelector {
    @Override
    public Optional<ReplicaView> select(TopicPartition topicPartition, ClientMetadata clientMetadata, PartitionView partitionView) {
        if (clientMetadata.rackId() != null && !clientMetadata.rackId().isEmpty()) {
            Set sameRackReplicas = partitionView.replicas().stream().filter(replicaInfo -> clientMetadata.rackId().equals(replicaInfo.endpoint().rack())).collect(Collectors.toSet());
            if (sameRackReplicas.isEmpty()) {
                return Optional.of(partitionView.leader());
            }
            if (sameRackReplicas.contains(partitionView.leader())) {
                return Optional.of(partitionView.leader());
            }
            return sameRackReplicas.stream().max(ReplicaView.comparator());
        }
        return Optional.of(partitionView.leader());
    }
}

