/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesqueesque.common.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.Iterator;
import org.apache.kafkaesqueesqueesque.common.TopicPartition;
import org.apache.kafkaesqueesqueesque.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafkaesqueesqueesque.common.record.ConvertedRecords;
import org.apache.kafkaesqueesqueesque.common.record.DefaultRecordsSend;
import org.apache.kafkaesqueesqueesque.common.record.LazyDownConversionRecords;
import org.apache.kafkaesqueesqueesque.common.record.MemoryRecords;
import org.apache.kafkaesqueesqueesque.common.record.RecordConversionStats;
import org.apache.kafkaesqueesqueesque.common.record.RecordsSend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LazyDownConversionRecordsSend
extends RecordsSend<LazyDownConversionRecords> {
    private static final Logger log = LoggerFactory.getLogger(LazyDownConversionRecordsSend.class);
    private static final int MAX_READ_SIZE = 131072;
    static final int MIN_OVERFLOW_MESSAGE_LENGTH = 12;
    private RecordConversionStats recordConversionStats = new RecordConversionStats();
    private RecordsSend convertedRecordsWriter = null;
    private Iterator<ConvertedRecords<?>> convertedRecordsIterator = ((LazyDownConversionRecords)this.records()).iterator(131072L);

    public LazyDownConversionRecordsSend(String destination, LazyDownConversionRecords records) {
        super(destination, records, records.sizeInBytes());
    }

    private MemoryRecords buildOverflowBatch(int remaining) {
        ByteBuffer overflowMessageBatch = ByteBuffer.allocate(Math.max(12, Math.min(remaining + 1, 131072)));
        overflowMessageBatch.putLong(-1L);
        overflowMessageBatch.putInt(Math.max(remaining + 1, 61));
        log.debug("Constructed overflow message batch for partition {} with length={}", (Object)this.topicPartition(), (Object)remaining);
        return MemoryRecords.readableRecords(overflowMessageBatch);
    }

    @Override
    public long writeTo(GatheringByteChannel channel, long previouslyWritten, int remaining) throws IOException {
        if (this.convertedRecordsWriter == null || this.convertedRecordsWriter.completed()) {
            MemoryRecords convertedRecords;
            try {
                if (this.convertedRecordsIterator.hasNext()) {
                    ConvertedRecords<?> recordsAndStats = this.convertedRecordsIterator.next();
                    convertedRecords = (MemoryRecords)recordsAndStats.records();
                    this.recordConversionStats.add(recordsAndStats.recordConversionStats());
                    log.debug("Down-converted records for partition {} with length={}", (Object)this.topicPartition(), (Object)convertedRecords.sizeInBytes());
                } else {
                    convertedRecords = this.buildOverflowBatch(remaining);
                }
            }
            catch (UnsupportedCompressionTypeException e) {
                convertedRecords = this.buildOverflowBatch(remaining);
            }
            this.convertedRecordsWriter = new DefaultRecordsSend(this.destination(), convertedRecords, Math.min(convertedRecords.sizeInBytes(), remaining));
        }
        return this.convertedRecordsWriter.writeTo(channel);
    }

    public RecordConversionStats recordConversionStats() {
        return this.recordConversionStats;
    }

    public TopicPartition topicPartition() {
        return ((LazyDownConversionRecords)this.records()).topicPartition();
    }
}

