/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesqueesque.common.metrics.stats;

public class Histogram {
    private final BinScheme binScheme;
    private final float[] hist;
    private double count;

    public Histogram(BinScheme binScheme) {
        this.hist = new float[binScheme.bins()];
        this.count = 0.0;
        this.binScheme = binScheme;
    }

    public void record(double value) {
        int n = this.binScheme.toBin(value);
        this.hist[n] = this.hist[n] + 1.0f;
        this.count += 1.0;
    }

    public double value(double quantile) {
        if (this.count == 0.0) {
            return Double.NaN;
        }
        if (quantile > 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (quantile < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        float sum = 0.0f;
        float quant = (float)quantile;
        for (int i = 0; i < this.hist.length - 1; ++i) {
            if (!((double)(sum += this.hist[i]) / this.count > (double)quant)) continue;
            return this.binScheme.fromBin(i);
        }
        return this.binScheme.fromBin(this.hist.length - 1);
    }

    public float[] counts() {
        return this.hist;
    }

    public void clear() {
        for (int i = 0; i < this.hist.length; ++i) {
            this.hist[i] = 0.0f;
        }
        this.count = 0.0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("{");
        for (int i = 0; i < this.hist.length - 1; ++i) {
            b.append(String.format("%.10f", this.binScheme.fromBin(i)));
            b.append(':');
            b.append(String.format("%.0f", Float.valueOf(this.hist[i])));
            b.append(',');
        }
        b.append(Float.POSITIVE_INFINITY);
        b.append(':');
        b.append(String.format("%.0f", Float.valueOf(this.hist[this.hist.length - 1])));
        b.append('}');
        return b.toString();
    }

    public static class LinearBinScheme
    implements BinScheme {
        private final int bins;
        private final double max;
        private final double scale;

        public LinearBinScheme(int numBins, double max) {
            if (numBins < 2) {
                throw new IllegalArgumentException("Must have at least 2 bins.");
            }
            this.bins = numBins;
            this.max = max;
            double denom = (double)numBins * ((double)numBins - 1.0) / 2.0;
            this.scale = max / denom;
        }

        @Override
        public int bins() {
            return this.bins;
        }

        @Override
        public double fromBin(int b) {
            if (b > this.bins - 1) {
                return Double.POSITIVE_INFINITY;
            }
            if ((double)b < 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return this.scale * ((double)b * ((double)b + 1.0)) / 2.0;
        }

        @Override
        public int toBin(double x) {
            if (x < 0.0) {
                throw new IllegalArgumentException("Values less than 0.0 not accepted.");
            }
            if (x > this.max) {
                return this.bins - 1;
            }
            return (int)(-0.5 + 0.5 * Math.sqrt(1.0 + 8.0 * x / this.scale));
        }
    }

    public static class ConstantBinScheme
    implements BinScheme {
        private static final int MIN_BIN_NUMBER = 0;
        private final double min;
        private final double max;
        private final int bins;
        private final double bucketWidth;
        private final int maxBinNumber;

        public ConstantBinScheme(int bins, double min, double max) {
            if (bins < 2) {
                throw new IllegalArgumentException("Must have at least 2 bins.");
            }
            this.min = min;
            this.max = max;
            this.bins = bins;
            this.bucketWidth = (max - min) / (double)bins;
            this.maxBinNumber = bins - 1;
        }

        @Override
        public int bins() {
            return this.bins;
        }

        @Override
        public double fromBin(int b) {
            if (b < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (b > this.maxBinNumber) {
                return Double.POSITIVE_INFINITY;
            }
            return this.min + (double)b * this.bucketWidth;
        }

        @Override
        public int toBin(double x) {
            int binNumber = (int)((x - this.min) / this.bucketWidth);
            if (binNumber < 0) {
                return 0;
            }
            if (binNumber > this.maxBinNumber) {
                return this.maxBinNumber;
            }
            return binNumber;
        }
    }

    public static interface BinScheme {
        public int bins();

        public int toBin(double var1);

        public double fromBin(int var1);
    }
}

