/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesqueesque.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafkaesqueesqueesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesqueesqueesque.common.protocol.ApiMessage;
import org.apache.kafkaesqueesqueesque.common.protocol.Message;
import org.apache.kafkaesqueesqueesque.common.protocol.MessageUtil;
import org.apache.kafkaesqueesqueesque.common.protocol.ObjectSerializationCache;
import org.apache.kafkaesqueesqueesque.common.protocol.Readable;
import org.apache.kafkaesqueesqueesque.common.protocol.Writable;
import org.apache.kafkaesqueesqueesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesqueesqueesque.common.protocol.types.CompactArrayOf;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Field;
import org.apache.kafkaesqueesqueesque.common.protocol.types.RawTaggedField;
import org.apache.kafkaesqueesqueesque.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Schema;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Struct;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Type;
import org.apache.kafkaesqueesqueesque.common.utils.ByteUtils;

public class LeaveGroupResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private List<MemberResponse> members;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema[] SCHEMAS;

    public LeaveGroupResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public LeaveGroupResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public LeaveGroupResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.members = new ArrayList<MemberResponse>();
    }

    @Override
    public short apiKey() {
        return 13;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 4;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _version >= 1 ? _readable.readInt() : 0;
        this.errorCode = _readable.readShort();
        if (_version >= 3) {
            int i;
            ArrayList<MemberResponse> newCollection;
            int arrayLength;
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field members was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new MemberResponse(_readable, _version));
                }
                this.members = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field members was serialized as null");
                }
                newCollection = new ArrayList<MemberResponse>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new MemberResponse(_readable, _version));
                }
                this.members = newCollection;
            }
        } else {
            this.members = new ArrayList<MemberResponse>();
        }
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeInt(this.throttleTimeMs);
        }
        _writable.writeShort(this.errorCode);
        if (_version >= 3) {
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.members.size() + 1);
                for (MemberResponse membersElement : this.members) {
                    membersElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.members.size());
                for (MemberResponse membersElement : this.members) {
                    membersElement.write(_writable, _cache, _version);
                }
            }
        } else if (!this.members.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default members at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = _version >= 1 ? struct.getInt("throttle_time_ms") : 0;
        this.errorCode = struct.getShort("error_code");
        if (_version >= 3) {
            Object[] _nestedObjects = struct.getArray("members");
            this.members = new ArrayList<MemberResponse>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.members.add(new MemberResponse((Struct)nestedObject, _version));
            }
        } else {
            this.members = new ArrayList<MemberResponse>();
        }
        if (_version >= 4 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 4) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        struct.set("error_code", (Object)this.errorCode);
        if (_version >= 3) {
            Struct[] _nestedObjects = new Struct[this.members.size()];
            int i = 0;
            for (MemberResponse element : this.members) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("members", (Object)_nestedObjects);
        } else if (!this.members.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default members at version " + _version);
        }
        if (_version >= 4) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _size += 4;
        }
        _size += 2;
        if (_version >= 3) {
            int _arraySize = 0;
            _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.members.size() + 1)) : (_arraySize += 4);
            for (MemberResponse membersElement : this.members) {
                _arraySize += membersElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 4) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LeaveGroupResponseData)) {
            return false;
        }
        LeaveGroupResponseData other = (LeaveGroupResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        return !(this.members == null ? other.members != null : !this.members.equals(other.members));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.members == null ? 0 : this.members.hashCode());
        return hashCode;
    }

    public String toString() {
        return "LeaveGroupResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", members=" + MessageUtil.deepToString(this.members.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<MemberResponse> members() {
        return this.members;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public LeaveGroupResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public LeaveGroupResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public LeaveGroupResponseData setMembers(List<MemberResponse> v) {
        this.members = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."));
        SCHEMA_3 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("members", new ArrayOf(MemberResponse.SCHEMA_3), "List of leaving member responses."));
        SCHEMA_4 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("members", new CompactArrayOf(MemberResponse.SCHEMA_4), "List of leaving member responses."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
    }

    public static class MemberResponse
    implements Message {
        private String memberId;
        private String groupInstanceId;
        private short errorCode;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_3 = new Schema(new Field("member_id", Type.STRING, "The member ID to remove from the group."), new Field("group_instance_id", Type.NULLABLE_STRING, "The group instance ID to remove from the group."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."));
        public static final Schema SCHEMA_4 = new Schema(new Field("member_id", Type.COMPACT_STRING, "The member ID to remove from the group."), new Field("group_instance_id", Type.COMPACT_NULLABLE_STRING, "The group instance ID to remove from the group."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, SCHEMA_3, SCHEMA_4};

        public MemberResponse(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public MemberResponse(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public MemberResponse() {
            this.memberId = "";
            this.groupInstanceId = "";
            this.errorCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MemberResponse");
            }
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field memberId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            }
            this.memberId = _readable.readString(length);
            length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.groupInstanceId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field groupInstanceId had invalid length " + length);
                }
                this.groupInstanceId = _readable.readString(length);
            }
            this.errorCode = _readable.readShort();
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MemberResponse");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.memberId);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (this.groupInstanceId == null) {
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.groupInstanceId);
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeShort(this.errorCode);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MemberResponse");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.memberId = struct.getString("member_id");
            this.groupInstanceId = struct.getString("group_instance_id");
            this.errorCode = struct.getShort("error_code");
            if (_version >= 4 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MemberResponse");
            }
            TreeMap _taggedFields = null;
            if (_version >= 4) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("member_id", (Object)this.memberId);
            struct.set("group_instance_id", (Object)this.groupInstanceId);
            struct.set("error_code", (Object)this.errorCode);
            if (_version >= 4) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MemberResponse");
            }
            byte[] _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.memberId, _stringBytes);
            _size = _version >= 4 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            if (this.groupInstanceId == null) {
                _size = _version >= 4 ? ++_size : (_size += 2);
            } else {
                _stringBytes = this.groupInstanceId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'groupInstanceId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.groupInstanceId, _stringBytes);
                _size = _version >= 4 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            }
            _size += 2;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 4) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MemberResponse)) {
                return false;
            }
            MemberResponse other = (MemberResponse)obj;
            if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
                return false;
            }
            if (this.groupInstanceId == null ? other.groupInstanceId != null : !this.groupInstanceId.equals(other.groupInstanceId)) {
                return false;
            }
            return this.errorCode == other.errorCode;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
            hashCode = 31 * hashCode + (this.groupInstanceId == null ? 0 : this.groupInstanceId.hashCode());
            hashCode = 31 * hashCode + this.errorCode;
            return hashCode;
        }

        public String toString() {
            return "MemberResponse(memberId=" + (this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", groupInstanceId=" + (this.groupInstanceId == null ? "null" : "'" + this.groupInstanceId.toString() + "'") + ", errorCode=" + this.errorCode + ")";
        }

        public String memberId() {
            return this.memberId;
        }

        public String groupInstanceId() {
            return this.groupInstanceId;
        }

        public short errorCode() {
            return this.errorCode;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MemberResponse setMemberId(String v) {
            this.memberId = v;
            return this;
        }

        public MemberResponse setGroupInstanceId(String v) {
            this.groupInstanceId = v;
            return this;
        }

        public MemberResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }
    }
}

