/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesqueesque.common.message;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafkaesqueesqueesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesqueesqueesque.common.protocol.ApiMessage;
import org.apache.kafkaesqueesqueesque.common.protocol.ObjectSerializationCache;
import org.apache.kafkaesqueesqueesque.common.protocol.Readable;
import org.apache.kafkaesqueesqueesque.common.protocol.Writable;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Field;
import org.apache.kafkaesqueesqueesque.common.protocol.types.RawTaggedField;
import org.apache.kafkaesqueesqueesque.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Schema;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Struct;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Type;
import org.apache.kafkaesqueesqueesque.common.utils.ByteUtils;

public class InitProducerIdResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private long producerId;
    private short producerEpoch;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;

    public InitProducerIdResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public InitProducerIdResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public InitProducerIdResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.producerId = -1L;
        this.producerEpoch = 0;
    }

    @Override
    public short apiKey() {
        return 22;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        this.producerId = _readable.readLong();
        this.producerEpoch = _readable.readShort();
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        _writable.writeLong(this.producerId);
        _writable.writeShort(this.producerEpoch);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.errorCode = struct.getShort("error_code");
        this.producerId = struct.getLong("producer_id");
        this.producerEpoch = struct.getShort("producer_epoch");
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        struct.set("error_code", (Object)this.errorCode);
        struct.set("producer_id", (Object)this.producerId);
        struct.set("producer_epoch", (Object)this.producerEpoch);
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        _size += 2;
        _size += 8;
        _size += 2;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InitProducerIdResponseData)) {
            return false;
        }
        InitProducerIdResponseData other = (InitProducerIdResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.producerId != other.producerId) {
            return false;
        }
        return this.producerEpoch == other.producerEpoch;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
        hashCode = 31 * hashCode + this.producerEpoch;
        return hashCode;
    }

    public String toString() {
        return "InitProducerIdResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public InitProducerIdResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public InitProducerIdResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public InitProducerIdResponseData setProducerId(long v) {
        this.producerId = v;
        return this;
    }

    public InitProducerIdResponseData setProducerEpoch(short v) {
        this.producerEpoch = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("producer_id", Type.INT64, "The current producer id."), new Field("producer_epoch", Type.INT16, "The current epoch associated with the producer id."));
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("producer_id", Type.INT64, "The current producer id."), new Field("producer_epoch", Type.INT16, "The current epoch associated with the producer id."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }
}

