/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesqueesque.common.message;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafkaesqueesqueesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesqueesqueesque.common.protocol.ApiMessage;
import org.apache.kafkaesqueesqueesque.common.protocol.ObjectSerializationCache;
import org.apache.kafkaesqueesqueesque.common.protocol.Readable;
import org.apache.kafkaesqueesqueesque.common.protocol.Writable;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Field;
import org.apache.kafkaesqueesqueesque.common.protocol.types.RawTaggedField;
import org.apache.kafkaesqueesqueesque.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Schema;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Struct;
import org.apache.kafkaesqueesqueesque.common.protocol.types.Type;
import org.apache.kafkaesqueesqueesque.common.utils.ByteUtils;

public class HeartbeatResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema[] SCHEMAS;

    public HeartbeatResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public HeartbeatResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public HeartbeatResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
    }

    @Override
    public short apiKey() {
        return 12;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 4;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _version >= 1 ? _readable.readInt() : 0;
        this.errorCode = _readable.readShort();
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeInt(this.throttleTimeMs);
        }
        _writable.writeShort(this.errorCode);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = _version >= 1 ? struct.getInt("throttle_time_ms") : 0;
        this.errorCode = struct.getShort("error_code");
        if (_version >= 4 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 4) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        struct.set("error_code", (Object)this.errorCode);
        if (_version >= 4) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _size += 4;
        }
        _size += 2;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 4) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HeartbeatResponseData)) {
            return false;
        }
        HeartbeatResponseData other = (HeartbeatResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return this.errorCode == other.errorCode;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        return hashCode;
    }

    public String toString() {
        return "HeartbeatResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public HeartbeatResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public HeartbeatResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error.")));
        SCHEMA_4 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
    }
}

