/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesqueesque.clients.producer.internals;

import java.util.List;
import java.util.Map;
import org.apache.kafkaesqueesqueesque.clients.producer.Partitioner;
import org.apache.kafkaesqueesqueesque.clients.producer.internals.StickyPartitionCache;
import org.apache.kafkaesqueesqueesque.common.Cluster;
import org.apache.kafkaesqueesqueesque.common.PartitionInfo;
import org.apache.kafkaesqueesqueesque.common.utils.Utils;

public class DefaultPartitioner
implements Partitioner {
    private final StickyPartitionCache stickyPartitionCache = new StickyPartitionCache();

    @Override
    public void configure(Map<String, ?> configs) {
    }

    @Override
    public int partition(String topic, Object key, byte[] keyBytes, Object value, byte[] valueBytes, Cluster cluster) {
        if (keyBytes == null) {
            return this.stickyPartitionCache.partition(topic, cluster);
        }
        List<PartitionInfo> partitions = cluster.partitionsForTopic(topic);
        int numPartitions = partitions.size();
        return Utils.toPositive(Utils.murmur2(keyBytes)) % numPartitions;
    }

    @Override
    public void close() {
    }

    @Override
    public void onNewBatch(String topic, Cluster cluster, int prevPartition) {
        this.stickyPartitionCache.nextPartition(topic, cluster, prevPartition);
    }
}

