/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesqueesque.clients.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafkaesqueesqueesque.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafkaesqueesqueesque.clients.consumer.internals.AbstractStickyAssignor;
import org.apache.kafkaesqueesqueesque.common.TopicPartition;

public class CooperativeStickyAssignor
extends AbstractStickyAssignor {
    @Override
    public String name() {
        return "cooperative-sticky";
    }

    @Override
    public List<ConsumerPartitionAssignor.RebalanceProtocol> supportedProtocols() {
        return Arrays.asList(ConsumerPartitionAssignor.RebalanceProtocol.COOPERATIVE, ConsumerPartitionAssignor.RebalanceProtocol.EAGER);
    }

    @Override
    protected AbstractStickyAssignor.MemberData memberData(ConsumerPartitionAssignor.Subscription subscription) {
        return new AbstractStickyAssignor.MemberData(subscription.ownedPartitions(), Optional.empty());
    }

    @Override
    public Map<String, List<TopicPartition>> assign(Map<String, Integer> partitionsPerTopic, Map<String, ConsumerPartitionAssignor.Subscription> subscriptions) {
        Map<String, List<TopicPartition>> assignments = super.assign(partitionsPerTopic, subscriptions);
        this.adjustAssignment(subscriptions, assignments);
        return assignments;
    }

    private void adjustAssignment(Map<String, ConsumerPartitionAssignor.Subscription> subscriptions, Map<String, List<TopicPartition>> assignments) {
        HashMap<TopicPartition, String> allAddedPartitions = new HashMap<TopicPartition, String>();
        HashSet<TopicPartition> allRevokedPartitions = new HashSet<TopicPartition>();
        for (Map.Entry<String, List<TopicPartition>> entry : assignments.entrySet()) {
            String consumer = entry.getKey();
            List<TopicPartition> ownedPartitions = subscriptions.get(consumer).ownedPartitions();
            List<TopicPartition> assignedPartitions = entry.getValue();
            ArrayList<TopicPartition> addedPartitions = new ArrayList<TopicPartition>(assignedPartitions);
            addedPartitions.removeAll(ownedPartitions);
            for (TopicPartition tp : addedPartitions) {
                allAddedPartitions.put(tp, consumer);
            }
            HashSet<TopicPartition> revokedPartitions = new HashSet<TopicPartition>(ownedPartitions);
            revokedPartitions.removeAll(assignedPartitions);
            allRevokedPartitions.addAll(revokedPartitions);
        }
        for (TopicPartition tp : allRevokedPartitions) {
            if (!allAddedPartitions.containsKey(tp)) continue;
            String assignedConsumer = (String)allAddedPartitions.get(tp);
            assignments.get(assignedConsumer).remove(tp);
        }
    }
}

