/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesqueesque.clients.admin;

import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.kafkaesqueesqueesque.clients.admin.AdminClientConfig;
import org.apache.kafkaesqueesqueesque.clients.admin.AlterConfigOp;
import org.apache.kafkaesqueesqueesque.clients.admin.AlterConfigsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.AlterConfigsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.AlterPartitionReassignmentsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.Config;
import org.apache.kafkaesqueesqueesque.clients.admin.CreateAclsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.CreateAclsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.CreateDelegationTokenResult;
import org.apache.kafkaesqueesqueesque.clients.admin.CreatePartitionsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.CreatePartitionsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.CreateTopicsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.CreateTopicsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.DeleteAclsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.DeleteAclsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.DeleteConsumerGroupOffsetsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.DeleteConsumerGroupsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.DeleteRecordsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.DeleteRecordsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.DeleteTopicsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.DeleteTopicsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeAclsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeAclsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeClusterOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeClusterResult;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeConfigsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeConfigsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeLogDirsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeLogDirsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeReplicaLogDirsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeTopicsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.DescribeTopicsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.ElectLeadersOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.ElectLeadersResult;
import org.apache.kafkaesqueesqueesque.clients.admin.ElectPreferredLeadersOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.ElectPreferredLeadersResult;
import org.apache.kafkaesqueesqueesque.clients.admin.ExpireDelegationTokenOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafkaesqueesqueesque.clients.admin.KafkaAdminClient;
import org.apache.kafkaesqueesqueesque.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.ListConsumerGroupsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.ListOffsetsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.ListOffsetsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.ListPartitionReassignmentsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.ListTopicsOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.ListTopicsResult;
import org.apache.kafkaesqueesqueesque.clients.admin.NewPartitionReassignment;
import org.apache.kafkaesqueesqueesque.clients.admin.NewPartitions;
import org.apache.kafkaesqueesqueesque.clients.admin.NewTopic;
import org.apache.kafkaesqueesqueesque.clients.admin.OffsetSpec;
import org.apache.kafkaesqueesqueesque.clients.admin.RecordsToDelete;
import org.apache.kafkaesqueesqueesque.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafkaesqueesqueesque.clients.admin.RenewDelegationTokenOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.RenewDelegationTokenResult;
import org.apache.kafkaesqueesqueesque.clients.consumer.OffsetAndMetadata;
import org.apache.kafkaesqueesqueesque.common.ElectionType;
import org.apache.kafkaesqueesqueesque.common.Metric;
import org.apache.kafkaesqueesqueesque.common.MetricName;
import org.apache.kafkaesqueesqueesque.common.TopicPartition;
import org.apache.kafkaesqueesqueesque.common.TopicPartitionReplica;
import org.apache.kafkaesqueesqueesque.common.acl.AclBinding;
import org.apache.kafkaesqueesqueesque.common.acl.AclBindingFilter;
import org.apache.kafkaesqueesqueesque.common.annotation.InterfaceStability;
import org.apache.kafkaesqueesqueesque.common.config.ConfigResource;

@InterfaceStability.Evolving
public interface Admin
extends AutoCloseable {
    public static Admin create(Properties props) {
        return KafkaAdminClient.createInternal(new AdminClientConfig(props, true), null);
    }

    public static Admin create(Map<String, Object> conf) {
        return KafkaAdminClient.createInternal(new AdminClientConfig(conf, true), null);
    }

    @Override
    default public void close() {
        this.close(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    default public void close(long duration, TimeUnit unit) {
        this.close(Duration.ofMillis(unit.toMillis(duration)));
    }

    public void close(Duration var1);

    default public CreateTopicsResult createTopics(Collection<NewTopic> newTopics) {
        return this.createTopics(newTopics, new CreateTopicsOptions());
    }

    public CreateTopicsResult createTopics(Collection<NewTopic> var1, CreateTopicsOptions var2);

    default public DeleteTopicsResult deleteTopics(Collection<String> topics) {
        return this.deleteTopics(topics, new DeleteTopicsOptions());
    }

    public DeleteTopicsResult deleteTopics(Collection<String> var1, DeleteTopicsOptions var2);

    default public ListTopicsResult listTopics() {
        return this.listTopics(new ListTopicsOptions());
    }

    public ListTopicsResult listTopics(ListTopicsOptions var1);

    default public DescribeTopicsResult describeTopics(Collection<String> topicNames) {
        return this.describeTopics(topicNames, new DescribeTopicsOptions());
    }

    public DescribeTopicsResult describeTopics(Collection<String> var1, DescribeTopicsOptions var2);

    default public DescribeClusterResult describeCluster() {
        return this.describeCluster(new DescribeClusterOptions());
    }

    public DescribeClusterResult describeCluster(DescribeClusterOptions var1);

    default public DescribeAclsResult describeAcls(AclBindingFilter filter) {
        return this.describeAcls(filter, new DescribeAclsOptions());
    }

    public DescribeAclsResult describeAcls(AclBindingFilter var1, DescribeAclsOptions var2);

    default public CreateAclsResult createAcls(Collection<AclBinding> acls) {
        return this.createAcls(acls, new CreateAclsOptions());
    }

    public CreateAclsResult createAcls(Collection<AclBinding> var1, CreateAclsOptions var2);

    default public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> filters) {
        return this.deleteAcls(filters, new DeleteAclsOptions());
    }

    public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> var1, DeleteAclsOptions var2);

    default public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources) {
        return this.describeConfigs(resources, new DescribeConfigsOptions());
    }

    public DescribeConfigsResult describeConfigs(Collection<ConfigResource> var1, DescribeConfigsOptions var2);

    @Deprecated
    default public AlterConfigsResult alterConfigs(Map<ConfigResource, Config> configs) {
        return this.alterConfigs(configs, new AlterConfigsOptions());
    }

    @Deprecated
    public AlterConfigsResult alterConfigs(Map<ConfigResource, Config> var1, AlterConfigsOptions var2);

    default public AlterConfigsResult incrementalAlterConfigs(Map<ConfigResource, Collection<AlterConfigOp>> configs) {
        return this.incrementalAlterConfigs(configs, new AlterConfigsOptions());
    }

    public AlterConfigsResult incrementalAlterConfigs(Map<ConfigResource, Collection<AlterConfigOp>> var1, AlterConfigsOptions var2);

    default public AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> replicaAssignment) {
        return this.alterReplicaLogDirs(replicaAssignment, new AlterReplicaLogDirsOptions());
    }

    public AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> var1, AlterReplicaLogDirsOptions var2);

    default public DescribeLogDirsResult describeLogDirs(Collection<Integer> brokers) {
        return this.describeLogDirs(brokers, new DescribeLogDirsOptions());
    }

    public DescribeLogDirsResult describeLogDirs(Collection<Integer> var1, DescribeLogDirsOptions var2);

    default public DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> replicas) {
        return this.describeReplicaLogDirs(replicas, new DescribeReplicaLogDirsOptions());
    }

    public DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> var1, DescribeReplicaLogDirsOptions var2);

    default public CreatePartitionsResult createPartitions(Map<String, NewPartitions> newPartitions) {
        return this.createPartitions(newPartitions, new CreatePartitionsOptions());
    }

    public CreatePartitionsResult createPartitions(Map<String, NewPartitions> var1, CreatePartitionsOptions var2);

    default public DeleteRecordsResult deleteRecords(Map<TopicPartition, RecordsToDelete> recordsToDelete) {
        return this.deleteRecords(recordsToDelete, new DeleteRecordsOptions());
    }

    public DeleteRecordsResult deleteRecords(Map<TopicPartition, RecordsToDelete> var1, DeleteRecordsOptions var2);

    default public CreateDelegationTokenResult createDelegationToken() {
        return this.createDelegationToken(new CreateDelegationTokenOptions());
    }

    public CreateDelegationTokenResult createDelegationToken(CreateDelegationTokenOptions var1);

    default public RenewDelegationTokenResult renewDelegationToken(byte[] hmac) {
        return this.renewDelegationToken(hmac, new RenewDelegationTokenOptions());
    }

    public RenewDelegationTokenResult renewDelegationToken(byte[] var1, RenewDelegationTokenOptions var2);

    default public ExpireDelegationTokenResult expireDelegationToken(byte[] hmac) {
        return this.expireDelegationToken(hmac, new ExpireDelegationTokenOptions());
    }

    public ExpireDelegationTokenResult expireDelegationToken(byte[] var1, ExpireDelegationTokenOptions var2);

    default public DescribeDelegationTokenResult describeDelegationToken() {
        return this.describeDelegationToken(new DescribeDelegationTokenOptions());
    }

    public DescribeDelegationTokenResult describeDelegationToken(DescribeDelegationTokenOptions var1);

    public DescribeConsumerGroupsResult describeConsumerGroups(Collection<String> var1, DescribeConsumerGroupsOptions var2);

    default public DescribeConsumerGroupsResult describeConsumerGroups(Collection<String> groupIds) {
        return this.describeConsumerGroups(groupIds, new DescribeConsumerGroupsOptions());
    }

    public ListConsumerGroupsResult listConsumerGroups(ListConsumerGroupsOptions var1);

    default public ListConsumerGroupsResult listConsumerGroups() {
        return this.listConsumerGroups(new ListConsumerGroupsOptions());
    }

    public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(String var1, ListConsumerGroupOffsetsOptions var2);

    default public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(String groupId) {
        return this.listConsumerGroupOffsets(groupId, new ListConsumerGroupOffsetsOptions());
    }

    public DeleteConsumerGroupsResult deleteConsumerGroups(Collection<String> var1, DeleteConsumerGroupsOptions var2);

    default public DeleteConsumerGroupsResult deleteConsumerGroups(Collection<String> groupIds) {
        return this.deleteConsumerGroups(groupIds, new DeleteConsumerGroupsOptions());
    }

    public DeleteConsumerGroupOffsetsResult deleteConsumerGroupOffsets(String var1, Set<TopicPartition> var2, DeleteConsumerGroupOffsetsOptions var3);

    default public DeleteConsumerGroupOffsetsResult deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions) {
        return this.deleteConsumerGroupOffsets(groupId, partitions, new DeleteConsumerGroupOffsetsOptions());
    }

    @Deprecated
    default public ElectPreferredLeadersResult electPreferredLeaders(Collection<TopicPartition> partitions) {
        return this.electPreferredLeaders(partitions, new ElectPreferredLeadersOptions());
    }

    @Deprecated
    default public ElectPreferredLeadersResult electPreferredLeaders(Collection<TopicPartition> partitions, ElectPreferredLeadersOptions options) {
        ElectLeadersOptions newOptions = new ElectLeadersOptions();
        newOptions.timeoutMs(options.timeoutMs());
        HashSet<TopicPartition> topicPartitions = partitions == null ? null : new HashSet<TopicPartition>(partitions);
        return new ElectPreferredLeadersResult(this.electLeaders(ElectionType.PREFERRED, topicPartitions, newOptions));
    }

    default public ElectLeadersResult electLeaders(ElectionType electionType, Set<TopicPartition> partitions) {
        return this.electLeaders(electionType, partitions, new ElectLeadersOptions());
    }

    public ElectLeadersResult electLeaders(ElectionType var1, Set<TopicPartition> var2, ElectLeadersOptions var3);

    default public AlterPartitionReassignmentsResult alterPartitionReassignments(Map<TopicPartition, Optional<NewPartitionReassignment>> reassignments) {
        return this.alterPartitionReassignments(reassignments, new AlterPartitionReassignmentsOptions());
    }

    public AlterPartitionReassignmentsResult alterPartitionReassignments(Map<TopicPartition, Optional<NewPartitionReassignment>> var1, AlterPartitionReassignmentsOptions var2);

    default public ListPartitionReassignmentsResult listPartitionReassignments() {
        return this.listPartitionReassignments(new ListPartitionReassignmentsOptions());
    }

    default public ListPartitionReassignmentsResult listPartitionReassignments(Set<TopicPartition> partitions) {
        return this.listPartitionReassignments(partitions, new ListPartitionReassignmentsOptions());
    }

    default public ListPartitionReassignmentsResult listPartitionReassignments(Set<TopicPartition> partitions, ListPartitionReassignmentsOptions options) {
        return this.listPartitionReassignments(Optional.of(partitions), options);
    }

    default public ListPartitionReassignmentsResult listPartitionReassignments(ListPartitionReassignmentsOptions options) {
        return this.listPartitionReassignments(Optional.empty(), options);
    }

    public ListPartitionReassignmentsResult listPartitionReassignments(Optional<Set<TopicPartition>> var1, ListPartitionReassignmentsOptions var2);

    public RemoveMembersFromConsumerGroupResult removeMembersFromConsumerGroup(String var1, RemoveMembersFromConsumerGroupOptions var2);

    default public AlterConsumerGroupOffsetsResult alterConsumerGroupOffsets(String groupId, Map<TopicPartition, OffsetAndMetadata> offsets) {
        return this.alterConsumerGroupOffsets(groupId, offsets, new AlterConsumerGroupOffsetsOptions());
    }

    public AlterConsumerGroupOffsetsResult alterConsumerGroupOffsets(String var1, Map<TopicPartition, OffsetAndMetadata> var2, AlterConsumerGroupOffsetsOptions var3);

    default public ListOffsetsResult listOffsets(Map<TopicPartition, OffsetSpec> topicPartitionOffsets) {
        return this.listOffsets(topicPartitionOffsets, new ListOffsetsOptions());
    }

    public ListOffsetsResult listOffsets(Map<TopicPartition, OffsetSpec> var1, ListOffsetsOptions var2);

    public Map<MetricName, ? extends Metric> metrics();
}

