/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.common.requests;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.kafkaesqueesque.common.protocol.types.Field;
import org.apache.kafkaesqueesque.common.protocol.types.Struct;

public final class RequestUtils {
    private RequestUtils() {
    }

    static void setLeaderEpochIfExists(Struct struct, Field.Int32 leaderEpochField, Optional<Integer> leaderEpoch) {
        struct.setIfExists(leaderEpochField, (Object)leaderEpoch.orElse(-1));
    }

    static Optional<Integer> getLeaderEpoch(Struct struct, Field.Int32 leaderEpochField) {
        int leaderEpoch = struct.getOrElse(leaderEpochField, -1);
        return RequestUtils.getLeaderEpoch(leaderEpoch);
    }

    static Optional<Integer> getLeaderEpoch(int leaderEpoch) {
        return leaderEpoch == -1 ? Optional.empty() : Optional.of(leaderEpoch);
    }

    public static ByteBuffer serialize(Struct headerStruct, Struct bodyStruct) {
        ByteBuffer buffer = ByteBuffer.allocate(headerStruct.sizeOf() + bodyStruct.sizeOf());
        headerStruct.writeTo(buffer);
        bodyStruct.writeTo(buffer);
        buffer.rewind();
        return buffer;
    }
}

