/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.kafka.KafkaTableProperties;
import org.apache.hadoop.hive.kafka.KafkaUtils;
import org.apache.hadoop.hive.ql.exec.tez.DagCredentialSupplier;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.kafkaesqueesqueesque.clients.admin.AdminClient;
import org.apache.kafkaesqueesqueesque.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafkaesqueesqueesque.clients.admin.CreateDelegationTokenResult;
import org.apache.kafkaesqueesqueesque.common.security.auth.SecurityProtocol;
import org.apache.kafkaesqueesqueesque.common.security.token.delegation.DelegationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaDagCredentialSupplier
implements DagCredentialSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaDagCredentialSupplier.class);

    public Token<?> obtainToken(BaseWork work, Set<TableDesc> fileSinkTableDescs, Configuration conf) {
        TableDesc tableDesc;
        if (!(work instanceof MapWork)) {
            return null;
        }
        Map partitions = ((MapWork)work).getAliasToPartnInfo();
        PartitionDesc partition = partitions.values().stream().findFirst().orElse(null);
        if (partition != null && this.isTokenRequired(tableDesc = partition.getTableDesc())) {
            return this.getKafkaDelegationTokenForBrokers(conf, tableDesc);
        }
        for (TableDesc tableDesc2 : fileSinkTableDescs) {
            if (!this.isTokenRequired(tableDesc2)) continue;
            return this.getKafkaDelegationTokenForBrokers(conf, tableDesc2);
        }
        return null;
    }

    public Text getTokenAlias() {
        return KafkaUtils.KAFKA_DELEGATION_TOKEN_KEY;
    }

    private boolean isTokenRequired(TableDesc tableDesc) {
        String kafkaBrokers = tableDesc.getProperties().getProperty(KafkaTableProperties.HIVE_KAFKA_BOOTSTRAP_SERVERS.getName());
        SecurityProtocol protocol = KafkaUtils.securityProtocol(tableDesc.getProperties());
        return !StringUtils.isEmpty((CharSequence)kafkaBrokers) && SecurityProtocol.PLAINTEXT != protocol;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Token<?> getKafkaDelegationTokenForBrokers(Configuration conf, TableDesc tableDesc) {
        Properties tableProperties = tableDesc.getProperties();
        String kafkaBrokers = (String)tableProperties.get(KafkaTableProperties.HIVE_KAFKA_BOOTSTRAP_SERVERS.getName());
        LOG.info("Getting kafka credentials for brokers: {}", (Object)kafkaBrokers);
        String keytab = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
        String principal = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
        try {
            principal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Properties config = new Properties();
        config.put("bootstrap.servers", kafkaBrokers);
        SecurityProtocol protocol = KafkaUtils.securityProtocol(tableProperties);
        if (protocol == null) {
            protocol = SecurityProtocol.SASL_PLAINTEXT;
            LOG.warn("Kafka security.protocol is undefined in table properties. Using default {}", (Object)protocol.name);
        }
        config.put("security.protocol", protocol.name);
        String jaasConfig = String.format("%s %s %s %s serviceName=\"%s\" keyTab=\"%s\" principal=\"%s\";", "com.sun.security.auth.module.Krb5LoginModule required", "debug=true", "useKeyTab=true", "storeKey=true", "kafka", keytab, principal);
        config.put("sasl.jaas.config", jaasConfig);
        LOG.debug("Jaas config for requesting kafka credentials: {}", (Object)jaasConfig);
        Configuration confCopy = new Configuration(conf);
        tableProperties.stringPropertyNames().forEach(key -> confCopy.set(key, tableProperties.getProperty((String)key)));
        KafkaUtils.setupKafkaSslProperties(confCopy, config);
        CreateDelegationTokenOptions createDelegationTokenOptions = new CreateDelegationTokenOptions();
        try (AdminClient admin = AdminClient.create(config);){
            CreateDelegationTokenResult createResult = admin.createDelegationToken(createDelegationTokenOptions);
            DelegationToken token = createResult.delegationToken().get();
            LOG.info("Got kafka delegation token: {}", (Object)token);
            Token token2 = new Token(token.tokenInfo().tokenId().getBytes(), token.hmac(), null, new Text("kafka"));
            return token2;
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Exception while getting Kafka token", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while getting Kafka token", e);
        }
    }
}

