/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafkaesqueesque.common.message.CreatePartitionsRequestData;
import org.apache.kafkaesqueesque.common.message.CreatePartitionsResponseData;
import org.apache.kafkaesqueesque.common.protocol.ApiKeys;
import org.apache.kafkaesqueesque.common.protocol.types.Struct;
import org.apache.kafkaesqueesque.common.requests.AbstractRequest;
import org.apache.kafkaesqueesque.common.requests.AbstractResponse;
import org.apache.kafkaesqueesque.common.requests.ApiError;
import org.apache.kafkaesqueesque.common.requests.CreatePartitionsResponse;

public class CreatePartitionsRequest
extends AbstractRequest {
    private final CreatePartitionsRequestData data;

    CreatePartitionsRequest(CreatePartitionsRequestData data, short apiVersion) {
        super(ApiKeys.CREATE_PARTITIONS, apiVersion);
        this.data = data;
    }

    public CreatePartitionsRequest(Struct struct, short apiVersion) {
        this(new CreatePartitionsRequestData(struct, apiVersion), apiVersion);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public CreatePartitionsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        CreatePartitionsResponseData response = new CreatePartitionsResponseData();
        response.setThrottleTimeMs(throttleTimeMs);
        ApiError apiError = ApiError.fromThrowable(e);
        for (CreatePartitionsRequestData.CreatePartitionsTopic topic : this.data.topics()) {
            response.results().add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topic.name()).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
        }
        return new CreatePartitionsResponse(response);
    }

    public static CreatePartitionsRequest parse(ByteBuffer buffer, short version) {
        return new CreatePartitionsRequest(ApiKeys.CREATE_PARTITIONS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<CreatePartitionsRequest> {
        private final CreatePartitionsRequestData data;

        public Builder(CreatePartitionsRequestData data) {
            super(ApiKeys.CREATE_PARTITIONS);
            this.data = data;
        }

        @Override
        public CreatePartitionsRequest build(short version) {
            return new CreatePartitionsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

