/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.kafkaesqueesque.common.acl.AccessControlEntry;
import org.apache.kafkaesqueesque.common.acl.AclBinding;
import org.apache.kafkaesqueesque.common.acl.AclOperation;
import org.apache.kafkaesqueesque.common.acl.AclPermissionType;
import org.apache.kafkaesqueesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesqueesque.common.message.CreateAclsRequestData;
import org.apache.kafkaesqueesque.common.message.CreateAclsResponseData;
import org.apache.kafkaesqueesque.common.protocol.ApiKeys;
import org.apache.kafkaesqueesque.common.protocol.types.Struct;
import org.apache.kafkaesqueesque.common.requests.AbstractRequest;
import org.apache.kafkaesqueesque.common.requests.AbstractResponse;
import org.apache.kafkaesqueesque.common.requests.ApiError;
import org.apache.kafkaesqueesque.common.requests.CreateAclsResponse;
import org.apache.kafkaesqueesque.common.resource.PatternType;
import org.apache.kafkaesqueesque.common.resource.ResourcePattern;
import org.apache.kafkaesqueesque.common.resource.ResourceType;

public class CreateAclsRequest
extends AbstractRequest {
    private final CreateAclsRequestData data;

    CreateAclsRequest(short version, CreateAclsRequestData data) {
        super(ApiKeys.CREATE_ACLS, version);
        this.validate(data);
        this.data = data;
    }

    public CreateAclsRequest(Struct struct, short version) {
        this(version, new CreateAclsRequestData(struct, version));
    }

    public List<CreateAclsRequestData.AclCreation> aclCreations() {
        return this.data.creations();
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable throwable) {
        CreateAclsResponseData.AclCreationResult result = CreateAclsRequest.aclResult(throwable);
        List<CreateAclsResponseData.AclCreationResult> results = Collections.nCopies(this.data.creations().size(), result);
        return new CreateAclsResponse(new CreateAclsResponseData().setThrottleTimeMs(throttleTimeMs).setResults(results));
    }

    public static CreateAclsRequest parse(ByteBuffer buffer, short version) {
        return new CreateAclsRequest(ApiKeys.CREATE_ACLS.parseRequest(version, buffer), version);
    }

    private void validate(CreateAclsRequestData data) {
        boolean unsupported;
        if (this.version() == 0 && (unsupported = data.creations().stream().anyMatch(creation -> creation.resourcePatternType() != PatternType.LITERAL.code()))) {
            throw new UnsupportedVersionException("Version 0 only supports literal resource pattern types");
        }
        boolean unknown = data.creations().stream().anyMatch(creation -> creation.resourcePatternType() == PatternType.UNKNOWN.code() || creation.resourceType() == ResourceType.UNKNOWN.code() || creation.permissionType() == AclPermissionType.UNKNOWN.code() || creation.operation() == AclOperation.UNKNOWN.code());
        if (unknown) {
            throw new IllegalArgumentException("CreatableAcls contain unknown elements: " + data.creations());
        }
    }

    public static AclBinding aclBinding(CreateAclsRequestData.AclCreation acl) {
        ResourcePattern pattern = new ResourcePattern(ResourceType.fromCode(acl.resourceType()), acl.resourceName(), PatternType.fromCode(acl.resourcePatternType()));
        AccessControlEntry entry = new AccessControlEntry(acl.principal(), acl.host(), AclOperation.fromCode(acl.operation()), AclPermissionType.fromCode(acl.permissionType()));
        return new AclBinding(pattern, entry);
    }

    public static CreateAclsRequestData.AclCreation aclCreation(AclBinding binding) {
        return new CreateAclsRequestData.AclCreation().setHost(binding.entry().host()).setOperation(binding.entry().operation().code()).setPermissionType(binding.entry().permissionType().code()).setPrincipal(binding.entry().principal()).setResourceName(binding.pattern().name()).setResourceType(binding.pattern().resourceType().code()).setResourcePatternType(binding.pattern().patternType().code());
    }

    private static CreateAclsResponseData.AclCreationResult aclResult(Throwable throwable) {
        ApiError apiError = ApiError.fromThrowable(throwable);
        return new CreateAclsResponseData.AclCreationResult().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message());
    }

    public static class Builder
    extends AbstractRequest.Builder<CreateAclsRequest> {
        private final CreateAclsRequestData data;

        public Builder(CreateAclsRequestData data) {
            super(ApiKeys.CREATE_ACLS);
            this.data = data;
        }

        @Override
        public CreateAclsRequest build(short version) {
            return new CreateAclsRequest(version, this.data);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

