/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.kafka.KafkaTableProperties;
import org.apache.hadoop.hive.kafka.KafkaUtils;
import org.apache.hadoop.hive.kafka.KafkaWritable;
import org.apache.hadoop.hive.kafka.SimpleKafkaWriter;
import org.apache.hadoop.hive.kafka.TransactionalKafkaWriter;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaOutputFormat
implements HiveOutputFormat<NullWritable, KafkaWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaOutputFormat.class);

    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) {
        Object recordWriter;
        String topic = jc.get(KafkaTableProperties.HIVE_KAFKA_TOPIC.getName());
        Boolean optimisticCommit = jc.getBoolean(KafkaTableProperties.HIVE_KAFKA_OPTIMISTIC_COMMIT.getName(), false);
        WriteSemantic writeSemantic = WriteSemantic.valueOf(jc.get(KafkaTableProperties.WRITE_SEMANTIC_PROPERTY.getName()));
        Properties producerProperties = KafkaUtils.producerProperties((Configuration)jc);
        switch (writeSemantic) {
            case AT_LEAST_ONCE: {
                recordWriter = new SimpleKafkaWriter(topic, Utilities.getTaskId((Configuration)jc), producerProperties);
                break;
            }
            case EXACTLY_ONCE: {
                FileSystem fs;
                try {
                    fs = finalOutPath.getFileSystem((Configuration)jc);
                }
                catch (IOException e) {
                    LOG.error("Can not construct file system instance", (Throwable)e);
                    throw new RuntimeException(e);
                }
                String queryId = (String)Preconditions.checkNotNull((Object)jc.get(HiveConf.ConfVars.HIVEQUERYID.varname, null));
                recordWriter = new TransactionalKafkaWriter(topic, producerProperties, new Path((Path)Preconditions.checkNotNull((Object)finalOutPath), queryId), fs, optimisticCommit);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown delivery semantic [%s]", writeSemantic.toString()));
            }
        }
        return recordWriter;
    }

    public RecordWriter<NullWritable, KafkaWritable> getRecordWriter(FileSystem fileSystem, JobConf jobConf, String s, Progressable progressable) {
        throw new RuntimeException("this is not suppose to be here");
    }

    public void checkOutputSpecs(FileSystem fileSystem, JobConf jobConf) {
    }

    static enum WriteSemantic {
        AT_LEAST_ONCE,
        EXACTLY_ONCE;

    }
}

