/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.ColumnType;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionListComposingSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpecWithSharedSD;
import org.apache.hadoop.hive.metastore.api.PartitionWithoutSD;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.api.WMPoolSchedulingPolicy;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregatorFactory;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMergerFactory;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.MetastoreException;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.util.MachineList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreUtils {
    private static final DateTimeFormatter DATE_FORMATTER = MetaStoreUtils.createDateTimeFormatter("uuuu-MM-dd");
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = MetaStoreUtils.createDateTimeFormatter("uuuu-MM-dd HH:mm:ss");
    public static final String TYPE_FROM_DESERIALIZER = "<derived from deserializer>";
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreUtils.class);
    public static final char CATALOG_DB_THRIFT_NAME_MARKER = '@';
    private static final char DOT = '.';
    public static final String CATALOG_DB_SEPARATOR = "#";
    public static final String DB_EMPTY_MARKER = "!";
    public static final String EXTERNAL_TABLE_PURGE = "external.table.purge";
    private static final char[] SPECIAL_CHARACTERS_IN_TABLE_NAMES = new char[]{' ', '\"', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '[', ']', '_', '|', '{', '}', '$', '^', '!', '~', '#', '@', '`'};
    public static final String NO_VAL = " --- ";
    public static final String USER_NAME_HTTP_HEADER = "x-actor-username";
    private static final Function<String, String> transFormNullsToEmptyString = new Function<String, String>(){

        public String apply(@Nullable String string) {
            return org.apache.commons.lang.StringUtils.defaultString((String)string);
        }
    };
    private static String ARCHIVING_LEVEL = "archiving_level";
    private static final String[] nullCatalogAndDatabase = new String[]{null, null};
    public static final int CAT_NAME = 0;
    public static final int DB_NAME = 1;

    private static DateTimeFormatter createDateTimeFormatter(String format) {
        return DateTimeFormatter.ofPattern(format).withZone(TimeZone.getTimeZone("UTC").toZoneId()).withResolverStyle(ResolverStyle.STRICT);
    }

    public static String convertDateToString(Date date) {
        return DATE_FORMATTER.format(date.toLocalDate());
    }

    public static Date convertStringToDate(String date) {
        LocalDate val = LocalDate.parse(date, DATE_FORMATTER);
        return Date.valueOf(val);
    }

    public static String normalizeDate(String date) {
        return MetaStoreUtils.convertDateToString(MetaStoreUtils.convertStringToDate(date));
    }

    public static String convertTimestampToString(Timestamp timestamp) {
        return TIMESTAMP_FORMATTER.format(timestamp.toLocalDateTime());
    }

    public static Timestamp convertStringToTimestamp(String timestamp) {
        LocalDateTime val = LocalDateTime.from(TIMESTAMP_FORMATTER.parse(timestamp));
        return Timestamp.valueOf(val);
    }

    public static void logAndThrowMetaException(Exception e) throws MetaException {
        String exInfo = "Got exception: " + e.getClass().getName() + " " + e.getMessage();
        LOG.error(exInfo, (Throwable)e);
        LOG.error("Converting exception to MetaException");
        throw new MetaException(exInfo);
    }

    public static void throwMetaException(Exception e) throws MetaException {
        throw new MetaException("Got exception: " + e.getClass().getName() + " " + e.getMessage());
    }

    public static String encodeTableName(String name) {
        StringBuilder sb = new StringBuilder();
        for (char ch : name.toCharArray()) {
            if (Character.isLetterOrDigit(ch) || ch == '_') {
                sb.append(ch);
                continue;
            }
            sb.append('-').append((int)ch).append('-');
        }
        return sb.toString();
    }

    public static MetaException newMetaException(Exception e) {
        return MetaStoreUtils.newMetaException(e != null ? e.getMessage() : null, e);
    }

    public static MetaException newMetaException(String errorMessage, Exception e) {
        MetaException metaException = new MetaException(errorMessage);
        if (e != null) {
            metaException.initCause(e);
        }
        return metaException;
    }

    public static Map<String, String> trimMapNulls(Map<String, String> dnMap, boolean retrieveMapNullsAsEmptyStrings) {
        if (dnMap == null) {
            return null;
        }
        if (retrieveMapNullsAsEmptyStrings) {
            return Maps.newLinkedHashMap((Map)Maps.transformValues(dnMap, transFormNullsToEmptyString));
        }
        return Maps.newLinkedHashMap((Map)Maps.filterValues(dnMap, (com.google.common.base.Predicate)Predicates.notNull()));
    }

    public static List<ColumnStatisticsObj> aggrPartitionStats(List<ColumnStatistics> partStats, String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, boolean areAllPartsFound, boolean useDensityFunctionForNDVEstimation, double ndvTuner) throws MetaException {
        HashMap<ColumnStatsAggregator, List<ColStatsObjWithSourceInfo>> colStatsMap = new HashMap<ColumnStatsAggregator, List<ColStatsObjWithSourceInfo>>();
        HashMap<String, ColumnStatsAggregator> aliasToAggregator = new HashMap<String, ColumnStatsAggregator>();
        for (ColumnStatistics css : partStats) {
            List<ColumnStatisticsObj> objs = css.getStatsObj();
            for (ColumnStatisticsObj obj : objs) {
                String partName = css.getStatsDesc().getPartName();
                if (aliasToAggregator.get(obj.getColName()) == null) {
                    aliasToAggregator.put(obj.getColName(), ColumnStatsAggregatorFactory.getColumnStatsAggregator((ColumnStatisticsData._Fields)obj.getStatsData().getSetField(), useDensityFunctionForNDVEstimation, ndvTuner));
                    colStatsMap.put((ColumnStatsAggregator)aliasToAggregator.get(obj.getColName()), new ArrayList());
                }
                ((List)colStatsMap.get(aliasToAggregator.get(obj.getColName()))).add(new ColStatsObjWithSourceInfo(obj, catName, dbName, tableName, partName));
            }
        }
        if (colStatsMap.size() < 1) {
            LOG.debug("No stats data found for: tblName= {}, partNames= {}, colNames= {}", new Object[]{TableName.getQualified((String)catName, (String)dbName, (String)tableName), partNames, colNames});
            return new ArrayList<ColumnStatisticsObj>();
        }
        return MetaStoreUtils.aggrPartitionStats(colStatsMap, partNames, areAllPartsFound, useDensityFunctionForNDVEstimation, ndvTuner);
    }

    public static List<ColumnStatisticsObj> aggrPartitionStats(Map<ColumnStatsAggregator, List<ColStatsObjWithSourceInfo>> colStatsMap, final List<String> partNames, final boolean areAllPartsFound, boolean useDensityFunctionForNDVEstimation, double ndvTuner) throws MetaException {
        ArrayList<ColumnStatisticsObj> aggrColStatObjs = new ArrayList<ColumnStatisticsObj>();
        int numProcessors = Runtime.getRuntime().availableProcessors();
        ExecutorService pool = Executors.newFixedThreadPool(Math.min(colStatsMap.size(), numProcessors), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("aggr-col-stats-%d").build());
        LinkedList futures = Lists.newLinkedList();
        LOG.debug("Aggregating column stats. Threads used: {}", (Object)Math.min(colStatsMap.size(), numProcessors));
        long start = System.currentTimeMillis();
        for (final Map.Entry<ColumnStatsAggregator, List<ColStatsObjWithSourceInfo>> entry : colStatsMap.entrySet()) {
            futures.add(pool.submit(new Callable<ColumnStatisticsObj>(){

                @Override
                public ColumnStatisticsObj call() throws MetaException {
                    List colStatWithSourceInfo = (List)entry.getValue();
                    ColumnStatsAggregator aggregator = (ColumnStatsAggregator)entry.getKey();
                    try {
                        ColumnStatisticsObj statsObj = aggregator.aggregate(colStatWithSourceInfo, partNames, areAllPartsFound);
                        return statsObj;
                    }
                    catch (MetaException e) {
                        LOG.debug(e.getMessage());
                        throw e;
                    }
                }
            }));
        }
        pool.shutdown();
        if (!futures.isEmpty()) {
            for (Future future : futures) {
                try {
                    if (future.get() == null) continue;
                    aggrColStatObjs.add((ColumnStatisticsObj)future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.debug(e.getMessage());
                    pool.shutdownNow();
                    throw new MetaException(e.toString());
                }
            }
        }
        LOG.debug("Time for aggr col stats in seconds: {} Threads used: {}", (Object)(((double)System.currentTimeMillis() - (double)start) / 1000.0), (Object)Math.min(colStatsMap.size(), numProcessors));
        return aggrColStatObjs;
    }

    public static double decimalToDouble(Decimal decimal) {
        return new BigDecimal(new BigInteger(decimal.getUnscaled()), decimal.getScale()).doubleValue();
    }

    public static void validatePartitionNameCharacters(List<String> partVals, Pattern partitionValidationPattern) throws MetaException {
        String invalidPartitionVal = MetaStoreUtils.getPartitionValWithInvalidCharacter(partVals, partitionValidationPattern);
        if (invalidPartitionVal != null) {
            throw new MetaException("Partition value '" + invalidPartitionVal + "' contains a character not matched by whitelist pattern '" + partitionValidationPattern.toString() + "'.  (configure with " + MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN.getVarname() + ")");
        }
    }

    private static String getPartitionValWithInvalidCharacter(List<String> partVals, Pattern partitionValidationPattern) {
        if (partitionValidationPattern == null) {
            return null;
        }
        for (String partVal : partVals) {
            if (partitionValidationPattern.matcher(partVal).matches()) continue;
            return partVal;
        }
        return null;
    }

    public static synchronized byte[] hashStorageDescriptor(StorageDescriptor sd, MessageDigest md) {
        md.reset();
        if (sd.getCols() != null) {
            for (FieldSchema fs : sd.getCols()) {
                md.update(fs.getName().getBytes(ENCODING));
                md.update(fs.getType().getBytes(ENCODING));
                if (fs.getComment() == null) continue;
                md.update(fs.getComment().getBytes(ENCODING));
            }
        }
        if (sd.getInputFormat() != null) {
            md.update(sd.getInputFormat().getBytes(ENCODING));
        }
        if (sd.getOutputFormat() != null) {
            md.update(sd.getOutputFormat().getBytes(ENCODING));
        }
        md.update(sd.isCompressed() ? "true".getBytes(ENCODING) : "false".getBytes(ENCODING));
        md.update(Integer.toString(sd.getNumBuckets()).getBytes(ENCODING));
        if (sd.getSerdeInfo() != null) {
            SerDeInfo serde = sd.getSerdeInfo();
            if (serde.getName() != null) {
                md.update(serde.getName().getBytes(ENCODING));
            }
            if (serde.getSerializationLib() != null) {
                md.update(serde.getSerializationLib().getBytes(ENCODING));
            }
            if (serde.getParameters() != null) {
                TreeMap<String, String> params = new TreeMap<String, String>(serde.getParameters());
                for (Map.Entry entry : params.entrySet()) {
                    md.update(((String)entry.getKey()).getBytes(ENCODING));
                    md.update(((String)entry.getValue()).getBytes(ENCODING));
                }
            }
        }
        if (sd.getBucketCols() != null) {
            ArrayList<String> bucketCols = new ArrayList<String>(sd.getBucketCols());
            for (String bucket : bucketCols) {
                md.update(bucket.getBytes(ENCODING));
            }
        }
        if (sd.getSortCols() != null) {
            TreeSet<Order> orders = new TreeSet<Order>(sd.getSortCols());
            for (Order order : orders) {
                md.update(order.getCol().getBytes(ENCODING));
                md.update(Integer.toString(order.getOrder()).getBytes(ENCODING));
            }
        }
        if (sd.getSkewedInfo() != null) {
            SkewedInfo skewed = sd.getSkewedInfo();
            if (skewed.getSkewedColNames() != null) {
                TreeSet<String> colnames = new TreeSet<String>(skewed.getSkewedColNames());
                for (String string : colnames) {
                    md.update(string.getBytes(ENCODING));
                }
            }
            if (skewed.getSkewedColValues() != null) {
                TreeSet<String> sortedOuterList = new TreeSet<String>();
                for (List list : skewed.getSkewedColValues()) {
                    TreeSet sortedInnerList = new TreeSet(list);
                    sortedOuterList.add(org.apache.commons.lang.StringUtils.join(sortedInnerList, (String)"."));
                }
                for (String string : sortedOuterList) {
                    md.update(string.getBytes(ENCODING));
                }
            }
            if (skewed.getSkewedColValueLocationMaps() != null) {
                TreeMap sortedMap = new TreeMap();
                for (Map.Entry entry : skewed.getSkewedColValueLocationMaps().entrySet()) {
                    TreeSet sortedKey = new TreeSet((Collection)entry.getKey());
                    sortedMap.put(org.apache.commons.lang.StringUtils.join(sortedKey, (String)"."), entry.getValue());
                }
                for (Map.Entry entry : sortedMap.entrySet()) {
                    md.update(((String)entry.getKey()).getBytes(ENCODING));
                    md.update(((String)entry.getValue()).getBytes(ENCODING));
                }
            }
            md.update(sd.isStoredAsSubDirectories() ? "true".getBytes(ENCODING) : "false".getBytes(ENCODING));
        }
        return md.digest();
    }

    public static List<String> getColumnNamesForTable(Table table) {
        ArrayList<String> colNames = new ArrayList<String>();
        Iterator<FieldSchema> colsIterator = table.getSd().getColsIterator();
        while (colsIterator.hasNext()) {
            colNames.add(colsIterator.next().getName());
        }
        return colNames;
    }

    public static List<String> getColumnNamesForPartition(Partition partition) {
        ArrayList<String> colNames = new ArrayList<String>();
        Iterator<FieldSchema> colsIterator = partition.getSd().getColsIterator();
        while (colsIterator.hasNext()) {
            colNames.add(colsIterator.next().getName());
        }
        return colNames;
    }

    public static boolean validateName(String name, Configuration conf) {
        String allowedSpecialCharacters = "";
        if (conf != null && MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.SUPPORT_SPECICAL_CHARACTERS_IN_TABLE_NAMES)) {
            char[] cArray = SPECIAL_CHARACTERS_IN_TABLE_NAMES;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                allowedSpecialCharacters = allowedSpecialCharacters + c;
            }
        }
        Pattern tpat = Pattern.compile("[\\w" + Pattern.quote(allowedSpecialCharacters) + "]+");
        Matcher m = tpat.matcher(name);
        return m.matches();
    }

    public static boolean validateColumnName(String name) {
        return true;
    }

    public static String validateTblColumns(List<FieldSchema> cols) {
        for (FieldSchema fieldSchema : cols) {
            String typeError = MetaStoreUtils.validateColumnType(fieldSchema.getType());
            if (typeError == null) continue;
            return typeError;
        }
        return null;
    }

    private static String validateColumnType(String type) {
        if (type.equals(TYPE_FROM_DESERIALIZER)) {
            return null;
        }
        int last = 0;
        boolean lastAlphaDigit = MetaStoreUtils.isValidTypeChar(type.charAt(last));
        for (int i = 1; i <= type.length(); ++i) {
            if (i != type.length() && MetaStoreUtils.isValidTypeChar(type.charAt(i)) == lastAlphaDigit) continue;
            String token = type.substring(last, i);
            last = i;
            if (ColumnType.AllTypes.contains(token)) break;
            return "type: " + type;
        }
        return null;
    }

    private static boolean isValidTypeChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public static boolean isExternalTable(Table table) {
        if (table == null) {
            return false;
        }
        Map<String, String> params = table.getParameters();
        if (params == null) {
            return false;
        }
        return MetaStoreUtils.isExternal(params);
    }

    public static boolean isIcebergTable(Map<String, String> params) {
        return "ICEBERG".equalsIgnoreCase(params.get("table_type"));
    }

    public static boolean isTranslatedToExternalTable(Table table) {
        Map<String, String> params = table.getParameters();
        return params != null && MetaStoreUtils.isPropertyTrue(params, "EXTERNAL") && MetaStoreUtils.isPropertyTrue(params, "TRANSLATED_TO_EXTERNAL") && table.getSd() != null && table.getSd().isSetLocation();
    }

    public static String getDbNameFromReplPolicy(String replPolicy) {
        assert (replPolicy != null);
        return replPolicy.split(Pattern.quote("."))[0];
    }

    public static boolean isDbReplIncompatible(Database db) {
        if (db == null) {
            return false;
        }
        Map<String, String> dbParameters = db.getParameters();
        return dbParameters != null && "true".equalsIgnoreCase(dbParameters.get("repl.incompatible"));
    }

    public static boolean isDbBeingFailedOver(Database db) {
        assert (db != null);
        Map<String, String> dbParameters = db.getParameters();
        if (dbParameters == null) {
            return false;
        }
        String dbFailoverEndPoint = dbParameters.get("repl.failover.endpoint");
        return FailoverEndpoint.SOURCE.toString().equalsIgnoreCase(dbFailoverEndPoint) || FailoverEndpoint.TARGET.toString().equalsIgnoreCase(dbFailoverEndPoint);
    }

    public static boolean isDbBeingFailedOverAtEndpoint(Database db, FailoverEndpoint endPoint) {
        if (db == null) {
            return false;
        }
        Map<String, String> dbParameters = db.getParameters();
        return dbParameters != null && endPoint.toString().equalsIgnoreCase(dbParameters.get("repl.failover.endpoint"));
    }

    public static boolean isTargetOfReplication(Database db) {
        assert (db != null);
        Map<String, String> dbParameters = db.getParameters();
        return dbParameters != null && !org.apache.commons.lang.StringUtils.isEmpty((String)dbParameters.get("repl.target.for"));
    }

    public static boolean checkIfDbNeedsToBeSkipped(Database db) {
        assert (db != null);
        if (MetaStoreUtils.isDbBeingFailedOver(db)) {
            LOG.info("Skipping all the tables which belong to database: {} as it is being failed over", (Object)db.getName());
            return true;
        }
        if (MetaStoreUtils.isTargetOfReplication(db)) {
            LOG.info("Skipping all the tables which belong to replicated database: {}", (Object)db.getName());
            return true;
        }
        return false;
    }

    public static boolean isExternalTablePurge(Table table) {
        if (table == null) {
            return false;
        }
        Map<String, String> params = table.getParameters();
        if (params == null) {
            return false;
        }
        return MetaStoreUtils.isPropertyTrue(params, EXTERNAL_TABLE_PURGE);
    }

    public static boolean isExternal(Map<String, String> tableParams) {
        return MetaStoreUtils.isPropertyTrue(tableParams, "EXTERNAL");
    }

    public static boolean isPropertyTrue(Map<String, String> tableParams, String prop) {
        return "TRUE".equalsIgnoreCase(tableParams.get(prop));
    }

    public static boolean requireCalStats(Partition oldPart, Partition newPart, Table tbl, EnvironmentContext environmentContext) {
        String statsType;
        if (environmentContext != null && environmentContext.isSetProperties() && "true".equals(environmentContext.getProperties().get("DO_NOT_UPDATE_STATS"))) {
            return false;
        }
        if (MetaStoreUtils.isView(tbl)) {
            return false;
        }
        if (oldPart == null && newPart == null) {
            return true;
        }
        if (newPart == null || newPart.getParameters() == null || !MetaStoreUtils.containsAllFastStats(newPart.getParameters())) {
            return true;
        }
        if (environmentContext != null && environmentContext.isSetProperties() && ("TASK".equals(statsType = environmentContext.getProperties().get("STATS_GENERATED")) || "USER".equals(statsType))) {
            return true;
        }
        return !MetaStoreUtils.isFastStatsSame(oldPart, newPart);
    }

    public static boolean isView(Table table) {
        if (table == null) {
            return false;
        }
        return TableType.VIRTUAL_VIEW.toString().equals(table.getTableType());
    }

    private static boolean containsAllFastStats(Map<String, String> partParams) {
        for (String stat : StatsSetupConst.FAST_STATS) {
            if (partParams.containsKey(stat)) continue;
            return false;
        }
        return true;
    }

    public static boolean isFastStatsSame(Partition oldPart, Partition newPart) {
        if (oldPart != null && oldPart.getParameters() != null) {
            for (String stat : StatsSetupConst.FAST_STATS) {
                if (oldPart.getParameters().containsKey(stat) && newPart.getParameters().containsKey(stat)) {
                    Long newStat;
                    Long oldStat = Long.parseLong(oldPart.getParameters().get(stat));
                    if (oldStat.equals(newStat = Long.valueOf(Long.parseLong(newPart.getParameters().get(stat))))) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static void updateTableStatsSlow(Database db, Table tbl, Warehouse wh, boolean newDir, boolean forceRecompute, EnvironmentContext environmentContext) throws MetaException {
        boolean populateQuickStats;
        Map<String, String> params = tbl.getParameters();
        boolean updateStats = true;
        if (params != null && params.containsKey("DO_NOT_UPDATE_STATS")) {
            updateStats = Boolean.valueOf(params.get("DO_NOT_UPDATE_STATS")) == false;
            params.remove("DO_NOT_UPDATE_STATS");
        }
        if (!updateStats || newDir || tbl.getPartitionKeysSize() != 0) {
            return;
        }
        if (!forceRecompute && params != null && MetaStoreUtils.containsAllFastStats(params)) {
            return;
        }
        if (params == null) {
            params = new HashMap<String, String>();
            tbl.setParameters(params);
        }
        boolean bl = populateQuickStats = environmentContext == null || !environmentContext.isSetProperties() || !"true".equals(environmentContext.getProperties().get("DO_NOT_POPULATE_QUICK_STATS"));
        if (populateQuickStats) {
            List<FileStatus> fileStatus = wh.getFileStatusesForUnpartitionedTable(db, tbl);
            LOG.info("Updating table stats for {}", (Object)tbl.getTableName());
            MetaStoreUtils.populateQuickStats(fileStatus, params);
        }
        LOG.info("Updated size of table {} to {}", (Object)tbl.getTableName(), (Object)params.get("totalSize"));
        if (environmentContext != null && environmentContext.isSetProperties() && "TASK".equals(environmentContext.getProperties().get("STATS_GENERATED"))) {
            StatsSetupConst.setBasicStatsState(params, "true");
        } else {
            StatsSetupConst.setBasicStatsState(params, "false");
        }
    }

    public static void populateQuickStats(List<FileStatus> fileStatus, Map<String, String> params) {
        LOG.trace("Populating quick stats based on {} files", (Object)fileStatus.size());
        int numFiles = 0;
        long tableSize = 0L;
        int numErasureCodedFiles = 0;
        for (FileStatus status : fileStatus) {
            if (status.isDir()) continue;
            tableSize += status.getLen();
            ++numFiles;
            if (!status.isErasureCoded()) continue;
            ++numErasureCodedFiles;
        }
        params.put("numFiles", Integer.toString(numFiles));
        params.put("totalSize", Long.toString(tableSize));
        params.put("numFilesErasureCoded", Integer.toString(numErasureCodedFiles));
    }

    public static void clearQuickStats(Map<String, String> params) {
        params.remove("numFiles");
        params.remove("totalSize");
        params.remove("numFilesErasureCoded");
    }

    public static void updateTableStatsForCreateTable(Warehouse wh, Database db, Table tbl, EnvironmentContext envContext, Configuration conf, Path tblPath, boolean newDir) throws MetaException {
        ByteBuffer buffer;
        List<ByteBuffer> values;
        if (MetaStoreUtils.isView(tbl)) {
            return;
        }
        assert (tblPath != null);
        if (tbl.isSetDictionary() && tbl.getDictionary().getValues() != null && (values = tbl.getDictionary().getValues().remove("setStatsStateForCreateTable")) != null && values.size() > 0 && (buffer = values.get(0)).hasArray()) {
            String val = new String(buffer.array(), StandardCharsets.UTF_8);
            StatsSetupConst.ColumnStatsSetup statsSetup = StatsSetupConst.ColumnStatsSetup.parseStatsSetup(val);
            if (statsSetup.enabled) {
                try {
                    if (newDir || statsSetup.isIcebergTable || wh.isEmptyDir(tblPath, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                        List<String> columns = statsSetup.columnNames;
                        if (columns == null || columns.isEmpty()) {
                            columns = MetaStoreUtils.getColumnNames(tbl.getSd().getCols());
                        }
                        StatsSetupConst.setStatsStateForCreateTable(tbl.getParameters(), columns, "true");
                    }
                }
                catch (IOException e) {
                    LOG.error("Error while checking the table directory: " + tblPath + " is empty or not", (Throwable)e);
                    throw MetaStoreUtils.newMetaException(e);
                }
            }
        }
        if (MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.STATS_AUTO_GATHER) && !MetaStoreUtils.getBooleanEnvProp(envContext, "DO_NOT_UPDATE_STATS")) {
            LOG.debug("Calling updateTableStatsSlow for table {}.{}.{}", new Object[]{tbl.getCatName(), tbl.getDbName(), tbl.getTableName()});
            MetaStoreUtils.updateTableStatsSlow(db, tbl, wh, newDir, false, envContext);
        }
    }

    public static boolean getBooleanEnvProp(EnvironmentContext envContext, String key) {
        return Optional.ofNullable(envContext).map(EnvironmentContext::getProperties).map(props -> props.getOrDefault(key, "false")).map(Boolean::parseBoolean).orElse(false);
    }

    public static boolean areSameColumns(List<FieldSchema> oldCols, List<FieldSchema> newCols) {
        return ListUtils.isEqualList(oldCols, newCols);
    }

    public static boolean arePrefixColumns(List<FieldSchema> p, List<FieldSchema> s) {
        if (p == s) {
            return true;
        }
        if (p.size() > s.size()) {
            return false;
        }
        return ListUtils.isEqualList(p, s.subList(0, p.size()));
    }

    public static void updateBasicState(EnvironmentContext environmentContext, Map<String, String> params) {
        if (params == null) {
            return;
        }
        if (environmentContext != null && environmentContext.isSetProperties() && "TASK".equals(environmentContext.getProperties().get("STATS_GENERATED"))) {
            StatsSetupConst.setBasicStatsState(params, "true");
        } else {
            StatsSetupConst.setBasicStatsState(params, "false");
        }
    }

    public static boolean updatePartitionStatsFast(Partition part, Table tbl, Warehouse wh, boolean madeDir, boolean forceRecompute, EnvironmentContext environmentContext, boolean isCreate) throws MetaException {
        return MetaStoreUtils.updatePartitionStatsFast(new PartitionSpecProxy.SimplePartitionWrapperIterator(part), tbl, wh, madeDir, forceRecompute, environmentContext, isCreate);
    }

    public static boolean updatePartitionStatsFast(PartitionSpecProxy.PartitionIterator part, Table table, Warehouse wh, boolean madeDir, boolean forceRecompute, EnvironmentContext environmentContext, boolean isCreate) throws MetaException {
        Map<String, String> params = part.getParameters();
        if (!forceRecompute && params != null && MetaStoreUtils.containsAllFastStats(params)) {
            return false;
        }
        if (params == null) {
            params = new HashMap<String, String>();
        }
        if (!isCreate && MetaStoreUtils.isTransactionalTable(table.getParameters())) {
            LOG.warn("Not updating fast stats for a transactional table " + table.getTableName());
            part.setParameters(params);
            return true;
        }
        if (!madeDir) {
            LOG.warn("Updating partition stats fast for: " + part.getTableName());
            List<FileStatus> fileStatus = wh.getFileStatusesForLocation(part.getLocation());
            MetaStoreUtils.populateQuickStats(fileStatus, params);
            LOG.warn("Updated size to " + params.get("totalSize"));
            MetaStoreUtils.updateBasicState(environmentContext, params);
        }
        part.setParameters(params);
        return true;
    }

    public static boolean columnsIncludedByNameType(List<FieldSchema> oldCols, List<FieldSchema> newCols) {
        if (oldCols.size() > newCols.size()) {
            return false;
        }
        HashMap<String, String> columnNameTypePairMap = new HashMap<String, String>(newCols.size());
        for (FieldSchema newCol : newCols) {
            columnNameTypePairMap.put(newCol.getName().toLowerCase(), newCol.getType());
        }
        for (FieldSchema oldCol : oldCols) {
            if (columnNameTypePairMap.containsKey(oldCol.getName()) && ((String)columnNameTypePairMap.get(oldCol.getName())).equalsIgnoreCase(oldCol.getType())) continue;
            return false;
        }
        return true;
    }

    public static boolean isTransactionalTable(Map<String, String> params) {
        String transactionalProp = params.get("transactional");
        return "true".equalsIgnoreCase(transactionalProp);
    }

    public static boolean isInsertOnlyTableParam(Map<String, String> params) {
        String transactionalProp = params.get("transactional_properties");
        return transactionalProp != null && "insert_only".equalsIgnoreCase(transactionalProp);
    }

    public static <T> List<T> getMetaStoreListeners(Class<T> clazz, Configuration conf, String listenerImplList) throws MetaException {
        String[] listenerImpls;
        ArrayList listeners = new ArrayList();
        if (org.apache.commons.lang.StringUtils.isBlank((String)listenerImplList)) {
            return listeners;
        }
        for (String listenerImpl : listenerImpls = listenerImplList.split(",")) {
            try {
                Object listener = Class.forName(listenerImpl.trim(), true, JavaUtils.getClassLoader()).getConstructor(Configuration.class).newInstance(conf);
                listeners.add(listener);
            }
            catch (InvocationTargetException ie) {
                LOG.error("Got InvocationTargetException", (Throwable)ie);
                throw new MetaException("Failed to instantiate listener named: " + listenerImpl + ", reason: " + ie.getCause());
            }
            catch (Exception e) {
                LOG.error("Got Exception", (Throwable)e);
                throw new MetaException("Failed to instantiate listener named: " + listenerImpl + ", reason: " + e);
            }
        }
        return listeners;
    }

    public static String validateSkewedColNames(List<String> cols) {
        if (CollectionUtils.isEmpty(cols)) {
            return null;
        }
        for (String col : cols) {
            if (MetaStoreUtils.validateColumnName(col)) continue;
            return col;
        }
        return null;
    }

    public static String validateSkewedColNamesSubsetCol(List<String> skewedColNames, List<FieldSchema> cols) {
        if (CollectionUtils.isEmpty(skewedColNames)) {
            return null;
        }
        ArrayList<String> colNames = new ArrayList<String>(cols.size());
        for (FieldSchema fieldSchema : cols) {
            colNames.add(fieldSchema.getName());
        }
        ArrayList<String> copySkewedColNames = new ArrayList<String>(skewedColNames);
        copySkewedColNames.removeAll(colNames);
        if (copySkewedColNames.isEmpty()) {
            return null;
        }
        return ((Object)copySkewedColNames).toString();
    }

    public static boolean isNonNativeTable(Table table) {
        if (table == null || table.getParameters() == null) {
            return false;
        }
        return MetaStoreUtils.isNonNativeTable(table.getParameters());
    }

    public static boolean isNonNativeTable(Map<String, String> tblProps) {
        return tblProps.get("storage_handler") != null;
    }

    public static List<String> getPvals(List<FieldSchema> partCols, Map<String, String> partSpec) {
        ArrayList<String> pvals = new ArrayList<String>(partCols.size());
        for (FieldSchema field : partCols) {
            String val = org.apache.commons.lang.StringUtils.defaultString((String)partSpec.get(field.getName()));
            pvals.add(val);
        }
        return pvals;
    }

    public static String makePartNameMatcher(Table table, List<String> partVals, String defaultStr) throws MetaException {
        List<FieldSchema> partCols = table.getPartitionKeys();
        int numPartKeys = partCols.size();
        if (partVals.size() > numPartKeys) {
            throw new MetaException("Incorrect number of partition values. numPartKeys=" + numPartKeys + ", part_val=" + partVals);
        }
        partCols = partCols.subList(0, partVals.size());
        String partNameMatcher = Warehouse.makePartName(partCols, partVals, defaultStr);
        if (partVals.size() < numPartKeys) {
            partNameMatcher = partNameMatcher + defaultStr;
        }
        return partNameMatcher;
    }

    public static boolean compareFieldColumns(List<FieldSchema> schema1, List<FieldSchema> schema2) {
        if (schema1.size() != schema2.size()) {
            return false;
        }
        Iterator<FieldSchema> its1 = schema1.iterator();
        Iterator<FieldSchema> its2 = schema2.iterator();
        while (its1.hasNext()) {
            FieldSchema f1 = its1.next();
            FieldSchema f2 = its2.next();
            if (org.apache.commons.lang.StringUtils.equals((String)f1.getName(), (String)f2.getName()) && org.apache.commons.lang.StringUtils.equals((String)f1.getType(), (String)f2.getType())) continue;
            return false;
        }
        return true;
    }

    public static boolean isArchived(Partition part) {
        Map<String, String> params = part.getParameters();
        return params != null && "TRUE".equalsIgnoreCase(params.get("is_archived"));
    }

    public static Path getOriginalLocation(Partition part) {
        Map<String, String> params = part.getParameters();
        assert (MetaStoreUtils.isArchived(part));
        String originalLocation = params.get("original_location");
        assert (originalLocation != null);
        return new Path(originalLocation);
    }

    public static int getArchivingLevel(Partition part) throws MetaException {
        if (!MetaStoreUtils.isArchived(part)) {
            throw new MetaException("Getting level of unarchived partition");
        }
        String lv = part.getParameters().get(ARCHIVING_LEVEL);
        if (lv != null) {
            return Integer.parseInt(lv);
        }
        return part.getValues().size();
    }

    public static boolean partitionNameHasValidCharacters(List<String> partVals, Pattern partitionValidationPattern) {
        return MetaStoreUtils.getPartitionValWithInvalidCharacter(partVals, partitionValidationPattern) == null;
    }

    public static void getMergableCols(ColumnStatistics csNew, Map<String, String> parameters) {
        ArrayList<ColumnStatisticsObj> list = new ArrayList<ColumnStatisticsObj>();
        for (int index = 0; index < csNew.getStatsObj().size(); ++index) {
            ColumnStatisticsObj statsObjNew = csNew.getStatsObj().get(index);
            if (!StatsSetupConst.canColumnStatsMerge(parameters, statsObjNew.getColName())) continue;
            list.add(statsObjNew);
        }
        csNew.setStatsObj(list);
    }

    public static void mergeColStats(ColumnStatistics csNew, ColumnStatistics csOld) throws InvalidObjectException {
        ArrayList<ColumnStatisticsObj> list = new ArrayList<ColumnStatisticsObj>();
        if (csNew.getStatsObj().size() != csOld.getStatsObjSize()) {
            LOG.debug("New ColumnStats size is {}, but old ColumnStats size is {}", (Object)csNew.getStatsObj().size(), (Object)csOld.getStatsObjSize());
        }
        HashMap<String, ColumnStatisticsObj> map = new HashMap<String, ColumnStatisticsObj>();
        for (ColumnStatisticsObj obj : csOld.getStatsObj()) {
            map.put(obj.getColName(), obj);
        }
        for (int index = 0; index < csNew.getStatsObj().size(); ++index) {
            ColumnStatisticsObj statsObjNew = csNew.getStatsObj().get(index);
            ColumnStatisticsObj statsObjOld = (ColumnStatisticsObj)map.get(statsObjNew.getColName());
            if (statsObjOld != null) {
                assert (statsObjNew.getStatsData().getSetField() == statsObjOld.getStatsData().getSetField());
                ColumnStatsMerger merger = ColumnStatsMergerFactory.getColumnStatsMerger(statsObjNew, statsObjOld);
                merger.merge(statsObjNew, statsObjOld);
            }
            list.add(statsObjNew);
        }
        csNew.setStatsObj(list);
    }

    public static Map<String, String> getMetaStoreSaslProperties(Configuration conf, boolean useSSL) {
        String hadoopRpcProtectionVal = conf.get("hadoop.rpc.protection");
        String hadoopRpcProtectionAuth = SaslRpcServer.QualityOfProtection.AUTHENTICATION.toString();
        if (useSSL && hadoopRpcProtectionVal != null && !hadoopRpcProtectionVal.equals(hadoopRpcProtectionAuth)) {
            LOG.warn("Overriding value of hadoop.rpc.protection setting it from " + hadoopRpcProtectionVal + " to " + hadoopRpcProtectionAuth + " because SSL is enabled");
            conf.set("hadoop.rpc.protection", hadoopRpcProtectionAuth);
        }
        return HadoopThriftAuthBridge.getBridge().getHadoopSaslProperties(conf);
    }

    public static ClassLoader addToClassPath(ClassLoader cloader, String[] newPaths) throws Exception {
        URLClassLoader loader = (URLClassLoader)cloader;
        List<URL> curPath = Arrays.asList(loader.getURLs());
        ArrayList<URL> newPath = new ArrayList<URL>(curPath.size());
        for (URL onePath : curPath) {
            newPath.add(onePath);
        }
        curPath = newPath;
        for (String onestr : newPaths) {
            URL oneurl = MetaStoreUtils.urlFromPathString(onestr);
            if (oneurl == null || curPath.contains(oneurl)) continue;
            curPath.add(oneurl);
        }
        return new URLClassLoader(curPath.toArray(new URL[0]), (ClassLoader)loader);
    }

    private static URL urlFromPathString(String onestr) {
        URL oneurl = null;
        try {
            oneurl = onestr.startsWith("file:/") ? new URL(onestr) : new File(onestr).toURL();
        }
        catch (Exception err) {
            LOG.error("Bad URL " + onestr + ", ignoring path");
        }
        return oneurl;
    }

    public static boolean checkUserHasHostProxyPrivileges(String user, Configuration conf, String ipAddress) {
        DefaultImpersonationProvider sip = ProxyUsers.getDefaultImpersonationProvider();
        if (sip == null) {
            ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
            sip = ProxyUsers.getDefaultImpersonationProvider();
        }
        Map proxyHosts = sip.getProxyHosts();
        Collection hostEntries = (Collection)proxyHosts.get(sip.getProxySuperuserIpConfKey(user));
        MachineList machineList = new MachineList(hostEntries);
        if (ipAddress == null) {
            try {
                ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                ipAddress = "";
            }
        }
        return machineList.includes(ipAddress);
    }

    public static String getDDLFromFieldSchema(String structName, List<FieldSchema> fieldSchemas) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("struct ");
        ddl.append(structName);
        ddl.append(" { ");
        boolean first = true;
        for (FieldSchema col : fieldSchemas) {
            if (first) {
                first = false;
            } else {
                ddl.append(", ");
            }
            ddl.append(ColumnType.typeToThriftType(col.getType()));
            ddl.append(' ');
            ddl.append(col.getName());
        }
        ddl.append("}");
        LOG.trace("DDL: {}", (Object)ddl);
        return ddl.toString();
    }

    public static Properties getTableMetadata(Table table) {
        return MetaStoreUtils.getSchema(table.getSd(), table.getSd(), table.getParameters(), table.getDbName(), table.getTableName(), table.getPartitionKeys());
    }

    public static Properties getPartitionMetadata(Partition partition, Table table) {
        return MetaStoreUtils.getSchema(partition.getSd(), partition.getSd(), partition.getParameters(), table.getDbName(), table.getTableName(), table.getPartitionKeys());
    }

    public static Properties getSchema(Partition part, Table table) {
        return MetaStoreUtils.getSchema(part.getSd(), table.getSd(), table.getParameters(), table.getDbName(), table.getTableName(), table.getPartitionKeys());
    }

    public static Properties getPartSchemaFromTableSchema(StorageDescriptor sd, Map<String, String> parameters, Properties tblSchema) {
        Properties schema = (Properties)tblSchema.clone();
        String inputFormat = sd.getInputFormat();
        if (inputFormat == null || inputFormat.length() == 0) {
            String tblInput = schema.getProperty("file.inputformat");
            inputFormat = tblInput == null ? SequenceFileInputFormat.class.getName() : tblInput;
        }
        schema.setProperty("file.inputformat", inputFormat);
        String outputFormat = sd.getOutputFormat();
        if (outputFormat == null || outputFormat.length() == 0) {
            String tblOutput = schema.getProperty("file.outputformat");
            outputFormat = tblOutput == null ? SequenceFileOutputFormat.class.getName() : tblOutput;
        }
        schema.setProperty("file.outputformat", outputFormat);
        if (sd.getLocation() != null) {
            schema.setProperty("location", sd.getLocation());
        }
        schema.setProperty("bucket_count", Integer.toString(sd.getNumBuckets()));
        if (sd.getBucketCols() != null && sd.getBucketCols().size() > 0) {
            schema.setProperty("bucket_field_name", Joiner.on((String)",").join(sd.getBucketCols()));
        }
        if (sd.getSerdeInfo() != null) {
            String cols = "columns";
            String colTypes = "columns.types";
            String parts = "partition_columns";
            for (Map.Entry<String, String> param : sd.getSerdeInfo().getParameters().entrySet()) {
                String key = param.getKey();
                if (schema.get(key) != null && (key.equals(cols) || key.equals(colTypes) || key.equals(parts) || key.startsWith("druid.") || key.startsWith("hive.sql."))) continue;
                schema.put(key, param.getValue() != null ? param.getValue() : "");
            }
            if (sd.getSerdeInfo().getSerializationLib() != null) {
                schema.setProperty("serialization.lib", sd.getSerdeInfo().getSerializationLib());
            }
        }
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                schema.setProperty(e.getKey(), e.getValue());
            }
        }
        return schema;
    }

    private static Properties addCols(Properties schema, List<FieldSchema> cols) {
        StringBuilder colNameBuf = new StringBuilder();
        StringBuilder colTypeBuf = new StringBuilder();
        StringBuilder colComment = new StringBuilder();
        boolean first = true;
        String columnNameDelimiter = MetaStoreUtils.getColumnNameDelimiter(cols);
        for (FieldSchema col : cols) {
            if (!first) {
                colNameBuf.append(columnNameDelimiter);
                colTypeBuf.append(":");
                colComment.append('\u0000');
            }
            colNameBuf.append(col.getName());
            colTypeBuf.append(col.getType());
            colComment.append(null != col.getComment() ? col.getComment() : "");
            first = false;
        }
        schema.setProperty("columns", colNameBuf.toString());
        schema.setProperty("column.name.delimiter", columnNameDelimiter);
        String colTypes = colTypeBuf.toString();
        schema.setProperty("columns.types", colTypes);
        schema.setProperty("columns.comments", colComment.toString());
        return schema;
    }

    public static Properties getSchemaWithoutCols(StorageDescriptor sd, Map<String, String> parameters, String databaseName, String tableName, List<FieldSchema> partitionKeys) {
        int bucket_cnt;
        Properties schema = new Properties();
        String inputFormat = sd.getInputFormat();
        if (inputFormat == null || inputFormat.length() == 0) {
            inputFormat = SequenceFileInputFormat.class.getName();
        }
        schema.setProperty("file.inputformat", inputFormat);
        String outputFormat = sd.getOutputFormat();
        if (outputFormat == null || outputFormat.length() == 0) {
            outputFormat = SequenceFileOutputFormat.class.getName();
        }
        schema.setProperty("file.outputformat", outputFormat);
        schema.setProperty("name", databaseName + "." + tableName);
        if (sd.getLocation() != null) {
            schema.setProperty("location", sd.getLocation());
        }
        if ((bucket_cnt = sd.getNumBuckets()) > 0) {
            schema.setProperty("bucket_count", Integer.toString(bucket_cnt));
        }
        if (sd.getBucketCols() != null && sd.getBucketCols().size() > 0) {
            schema.setProperty("bucket_field_name", Joiner.on((String)",").join(sd.getBucketCols()));
        }
        if (sd.getSerdeInfo() != null) {
            for (Map.Entry<String, String> param : sd.getSerdeInfo().getParameters().entrySet()) {
                schema.put(param.getKey(), param.getValue() != null ? param.getValue() : "");
            }
            if (sd.getSerdeInfo().getSerializationLib() != null) {
                schema.setProperty("serialization.lib", sd.getSerdeInfo().getSerializationLib());
            }
        }
        if (partitionKeys != null) {
            String partString = "";
            String partStringSep = "";
            String partTypesString = "";
            String partTypesStringSep = "";
            for (FieldSchema partKey : partitionKeys) {
                partString = partString.concat(partStringSep);
                partString = partString.concat(partKey.getName());
                partTypesString = partTypesString.concat(partTypesStringSep);
                partTypesString = partTypesString.concat(partKey.getType());
                if (partStringSep.length() != 0) continue;
                partStringSep = "/";
                partTypesStringSep = ":";
            }
            if (partString.length() > 0) {
                schema.setProperty("partition_columns", partString);
                schema.setProperty("partition_columns.types", partTypesString);
            }
        }
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                String key = e.getKey();
                if ("COLUMN_STATS_ACCURATE".equals(key) || "transient_lastDdlTime".equals(key) || "totalSize".equals(key) || "rawDataSize".equals(key) || "numFiles".equals(key) || "numRows".equals(key) || e.getValue() == null) continue;
                schema.setProperty(e.getKey(), e.getValue());
            }
        }
        return schema;
    }

    public static Properties getSchema(StorageDescriptor sd, StorageDescriptor tblsd, Map<String, String> parameters, String databaseName, String tableName, List<FieldSchema> partitionKeys) {
        return MetaStoreUtils.addCols(MetaStoreUtils.getSchemaWithoutCols(sd, parameters, databaseName, tableName, partitionKeys), tblsd.getCols());
    }

    public static String getColumnNameDelimiter(List<FieldSchema> fieldSchemas) {
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (!fieldSchemas.get(i).getName().contains(",")) continue;
            return String.valueOf('\u0000');
        }
        return String.valueOf(',');
    }

    public static String getColumnNamesFromFieldSchema(List<FieldSchema> fieldSchemas) {
        String delimiter = MetaStoreUtils.getColumnNameDelimiter(fieldSchemas);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(fieldSchemas.get(i).getName());
        }
        return sb.toString();
    }

    public static String getColumnTypesFromFieldSchema(List<FieldSchema> fieldSchemas, String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(fieldSchemas.get(i).getType());
        }
        return sb.toString();
    }

    public static String getColumnTypesFromFieldSchema(List<FieldSchema> fieldSchemas) {
        return MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas, ",");
    }

    public static String getColumnCommentsFromFieldSchema(List<FieldSchema> fieldSchemas) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (i > 0) {
                sb.append('\u0000');
            }
            sb.append(fieldSchemas.get(i).getComment());
        }
        return sb.toString();
    }

    public static int startMetaStore() throws Exception {
        return MetaStoreUtils.startMetaStore(HadoopThriftAuthBridge.getBridge(), null);
    }

    public static int startMetaStore(HadoopThriftAuthBridge bridge, Configuration conf) throws Exception {
        int port = MetaStoreUtils.findFreePort();
        MetaStoreUtils.startMetaStore(port, bridge, conf);
        return port;
    }

    public static int startMetaStore(Configuration conf) throws Exception {
        return MetaStoreUtils.startMetaStore(HadoopThriftAuthBridge.getBridge(), conf);
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge) throws Exception {
        MetaStoreUtils.startMetaStore(port, bridge, null);
    }

    public static void startMetaStore(final int port, final HadoopThriftAuthBridge bridge, Configuration hiveConf) throws Exception {
        if (hiveConf == null) {
            hiveConf = MetastoreConf.newMetastoreConf();
        }
        final Configuration finalHiveConf = hiveConf;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HiveMetaStore.startMetaStore(port, bridge, finalHiveConf);
                }
                catch (Throwable e) {
                    LOG.error("Metastore Thrift Server threw an exception...", e);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
        MetaStoreUtils.loopUntilHMSReady(port);
    }

    private static void loopUntilHMSReady(int port) throws Exception {
        int retries = 0;
        while (true) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(port), 5000);
                socket.close();
                return;
            }
            catch (Exception e) {
                if (retries++ <= 60) {
                    Thread.sleep(1000L);
                    continue;
                }
                Exception exc = e;
                LOG.error("Unable to connect to metastore server: " + exc.getMessage());
                LOG.info("Printing all thread stack traces for debugging before throwing exception.");
                LOG.info(MetaStoreUtils.getAllThreadStacksAsString());
                throw exc;
            }
            break;
        }
    }

    private static String getAllThreadStacksAsString() {
        Map<Thread, StackTraceElement[]> threadStacks = Thread.getAllStackTraces();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> entry : threadStacks.entrySet()) {
            Thread t = entry.getKey();
            sb.append(System.lineSeparator());
            sb.append("Name: ").append(t.getName()).append(" State: ").append((Object)t.getState());
            MetaStoreUtils.addStackString(entry.getValue(), sb);
        }
        return sb.toString();
    }

    private static void addStackString(StackTraceElement[] stackElems, StringBuilder sb) {
        sb.append(System.lineSeparator());
        for (StackTraceElement stackElem : stackElems) {
            sb.append(stackElem).append(System.lineSeparator());
        }
    }

    public static int findFreePort() throws IOException {
        ServerSocket socket = new ServerSocket(0);
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findFreePortExcepting(int portToExclude) throws IOException {
        ServerSocket socket1 = null;
        ServerSocket socket2 = null;
        try {
            socket1 = new ServerSocket(0);
            socket2 = new ServerSocket(0);
            if (socket1.getLocalPort() != portToExclude) {
                int n = socket1.getLocalPort();
                return n;
            }
            int n = socket2.getLocalPort();
            return n;
        }
        finally {
            if (socket1 != null) {
                socket1.close();
            }
            if (socket2 != null) {
                socket2.close();
            }
        }
    }

    public static String getIndexTableName(String dbName, String baseTblName, String indexName) {
        return dbName + "__" + baseTblName + "_" + indexName + "__";
    }

    public static boolean isMaterializedViewTable(Table table) {
        if (table == null) {
            return false;
        }
        return TableType.MATERIALIZED_VIEW.toString().equals(table.getTableType());
    }

    public static List<String> getColumnNames(List<FieldSchema> schema) {
        ArrayList<String> cols = new ArrayList<String>(schema.size());
        for (FieldSchema fs : schema) {
            cols.add(fs.getName());
        }
        return cols;
    }

    public static boolean isValidSchedulingPolicy(String str) {
        try {
            MetaStoreUtils.parseSchedulingPolicy(str);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static WMPoolSchedulingPolicy parseSchedulingPolicy(String schedulingPolicy) {
        if (schedulingPolicy == null) {
            return WMPoolSchedulingPolicy.FAIR;
        }
        if ("DEFAULT".equals(schedulingPolicy = schedulingPolicy.trim().toUpperCase())) {
            return WMPoolSchedulingPolicy.FAIR;
        }
        return Enum.valueOf(WMPoolSchedulingPolicy.class, schedulingPolicy);
    }

    public static String anonymizeConnectionURL(String connectionURL) {
        if (connectionURL == null) {
            return null;
        }
        CharSequence[] sensitiveData = new String[]{"user", "password"};
        String regex = "([;,?&\\(]" + String.join((CharSequence)"|", sensitiveData) + ")=.*?([;,&\\)]|$)";
        return connectionURL.replaceAll(regex, "$1=****$2");
    }

    public static List<PartitionSpec> getPartitionspecsGroupedByStorageDescriptor(Table table, Collection<Partition> partitions) {
        String tablePath = table.getSd().getLocation();
        ImmutableListMultimap partitionsWithinTableDirectory = Multimaps.index(partitions, input -> {
            if (input.getSd() == null) {
                return StorageDescriptorKey.UNSET_KEY;
            }
            if (input.getSd().getLocation() != null && input.getSd().getLocation().startsWith(tablePath)) {
                return new StorageDescriptorKey(tablePath, input.getSd());
            }
            return new StorageDescriptorKey(input.getSd());
        });
        ArrayList<PartitionSpec> partSpecs = new ArrayList<PartitionSpec>();
        HashMap sdToPartList = new HashMap();
        ArrayList<Partition> partitionsOutsideTableDir = new ArrayList<Partition>(0);
        for (StorageDescriptorKey storageDescriptorKey : partitionsWithinTableDirectory.keySet()) {
            boolean isUnsetKey = storageDescriptorKey.equals(StorageDescriptorKey.UNSET_KEY);
            if (isUnsetKey || storageDescriptorKey.baseLocation == null || storageDescriptorKey.baseLocation.equals(tablePath)) {
                for (Partition partition : partitionsWithinTableDirectory.get((Object)storageDescriptorKey)) {
                    PartitionWithoutSD partitionWithoutSD = new PartitionWithoutSD();
                    partitionWithoutSD.setValues(partition.getValues());
                    partitionWithoutSD.setCreateTime(partition.getCreateTime());
                    partitionWithoutSD.setLastAccessTime(partition.getLastAccessTime());
                    partitionWithoutSD.setRelativePath(isUnsetKey || !partition.getSd().isSetLocation() ? null : partition.getSd().getLocation().substring(tablePath.length()));
                    partitionWithoutSD.setParameters(partition.getParameters());
                    if (!sdToPartList.containsKey(storageDescriptorKey)) {
                        sdToPartList.put(storageDescriptorKey, new ArrayList());
                    }
                    ((List)sdToPartList.get(storageDescriptorKey)).add(partitionWithoutSD);
                }
                continue;
            }
            partitionsOutsideTableDir.addAll((Collection<Partition>)partitionsWithinTableDirectory.get((Object)storageDescriptorKey));
        }
        for (Map.Entry entry : sdToPartList.entrySet()) {
            partSpecs.add(MetaStoreUtils.getSharedSDPartSpec(table, (StorageDescriptorKey)entry.getKey(), (List)entry.getValue()));
        }
        if (!partitionsOutsideTableDir.isEmpty()) {
            PartitionSpec partListSpec = new PartitionSpec();
            partListSpec.setDbName(table.getDbName());
            partListSpec.setTableName(table.getTableName());
            partListSpec.setPartitionList(new PartitionListComposingSpec(partitionsOutsideTableDir));
            partSpecs.add(partListSpec);
        }
        return partSpecs;
    }

    private static PartitionSpec getSharedSDPartSpec(Table table, StorageDescriptorKey sdKey, List<PartitionWithoutSD> partitions) {
        StorageDescriptor sd;
        if (sdKey.getSd() == null) {
            sd = new StorageDescriptor();
        } else {
            sd = new StorageDescriptor(sdKey.getSd());
            sd.setLocation(sdKey.baseLocation);
        }
        PartitionSpecWithSharedSD sharedSDPartSpec = new PartitionSpecWithSharedSD();
        sharedSDPartSpec.setPartitions(partitions);
        sharedSDPartSpec.setSd(sd);
        PartitionSpec ret = new PartitionSpec();
        ret.setRootPath(sd.getLocation());
        ret.setSharedSDPartitionSpec(sharedSDPartSpec);
        ret.setDbName(table.getDbName());
        ret.setTableName(table.getTableName());
        return ret;
    }

    public static void setNestedProperty(Object bean, String propertyName, Object value, boolean instantiateMissingFields) throws MetaException {
        try {
            String[] nestedFields = propertyName.split("\\.");
            if (nestedFields.length > 1 && instantiateMissingFields) {
                StringBuilder fieldNameBuilder = new StringBuilder();
                for (int level = 0; level < nestedFields.length - 1; ++level) {
                    fieldNameBuilder.append(nestedFields[level]);
                    String currentFieldName = fieldNameBuilder.toString();
                    Object fieldVal = PropertyUtils.getProperty((Object)bean, (String)currentFieldName);
                    if (fieldVal == null) {
                        PropertyDescriptor fieldDescriptor = PropertyUtils.getPropertyDescriptor((Object)bean, (String)currentFieldName);
                        Object defaultInstance = fieldDescriptor.getPropertyType().newInstance();
                        PropertyUtils.setNestedProperty((Object)bean, (String)currentFieldName, defaultInstance);
                    }
                    fieldNameBuilder.append('.');
                }
            }
            PropertyUtils.setNestedProperty((Object)bean, (String)propertyName, (Object)value);
        }
        catch (Exception e) {
            throw new MetaException(StringUtils.stringifyException(e));
        }
    }

    public static boolean hasCatalogName(String dbName) {
        return dbName != null && dbName.length() > 0 && dbName.charAt(0) == '@';
    }

    public static String prependCatalogToDbName(@Nullable String catalogName, @Nullable String dbName, Configuration conf) {
        if (catalogName == null) {
            catalogName = MetaStoreUtils.getDefaultCatalog(conf);
        }
        StringBuilder buf = new StringBuilder().append('@').append(catalogName).append(CATALOG_DB_SEPARATOR);
        if (dbName != null) {
            if (dbName.isEmpty()) {
                buf.append(DB_EMPTY_MARKER);
            } else {
                buf.append(dbName);
            }
        }
        return buf.toString();
    }

    public static String prependNotNullCatToDbName(String catalogName, String dbName) {
        assert (catalogName != null);
        return MetaStoreUtils.prependCatalogToDbName(catalogName, dbName, null);
    }

    public static String prependCatalogToDbName(String dbName, Configuration conf) {
        return MetaStoreUtils.prependCatalogToDbName(null, dbName, conf);
    }

    public static String[] parseDbName(String dbName, Configuration conf) throws MetaException {
        if (dbName == null) {
            return nullCatalogAndDatabase;
        }
        if (MetaStoreUtils.hasCatalogName(dbName)) {
            if (dbName.endsWith(CATALOG_DB_SEPARATOR)) {
                return new String[]{dbName.substring(1, dbName.length() - 1), null};
            }
            if (dbName.endsWith(DB_EMPTY_MARKER)) {
                return new String[]{dbName.substring(1, dbName.length() - DB_EMPTY_MARKER.length() - 1), ""};
            }
            String[] names = dbName.substring(1).split(CATALOG_DB_SEPARATOR, 2);
            if (names.length != 2) {
                throw new MetaException(dbName + " is prepended with the catalog marker but does not appear to have a catalog name in it");
            }
            return names;
        }
        return new String[]{MetaStoreUtils.getDefaultCatalog(conf), dbName};
    }

    public static String getDefaultCatalog(Configuration conf) {
        if (conf == null) {
            LOG.warn("Configuration is null, so going with default catalog.");
            return "hive";
        }
        String catName = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.CATALOG_DEFAULT);
        if (catName == null || "".equals(catName)) {
            catName = "hive";
        }
        return catName;
    }

    public static boolean isNoAutoCompactSet(Map<String, String> dbParameters, Map<String, String> tblParameters) {
        String dbNoAutoCompact = MetaStoreUtils.getNoAutoCompact(dbParameters);
        if (dbNoAutoCompact == null) {
            LOG.debug("Using table configuration 'no_auto_compaction' for compaction");
            String noAutoCompact = MetaStoreUtils.getNoAutoCompact(tblParameters);
            return Boolean.parseBoolean(noAutoCompact);
        }
        LOG.debug("Using database configuration 'no_auto_compaction' for compaction");
        return Boolean.parseBoolean(dbNoAutoCompact);
    }

    public static String getNoAutoCompact(Map<String, String> parameters) {
        String noAutoCompact = parameters.get("no_auto_compaction");
        if (noAutoCompact == null) {
            return parameters.get("no_auto_compaction".toUpperCase());
        }
        return noAutoCompact;
    }

    public static Path getPath(Table table) {
        String location = table.getSd().getLocation();
        if (location == null) {
            return null;
        }
        return new Path(location);
    }

    public static List<Partition> getPartitionsByProjectSpec(IMetaStoreClient msc, GetPartitionsRequest request) throws MetastoreException {
        try {
            GetPartitionsResponse response = msc.getPartitionsWithSpecs(request);
            List<PartitionSpec> partitionSpecList = response.getPartitionSpec();
            ArrayList<Partition> result = new ArrayList<Partition>();
            for (PartitionSpec spec : partitionSpecList) {
                PartitionSpecWithSharedSD pSpecWithSharedSD;
                if (spec.getPartitionList() != null && spec.getPartitionList().getPartitions() != null) {
                    spec.getPartitionList().getPartitions().forEach(partition -> {
                        partition.setCatName(spec.getCatName());
                        partition.setDbName(spec.getDbName());
                        partition.setTableName(spec.getTableName());
                        result.add((Partition)partition);
                    });
                }
                if ((pSpecWithSharedSD = spec.getSharedSDPartitionSpec()) == null) continue;
                List<PartitionWithoutSD> withoutSDList = pSpecWithSharedSD.getPartitions();
                StorageDescriptor descriptor = pSpecWithSharedSD.getSd();
                if (withoutSDList == null) continue;
                for (PartitionWithoutSD psd : withoutSDList) {
                    StorageDescriptor newSD = new StorageDescriptor(descriptor);
                    Partition partition2 = new Partition(psd.getValues(), spec.getDbName(), spec.getTableName(), psd.getCreateTime(), psd.getLastAccessTime(), newSD, psd.getParameters());
                    partition2.getSd().setLocation(newSD.getLocation() + psd.getRelativePath());
                    result.add(partition2);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new MetastoreException(e);
        }
    }

    public static void getPartitionListByFilterExp(IMetaStoreClient msc, Table table, byte[] filterExp, String defaultPartName, List<Partition> results) throws MetastoreException {
        try {
            msc.listPartitionsByExpr(table.getCatName(), table.getDbName(), table.getTableName(), filterExp, defaultPartName, -1, results);
        }
        catch (Exception e) {
            throw new MetastoreException(e);
        }
    }

    public static List<Partition> getAllPartitionsOf(IMetaStoreClient msc, Table table) throws MetastoreException {
        try {
            return msc.listPartitions(table.getCatName(), table.getDbName(), table.getTableName(), -1);
        }
        catch (Exception e) {
            throw new MetastoreException(e);
        }
    }

    public static boolean isPartitioned(Table table) {
        if (MetaStoreUtils.getPartCols(table) == null) {
            return false;
        }
        return MetaStoreUtils.getPartCols(table).size() != 0;
    }

    public static List<FieldSchema> getPartCols(Table table) {
        List<FieldSchema> partKeys = table.getPartitionKeys();
        if (partKeys == null) {
            partKeys = new ArrayList<FieldSchema>();
            table.setPartitionKeys(partKeys);
        }
        return partKeys;
    }

    public static List<String> getPartColNames(Table table) {
        ArrayList<String> partColNames = new ArrayList<String>();
        for (FieldSchema key : MetaStoreUtils.getPartCols(table)) {
            partColNames.add(key.getName());
        }
        return partColNames;
    }

    public static Path getDataLocation(Table table, Partition partition) {
        if (MetaStoreUtils.isPartitioned(table)) {
            if (partition.getSd() == null) {
                return null;
            }
            return new Path(partition.getSd().getLocation());
        }
        if (table.getSd() == null) {
            return null;
        }
        return MetaStoreUtils.getPath(table);
    }

    public static String getPartitionName(Table table, Partition partition) {
        try {
            return Warehouse.makePartName(MetaStoreUtils.getPartCols(table), partition.getValues());
        }
        catch (MetaException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public static Map<String, String> getPartitionSpec(Table table, Partition partition) {
        return Warehouse.makeSpecFromValues(MetaStoreUtils.getPartCols(table), partition.getValues());
    }

    public static Partition getPartition(IMetaStoreClient msc, Table tbl, Map<String, String> partSpec) throws MetastoreException {
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : MetaStoreUtils.getPartCols(tbl)) {
            String val = partSpec.get(field.getName());
            pvals.add(val);
        }
        Partition tpart = null;
        try {
            tpart = msc.getPartition(tbl.getCatName(), tbl.getDbName(), tbl.getTableName(), pvals);
        }
        catch (NoSuchObjectException field) {
        }
        catch (Exception e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw new MetastoreException(e);
        }
        return tpart;
    }

    public static String getPartitionName(Path tablePath, Path partitionPath, Set<String> partCols) {
        String result = null;
        LOG.debug("tablePath:" + tablePath + ", partCols: " + partCols);
        for (Path currPath = partitionPath; currPath != null && !tablePath.equals((Object)currPath); currPath = currPath.getParent()) {
            String[] parts = currPath.getName().split("=");
            if (parts.length > 0) {
                if (parts.length != 2) {
                    LOG.warn(currPath.getName() + " is not a valid partition name");
                    return result;
                }
                String partitionName = parts[0].toLowerCase();
                String partitionValue = parts[1];
                if (partCols.contains(partitionName)) {
                    result = result == null ? partitionName + "=" + partitionValue : partitionName + "=" + partitionValue + "/" + result;
                }
            }
            LOG.debug("currPath=" + currPath);
        }
        return result;
    }

    public static Partition createMetaPartitionObject(Table tbl, Map<String, String> partSpec, Path location) throws MetastoreException {
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : MetaStoreUtils.getPartCols(tbl)) {
            String val = partSpec.get(field.getName());
            if (val == null || val.isEmpty()) {
                throw new MetastoreException("partition spec is invalid; field " + field.getName() + " does not exist or is empty");
            }
            pvals.add(val);
        }
        Partition tpart = new Partition();
        tpart.setCatName(tbl.getCatName());
        tpart.setDbName(tbl.getDbName());
        tpart.setTableName(tbl.getTableName());
        tpart.setValues(pvals);
        if (!MetaStoreUtils.isView(tbl)) {
            tpart.setSd(tbl.getSd().deepCopy());
            tpart.getSd().setLocation(location != null ? location.toString() : null);
        }
        return tpart;
    }

    public static <T> void filterMapKeys(Map<String, T> map, Predicate<String> predicate) {
        if (map == null) {
            return;
        }
        map.entrySet().removeIf(entry -> predicate.test((String)entry.getKey()));
    }

    public static <T> void filterMapkeys(Map<String, T> map, List<Predicate<String>> predicates) {
        if (map == null) {
            return;
        }
        MetaStoreUtils.filterMapKeys(map, predicates.stream().reduce(Predicate::or).orElse(x -> false));
    }

    public static List<Predicate<String>> compilePatternsToPredicates(List<String> patterns) {
        return patterns.stream().map(pattern -> Pattern.compile(pattern).asPredicate()).collect(Collectors.toList());
    }

    public static TableName getTableNameFor(Table table) {
        return TableName.fromString((String)table.getTableName().toLowerCase(), (String)table.getCatName().toLowerCase(), (String)table.getDbName().toLowerCase());
    }

    public static String getHostFromId(String id) {
        if (id == null) {
            return NO_VAL;
        }
        int lastDash = id.lastIndexOf(45);
        return id.substring(0, lastDash > -1 ? lastDash : id.length());
    }

    public static String getThreadIdFromId(String id) {
        if (id == null) {
            return NO_VAL;
        }
        return id.substring(id.lastIndexOf(45) + 1);
    }

    public static GetPartitionsByNamesRequest convertToGetPartitionsByNamesRequest(String dbName, String tblName, List<String> partNames) {
        GetPartitionsByNamesRequest result = new GetPartitionsByNamesRequest(dbName, tblName);
        result.setNames(partNames);
        result.setGet_col_stats(false);
        return result;
    }

    public static <T> T createThriftPartitionsReq(Class<T> clazz, Configuration conf, T ... deepCopy) {
        T req;
        if (deepCopy != null && deepCopy.length == 1) {
            assert (clazz.isAssignableFrom(deepCopy[0].getClass()));
            req = JavaUtils.newInstance(clazz, new Class[]{clazz}, deepCopy);
        } else {
            req = JavaUtils.newInstance(clazz);
        }
        JavaUtils.setField(req, "setSkipColumnSchemaForPartition", new Class[]{Boolean.TYPE}, MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.METASTORE_CLIENT_FIELD_SCHEMA_FOR_PARTITIONS));
        JavaUtils.setField(req, "setIncludeParamKeyPattern", new Class[]{String.class}, MetastoreConf.getAsString(conf, MetastoreConf.ConfVars.METASTORE_PARTITIONS_PARAMETERS_INCLUDE_PATTERN));
        JavaUtils.setField(req, "setExcludeParamKeyPattern", new Class[]{String.class}, MetastoreConf.getAsString(conf, MetastoreConf.ConfVars.METASTORE_PARTITIONS_PARAMETERS_EXCLUDE_PATTERN));
        return req;
    }

    public static String getHttpPath(String httpPath) {
        if (httpPath == null || httpPath.equals("")) {
            httpPath = "/*";
        } else {
            if (!httpPath.startsWith("/")) {
                httpPath = "/" + httpPath;
            }
            if (httpPath.endsWith("/")) {
                httpPath = httpPath + "*";
            }
            if (!httpPath.endsWith("/*")) {
                httpPath = httpPath + "/*";
            }
        }
        return httpPath;
    }

    public static boolean isCompactionTxn(TxnType txnType) {
        return TxnType.COMPACTION.equals((Object)txnType) || TxnType.REBALANCE_COMPACTION.equals((Object)txnType);
    }

    public static enum FailoverEndpoint {
        SOURCE,
        TARGET;

    }

    @VisibleForTesting
    static class StorageDescriptorKey {
        private final StorageDescriptor sd;
        private final String baseLocation;
        private final int hashCode;
        @VisibleForTesting
        static final StorageDescriptorKey UNSET_KEY = new StorageDescriptorKey();

        StorageDescriptorKey(StorageDescriptor sd) {
            this(sd.getLocation(), sd);
        }

        StorageDescriptorKey(String baseLocation, StorageDescriptor sd) {
            this.sd = sd;
            this.baseLocation = baseLocation;
            this.hashCode = sd == null ? Objects.hashCode(baseLocation) : Objects.hash(sd.getSerdeInfo() == null ? null : sd.getSerdeInfo().getSerializationLib(), sd.getInputFormat(), sd.getOutputFormat(), baseLocation, sd.getCols());
        }

        StorageDescriptorKey() {
            this.baseLocation = null;
            this.sd = null;
            this.hashCode = 0;
        }

        StorageDescriptor getSd() {
            return this.sd;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StorageDescriptorKey that = (StorageDescriptorKey)o;
            if (!Objects.equals(this.baseLocation, that.baseLocation)) {
                return false;
            }
            if (this.sd == null && that.sd == null) {
                return true;
            }
            if (this.sd == null || that.sd == null) {
                return false;
            }
            if (!Objects.equals(this.sd.getOutputFormat(), that.sd.getOutputFormat())) {
                return false;
            }
            if (!Objects.equals(this.sd.getCols(), that.sd.getCols())) {
                return false;
            }
            if (!Objects.equals(this.sd.getInputFormat(), that.sd.getInputFormat())) {
                return false;
            }
            if (!Objects.equals(this.sd.getSerdeInfo(), that.sd.getSerdeInfo())) {
                return false;
            }
            if (this.sd.getSerdeInfo() != null && that.sd.getSerdeInfo() == null) {
                return false;
            }
            if (this.sd.getSerdeInfo() == null && that.sd.getSerdeInfo() != null) {
                return false;
            }
            return this.sd.getSerdeInfo() == null || that.sd.getSerdeInfo() == null || Objects.equals(this.sd.getSerdeInfo().getSerializationLib(), that.sd.getSerdeInfo().getSerializationLib());
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static class ColStatsObjWithSourceInfo {
        private final ColumnStatisticsObj colStatsObj;
        private final String catName;
        private final String dbName;
        private final String tblName;
        private final String partName;

        public ColStatsObjWithSourceInfo(ColumnStatisticsObj colStatsObj, String catName, String dbName, String tblName, String partName) {
            this.colStatsObj = colStatsObj;
            this.catName = catName;
            this.dbName = dbName;
            this.tblName = tblName;
            this.partName = partName;
        }

        public ColumnStatisticsObj getColStatsObj() {
            return this.colStatsObj;
        }

        public String getCatName() {
            return this.catName;
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getTblName() {
            return this.tblName;
        }

        public String getPartName() {
            return this.partName;
        }
    }
}

