/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxnUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TxnUtils.class);
    private static final EnumMap<DatabaseProduct, String> DB_EPOCH_FN = new EnumMap<DatabaseProduct, String>(DatabaseProduct.class){
        {
            this.put(DatabaseProduct.DERBY, "{ fn timestampdiff(sql_tsi_frac_second, timestamp('" + new Timestamp(0L) + "'), current_timestamp) } / 1000000");
            this.put(DatabaseProduct.MYSQL, "round(unix_timestamp(now(3)) * 1000)");
            this.put(DatabaseProduct.POSTGRES, "round(extract(epoch from current_timestamp) * 1000)");
            this.put(DatabaseProduct.ORACLE, "(cast(systimestamp at time zone 'UTC' as date) - date '1970-01-01')*24*60*60*1000 + cast(mod( extract( second from systimestamp ), 1 ) * 1000 as int)");
            this.put(DatabaseProduct.SQLSERVER, "datediff_big(millisecond, '19700101', sysutcdatetime())");
        }
    };
    private static final EnumMap<DatabaseProduct, String> DB_SEED_FN = new EnumMap<DatabaseProduct, String>(DatabaseProduct.class){
        {
            this.put(DatabaseProduct.DERBY, "UPDATE \"NEXT_TXN_ID\" SET \"NTXN_NEXT\" = %s");
            this.put(DatabaseProduct.MYSQL, "UPDATE \"NEXT_TXN_ID\" SET \"NTXN_NEXT\" = %s");
            this.put(DatabaseProduct.POSTGRES, "UPDATE \"NEXT_TXN_ID\" SET \"NTXN_NEXT\" = %s");
            this.put(DatabaseProduct.ORACLE, "UPDATE \"NEXT_TXN_ID\" SET \"NTXN_NEXT\" = %s");
            this.put(DatabaseProduct.SQLSERVER, "UPDATE \"NEXT_TXN_ID\" SET \"NTXN_NEXT\" = %s");
        }
    };

    public static ValidTxnList createValidTxnListForCleaner(GetOpenTxnsResponse txns, long minOpenTxn, boolean isAbortCleanup) {
        long txnId;
        long highWatermark = minOpenTxn - 1L;
        long[] exceptions = new long[txns.getOpen_txnsSize()];
        BitSet abortedBits = BitSet.valueOf(txns.getAbortedBits());
        int i = 0;
        Iterator<Long> iterator = txns.getOpen_txns().iterator();
        while (iterator.hasNext() && (txnId = iterator.next().longValue()) <= highWatermark) {
            if (abortedBits.get(i)) {
                exceptions[i] = txnId;
            } else if (isAbortCleanup) {
                exceptions[i] = txnId;
            } else assert (false) : JavaUtils.txnIdToString(txnId) + " is open and <= hwm:" + highWatermark;
            ++i;
        }
        exceptions = Arrays.copyOf(exceptions, i);
        if (!isAbortCleanup) {
            BitSet bitSet = new BitSet(exceptions.length);
            bitSet.set(0, exceptions.length);
            return new ValidReadTxnList(exceptions, bitSet, highWatermark, Long.MAX_VALUE);
        }
        return new ValidReadTxnList(exceptions, abortedBits, highWatermark, Long.MAX_VALUE);
    }

    public static ValidTxnList createValidReadTxnList(GetOpenTxnsResponse txns, long currentTxn) {
        long highWaterMark = currentTxn > 0L ? Math.min(currentTxn, txns.getTxn_high_water_mark()) : txns.getTxn_high_water_mark();
        List<Long> openTxns = txns.getOpen_txns();
        int sizeToHwm = currentTxn > 0L ? Math.abs(Collections.binarySearch(openTxns, currentTxn)) : openTxns.size();
        sizeToHwm = Math.min(sizeToHwm, openTxns.size());
        long[] exceptions = new long[sizeToHwm];
        BitSet inAbortedBits = BitSet.valueOf(txns.getAbortedBits());
        BitSet outAbortedBits = new BitSet();
        long minOpenTxnId = Long.MAX_VALUE;
        int i = 0;
        for (long txn : openTxns) {
            if (currentTxn > 0L && txn >= currentTxn) break;
            if (inAbortedBits.get(i)) {
                outAbortedBits.set(i);
            } else if (minOpenTxnId == Long.MAX_VALUE) {
                minOpenTxnId = txn;
            }
            exceptions[i++] = txn;
        }
        return new ValidReadTxnList(exceptions, outAbortedBits, highWaterMark, minOpenTxnId);
    }

    public static ValidTxnWriteIdList createValidTxnWriteIdList(Long currentTxnId, List<TableValidWriteIds> validIds) {
        ValidTxnWriteIdList validTxnWriteIdList = new ValidTxnWriteIdList(currentTxnId);
        for (TableValidWriteIds tableWriteIds : validIds) {
            validTxnWriteIdList.addTableValidWriteIdList((ValidWriteIdList)TxnUtils.createValidReaderWriteIdList(tableWriteIds));
        }
        return validTxnWriteIdList;
    }

    public static ValidReaderWriteIdList createValidReaderWriteIdList(TableValidWriteIds tableWriteIds) {
        String fullTableName = tableWriteIds.getFullTableName();
        long highWater = tableWriteIds.getWriteIdHighWaterMark();
        List<Long> invalids = tableWriteIds.getInvalidWriteIds();
        BitSet abortedBits = BitSet.valueOf(tableWriteIds.getAbortedBits());
        long[] exceptions = new long[invalids.size()];
        int i = 0;
        for (long writeId : invalids) {
            exceptions[i++] = writeId;
        }
        if (tableWriteIds.isSetMinOpenWriteId()) {
            return new ValidReaderWriteIdList(fullTableName, exceptions, abortedBits, highWater, tableWriteIds.getMinOpenWriteId());
        }
        return new ValidReaderWriteIdList(fullTableName, exceptions, abortedBits, highWater);
    }

    public static ValidCompactorWriteIdList createValidCompactWriteIdList(TableValidWriteIds tableValidWriteIds) {
        String fullTableName = tableValidWriteIds.getFullTableName();
        List<Long> invalids = tableValidWriteIds.getInvalidWriteIds();
        BitSet abortedBits = BitSet.valueOf(tableValidWriteIds.getAbortedBits());
        long[] exceptions = new long[invalids.size()];
        int i = 0;
        for (long writeId : invalids) {
            if (!abortedBits.get(i)) continue;
            exceptions[i++] = writeId;
        }
        if (i < exceptions.length) {
            exceptions = Arrays.copyOf(exceptions, i);
        }
        BitSet bitSet = new BitSet(exceptions.length);
        bitSet.set(0, exceptions.length);
        if (tableValidWriteIds.isSetMinOpenWriteId()) {
            long minOpenWriteId = tableValidWriteIds.getMinOpenWriteId();
            return new ValidCompactorWriteIdList(fullTableName, exceptions, bitSet, minOpenWriteId - 1L, minOpenWriteId);
        }
        return new ValidCompactorWriteIdList(fullTableName, exceptions, bitSet, tableValidWriteIds.getWriteIdHighWaterMark());
    }

    public static TxnStore getTxnStore(Configuration conf) {
        String className = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.TXN_STORE_IMPL);
        try {
            TxnStore handler = JavaUtils.getClass(className, TxnStore.class).newInstance();
            handler.setConf(conf);
            return handler;
        }
        catch (Exception e) {
            LOG.error("Unable to instantiate raw store directly in fastpath mode", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean isTransactionalTable(Table table) {
        return table != null && TxnUtils.isTransactionalTable(table.getParameters());
    }

    public static boolean isTransactionalTable(Map<String, String> parameters) {
        if (parameters == null) {
            return false;
        }
        String tableIsTransactional = parameters.get("transactional");
        return Boolean.parseBoolean(tableIsTransactional);
    }

    public static boolean isAcidTable(Table table) {
        return table != null && TxnUtils.isAcidTable(table.getParameters());
    }

    public static boolean isAcidTable(Map<String, String> parameters) {
        return TxnUtils.isTransactionalTable(parameters) && "default".equalsIgnoreCase(parameters.get("transactional_properties"));
    }

    public static boolean isInsertOnlyTable(Table table) {
        return TxnUtils.isTransactionalTable(table) && "insert_only".equalsIgnoreCase(table.getParameters().get("transactional_properties"));
    }

    public static boolean isTableSoftDeleteEnabled(Table table, boolean isSoftDelete) {
        return isSoftDelete && TxnUtils.isTransactionalTable(table) && Boolean.parseBoolean(table.getParameters().get("soft_delete"));
    }

    public static String getFullTableName(String dbName, String tableName) {
        return dbName.toLowerCase() + "." + tableName.toLowerCase();
    }

    public static String[] getDbTableName(String fullTableName) {
        return fullTableName.split("\\.");
    }

    public static List<Integer> buildQueryWithINClause(Configuration conf, List<String> queries, StringBuilder prefix, StringBuilder suffix, Collection<Long> inValues, String inColumn, boolean addParens, boolean notIn) {
        List<String> inValueStrings = inValues.stream().map(Object::toString).collect(Collectors.toList());
        return TxnUtils.buildQueryWithINClauseStrings(conf, queries, prefix, suffix, inValueStrings, inColumn, addParens, notIn);
    }

    public static List<Integer> buildQueryWithINClauseStrings(Configuration conf, List<String> queries, StringBuilder prefix, StringBuilder suffix, List<String> inList, String inColumn, boolean addParens, boolean notIn) {
        int maxQueryLength = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.DIRECT_SQL_MAX_QUERY_LENGTH);
        int batchSize = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.DIRECT_SQL_MAX_ELEMENTS_IN_CLAUSE);
        int maxParameters = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.DIRECT_SQL_MAX_PARAMETERS);
        if (inList == null || inList.size() == 0 || maxQueryLength <= 0 || batchSize <= 0) {
            throw new IllegalArgumentException("The IN list is empty!");
        }
        int inListSize = inList.size();
        StringBuilder buf = new StringBuilder();
        int cursor4InListArray = 0;
        int cursor4InClauseElements = 0;
        int cursor4queryOfInClauses = 0;
        boolean nextItemNeeded = true;
        boolean newInclausePrefixJustAppended = false;
        StringBuilder nextValue = new StringBuilder("");
        StringBuilder newInclausePrefix = new StringBuilder(notIn ? " and " + inColumn + " not in (" : " or " + inColumn + " in (");
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int currentCount = 0;
        while (cursor4InListArray < inListSize || !nextItemNeeded) {
            int querySize;
            if (cursor4queryOfInClauses == 0) {
                buf.append((CharSequence)prefix);
                if (addParens) {
                    buf.append("(");
                }
                buf.append(inColumn);
                if (notIn) {
                    buf.append(" not in (");
                } else {
                    buf.append(" in (");
                }
                ++cursor4queryOfInClauses;
                newInclausePrefixJustAppended = false;
            }
            if (nextItemNeeded) {
                nextValue.setLength(0);
                nextValue.append(String.valueOf(inList.get(cursor4InListArray++)));
                nextItemNeeded = false;
            }
            if ((querySize = TxnUtils.querySizeExpected(buf.length(), nextValue.length(), suffix.length(), addParens)) > maxQueryLength * 1024 || currentCount >= maxParameters) {
                if (cursor4queryOfInClauses == 1 && cursor4InClauseElements == 0) {
                    throw new IllegalArgumentException("The current " + MetastoreConf.ConfVars.DIRECT_SQL_MAX_QUERY_LENGTH.getVarname() + " is set too small to have one IN clause with single value!");
                }
                if (notIn) {
                    throw new IllegalArgumentException("The NOT IN list has too many elements for the current " + MetastoreConf.ConfVars.DIRECT_SQL_MAX_QUERY_LENGTH.getVarname() + "!");
                }
                if (newInclausePrefixJustAppended) {
                    buf.delete(buf.length() - newInclausePrefix.length(), buf.length());
                }
                buf.setCharAt(buf.length() - 1, ')');
                if (addParens) {
                    buf.append(")");
                }
                buf.append((CharSequence)suffix);
                queries.add(buf.toString());
                ret.add(currentCount);
                buf.setLength(0);
                currentCount = 0;
                cursor4InClauseElements = 0;
                cursor4queryOfInClauses = 0;
                querySize = 0;
                newInclausePrefixJustAppended = false;
                continue;
            }
            if (cursor4InClauseElements >= batchSize - 1 && cursor4InClauseElements != 0) {
                buf.setCharAt(buf.length() - 1, ')');
                buf.append(newInclausePrefix.toString());
                newInclausePrefixJustAppended = true;
                ++cursor4queryOfInClauses;
                cursor4InClauseElements = 0;
                continue;
            }
            buf.append(nextValue.toString()).append(",");
            ++currentCount;
            nextItemNeeded = true;
            newInclausePrefixJustAppended = false;
            ++cursor4InClauseElements;
        }
        if (newInclausePrefixJustAppended) {
            buf.delete(buf.length() - newInclausePrefix.length(), buf.length());
        }
        buf.setCharAt(buf.length() - 1, ')');
        if (addParens) {
            buf.append(")");
        }
        buf.append((CharSequence)suffix);
        queries.add(buf.toString());
        ret.add(currentCount);
        return ret;
    }

    private static int querySizeExpected(int sizeSoFar, int sizeNextItem, int suffixSize, boolean addParens) {
        int size = sizeSoFar + sizeNextItem + suffixSize;
        if (addParens) {
            ++size;
        }
        return size;
    }

    public static String getEpochFn(DatabaseProduct dbProduct) throws MetaException {
        String epochFn = DB_EPOCH_FN.get((Object)dbProduct);
        if (epochFn != null) {
            return epochFn;
        }
        String msg = "Unknown database product: " + dbProduct.toString();
        LOG.error(msg);
        throw new MetaException(msg);
    }

    public static void executeQueriesInBatchNoCount(DatabaseProduct dbProduct, Statement stmt, List<String> queries, int batchSize) throws SQLException {
        if (dbProduct == DatabaseProduct.ORACLE) {
            int queryCounter = 0;
            StringBuilder sb = new StringBuilder();
            sb.append("begin ");
            for (String query : queries) {
                LOG.debug("Adding query to batch: <" + query + ">");
                sb.append(query).append(";");
                if (++queryCounter % batchSize != 0) continue;
                sb.append("end;");
                String batch = sb.toString();
                LOG.debug("Going to execute queries in oracle anonymous statement. {}", (Object)batch);
                stmt.execute(batch);
                sb.setLength(0);
                sb.append("begin ");
            }
            if (queryCounter % batchSize != 0) {
                sb.append("end;");
                String batch = sb.toString();
                LOG.debug("Going to execute queries in oracle anonymous statement. {}", (Object)batch);
                stmt.execute(batch);
            }
        } else {
            TxnUtils.executeQueriesInBatch(stmt, queries, batchSize);
        }
    }

    public static List<Integer> executeQueriesInBatch(Statement stmt, List<String> queries, int batchSize) throws SQLException {
        ArrayList<Integer> affectedRowsByQuery = new ArrayList<Integer>();
        int queryCounter = 0;
        for (String query : queries) {
            LOG.debug("Adding query to batch: <{}>", (Object)query);
            stmt.addBatch(query);
            if (++queryCounter % batchSize != 0) continue;
            LOG.debug("Going to execute queries in batch. Batch size: {}", (Object)batchSize);
            int[] affectedRecordsByQuery = stmt.executeBatch();
            Arrays.stream(affectedRecordsByQuery).forEach(affectedRowsByQuery::add);
        }
        if (queryCounter % batchSize != 0) {
            LOG.debug("Going to execute queries in batch. Batch size: {}", (Object)(queryCounter % batchSize));
            int[] affectedRecordsByQuery = stmt.executeBatch();
            Arrays.stream(affectedRecordsByQuery).forEach(affectedRowsByQuery::add);
        }
        return affectedRowsByQuery;
    }

    public static void seedTxnSequence(Connection conn, Statement stmt, long seedTxnId) throws SQLException {
        String dbProduct = conn.getMetaData().getDatabaseProductName();
        DatabaseProduct databaseProduct = DatabaseProduct.determineDatabaseProduct(dbProduct);
        stmt.execute(String.format(DB_SEED_FN.get((Object)databaseProduct), seedTxnId));
    }

    public static String findUserToRunAs(String location, Table t, Configuration conf) throws IOException, InterruptedException {
        LOG.debug("Determining who to run the job as.");
        String runUserAs = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.COMPACTOR_RUN_AS_USER);
        if (runUserAs != null && !"".equals(runUserAs)) {
            return runUserAs;
        }
        Path p = new Path(location);
        FileSystem fs = p.getFileSystem(conf);
        try {
            FileStatus stat = fs.getFileStatus(p);
            LOG.debug("Running job as {}", (Object)stat.getOwner());
            return stat.getOwner();
        }
        catch (AccessControlException e) {
            LOG.debug("Unable to stat file as current user, trying as table owner");
            ArrayList wrapper = new ArrayList(1);
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)t.getOwner(), (UserGroupInformation)UserGroupInformation.getLoginUser());
            ugi.doAs(() -> {
                FileSystem proxyFs = p.getFileSystem(conf);
                FileStatus stat = proxyFs.getFileStatus(p);
                wrapper.add(stat.getOwner());
                return null;
            });
            try {
                FileSystem.closeAllForUGI((UserGroupInformation)ugi);
            }
            catch (IOException exception) {
                LOG.error("Could not clean up file-system handles for UGI: " + ugi, (Throwable)exception);
            }
            if (wrapper.size() == 1) {
                LOG.debug("Running job as {}", wrapper.get(0));
                return (String)wrapper.get(0);
            }
            LOG.error("Unable to stat file {} as either current user({}) or table owner({}), giving up", new Object[]{p, UserGroupInformation.getLoginUser(), t.getOwner()});
            throw new IOException("Unable to stat file: " + p);
        }
    }

    public static CompactionType dbCompactionType2ThriftType(char dbValue) throws MetaException {
        switch (dbValue) {
            case 'a': {
                return CompactionType.MAJOR;
            }
            case 'i': {
                return CompactionType.MINOR;
            }
            case 'r': {
                return CompactionType.REBALANCE;
            }
            case 'c': {
                return CompactionType.ABORT_TXN_CLEANUP;
            }
        }
        throw new MetaException("Unexpected compaction type " + dbValue);
    }

    public static Character thriftCompactionType2DbType(CompactionType ct) throws MetaException {
        switch (ct) {
            case MAJOR: {
                return Character.valueOf('a');
            }
            case MINOR: {
                return Character.valueOf('i');
            }
            case REBALANCE: {
                return Character.valueOf('r');
            }
            case ABORT_TXN_CLEANUP: {
                return Character.valueOf('c');
            }
        }
        throw new MetaException("Unexpected compaction type " + (Object)((Object)ct));
    }

    public static String nvl(String input) {
        return input != null ? " = ? " : " IS NULL ";
    }

    public static String createUpdatePreparedStmt(String tableName, List<String> columnNames, List<String> conditionKeys) {
        StringBuilder sb = new StringBuilder();
        sb.append("update " + tableName + " set ");
        sb.append(columnNames.stream().map(col -> col + "=?").collect(Collectors.joining(",")));
        sb.append(" where " + conditionKeys.stream().map(cond -> cond + "=?").collect(Collectors.joining(" and ")));
        return sb.toString();
    }

    public static String createInsertPreparedStmt(String tableName, List<String> columnNames) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into " + tableName + "(");
        sb.append(columnNames.stream().collect(Collectors.joining(",")));
        String placeholder = columnNames.stream().map(col -> "?").collect(Collectors.joining(","));
        sb.append(") values (" + placeholder + ")");
        return sb.toString();
    }
}

