/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.MaterializationSnapshot;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.common.classification.RetrySemantics;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.LockTypeComparator;
import org.apache.hadoop.hive.metastore.MetaStoreListenerNotifier;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.AllocateTableWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionInfoStruct;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoRequest;
import org.apache.hadoop.hive.metastore.api.GetLatestCommittedCompactionInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.GetValidWriteIdsResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MaxAllocatedTableWriteIdRequest;
import org.apache.hadoop.hive.metastore.api.MaxAllocatedTableWriteIdResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ReplLastIdInfo;
import org.apache.hadoop.hive.metastore.api.ReplTblWriteIdStateRequest;
import org.apache.hadoop.hive.metastore.api.SeedTableWriteIdsRequest;
import org.apache.hadoop.hive.metastore.api.SeedTxnIdRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.api.UpdateTransactionalStatsRequest;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProviderFactory;
import org.apache.hadoop.hive.metastore.events.AbortTxnEvent;
import org.apache.hadoop.hive.metastore.events.AcidWriteEvent;
import org.apache.hadoop.hive.metastore.events.AllocWriteIdEvent;
import org.apache.hadoop.hive.metastore.events.CommitTxnEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.events.OpenTxnEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;
import org.apache.hadoop.hive.metastore.txn.MetricsInfo;
import org.apache.hadoop.hive.metastore.txn.OpenTxn;
import org.apache.hadoop.hive.metastore.txn.OpenTxnList;
import org.apache.hadoop.hive.metastore.txn.OperationType;
import org.apache.hadoop.hive.metastore.txn.TxnErrorMsg;
import org.apache.hadoop.hive.metastore.txn.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.LockTypeUtil;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.metastore.utils.StringableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
abstract class TxnHandler
implements TxnStore,
TxnStore.MutexAPI {
    protected static final char INITIATED_STATE = 'i';
    protected static final char WORKING_STATE = 'w';
    protected static final char READY_FOR_CLEANING = 'r';
    static final char FAILED_STATE = 'f';
    static final char SUCCEEDED_STATE = 's';
    static final char DID_NOT_INITIATE = 'a';
    static final char REFUSED_STATE = 'c';
    protected static final char MAJOR_TYPE = 'a';
    protected static final char MINOR_TYPE = 'i';
    protected static final char REBALANCE_TYPE = 'r';
    protected static final char ABORT_TXN_CLEANUP_TYPE = 'c';
    private static final String DEFAULT_POOL_NAME = "default";
    protected static final char LOCK_ACQUIRED = 'a';
    protected static final char LOCK_WAITING = 'w';
    private static final int ALLOWED_REPEATED_DEADLOCKS = 10;
    private static final Logger LOG = LoggerFactory.getLogger((String)TxnHandler.class.getName());
    private static DataSource connPool;
    private static DataSource connPoolMutex;
    private static boolean doRetryOnConnPool;
    private static final String HIVE_LOCKS_INSERT_QRY = "INSERT INTO \"HIVE_LOCKS\" ( \"HL_LOCK_EXT_ID\", \"HL_LOCK_INT_ID\", \"HL_TXNID\", \"HL_DB\", \"HL_TABLE\", \"HL_PARTITION\", \"HL_LOCK_STATE\", \"HL_LOCK_TYPE\", \"HL_LAST_HEARTBEAT\", \"HL_USER\", \"HL_HOST\", \"HL_AGENT_INFO\") VALUES (?, ?, ?, ?, ?, ?, ?, ?, %s, ?, ?, ?)";
    private static final String TXN_COMPONENTS_INSERT_QUERY = "INSERT INTO \"TXN_COMPONENTS\" (\"TC_TXNID\", \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_OPERATION_TYPE\", \"TC_WRITEID\") VALUES (?, ?, ?, ?, ?, ?)";
    private static final String TXN_COMPONENTS_DP_DELETE_QUERY = "DELETE FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\" = ? AND \"TC_DATABASE\" = ? AND \"TC_TABLE\" = ? AND \"TC_PARTITION\" IS NULL";
    private static final String INCREMENT_NEXT_LOCK_ID_QUERY = "UPDATE \"NEXT_LOCK_ID\" SET \"NL_NEXT\" = %s";
    private static final String UPDATE_HIVE_LOCKS_EXT_ID_QUERY = "UPDATE \"HIVE_LOCKS\" SET \"HL_LOCK_EXT_ID\" = %s WHERE \"HL_LOCK_EXT_ID\" = %s";
    private static final String SELECT_WRITE_ID_QUERY = "SELECT \"T2W_WRITEID\" FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ? AND \"T2W_TXNID\" = ?";
    private static final String COMPL_TXN_COMPONENTS_INSERT_QUERY = "INSERT INTO \"COMPLETED_TXN_COMPONENTS\" (\"CTC_TXNID\", \"CTC_DATABASE\", \"CTC_TABLE\", \"CTC_PARTITION\", \"CTC_WRITEID\", \"CTC_UPDATE_DELETE\") VALUES (%s, ?, ?, ?, ?, %s)";
    private static final String SELECT_LOCKS_FOR_LOCK_ID_QUERY = "SELECT \"HL_LOCK_EXT_ID\", \"HL_LOCK_INT_ID\", \"HL_DB\", \"HL_TABLE\", \"HL_PARTITION\", \"HL_LOCK_STATE\", \"HL_LOCK_TYPE\", \"HL_TXNID\" FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = ?";
    private static final String SELECT_TIMED_OUT_LOCKS_QUERY = "SELECT DISTINCT \"HL_LOCK_EXT_ID\" FROM \"HIVE_LOCKS\" WHERE \"HL_LAST_HEARTBEAT\" < %s - ? AND \"HL_TXNID\" = 0";
    private static final String TXN_TO_WRITE_ID_INSERT_QUERY = "INSERT INTO \"TXN_TO_WRITE_ID\" (\"T2W_TXNID\", \"T2W_DATABASE\", \"T2W_TABLE\", \"T2W_WRITEID\") VALUES (?, ?, ?, ?)";
    private static final String MIN_HISTORY_WRITE_ID_INSERT_QUERY = "INSERT INTO \"MIN_HISTORY_WRITE_ID\" (\"MH_TXNID\", \"MH_DATABASE\", \"MH_TABLE\", \"MH_WRITEID\") VALUES (?, ?, ?, ?)";
    private static final String SELECT_NWI_NEXT_FROM_NEXT_WRITE_ID = "SELECT \"NWI_NEXT\" FROM \"NEXT_WRITE_ID\" WHERE \"NWI_DATABASE\" = ? AND \"NWI_TABLE\" = ?";
    private static final String SELECT_METRICS_INFO_QUERY;
    private static final String SELECT_TABLES_WITH_X_ABORTED_TXNS;
    private static final String EXCL_CTAS_ERR_MSG = "Failed to initiate a concurrent CTAS operation with the same table name, lockInfo : %s";
    private static final String ZERO_WAIT_READ_ERR_MSG = "Unable to acquire read lock due to an existing exclusive lock {%s}";
    protected List<TransactionalMetaStoreEventListener> transactionalListeners;
    private static volatile int maxOpenTxns;
    private static volatile boolean tooManyOpenTxns;
    private int deadlockCnt;
    private long deadlockRetryInterval;
    protected Configuration conf;
    protected static DatabaseProduct dbProduct;
    protected static SQLGenerator sqlGenerator;
    private long timeout;
    private long replicationTxnTimeout;
    private int maxBatchSize;
    private String identifierQuoteString;
    private long retryInterval;
    private int retryLimit;
    private int retryNum;
    private AtomicInteger numOpenTxns;
    static boolean useMinHistoryLevel;
    static boolean useMinHistoryWriteId;
    private static final ReentrantLock derbyLock;
    private static final ConcurrentHashMap<String, Semaphore> derbyKey2Lock;
    private static final String hostname;
    private static Map<LockType, Map<LockType, Map<LockState, LockAction>>> jumpTable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConf(Configuration conf) {
        this.conf = conf;
        int maxPoolSize = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.CONNECTION_POOLING_MAX_CONNECTIONS);
        Class<TxnHandler> clazz = TxnHandler.class;
        synchronized (TxnHandler.class) {
            String msg;
            try (DataSourceProvider.DataSourceNameConfigurator configurator = new DataSourceProvider.DataSourceNameConfigurator(conf, "txnhandler");){
                if (connPool == null) {
                    connPool = TxnHandler.setupJdbcConnectionPool(conf, maxPoolSize);
                }
                if (connPoolMutex == null) {
                    configurator.resetName("mutex");
                    connPoolMutex = TxnHandler.setupJdbcConnectionPool(conf, maxPoolSize);
                }
            }
            if (dbProduct == null) {
                try {
                    var5_8 = null;
                    try (Connection dbConn = this.getDbConn(2);){
                        this.determineDatabaseProduct(dbConn);
                    }
                    catch (Throwable throwable) {
                        var5_8 = throwable;
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    LOG.error("Unable to determine database product", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            if (sqlGenerator == null) {
                sqlGenerator = new SQLGenerator(dbProduct, conf);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.numOpenTxns = Metrics.getOrCreateGauge("num_open_transactions");
            this.timeout = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.TXN_TIMEOUT, TimeUnit.MILLISECONDS);
            this.replicationTxnTimeout = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.REPL_TXN_TIMEOUT, TimeUnit.MILLISECONDS);
            this.retryInterval = MetastoreConf.getTimeVar(conf, MetastoreConf.ConfVars.HMS_HANDLER_INTERVAL, TimeUnit.MILLISECONDS);
            this.retryLimit = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.HMS_HANDLER_ATTEMPTS);
            this.deadlockRetryInterval = this.retryInterval / 10L;
            maxOpenTxns = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.MAX_OPEN_TXNS);
            this.maxBatchSize = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.JDBC_MAX_BATCH_SIZE);
            try {
                useMinHistoryWriteId = this.checkIfTableIsUsable("MIN_HISTORY_WRITE_ID", MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.TXN_USE_MIN_HISTORY_WRITE_ID));
                useMinHistoryLevel = this.checkIfTableIsUsable("MIN_HISTORY_LEVEL", MetastoreConf.getBoolVar(conf, MetastoreConf.ConfVars.TXN_USE_MIN_HISTORY_LEVEL));
            }
            catch (MetaException e) {
                msg = "Error during TxnHandler startup, " + e.getMessage();
                LOG.error(msg);
                throw new RuntimeException((Throwable)((Object)e));
            }
            try {
                this.transactionalListeners = MetaStoreUtils.getMetaStoreListeners(TransactionalMetaStoreEventListener.class, conf, MetastoreConf.getVar(conf, MetastoreConf.ConfVars.TRANSACTIONAL_EVENT_LISTENERS));
            }
            catch (MetaException e) {
                msg = "Unable to get transaction listeners, " + e.getMessage();
                LOG.error(msg);
                throw new RuntimeException((Throwable)((Object)e));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfTableIsUsable(String tableName, boolean configValue) throws MetaException {
        boolean tableExists;
        block31: {
            if (!configValue) {
                return false;
            }
            Connection dbConn = null;
            tableExists = true;
            try {
                dbConn = this.getDbConn(2);
                try (Statement stmt = dbConn.createStatement();
                     ResultSet rs = stmt.executeQuery("SELECT 1 FROM \"" + tableName + "\"");){
                    rs.next();
                }
            }
            catch (SQLException e) {
                LOG.debug("Catching sql exception in " + tableName + " check", (Throwable)e);
                if (DatabaseProduct.isTableNotExistsError(dbProduct, e)) {
                    tableExists = false;
                    break block31;
                }
                throw new MetaException("Unable to select from transaction database: " + TxnHandler.getMessage(e) + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            }
            finally {
                TxnHandler.closeDbConn(dbConn);
            }
        }
        return tableExists;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    @RetrySemantics.ReadOnly
    public GetOpenTxnsInfoResponse getOpenTxnsInfo() throws MetaException {
        return this.getOpenTxnsList(true).toOpenTxnsInfoResponse();
    }

    @Override
    @RetrySemantics.ReadOnly
    public GetOpenTxnsResponse getOpenTxns() throws MetaException {
        return this.getOpenTxnsList(false).toOpenTxnsResponse(Arrays.asList(TxnType.READ_ONLY));
    }

    @Override
    @RetrySemantics.ReadOnly
    public GetOpenTxnsResponse getOpenTxns(List<TxnType> excludeTxnTypes) throws MetaException {
        return this.getOpenTxnsList(false).toOpenTxnsResponse(excludeTxnTypes);
    }

    @Override
    @RetrySemantics.ReadOnly
    public List<Long> getOpenTxnForPolicy(List<Long> openTxnList, String dbName) {
        ResultSet rs = null;
        Statement pst = null;
        Connection dbConn = null;
        if (openTxnList.isEmpty()) {
            return null;
        }
        try {
            dbConn = this.getDbConn(2);
            String query = "select RTM_TARGET_TXN_ID from REPL_TXN_MAP where RTM_TARGET_TXN_ID in (" + String.join((CharSequence)",", Collections.nCopies(openTxnList.size(), "?")) + ") and RTM_REPL_POLICY  =  ?   ";
            pst = dbConn.prepareStatement(query);
            for (int i = 0; i < openTxnList.size(); ++i) {
                pst.setLong(i + 1, openTxnList.get(i));
            }
            pst.setString(openTxnList.size() + 1, dbName + ".*");
            LOG.debug("Going to execute query <" + query.replaceAll("\\?", "{}") + ">", (Object)TxnHandler.quoteString(openTxnList.toString()));
            rs = pst.executeQuery();
            ArrayList<Long> resultList = new ArrayList<Long>();
            while (rs.next()) {
                resultList.add(rs.getLong(1));
            }
            if (resultList.isEmpty()) {
                LOG.info("There are no Repl Created open transactions on DR side. So, no clean up required");
            }
            ArrayList<Long> arrayList = resultList;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pst != null) {
                    pst.close();
                }
                if (dbConn != null) {
                    dbConn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private GetOpenTxnsResponse getOpenTxns(Connection dbConn) throws MetaException {
        return this.getOpenTxnsList(false, dbConn).toOpenTxnsResponse(Arrays.asList(TxnType.READ_ONLY));
    }

    private OpenTxnList getOpenTxnsList(boolean infoFileds) throws MetaException {
        Connection dbConn = null;
        try {
            dbConn = this.getDbConn(2);
            OpenTxnList openTxnList = this.getOpenTxnsList(infoFileds, dbConn);
            return openTxnList;
        }
        catch (SQLException e) {
            throw new MetaException("Unable to get a connection: " + TxnHandler.getMessage(e) + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
        }
        finally {
            TxnHandler.closeDbConn(dbConn);
        }
    }

    private OpenTxnList getOpenTxnsList(boolean infoFields, Connection dbConn) throws MetaException {
        OpenTxnList openTxnList;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.createStatement();
            String s = "SELECT \"NTXN_NEXT\" - 1 FROM \"NEXT_TXN_ID\"";
            LOG.debug("Going to execute query <{}>", (Object)s);
            rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("Transaction tables not properly initialized, no record found in next_txn_id");
            }
            long hwm = rs.getLong(1);
            if (rs.wasNull()) {
                throw new MetaException("Transaction tables not properly initialized, null record found in next_txn_id");
            }
            TxnHandler.close(rs);
            ArrayList<OpenTxn> txnInfos = new ArrayList<OpenTxn>();
            String txnsQuery = String.format(infoFields ? "SELECT \"TXN_ID\", \"TXN_STATE\", \"TXN_TYPE\", \"TXN_USER\", \"TXN_HOST\", \"TXN_STARTED\", \"TXN_LAST_HEARTBEAT\" FROM \"TXNS\" WHERE \"TXN_ID\" <= %s ORDER BY \"TXN_ID\"" : "SELECT \"TXN_ID\", \"TXN_STATE\", \"TXN_TYPE\" FROM \"TXNS\" WHERE \"TXN_ID\" <= %s ORDER BY \"TXN_ID\"", hwm);
            LOG.debug("Going to execute query<{}>", (Object)txnsQuery);
            rs = stmt.executeQuery(txnsQuery);
            while (rs.next()) {
                long txnId = rs.getLong(1);
                TxnStatus state = TxnStatus.fromString(rs.getString(2));
                OpenTxn txnInfo = new OpenTxn(txnId, state, TxnType.findByValue(rs.getInt(3)));
                if (infoFields) {
                    txnInfo.setUser(rs.getString(4));
                    txnInfo.setHost(rs.getString(5));
                    txnInfo.setStartedTime(rs.getLong(6));
                    txnInfo.setLastHeartBeatTime(rs.getLong(7));
                }
                txnInfos.add(txnInfo);
            }
            LOG.debug("Got OpenTxnList with hwm: {} and openTxnList size {}.", (Object)hwm, (Object)txnInfos.size());
            openTxnList = new OpenTxnList(hwm, txnInfos);
        }
        catch (SQLException e) {
            try {
                try {
                    this.checkRetryable(e, "getOpenTxnsList");
                    throw new MetaException("Unable to select from transaction database, " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(rs, stmt, null);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getOpenTxnsList(infoFields, dbConn);
            }
        }
        TxnHandler.close(rs, stmt, null);
        return openTxnList;
    }

    @Override
    @RetrySemantics.Idempotent
    public OpenTxnsResponse openTxns(OpenTxnRequest rqst) throws MetaException {
        OpenTxnsResponse openTxnsResponse;
        int numTxns;
        if (!tooManyOpenTxns && this.numOpenTxns.get() >= maxOpenTxns) {
            tooManyOpenTxns = true;
        }
        if (tooManyOpenTxns) {
            if ((double)this.numOpenTxns.get() < (double)maxOpenTxns * 0.9) {
                tooManyOpenTxns = false;
            } else {
                LOG.warn("Maximum allowed number of open transactions ({}) has been reached. Current number of open transactions: {}", (Object)maxOpenTxns, (Object)this.numOpenTxns);
                throw new MetaException("Maximum allowed number of open transactions has been reached. See hive.max.open.txns.");
            }
        }
        if ((numTxns = rqst.getNum_txns()) <= 0) {
            throw new MetaException("Invalid input for number of txns: " + numTxns);
        }
        Connection dbConn = null;
        Statement stmt = null;
        try {
            this.lockInternal();
            dbConn = this.getDbConn(2);
            int maxTxns = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.TXN_MAX_OPEN_BATCH);
            if (numTxns > maxTxns) {
                numTxns = maxTxns;
            }
            stmt = dbConn.createStatement();
            List<Long> txnIds = this.openTxns(dbConn, stmt, rqst);
            LOG.debug("Going to commit");
            dbConn.commit();
            openTxnsResponse = new OpenTxnsResponse(txnIds);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback: ", (Throwable)e);
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "openTxns(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, stmt, dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.openTxns(rqst);
            }
        }
        TxnHandler.close(null, stmt, dbConn);
        this.unlockInternal();
        return openTxnsResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<Long> openTxns(Connection dbConn, Statement stmt, OpenTxnRequest rqst) throws SQLException, MetaException {
        ArrayList<Long> arrayList;
        ResultSet rs;
        block20: {
            boolean isHiveReplTxn;
            boolean isReplayedReplTxn;
            TxnType txnType;
            List<PreparedStatement> insertPreparedStmts;
            int numTxns;
            block18: {
                List<Long> list;
                block19: {
                    numTxns = rqst.getNum_txns();
                    rs = null;
                    insertPreparedStmts = null;
                    txnType = rqst.isSetTxn_type() ? rqst.getTxn_type() : TxnType.DEFAULT;
                    isReplayedReplTxn = txnType == TxnType.REPL_CREATED;
                    isHiveReplTxn = rqst.isSetReplPolicy() && txnType == TxnType.DEFAULT;
                    if (!isReplayedReplTxn) break block18;
                    assert (rqst.isSetReplPolicy());
                    List<Long> targetTxnIdList = this.getTargetTxnIdList(rqst.getReplPolicy(), rqst.getReplSrcTxnIds(), dbConn);
                    if (targetTxnIdList.isEmpty()) break block18;
                    if (targetTxnIdList.size() != rqst.getReplSrcTxnIds().size()) {
                        LOG.warn("target txn id number {} is not matching with source txn id number {}", targetTxnIdList, rqst.getReplSrcTxnIds());
                    }
                    LOG.info("Target transactions {} are present for repl policy : {} and Source transaction id : {}", new Object[]{targetTxnIdList.toString(), rqst.getReplPolicy(), rqst.getReplSrcTxnIds().toString()});
                    list = targetTxnIdList;
                    if (insertPreparedStmts == null) break block19;
                    for (PreparedStatement pst : insertPreparedStmts) {
                        pst.close();
                    }
                }
                TxnHandler.close(rs);
                return list;
            }
            try {
                String s = sqlGenerator.addForUpdateClause("SELECT \"NTXN_NEXT\" FROM \"NEXT_TXN_ID\"");
                LOG.debug("Going to execute query <{}>", (Object)s);
                rs = stmt.executeQuery(s);
                if (!rs.next()) {
                    throw new MetaException("Transaction database not properly configured, can't find next transaction id.");
                }
                long first = rs.getLong(1);
                s = "UPDATE \"NEXT_TXN_ID\" SET \"NTXN_NEXT\" = " + (first + (long)numTxns);
                LOG.debug("Going to execute update <{}>", (Object)s);
                stmt.executeUpdate(s);
                long minOpenTxnId = 0L;
                if (useMinHistoryLevel) {
                    minOpenTxnId = this.getMinOpenTxnIdWaterMark(dbConn);
                }
                ArrayList<Long> txnIds = new ArrayList<Long>(numTxns);
                ArrayList<String> rows = new ArrayList<String>();
                ArrayList<String> params = new ArrayList<String>();
                params.add(rqst.getUser());
                params.add(rqst.getHostname());
                ArrayList<List<String>> paramsList = new ArrayList<List<String>>(numTxns);
                for (long i = first; i < first + (long)numTxns; ++i) {
                    txnIds.add(i);
                    rows.add(i + "," + (Object)((Object)TxnStatus.OPEN) + "," + TxnUtils.getEpochFn(dbProduct) + "," + TxnUtils.getEpochFn(dbProduct) + ",?,?," + txnType.getValue());
                    paramsList.add(params);
                }
                insertPreparedStmts = sqlGenerator.createInsertValuesPreparedStmt(dbConn, "\"TXNS\" (\"TXN_ID\", \"TXN_STATE\", \"TXN_STARTED\", \"TXN_LAST_HEARTBEAT\", \"TXN_USER\", \"TXN_HOST\", \"TXN_TYPE\")", rows, paramsList);
                for (PreparedStatement preparedStatement : insertPreparedStmts) {
                    preparedStatement.execute();
                }
                this.addTxnToMinHistoryLevel(dbConn, txnIds, minOpenTxnId);
                if (isReplayedReplTxn) {
                    void var20_25;
                    ArrayList<String> rowsRepl = new ArrayList<String>();
                    for (PreparedStatement pst : insertPreparedStmts) {
                        pst.close();
                    }
                    insertPreparedStmts.clear();
                    params.clear();
                    paramsList.clear();
                    params.add(rqst.getReplPolicy());
                    boolean bl = false;
                    while (var20_25 < numTxns) {
                        rowsRepl.add("?," + rqst.getReplSrcTxnIds().get((int)var20_25) + "," + txnIds.get((int)var20_25));
                        paramsList.add(params);
                        ++var20_25;
                    }
                    insertPreparedStmts = sqlGenerator.createInsertValuesPreparedStmt(dbConn, "\"REPL_TXN_MAP\" (\"RTM_REPL_POLICY\", \"RTM_SRC_TXN_ID\", \"RTM_TARGET_TXN_ID\")", rowsRepl, paramsList);
                    for (PreparedStatement pst : insertPreparedStmts) {
                        pst.execute();
                    }
                }
                if (this.transactionalListeners != null && !isHiveReplTxn) {
                    MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.OPEN_TXN, new OpenTxnEvent(txnIds, txnType), dbConn, sqlGenerator);
                }
                arrayList = txnIds;
                if (insertPreparedStmts == null) break block20;
            }
            catch (Throwable throwable) {
                if (insertPreparedStmts != null) {
                    for (PreparedStatement pst : insertPreparedStmts) {
                        pst.close();
                    }
                }
                TxnHandler.close(rs);
                throw throwable;
            }
            for (PreparedStatement pst : insertPreparedStmts) {
                pst.close();
            }
        }
        TxnHandler.close(rs);
        return arrayList;
    }

    private List<Long> getTargetTxnIdList(String replPolicy, List<Long> sourceTxnIdList, Connection dbConn) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            ArrayList<String> inQueries = new ArrayList<String>();
            StringBuilder prefix = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            ArrayList<Long> targetTxnIdList = new ArrayList<Long>();
            prefix.append("SELECT \"RTM_TARGET_TXN_ID\" FROM \"REPL_TXN_MAP\" WHERE ");
            suffix.append(" AND \"RTM_REPL_POLICY\" = ?");
            TxnUtils.buildQueryWithINClause(this.conf, inQueries, prefix, suffix, sourceTxnIdList, "\"RTM_SRC_TXN_ID\"", false, false);
            List<String> params = Arrays.asList(replPolicy);
            for (String query : inQueries) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Going to execute select <" + query.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(replPolicy));
                }
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
                rs = pst.executeQuery();
                while (rs.next()) {
                    targetTxnIdList.add(rs.getLong(1));
                }
                TxnHandler.closeStmt(pst);
            }
            LOG.debug("targetTxnid for srcTxnId {} is {}", sourceTxnIdList, targetTxnIdList);
            ArrayList<Long> arrayList = targetTxnIdList;
            return arrayList;
        }
        catch (SQLException e) {
            LOG.warn("failed to get target txn ids " + e.getMessage());
            throw e;
        }
        finally {
            TxnHandler.closeStmt(pst);
            TxnHandler.close(rs);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.Idempotent
    public long getTargetTxnId(String replPolicy, long sourceTxnId) throws MetaException {
        try {
            long l;
            List<Long> targetTxnIds;
            Connection dbConn;
            block8: {
                dbConn = null;
                this.lockInternal();
                dbConn = this.getDbConn(2);
                targetTxnIds = this.getTargetTxnIdList(replPolicy, Collections.singletonList(sourceTxnId), dbConn);
                if (!targetTxnIds.isEmpty()) break block8;
                LOG.info("Txn {} not present for repl policy {}", (Object)sourceTxnId, (Object)replPolicy);
                long l2 = -1L;
                TxnHandler.closeDbConn(dbConn);
                this.unlockInternal();
                return l2;
            }
            try {
                assert (targetTxnIds.size() == 1);
                l = targetTxnIds.get(0);
            }
            catch (SQLException e) {
                try {
                    this.checkRetryable(e, "getTargetTxnId(" + replPolicy + sourceTxnId + ")");
                    throw new MetaException("Unable to get target transaction id " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.closeDbConn(dbConn);
            this.unlockInternal();
            return l;
        }
        catch (RetryException e2) {
            return this.getTargetTxnId(replPolicy, sourceTxnId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getDbNamesForReplayedTxns(Connection dbConn, List<Long> targetTxnIds) throws SQLException {
        HashSet<String> dbNames = new HashSet<String>();
        if (targetTxnIds.isEmpty()) {
            return dbNames;
        }
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            ArrayList<String> inQueries = new ArrayList<String>();
            StringBuilder prefix = new StringBuilder();
            prefix.append("SELECT \"RTM_REPL_POLICY\" FROM \"REPL_TXN_MAP\" WHERE ");
            TxnUtils.buildQueryWithINClause(this.conf, inQueries, prefix, new StringBuilder(), targetTxnIds, "\"RTM_TARGET_TXN_ID\"", false, false);
            for (String query : inQueries) {
                LOG.debug("Going to execute select <{}>", (Object)query);
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, null);
                rs = pst.executeQuery();
                while (rs.next()) {
                    dbNames.add(MetaStoreUtils.getDbNameFromReplPolicy(rs.getString(1)));
                }
            }
            HashSet<String> hashSet = dbNames;
            return hashSet;
        }
        finally {
            TxnHandler.closeStmt(pst);
            TxnHandler.close(rs);
        }
    }

    private void deleteReplTxnMapEntry(Connection dbConn, long sourceTxnId, String replPolicy) throws SQLException {
        String s = "DELETE FROM \"REPL_TXN_MAP\" WHERE \"RTM_SRC_TXN_ID\" = " + sourceTxnId + " AND \"RTM_REPL_POLICY\" = ?";
        try (PreparedStatement pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, Arrays.asList(replPolicy));){
            LOG.info("Going to execute  <" + s.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(replPolicy));
            pst.executeUpdate();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @RetrySemantics.Idempotent
    public void abortTxn(AbortTxnRequest rqst) throws NoSuchTxnException, MetaException, TxnAbortedException {
        txnid = rqst.getTxnid();
        txnErrorMsg = TxnErrorMsg.NONE;
        sourceTxnId = -1L;
        isReplayedReplTxn = TxnType.REPL_CREATED.equals((Object)rqst.getTxn_type());
        isHiveReplTxn = rqst.isSetReplPolicy() != false && TxnType.DEFAULT.equals((Object)rqst.getTxn_type()) != false;
        try {
            block19: {
                block18: {
                    dbConn = null;
                    stmt = null;
                    this.lockInternal();
                    dbConn = this.getDbConn(2);
                    stmt = dbConn.createStatement();
                    if (!isReplayedReplTxn) ** GOTO lbl28
                    if (!TxnHandler.$assertionsDisabled && !rqst.isSetReplPolicy()) {
                        throw new AssertionError();
                    }
                    sourceTxnId = rqst.getTxnid();
                    targetTxnIds = this.getTargetTxnIdList(rqst.getReplPolicy(), Collections.singletonList(sourceTxnId), dbConn);
                    if (!targetTxnIds.isEmpty()) break block18;
                    TxnHandler.LOG.info("Target txn id is missing for source txn id : {} and repl policy {}", (Object)sourceTxnId, (Object)rqst.getReplPolicy());
                    TxnHandler.close(null, stmt, dbConn);
                    this.unlockInternal();
                    return;
                }
                if (!TxnHandler.$assertionsDisabled && targetTxnIds.size() != 1) {
                    throw new AssertionError();
                }
                txnid = targetTxnIds.get(0);
lbl28:
                // 2 sources

                if ((txnType = this.getOpenTxnTypeAndLock(stmt, txnid)) != null) ** GOTO lbl41
                status = this.findTxnState(txnid, stmt);
                if (status != TxnStatus.ABORTED) break block19;
                if (isReplayedReplTxn) {
                    TxnHandler.LOG.warn("Invalid state ABORTED for transactions started using replication replay task");
                    this.deleteReplTxnMapEntry(dbConn, sourceTxnId, rqst.getReplPolicy());
                }
                TxnHandler.LOG.info("abortTxn({}) requested by it is already {}", (Object)JavaUtils.txnIdToString(txnid), (Object)TxnStatus.ABORTED);
                TxnHandler.close(null, stmt, dbConn);
                this.unlockInternal();
                return;
            }
            try {
                TxnHandler.raiseTxnUnexpectedState(status, txnid);
lbl41:
                // 2 sources

                if (isReplayedReplTxn) {
                    txnErrorMsg = TxnErrorMsg.ABORT_REPLAYED_REPL_TXN;
                } else if (isHiveReplTxn) {
                    txnErrorMsg = TxnErrorMsg.ABORT_DEFAULT_REPL_TXN;
                } else if (rqst.isSetErrorCode()) {
                    txnErrorMsg = TxnErrorMsg.getTxnErrorMsg(rqst.getErrorCode());
                }
                this.abortTxns(dbConn, Collections.singletonList(txnid), true, isReplayedReplTxn, txnErrorMsg);
                if (isReplayedReplTxn) {
                    this.deleteReplTxnMapEntry(dbConn, sourceTxnId, rqst.getReplPolicy());
                }
                if (this.transactionalListeners != null && !isHiveReplTxn) {
                    MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.ABORT_TXN, new AbortTxnEvent((Long)txnid, txnType), dbConn, TxnHandler.sqlGenerator);
                }
                TxnHandler.LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    TxnHandler.LOG.debug("Going to rollback: ", (Throwable)e);
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "abortTxn(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable var13_13) {
                    TxnHandler.close(null, stmt, dbConn);
                    this.unlockInternal();
                    throw var13_13;
                }
            }
            TxnHandler.close(null, stmt, dbConn);
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.abortTxn(rqst);
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void abortTxns(AbortTxnsRequest rqst) throws MetaException {
        List<Long> txnIds = rqst.getTxn_ids();
        TxnErrorMsg txnErrorMsg = TxnErrorMsg.NONE;
        if (rqst.isSetErrorCode()) {
            txnErrorMsg = TxnErrorMsg.getTxnErrorMsg(rqst.getErrorCode());
        }
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                ArrayList<String> queries = new ArrayList<String>();
                StringBuilder prefix = new StringBuilder("select \"TXN_ID\", \"TXN_TYPE\" from \"TXNS\" where \"TXN_STATE\" = ").append((Object)TxnStatus.OPEN).append(" and \"TXN_TYPE\" != ").append(TxnType.READ_ONLY.getValue()).append(" and ");
                TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, new StringBuilder(), txnIds, "\"TXN_ID\"", false, false);
                HashMap<Long, TxnType> nonReadOnlyTxns = new HashMap<Long, TxnType>();
                for (String query : queries) {
                    LOG.debug("Going to execute query <{}>", (Object)query);
                    ResultSet rs = stmt.executeQuery(sqlGenerator.addForUpdateClause(query));
                    Throwable throwable = null;
                    try {
                        while (rs.next()) {
                            TxnType txnType = TxnType.findByValue(rs.getInt(2));
                            nonReadOnlyTxns.put(rs.getLong(1), txnType);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                int numAborted = this.abortTxns(dbConn, txnIds, false, false, txnErrorMsg);
                if (numAborted != txnIds.size()) {
                    LOG.warn("Abort Transactions command only aborted {} out of {} transactions. It's possible that the other {} transactions have been aborted or committed, or the transaction ids are invalid.", new Object[]{numAborted, txnIds.size(), txnIds.size() - numAborted});
                }
                if (this.transactionalListeners != null) {
                    for (Long txnId : txnIds) {
                        MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.ABORT_TXN, new AbortTxnEvent(txnId, nonReadOnlyTxns.getOrDefault(txnId, TxnType.READ_ONLY)), dbConn, sqlGenerator);
                    }
                }
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback: ", (Throwable)e);
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "abortTxns(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
        }
        catch (RetryException e) {
            this.abortTxns(rqst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getDatabaseId(Connection dbConn, String database, String catalog) throws SQLException, MetaException {
        long l;
        ResultSet rs = null;
        PreparedStatement pst = null;
        try {
            String query = "select \"DB_ID\" from \"DBS\" where \"NAME\" = ?  and \"CTLG_NAME\" = ?";
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, Arrays.asList(database, catalog));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to execute query <" + query.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(database), (Object)TxnHandler.quoteString(catalog));
            }
            if (!(rs = pst.executeQuery()).next()) {
                throw new MetaException("DB with name " + database + " does not exist in catalog " + catalog);
            }
            l = rs.getLong(1);
        }
        catch (Throwable throwable) {
            TxnHandler.close(rs);
            TxnHandler.closeStmt(pst);
            throw throwable;
        }
        TxnHandler.close(rs);
        TxnHandler.closeStmt(pst);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDatabaseProp(Connection dbConn, String database, long dbId, String prop, String propValue) throws SQLException {
        String query;
        PreparedStatement pst;
        ResultSet rs;
        block8: {
            rs = null;
            pst = null;
            try {
                query = "SELECT \"PARAM_VALUE\" FROM \"DATABASE_PARAMS\" WHERE \"PARAM_KEY\" = '" + prop + "' AND \"DB_ID\" = " + dbId;
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, null);
                rs = pst.executeQuery();
                query = null;
                if (!rs.next()) {
                    query = "INSERT INTO \"DATABASE_PARAMS\" VALUES ( " + dbId + " , '" + prop + "' , ? )";
                } else if (!rs.getString(1).equals(propValue)) {
                    query = "UPDATE \"DATABASE_PARAMS\" SET \"PARAM_VALUE\" = ? WHERE \"DB_ID\" = " + dbId + " AND \"PARAM_KEY\" = '" + prop + "'";
                }
                TxnHandler.closeStmt(pst);
                if (query != null) break block8;
                LOG.info("Database property: {} with value: {} already updated for db: {}", new Object[]{prop, propValue, database});
            }
            catch (Throwable throwable) {
                TxnHandler.close(rs);
                TxnHandler.closeStmt(pst);
                throw throwable;
            }
            TxnHandler.close(rs);
            TxnHandler.closeStmt(pst);
            return;
        }
        pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, Arrays.asList(propValue));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating " + prop + " for db: " + database + " <" + query.replace("?", "{}") + ">", (Object)propValue);
        }
        if (pst.executeUpdate() != 1) {
            throw new RuntimeException("DATABASE_PARAMS is corrupted for database: " + database);
        }
        TxnHandler.close(rs);
        TxnHandler.closeStmt(pst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDbAsReplIncompatible(Connection dbConn, String database) throws SQLException, MetaException {
        Statement stmt = null;
        try {
            stmt = dbConn.createStatement();
            String catalog = MetaStoreUtils.getDefaultCatalog(this.conf);
            if (sqlGenerator.getDbProduct() == DatabaseProduct.MYSQL) {
                stmt.execute("SET @@session.sql_mode=ANSI_QUOTES");
            }
            long dbId = this.getDatabaseId(dbConn, database, catalog);
            this.updateDatabaseProp(dbConn, database, dbId, "repl.incompatible", "true");
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReplId(Connection dbConn, ReplLastIdInfo replLastIdInfo) throws SQLException, MetaException {
        long tblId;
        List<String> params;
        String query;
        List<String> partList;
        String table;
        String db;
        String catalog;
        String lastReplId;
        Statement stmt;
        ResultSet rs;
        PreparedStatement pst;
        block13: {
            long dbId;
            block12: {
                pst = null;
                rs = null;
                stmt = null;
                lastReplId = TxnHandler.quoteString(Long.toString(replLastIdInfo.getLastReplId()));
                catalog = replLastIdInfo.isSetCatalog() ? StringUtils.normalizeIdentifier(replLastIdInfo.getCatalog()) : MetaStoreUtils.getDefaultCatalog(this.conf);
                db = StringUtils.normalizeIdentifier(replLastIdInfo.getDatabase());
                table = replLastIdInfo.isSetTable() ? StringUtils.normalizeIdentifier(replLastIdInfo.getTable()) : null;
                partList = replLastIdInfo.isSetPartitionList() ? replLastIdInfo.getPartitionList() : null;
                stmt = dbConn.createStatement();
                if (sqlGenerator.getDbProduct() == DatabaseProduct.MYSQL) {
                    stmt.execute("SET @@session.sql_mode=ANSI_QUOTES");
                }
                dbId = this.getDatabaseId(dbConn, db, catalog);
                this.updateDatabaseProp(dbConn, db, dbId, "repl.last.id", lastReplId);
                if (table != null) break block12;
                TxnHandler.closeStmt(stmt);
                TxnHandler.close(rs);
                TxnHandler.closeStmt(pst);
                return;
            }
            query = "SELECT \"TBL_ID\" FROM \"TBLS\" WHERE \"TBL_NAME\" = ? AND \"DB_ID\" = " + dbId;
            params = Arrays.asList(table);
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to execute query <" + query.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(table));
            }
            if ((rs = pst.executeQuery()) == null || !rs.next()) {
                throw new MetaException(" table with name " + table + " does not exist in db " + catalog + "." + db);
            }
            tblId = rs.getLong(1);
            rs = stmt.executeQuery("SELECT \"PARAM_VALUE\" FROM \"TABLE_PARAMS\" WHERE \"PARAM_KEY\" = 'repl.last.id' AND \"TBL_ID\" = " + tblId);
            if (rs == null || !rs.next()) {
                stmt.executeUpdate("INSERT INTO \"TABLE_PARAMS\" VALUES ( " + tblId + " , 'repl.last.id' , " + lastReplId + ")");
            } else {
                stmt.executeUpdate("update \"TABLE_PARAMS\" set \"PARAM_VALUE\" = " + lastReplId + " where \"TBL_ID\" = " + tblId + " and \"PARAM_KEY\" = 'repl.last.id'");
            }
            if (partList != null && !partList.isEmpty()) break block13;
            TxnHandler.closeStmt(stmt);
            TxnHandler.close(rs);
            TxnHandler.closeStmt(pst);
            return;
        }
        try {
            for (String part : partList) {
                query = "SELECT \"PART_ID\" FROM \"PARTITIONS\" WHERE \"TBL_ID\" = " + tblId + " and \"PART_NAME\" = ? ";
                params = Arrays.asList(part);
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
                LOG.debug("Going to execute query <" + query.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(part));
                rs = pst.executeQuery();
                if (rs == null || !rs.next()) {
                    throw new MetaException(" partition with name " + part + " does not exist in table " + catalog + "." + db + "." + table);
                }
                long partId = rs.getLong(1);
                rs = stmt.executeQuery("SELECT \"PARAM_VALUE\" FROM \"PARTITION_PARAMS\" WHERE \"PARAM_KEY\"  = 'repl.last.id' AND \"PART_ID\" = " + partId);
                if (rs == null || !rs.next()) {
                    stmt.executeUpdate("INSERT INTO \"PARTITION_PARAMS\" VALUES ( " + partId + " , 'repl.last.id' , " + lastReplId + ")");
                    continue;
                }
                stmt.executeUpdate("UPDATE \"PARTITION_PARAMS\" SET \"PARAM_VALUE\" = " + lastReplId + " WHERE \"PART_ID\" = " + partId + " AND \"PARAM_KEY\" = 'repl.last.id'");
            }
        }
        catch (Throwable throwable) {
            TxnHandler.closeStmt(stmt);
            TxnHandler.close(rs);
            TxnHandler.closeStmt(pst);
            throw throwable;
        }
        TxnHandler.closeStmt(stmt);
        TxnHandler.close(rs);
        TxnHandler.closeStmt(pst);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @RetrySemantics.Idempotent(value={"No-op if already committed"})
    public void commitTxn(CommitTxnRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        isUpdateDelete = 'N';
        txnid = rqst.getTxnid();
        sourceTxnId = -1L;
        isReplayedReplTxn = TxnType.REPL_CREATED.equals((Object)rqst.getTxn_type());
        isHiveReplTxn = rqst.isSetReplPolicy() != false && TxnType.DEFAULT.equals((Object)rqst.getTxn_type()) != false;
        try {
            block97: {
                block93: {
                    block92: {
                        dbConn = null;
                        stmt = null;
                        commitId = null;
                        this.lockInternal();
                        dbConn = this.getDbConn(2);
                        if (rqst.isSetReplLastIdInfo()) {
                            this.updateReplId(dbConn, rqst.getReplLastIdInfo());
                        }
                        stmt = dbConn.createStatement();
                        if (!isReplayedReplTxn) ** GOTO lbl32
                        if (!TxnHandler.$assertionsDisabled && !rqst.isSetReplPolicy()) {
                            throw new AssertionError();
                        }
                        sourceTxnId = rqst.getTxnid();
                        targetTxnIds = this.getTargetTxnIdList(rqst.getReplPolicy(), Collections.singletonList(sourceTxnId), dbConn);
                        if (!targetTxnIds.isEmpty()) break block92;
                        TxnHandler.LOG.info("Target txn id is missing for source txn id : {} and repl policy {}", (Object)sourceTxnId, (Object)rqst.getReplPolicy());
                        TxnHandler.closeStmt(stmt);
                        TxnHandler.closeDbConn(dbConn);
                        this.unlockInternal();
                        return;
                    }
                    if (!TxnHandler.$assertionsDisabled && targetTxnIds.size() != 1) {
                        throw new AssertionError();
                    }
                    txnid = targetTxnIds.get(0);
lbl32:
                    // 2 sources

                    if ((txnType = this.getOpenTxnTypeAndLock(stmt, txnid)) != null) ** GOTO lbl45
                    actualTxnStatus = this.findTxnState(txnid, stmt);
                    if (actualTxnStatus != TxnStatus.COMMITTED) break block93;
                    if (isReplayedReplTxn) {
                        TxnHandler.LOG.warn("Invalid state COMMITTED for transactions started using replication replay task");
                    }
                    TxnHandler.LOG.info("Nth commitTxn({}) msg", (Object)JavaUtils.txnIdToString(txnid));
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    this.unlockInternal();
                    return;
                }
                try {
                    TxnHandler.raiseTxnUnexpectedState(actualTxnStatus, txnid);
lbl45:
                    // 2 sources

                    conflictSQLSuffix = "FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\"=" + txnid + " AND \"TC_OPERATION_TYPE\" IN (" + (Object)OperationType.UPDATE + "," + (Object)OperationType.DELETE + ")";
                    tempCommitId = this.generateTemporaryId();
                    if (txnType == TxnType.SOFT_DELETE || txnType == TxnType.COMPACTION) {
                        commitIdRs = stmt.executeQuery(TxnHandler.sqlGenerator.addForUpdateClause("SELECT \"NTXN_NEXT\" - 1 FROM \"NEXT_TXN_ID\""));
                        var17_16 = null;
                        try {
                            if (!commitIdRs.next()) {
                                throw new IllegalStateException("No rows found in NEXT_TXN_ID");
                            }
                            commitId = commitIdRs.getLong(1);
                        }
                        catch (Throwable var18_18) {
                            var17_16 = var18_18;
                            throw var18_18;
                        }
                        finally {
                            if (commitIdRs != null) {
                                if (var17_16 != null) {
                                    try {
                                        commitIdRs.close();
                                    }
                                    catch (Throwable var18_17) {
                                        var17_16.addSuppressed(var18_17);
                                    }
                                } else {
                                    commitIdRs.close();
                                }
                            }
                        }
                    }
                    if (txnType != TxnType.READ_ONLY && !isReplayedReplTxn) {
                        writeSetInsertSql = "INSERT INTO \"WRITE_SET\" (\"WS_DATABASE\", \"WS_TABLE\", \"WS_PARTITION\",   \"WS_TXNID\", \"WS_COMMIT_ID\", \"WS_OPERATION_TYPE\") SELECT DISTINCT \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_TXNID\", " + tempCommitId + ", \"TC_OPERATION_TYPE\" ";
                        if (this.isUpdateOrDelete(stmt, conflictSQLSuffix)) {
                            isUpdateDelete = 'Y';
                            undoWriteSetForCurrentTxn = dbConn.setSavepoint();
                            stmt.executeUpdate(writeSetInsertSql + (TxnHandler.useMinHistoryLevel != false ? conflictSQLSuffix : "FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\"=" + txnid + " AND \"TC_OPERATION_TYPE\" <> " + (Object)OperationType.COMPACT));
                            commitIdRs = stmt.executeQuery(TxnHandler.sqlGenerator.addForUpdateClause("SELECT \"NTXN_NEXT\" - 1 FROM \"NEXT_TXN_ID\""));
                            var19_21 = null;
                            try {
                                if (!commitIdRs.next()) {
                                    throw new IllegalStateException("No rows found in NEXT_TXN_ID");
                                }
                                commitId = commitIdRs.getLong(1);
                            }
                            catch (Throwable var20_29) {
                                var19_21 = var20_29;
                                throw var20_29;
                            }
                            finally {
                                if (commitIdRs != null) {
                                    if (var19_21 != null) {
                                        try {
                                            commitIdRs.close();
                                        }
                                        catch (Throwable var20_28) {
                                            var19_21.addSuppressed(var20_28);
                                        }
                                    } else {
                                        commitIdRs.close();
                                    }
                                }
                            }
                            if (!rqst.isExclWriteEnabled()) {
                                rs = this.checkForWriteConflict(stmt, txnid);
                                var19_21 = null;
                                try {
                                    if (rs.next()) {
                                        committedTxn = "[" + JavaUtils.txnIdToString(rs.getLong(1)) + "," + rs.getLong(2) + "]";
                                        resource = new StringBuilder(rs.getString(3)).append("/").append(rs.getString(4));
                                        partitionName = rs.getString(5);
                                        if (partitionName != null) {
                                            resource.append('/').append(partitionName);
                                        }
                                        msg = "Aborting [" + JavaUtils.txnIdToString(txnid) + "," + commitId + "] due to a write conflict on " + resource + " committed by " + committedTxn + " " + rs.getString(7) + "/" + rs.getString(8);
                                        dbConn.rollback(undoWriteSetForCurrentTxn);
                                        TxnHandler.LOG.info(msg);
                                        if (this.abortTxns(dbConn, Collections.singletonList(txnid), false, isReplayedReplTxn, TxnErrorMsg.ABORT_WRITE_CONFLICT) != 1) {
                                            throw new IllegalStateException(msg + " FAILED!");
                                        }
                                        dbConn.commit();
                                        throw new TxnAbortedException(msg);
                                    }
                                }
                                catch (Throwable var20_32) {
                                    var19_21 = var20_32;
                                    throw var20_32;
                                }
                                finally {
                                    if (rs != null) {
                                        if (var19_21 != null) {
                                            try {
                                                rs.close();
                                            }
                                            catch (Throwable var20_31) {
                                                var19_21.addSuppressed(var20_31);
                                            }
                                        } else {
                                            rs.close();
                                        }
                                    }
                                }
                            }
                        } else if (!TxnHandler.useMinHistoryLevel && stmt.executeUpdate(writeSetInsertSql + "FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\"=" + txnid + " AND \"TC_OPERATION_TYPE\" <> " + (Object)OperationType.COMPACT) > 0) {
                            commitIdRs = stmt.executeQuery("SELECT \"NTXN_NEXT\" - 1 FROM \"NEXT_TXN_ID\"");
                            var18_19 = null;
                            try {
                                if (!commitIdRs.next()) {
                                    throw new IllegalStateException("No rows found in NEXT_TXN_ID");
                                }
                                commitId = commitIdRs.getLong(1);
                            }
                            catch (Throwable var19_23) {
                                var18_19 = var19_23;
                                throw var19_23;
                            }
                            finally {
                                if (commitIdRs != null) {
                                    if (var18_19 != null) {
                                        try {
                                            commitIdRs.close();
                                        }
                                        catch (Throwable var19_22) {
                                            var18_19.addSuppressed(var19_22);
                                        }
                                    } else {
                                        commitIdRs.close();
                                    }
                                }
                            }
                        }
                    }
                    if (txnType != TxnType.READ_ONLY && !isReplayedReplTxn && !MetaStoreUtils.isCompactionTxn(txnType)) {
                        this.moveTxnComponentsToCompleted(stmt, txnid, isUpdateDelete);
                    } else if (isReplayedReplTxn) {
                        if (rqst.isSetWriteEventInfos()) {
                            sql = String.format("INSERT INTO \"COMPLETED_TXN_COMPONENTS\" (\"CTC_TXNID\", \"CTC_DATABASE\", \"CTC_TABLE\", \"CTC_PARTITION\", \"CTC_WRITEID\", \"CTC_UPDATE_DELETE\") VALUES (%s, ?, ?, ?, ?, %s)", new Object[]{txnid, TxnHandler.quoteChar(isUpdateDelete)});
                            pstmt = dbConn.prepareStatement(sql);
                            var18_19 = null;
                            try {
                                insertCounter = 0;
                                for (WriteEventInfo writeEventInfo : rqst.getWriteEventInfos()) {
                                    pstmt.setString(1, writeEventInfo.getDatabase());
                                    pstmt.setString(2, writeEventInfo.getTable());
                                    pstmt.setString(3, writeEventInfo.getPartition());
                                    pstmt.setLong(4, writeEventInfo.getWriteId());
                                    pstmt.addBatch();
                                    if (++insertCounter % this.maxBatchSize != 0) continue;
                                    TxnHandler.LOG.debug("Executing a batch of <{}> queries. Batch size: {}", (Object)sql, (Object)this.maxBatchSize);
                                    pstmt.executeBatch();
                                }
                                if (insertCounter % this.maxBatchSize != 0) {
                                    TxnHandler.LOG.debug("Executing a batch of <{}> queries. Batch size: {}", (Object)sql, (Object)(insertCounter % this.maxBatchSize));
                                    pstmt.executeBatch();
                                }
                            }
                            catch (Throwable var19_26) {
                                var18_19 = var19_26;
                                throw var19_26;
                            }
                            finally {
                                if (pstmt != null) {
                                    if (var18_19 != null) {
                                        try {
                                            pstmt.close();
                                        }
                                        catch (Throwable var19_25) {
                                            var18_19.addSuppressed(var19_25);
                                        }
                                    } else {
                                        pstmt.close();
                                    }
                                }
                            }
                        }
                        this.deleteReplTxnMapEntry(dbConn, sourceTxnId, rqst.getReplPolicy());
                    }
                    this.removeWriteIdsFromMinHistory(dbConn, (List<Long>)ImmutableList.of((Object)txnid));
                    this.updateCommitIdAndCleanUpMetadata(stmt, txnid, txnType, commitId, tempCommitId);
                    this.removeTxnsFromMinHistoryLevel(dbConn, (List<Long>)ImmutableList.of((Object)txnid));
                    if (rqst.isSetKeyValue()) {
                        this.updateKeyValueAssociatedWithTxn(rqst, stmt);
                    }
                    if (!isHiveReplTxn) {
                        this.createCommitNotificationEvent(dbConn, txnid, txnType);
                    }
                    TxnHandler.LOG.debug("Going to commit");
                    dbConn.commit();
                    if (!MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_EXT_ON)) break block97;
                    Metrics.getOrCreateCounter("total_num_committed_transactions").inc();
                }
                catch (SQLException e) {
                    try {
                        TxnHandler.LOG.debug("Going to rollback: ", (Throwable)e);
                        TxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(e, "commitTxn(" + rqst + ")");
                        throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                    }
                    catch (Throwable var30_46) {
                        TxnHandler.closeStmt(stmt);
                        TxnHandler.closeDbConn(dbConn);
                        this.unlockInternal();
                        throw var30_46;
                    }
                }
            }
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.commitTxn(rqst);
        }
    }

    protected void createCommitNotificationEvent(Connection dbConn, long txnid, TxnType txnType) throws MetaException, SQLException {
        if (this.transactionalListeners != null) {
            MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.COMMIT_TXN, new CommitTxnEvent((Long)txnid, txnType), dbConn, sqlGenerator);
        }
    }

    private boolean isUpdateOrDelete(Statement stmt, String conflictSQLSuffix) throws SQLException, MetaException {
        try (ResultSet rs = stmt.executeQuery(sqlGenerator.addLimitClause(1, "\"TC_OPERATION_TYPE\" " + conflictSQLSuffix));){
            boolean bl = rs.next();
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    private List<String> getTxnDbsUpdated(long txnId, Connection dbConn) throws MetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @RetrySemantics.ReadOnly
    public long getLatestTxnIdInConflict(long txnid) throws MetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ResultSet checkForWriteConflict(Statement stmt, long txnid) throws SQLException, MetaException {
        String writeConflictQuery = sqlGenerator.addLimitClause(1, "\"COMMITTED\".\"WS_TXNID\", \"COMMITTED\".\"WS_COMMIT_ID\", \"COMMITTED\".\"WS_DATABASE\", \"COMMITTED\".\"WS_TABLE\", \"COMMITTED\".\"WS_PARTITION\", \"CUR\".\"WS_COMMIT_ID\" \"CUR_WS_COMMIT_ID\", \"CUR\".\"WS_OPERATION_TYPE\" \"CUR_OP\", \"COMMITTED\".\"WS_OPERATION_TYPE\" \"COMMITTED_OP\" FROM \"WRITE_SET\" \"COMMITTED\" INNER JOIN \"WRITE_SET\" \"CUR\" ON \"COMMITTED\".\"WS_DATABASE\"=\"CUR\".\"WS_DATABASE\" AND \"COMMITTED\".\"WS_TABLE\"=\"CUR\".\"WS_TABLE\" AND (\"COMMITTED\".\"WS_PARTITION\"=\"CUR\".\"WS_PARTITION\" OR (\"COMMITTED\".\"WS_PARTITION\" IS NULL AND \"CUR\".\"WS_PARTITION\" IS NULL)) WHERE \"CUR\".\"WS_TXNID\" <= \"COMMITTED\".\"WS_COMMIT_ID\" AND \"CUR\".\"WS_TXNID\"=" + txnid + " AND \"COMMITTED\".\"WS_TXNID\" <> " + txnid + " and (\"COMMITTED\".\"WS_OPERATION_TYPE\" IN(" + (Object)((Object)OperationType.UPDATE) + ", " + (Object)((Object)OperationType.DELETE) + ") AND \"CUR\".\"WS_OPERATION_TYPE\" IN(" + (Object)((Object)OperationType.UPDATE) + ", " + (Object)((Object)OperationType.DELETE) + "))");
        LOG.debug("Going to execute query: <{}>", (Object)writeConflictQuery);
        return stmt.executeQuery(writeConflictQuery);
    }

    private void moveTxnComponentsToCompleted(Statement stmt, long txnid, char isUpdateDelete) throws SQLException {
        String s = "INSERT INTO \"COMPLETED_TXN_COMPONENTS\" (\"CTC_TXNID\", \"CTC_DATABASE\", \"CTC_TABLE\", \"CTC_PARTITION\", \"CTC_WRITEID\", \"CTC_UPDATE_DELETE\") SELECT \"TC_TXNID\", \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_WRITEID\", '" + isUpdateDelete + "' FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\" = " + txnid + " AND \"TC_OPERATION_TYPE\" <> " + (Object)((Object)OperationType.COMPACT);
        LOG.debug("Going to execute insert <{}>", (Object)s);
        if (stmt.executeUpdate(s) < 1) {
            LOG.info("Expected to move at least one record from txn_components to completed_txn_components when committing txn! {}", (Object)JavaUtils.txnIdToString(txnid));
        }
    }

    protected void updateCommitIdAndCleanUpMetadata(Statement stmt, long txnid, TxnType txnType, Long commitId, long tempId) throws SQLException, MetaException {
        ArrayList<String> queryBatch = new ArrayList<String>(5);
        if (commitId != null) {
            queryBatch.add("UPDATE \"WRITE_SET\" SET \"WS_COMMIT_ID\" = " + commitId + " WHERE \"WS_COMMIT_ID\" = " + tempId + " AND \"WS_TXNID\" = " + txnid);
        }
        if (txnType != TxnType.READ_ONLY) {
            queryBatch.add("DELETE FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\" = " + txnid);
        }
        queryBatch.add("DELETE FROM \"HIVE_LOCKS\" WHERE \"HL_TXNID\" = " + txnid);
        queryBatch.add("DELETE FROM \"TXNS\" WHERE \"TXN_ID\" = " + txnid);
        queryBatch.add("DELETE FROM \"MATERIALIZATION_REBUILD_LOCKS\" WHERE \"MRL_TXN_ID\" = " + txnid);
        TxnUtils.executeQueriesInBatchNoCount(dbProduct, stmt, queryBatch, this.maxBatchSize);
    }

    private void updateKeyValueAssociatedWithTxn(CommitTxnRequest rqst, Statement stmt) throws SQLException {
        if (!rqst.getKeyValue().getKey().startsWith("_meta")) {
            String errorMsg = "Error updating key/value in the sql backend with txnId=" + rqst.getTxnid() + ", tableId=" + rqst.getKeyValue().getTableId() + ", key=" + rqst.getKeyValue().getKey() + ", value=" + rqst.getKeyValue().getValue() + ". key should start with " + "_meta" + ".";
            LOG.warn(errorMsg);
            throw new IllegalArgumentException(errorMsg);
        }
        String s = "UPDATE \"TABLE_PARAMS\" SET \"PARAM_VALUE\" = " + TxnHandler.quoteString(rqst.getKeyValue().getValue()) + " WHERE \"TBL_ID\" = " + rqst.getKeyValue().getTableId() + " AND \"PARAM_KEY\" = " + TxnHandler.quoteString(rqst.getKeyValue().getKey());
        LOG.debug("Going to execute update <{}>", (Object)s);
        int affectedRows = stmt.executeUpdate(s);
        if (affectedRows != 1) {
            String errorMsg = "Error updating key/value in the sql backend with txnId=" + rqst.getTxnid() + ", tableId=" + rqst.getKeyValue().getTableId() + ", key=" + rqst.getKeyValue().getKey() + ", value=" + rqst.getKeyValue().getValue() + ". Only one row should have been affected but " + affectedRows + " rows where affected.";
            LOG.warn(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
    }

    @Override
    @RetrySemantics.Idempotent(value={"No-op if already replicated the writeid state"})
    public void replTableWriteIdState(ReplTblWriteIdStateRequest rqst) throws MetaException {
        String dbName = rqst.getDbName().toLowerCase();
        String tblName = rqst.getTableName().toLowerCase();
        ValidReaderWriteIdList validWriteIdList = new ValidReaderWriteIdList(rqst.getValidWriteIdlist());
        List<Long> abortedWriteIds = this.getAbortedWriteIds((ValidWriteIdList)validWriteIdList);
        int numAbortedWrites = abortedWriteIds.size();
        try {
            ResultSet rs;
            PreparedStatement pStmt;
            Statement stmt;
            Connection dbConn;
            block24: {
                Object sql;
                List<String> params;
                List<PreparedStatement> insertPreparedStmts;
                block22: {
                    block23: {
                        dbConn = null;
                        stmt = null;
                        pStmt = null;
                        insertPreparedStmts = null;
                        rs = null;
                        params = Arrays.asList(dbName, tblName);
                        this.lockInternal();
                        dbConn = this.getDbConn(2);
                        stmt = dbConn.createStatement();
                        sql = SELECT_NWI_NEXT_FROM_NEXT_WRITE_ID;
                        pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, (String)sql, params);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Going to execute query <" + ((String)sql).replace("?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                        }
                        if (!(rs = pStmt.executeQuery()).next()) break block22;
                        LOG.info("Idempotent flow: WriteId state <{}> is already applied for the table: {}.{}", new Object[]{validWriteIdList, dbName, tblName});
                        TxnHandler.rollbackDBConn(dbConn);
                        if (insertPreparedStmts == null) break block23;
                        for (PreparedStatement pst : insertPreparedStmts) {
                            TxnHandler.closeStmt(pst);
                        }
                    }
                    TxnHandler.closeStmt(pStmt);
                    TxnHandler.close(rs, stmt, dbConn);
                    this.unlockInternal();
                    return;
                }
                try {
                    if (numAbortedWrites > 0) {
                        List<Long> txnIds = this.openTxns(dbConn, stmt, new OpenTxnRequest(numAbortedWrites, rqst.getUser(), rqst.getHostName()));
                        assert (numAbortedWrites == txnIds.size());
                        ArrayList<String> rows = new ArrayList<String>();
                        ArrayList<List<String>> paramsList = new ArrayList<List<String>>();
                        int i = 0;
                        Iterator<Object> iterator = txnIds.iterator();
                        while (iterator.hasNext()) {
                            long txn = iterator.next();
                            long writeId = abortedWriteIds.get(i++);
                            rows.add(txn + ", ?, ?, " + writeId);
                            paramsList.add(params);
                            LOG.info("Allocated writeID: {} for txnId: {}", (Object)writeId, (Object)txn);
                        }
                        insertPreparedStmts = sqlGenerator.createInsertValuesPreparedStmt(dbConn, "\"TXN_TO_WRITE_ID\" (\"T2W_TXNID\", \"T2W_DATABASE\", \"T2W_TABLE\", \"T2W_WRITEID\")", rows, paramsList);
                        for (PreparedStatement pst : insertPreparedStmts) {
                            pst.execute();
                        }
                        int numAborts = this.abortTxns(dbConn, txnIds, false, false, TxnErrorMsg.ABORT_REPL_WRITEID_TXN);
                        assert (numAborts == numAbortedWrites);
                    }
                    long nextWriteId = validWriteIdList.getHighWatermark() + 1L;
                    sql = "INSERT INTO \"NEXT_WRITE_ID\" (\"NWI_DATABASE\", \"NWI_TABLE\", \"NWI_NEXT\") VALUES (?, ?, " + Long.toString(nextWriteId) + ")";
                    TxnHandler.closeStmt(pStmt);
                    pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, (String)sql, params);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Going to execute insert <" + ((String)sql).replace("?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                    }
                    pStmt.execute();
                    LOG.info("WriteId state <{}> is applied for the table: {}.{}", new Object[]{validWriteIdList, dbName, tblName});
                    LOG.debug("Going to commit");
                    dbConn.commit();
                    if (insertPreparedStmts == null) break block24;
                }
                catch (SQLException e) {
                    try {
                        LOG.debug("Going to rollback: ", (Throwable)e);
                        TxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(e, "replTableWriteIdState(" + rqst + ")", true);
                        throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                    }
                    catch (Throwable throwable) {
                        if (insertPreparedStmts != null) {
                            for (PreparedStatement pst : insertPreparedStmts) {
                                TxnHandler.closeStmt(pst);
                            }
                        }
                        TxnHandler.closeStmt(pStmt);
                        TxnHandler.close(rs, stmt, dbConn);
                        this.unlockInternal();
                        throw throwable;
                    }
                }
                for (PreparedStatement pst : insertPreparedStmts) {
                    TxnHandler.closeStmt(pst);
                }
            }
            TxnHandler.closeStmt(pStmt);
            TxnHandler.close(rs, stmt, dbConn);
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.replTableWriteIdState(rqst);
        }
        if (numAbortedWrites > 0) {
            CompactionRequest compactRqst = new CompactionRequest(rqst.getDbName(), rqst.getTableName(), CompactionType.MAJOR);
            if (rqst.isSetPartNames()) {
                for (String partName : rqst.getPartNames()) {
                    compactRqst.setPartitionname(partName);
                    this.compact(compactRqst);
                }
            } else {
                this.compact(compactRqst);
            }
        }
    }

    private List<Long> getAbortedWriteIds(ValidWriteIdList validWriteIdList) {
        return Arrays.stream(validWriteIdList.getInvalidWriteIds()).filter(arg_0 -> ((ValidWriteIdList)validWriteIdList).isWriteIdAborted(arg_0)).boxed().collect(Collectors.toList());
    }

    private ValidTxnList getValidTxnList(Connection dbConn, String fullTableName, Long writeId) throws MetaException, SQLException {
        block5: {
            ValidTxnList validTxnList;
            PreparedStatement pst = null;
            ResultSet rs = null;
            try {
                String[] names = TxnUtils.getDbTableName(fullTableName);
                assert (names.length == 2);
                String s = "SELECT \"T2W_TXNID\" FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ? AND \"T2W_WRITEID\" = ?";
                pst = dbConn.prepareStatement(sqlGenerator.addEscapeCharacters(s));
                pst.setString(1, names[0]);
                pst.setString(2, names[1]);
                pst.setLong(3, writeId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Going to execute query <" + s.replace("?", "{}") + ">", new Object[]{TxnHandler.quoteString(names[0]), TxnHandler.quoteString(names[1]), writeId});
                }
                if (!(rs = pst.executeQuery()).next()) break block5;
                long txnId = rs.getLong(1);
                validTxnList = TxnUtils.createValidReadTxnList(this.getOpenTxns(), txnId);
            }
            catch (Throwable throwable) {
                TxnHandler.close(rs, pst, null);
                throw throwable;
            }
            TxnHandler.close(rs, pst, null);
            return validTxnList;
        }
        throw new MetaException("invalid write id " + writeId + " for table " + fullTableName);
    }

    @Override
    @RetrySemantics.ReadOnly
    public GetValidWriteIdsResponse getValidWriteIds(GetValidWriteIdsRequest rqst) throws MetaException {
        GetValidWriteIdsResponse getValidWriteIdsResponse;
        Connection dbConn = null;
        Object validTxnList = rqst.isSetValidTxnList() ? new ValidReadTxnList(rqst.getValidTxnList()) : TxnUtils.createValidReadTxnList(this.getOpenTxns(), 0L);
        try {
            GetValidWriteIdsResponse owr;
            dbConn = this.getDbConn(2);
            if (rqst.isSetValidTxnList()) {
                assert (!rqst.isSetWriteId());
                validTxnList = new ValidReadTxnList(rqst.getValidTxnList());
            } else {
                validTxnList = rqst.isSetWriteId() ? this.getValidTxnList(dbConn, rqst.getFullTableNames().get(0), rqst.getWriteId()) : TxnUtils.createValidReadTxnList(this.getOpenTxns(dbConn), 0L);
            }
            ArrayList<TableValidWriteIds> tblValidWriteIdsList = new ArrayList<TableValidWriteIds>();
            for (String fullTableName : rqst.getFullTableNames()) {
                tblValidWriteIdsList.add(this.getValidWriteIdsForTable(dbConn, fullTableName, (ValidTxnList)validTxnList));
            }
            getValidWriteIdsResponse = owr = new GetValidWriteIdsResponse(tblValidWriteIdsList);
        }
        catch (SQLException e) {
            try {
                try {
                    this.checkRetryable(e, "getValidWriteIds");
                    throw new MetaException("Unable to select from transaction database, " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getValidWriteIds(rqst);
            }
        }
        TxnHandler.closeDbConn(dbConn);
        return getValidWriteIdsResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableValidWriteIds getValidWriteIdsForTable(Connection dbConn, String fullTableName, ValidTxnList validTxnList) throws SQLException {
        TableValidWriteIds tableValidWriteIds;
        PreparedStatement pst = null;
        ResultSet rs = null;
        String[] names = TxnUtils.getDbTableName(fullTableName);
        assert (names.length == 2);
        List<String> params = Arrays.asList(names[0], names[1]);
        try {
            long writeIdHwm = 0L;
            ArrayList<Long> invalidWriteIdList = new ArrayList<Long>();
            long minOpenWriteId = Long.MAX_VALUE;
            BitSet abortedBits = new BitSet();
            long txnHwm = validTxnList.getHighWatermark();
            String s = "SELECT MAX(\"T2W_WRITEID\") FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_TXNID\" <= " + txnHwm + " AND \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ?";
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to execute query<" + s.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(names[0]), (Object)TxnHandler.quoteString(names[1]));
            }
            if ((rs = pst.executeQuery()).next()) {
                writeIdHwm = rs.getLong(1);
            }
            if (writeIdHwm <= 0L) {
                s = "SELECT \"NWI_NEXT\"-1 FROM \"NEXT_WRITE_ID\" WHERE \"NWI_DATABASE\" = ? AND \"NWI_TABLE\" = ?";
                TxnHandler.closeStmt(pst);
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Going to execute query<" + s.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(names[0]), (Object)TxnHandler.quoteString(names[1]));
                }
                if ((rs = pst.executeQuery()).next()) {
                    writeIdHwm = rs.getLong(1);
                }
            }
            boolean foundValidUncompactedWrite = false;
            s = "SELECT \"T2W_TXNID\", \"T2W_WRITEID\" FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_WRITEID\" <= " + Long.toString(writeIdHwm) + " AND \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ? ORDER BY \"T2W_WRITEID\" ASC";
            TxnHandler.closeStmt(pst);
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to execute query<" + s.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(names[0]), (Object)TxnHandler.quoteString(names[1]));
            }
            rs = pst.executeQuery();
            while (rs.next()) {
                long txnId = rs.getLong(1);
                long writeId = rs.getLong(2);
                if (validTxnList.isTxnValid(txnId)) {
                    foundValidUncompactedWrite = true;
                    continue;
                }
                invalidWriteIdList.add(writeId);
                if (validTxnList.isTxnAborted(txnId)) {
                    abortedBits.set(invalidWriteIdList.size() - 1);
                    continue;
                }
                minOpenWriteId = Math.min(minOpenWriteId, writeId);
            }
            if (!foundValidUncompactedWrite) {
                long writeId = invalidWriteIdList.isEmpty() ? -1L : (Long)invalidWriteIdList.get(0);
                invalidWriteIdList = new ArrayList();
                abortedBits = new BitSet();
                if (writeId != -1L) {
                    invalidWriteIdList.add(writeId);
                    writeIdHwm = writeId;
                    if (writeId != minOpenWriteId) {
                        abortedBits.set(0);
                    }
                }
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(abortedBits.toByteArray());
            TableValidWriteIds owi = new TableValidWriteIds(fullTableName, writeIdHwm, invalidWriteIdList, byteBuffer);
            if (minOpenWriteId < Long.MAX_VALUE) {
                owi.setMinOpenWriteId(minOpenWriteId);
            }
            tableValidWriteIds = owi;
        }
        catch (Throwable throwable) {
            TxnHandler.closeStmt(pst);
            TxnHandler.close(rs);
            throw throwable;
        }
        TxnHandler.closeStmt(pst);
        TxnHandler.close(rs);
        return tableValidWriteIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.Idempotent
    public AllocateTableWriteIdsResponse allocateTableWriteIds(AllocateTableWriteIdsRequest rqst) throws MetaException {
        String dbName = rqst.getDbName().toLowerCase();
        String tblName = rqst.getTableName().toLowerCase();
        boolean shouldReallocate = rqst.isReallocate();
        try {
            AllocateTableWriteIdsResponse allocateTableWriteIdsResponse;
            Connection dbConn = null;
            PreparedStatement pStmt = null;
            ResultSet rs = null;
            ArrayList<TxnToWriteId> txnToWriteIds = new ArrayList<TxnToWriteId>();
            List<TxnToWriteId> srcTxnToWriteIds = null;
            try {
                long writeId;
                Object object;
                List<Long> txnIds;
                this.lockInternal();
                dbConn = this.getDbConn(2);
                if (rqst.isSetReplPolicy()) {
                    srcTxnToWriteIds = rqst.getSrcTxnToWriteIdList();
                    ArrayList<Long> srcTxnIds = new ArrayList<Long>();
                    assert (rqst.isSetSrcTxnToWriteIdList());
                    assert (!rqst.isSetTxnIds());
                    assert (!srcTxnToWriteIds.isEmpty());
                    for (TxnToWriteId txnToWriteId : srcTxnToWriteIds) {
                        srcTxnIds.add(txnToWriteId.getTxnId());
                    }
                    txnIds = this.getTargetTxnIdList(rqst.getReplPolicy(), srcTxnIds, dbConn);
                    if (srcTxnIds.size() != txnIds.size()) {
                        LOG.info("Idempotent case: Target txn id is missing for source txn id : {} and repl policy {}", srcTxnIds, (Object)rqst.getReplPolicy());
                        object = new AllocateTableWriteIdsResponse(txnToWriteIds);
                        return object;
                    }
                } else {
                    assert (!rqst.isSetSrcTxnToWriteIdList());
                    assert (rqst.isSetTxnIds());
                    txnIds = rqst.getTxnIds();
                }
                if (txnIds.size() > 1) {
                    Collections.sort(txnIds);
                }
                Statement stmt = dbConn.createStatement();
                object = null;
                try {
                    if (!this.isTxnsOpenAndNotReadOnly(txnIds, stmt)) {
                        String errorMsg = "Write ID allocation on " + TableName.getDbTable((String)dbName, (String)tblName) + " failed for input txns: " + this.getAbortedAndReadOnlyTxns(txnIds, stmt) + this.getCommittedTxns(txnIds, stmt);
                        LOG.error(errorMsg);
                        throw new IllegalStateException("Write ID allocation failed on " + TableName.getDbTable((String)dbName, (String)tblName) + " as not all input txns in open state or read-only");
                    }
                }
                catch (Throwable errorMsg) {
                    object = errorMsg;
                    throw errorMsg;
                }
                finally {
                    if (stmt != null) {
                        if (object != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable errorMsg) {
                                ((Throwable)object).addSuppressed(errorMsg);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
                ArrayList<String> queries = new ArrayList<String>();
                StringBuilder prefix = new StringBuilder();
                StringBuilder suffix = new StringBuilder();
                int allocatedTxnsCount = 0;
                List<String> params = Arrays.asList(dbName, tblName);
                if (shouldReallocate) {
                    prefix.append("DELETE FROM \"TXN_TO_WRITE_ID\" WHERE").append(" \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ? AND ");
                    TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnIds, "\"T2W_TXNID\"", false, false);
                    for (String query : queries) {
                        pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Going to execute delete <" + query.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                        }
                        int numRowsDeleted = pStmt.executeUpdate();
                        LOG.info("Removed {} prior writeIds during reallocation", (Object)numRowsDeleted);
                        TxnHandler.closeStmt(pStmt);
                    }
                } else {
                    prefix.append("SELECT \"T2W_TXNID\", \"T2W_WRITEID\" FROM \"TXN_TO_WRITE_ID\" WHERE").append(" \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ? AND ");
                    TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnIds, "\"T2W_TXNID\"", false, false);
                    for (String query : queries) {
                        pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, query, params);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Going to execute query <" + query.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                        }
                        rs = pStmt.executeQuery();
                        while (rs.next()) {
                            long txnId = rs.getLong(1);
                            writeId = rs.getLong(2);
                            txnToWriteIds.add(new TxnToWriteId(txnId, writeId));
                            ++allocatedTxnsCount;
                            LOG.info("Reused already allocated writeID: {} for txnId: {}", (Object)writeId, (Object)txnId);
                        }
                        TxnHandler.closeStmt(pStmt);
                    }
                }
                long numOfWriteIds = txnIds.size();
                assert (allocatedTxnsCount == 0 || numOfWriteIds == (long)allocatedTxnsCount);
                if ((long)allocatedTxnsCount == numOfWriteIds) {
                    AllocateTableWriteIdsResponse txnId = new AllocateTableWriteIdsResponse(txnToWriteIds);
                    TxnHandler.close(rs, pStmt, dbConn);
                    this.unlockInternal();
                    return txnId;
                }
                long srcWriteId = 0L;
                if (rqst.isSetReplPolicy()) {
                    assert (srcTxnToWriteIds != null);
                    srcWriteId = srcTxnToWriteIds.get(0).getWriteId();
                }
                String s = sqlGenerator.addForUpdateClause(SELECT_NWI_NEXT_FROM_NEXT_WRITE_ID);
                TxnHandler.closeStmt(pStmt);
                pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Going to execute query <" + s.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                }
                if (!(rs = pStmt.executeQuery()).next()) {
                    writeId = srcWriteId > 0L ? srcWriteId : 1L;
                    s = "INSERT INTO \"NEXT_WRITE_ID\" (\"NWI_DATABASE\", \"NWI_TABLE\", \"NWI_NEXT\") VALUES (?, ?, " + (writeId + numOfWriteIds) + ")";
                    TxnHandler.closeStmt(pStmt);
                    pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Going to execute insert <" + s.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                    }
                    pStmt.execute();
                } else {
                    long nextWriteId = rs.getLong(1);
                    writeId = srcWriteId > 0L ? srcWriteId : nextWriteId;
                    s = "UPDATE \"NEXT_WRITE_ID\" SET \"NWI_NEXT\" = " + (writeId + numOfWriteIds) + " WHERE \"NWI_DATABASE\" = ? AND \"NWI_TABLE\" = ?";
                    TxnHandler.closeStmt(pStmt);
                    pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Going to execute update <" + s.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                    }
                    pStmt.executeUpdate();
                    if (srcWriteId > 0L && srcWriteId != nextWriteId) {
                        s = "DELETE FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ?";
                        TxnHandler.closeStmt(pStmt);
                        pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Going to execute delete <" + s.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
                        }
                        pStmt.executeUpdate();
                    }
                }
                try (PreparedStatement pstmt = dbConn.prepareStatement(TXN_TO_WRITE_ID_INSERT_QUERY);){
                    for (long txnId : txnIds) {
                        pstmt.setLong(1, txnId);
                        pstmt.setString(2, dbName);
                        pstmt.setString(3, tblName);
                        pstmt.setLong(4, writeId);
                        pstmt.addBatch();
                        txnToWriteIds.add(new TxnToWriteId(txnId, writeId));
                        LOG.info("Allocated writeId: {} for txnId: {}", (Object)writeId, (Object)txnId);
                        ++writeId;
                        if (txnToWriteIds.size() % this.maxBatchSize != 0) continue;
                        LOG.debug("Executing a batch of <{}> queries. Batch size: {}", (Object)TXN_TO_WRITE_ID_INSERT_QUERY, (Object)this.maxBatchSize);
                        pstmt.executeBatch();
                    }
                    if (txnToWriteIds.size() % this.maxBatchSize != 0) {
                        LOG.debug("Executing a batch of <{}> queries. Batch size: {}", (Object)TXN_TO_WRITE_ID_INSERT_QUERY, (Object)(txnToWriteIds.size() % this.maxBatchSize));
                        pstmt.executeBatch();
                    }
                }
                if (this.transactionalListeners != null) {
                    MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.ALLOC_WRITE_ID, new AllocWriteIdEvent(txnToWriteIds, dbName, tblName), dbConn, sqlGenerator);
                }
                LOG.info("Allocated write ids for dbName={}, tblName={} (txnIds: {})", new Object[]{dbName, tblName, rqst.getTxnIds()});
                dbConn.commit();
                allocateTableWriteIdsResponse = new AllocateTableWriteIdsResponse(txnToWriteIds);
                TxnHandler.close(rs, pStmt, dbConn);
            }
            catch (SQLException e) {
                LOG.error("Exception during write ids allocation for request={}. Will retry if possible.", (Object)rqst, (Object)e);
                TxnHandler.rollbackDBConn(dbConn);
                this.checkRetryable(e, "allocateTableWriteIds(" + rqst + ")", true);
                throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            }
            this.unlockInternal();
            return allocateTableWriteIdsResponse;
            finally {
                TxnHandler.close(rs, pStmt, dbConn);
                this.unlockInternal();
            }
        }
        catch (RetryException e) {
            return this.allocateTableWriteIds(rqst);
        }
    }

    @Override
    public MaxAllocatedTableWriteIdResponse getMaxAllocatedTableWrited(MaxAllocatedTableWriteIdRequest rqst) throws MetaException {
        MaxAllocatedTableWriteIdResponse maxAllocatedTableWriteIdResponse;
        String dbName = rqst.getDbName();
        String tableName = rqst.getTableName();
        Connection dbConn = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            pStmt = sqlGenerator.prepareStmtWithParameters(dbConn, SELECT_NWI_NEXT_FROM_NEXT_WRITE_ID, Arrays.asList(dbName, tableName));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to execute query <" + SELECT_NWI_NEXT_FROM_NEXT_WRITE_ID.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tableName));
            }
            rs = pStmt.executeQuery();
            long maxWriteId = 0L;
            if (rs.next()) {
                maxWriteId = rs.getLong(1) - 1L;
            }
            maxAllocatedTableWriteIdResponse = new MaxAllocatedTableWriteIdResponse(maxWriteId);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.error("Exception during reading the max allocated writeId for dbName={}, tableName={}. Will retry if possible.", new Object[]{dbName, tableName, e});
                    this.checkRetryable(e, "getMaxAllocatedTableWrited(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(rs, pStmt, dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getMaxAllocatedTableWrited(rqst);
            }
        }
        TxnHandler.close(rs, pStmt, dbConn);
        return maxAllocatedTableWriteIdResponse;
    }

    @Override
    public void seedWriteId(SeedTableWriteIdsRequest rqst) throws MetaException {
        try {
            Connection dbConn = null;
            PreparedStatement pst = null;
            try {
                dbConn = this.getDbConn(2);
                String s = "INSERT INTO \"NEXT_WRITE_ID\" (\"NWI_DATABASE\", \"NWI_TABLE\", \"NWI_NEXT\") VALUES (?, ?, " + Long.toString(rqst.getSeedWriteId() + 1L) + ")";
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, Arrays.asList(rqst.getDbName(), rqst.getTableName()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Going to execute insert <" + s.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(rqst.getDbName()), (Object)TxnHandler.quoteString(rqst.getTableName()));
                }
                pst.execute();
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "seedWriteId(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, pst, dbConn);
                    throw throwable;
                }
            }
            TxnHandler.close(null, pst, dbConn);
        }
        catch (RetryException e) {
            this.seedWriteId(rqst);
        }
    }

    @Override
    public void seedTxnId(SeedTxnIdRequest rqst) throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                this.lockInternal();
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                String s = sqlGenerator.addForUpdateClause("SELECT \"NTXN_NEXT\" -1 FROM \"NEXT_TXN_ID\"");
                LOG.debug("Going to execute query <{}>", (Object)s);
                rs = stmt.executeQuery(s);
                if (!rs.next()) {
                    throw new MetaException("Transaction database not properly configured, can't find next transaction id.");
                }
                long highWaterMark = rs.getLong(1);
                if (highWaterMark >= rqst.getSeedTxnId()) {
                    throw new MetaException(MessageFormat.format("Invalid txnId seed {}, the highWaterMark is {}", rqst.getSeedTxnId(), highWaterMark));
                }
                TxnUtils.seedTxnSequence(dbConn, stmt, rqst.getSeedTxnId());
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "seedTxnId(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(rs, stmt, dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.close(rs, stmt, dbConn);
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.seedTxnId(rqst);
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void addWriteNotificationLog(ListenerEvent acidWriteEvent) throws MetaException {
        Connection dbConn = null;
        try {
            try {
                this.lockInternal();
                dbConn = this.getDbConn(2);
                MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, acidWriteEvent instanceof AcidWriteEvent ? EventMessage.EventType.ACID_WRITE : EventMessage.EventType.BATCH_ACID_WRITE, acidWriteEvent, dbConn, sqlGenerator);
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback: ", (Throwable)e);
                    TxnHandler.rollbackDBConn(dbConn);
                    if (this.isDuplicateKeyError(e)) {
                        if (this.waitForRetry("addWriteNotificationLog(" + acidWriteEvent + ")", e.getMessage())) {
                            throw new RetryException();
                        }
                        this.retryNum = 0;
                        throw new MetaException(e.getMessage());
                    }
                    this.checkRetryable(e, "addWriteNotificationLog(" + acidWriteEvent + ")");
                    throw new MetaException("Unable to add write notification event " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.closeDbConn(dbConn);
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.addWriteNotificationLog(acidWriteEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.SafeToRetry
    public void performWriteSetGC() {
        Connection dbConn = null;
        Statement stmt = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            long commitHighWaterMark = this.getMinOpenTxnIdWaterMark(dbConn);
            int delCnt = stmt.executeUpdate("DELETE FROM \"WRITE_SET\" WHERE \"WS_COMMIT_ID\" < " + commitHighWaterMark);
            LOG.info("Deleted " + delCnt + " obsolete rows from WRTIE_SET");
            dbConn.commit();
        }
        catch (SQLException ex) {
            try {
                LOG.warn("WriteSet GC failed due to " + TxnHandler.getMessage(ex), (Throwable)ex);
            }
            catch (Throwable throwable) {
                TxnHandler.close(null, stmt, dbConn);
                throw throwable;
            }
            TxnHandler.close(null, stmt, dbConn);
        }
        TxnHandler.close(null, stmt, dbConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getMinOpenTxnIdWaterMark(Connection dbConn) throws SQLException {
        long commitHighWaterMark;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.createStatement();
            rs = stmt.executeQuery("SELECT \"NTXN_NEXT\" - 1 FROM \"NEXT_TXN_ID\"");
            if (!rs.next()) {
                throw new IllegalStateException("NEXT_TXN_ID is empty: DB is corrupted");
            }
            long highestAllocatedTxnId = rs.getLong(1);
            TxnHandler.close(rs);
            rs = stmt.executeQuery("SELECT MIN(\"TXN_ID\") FROM \"TXNS\" WHERE \"TXN_STATE\"=" + (Object)((Object)TxnStatus.OPEN));
            if (!rs.next()) {
                throw new IllegalStateException("Scalar query returned no rows?!?!!");
            }
            long lowestOpenTxnId = rs.getLong(1);
            commitHighWaterMark = rs.wasNull() ? highestAllocatedTxnId + 1L : lowestOpenTxnId;
        }
        catch (Throwable throwable) {
            TxnHandler.close(rs, stmt, null);
            throw throwable;
        }
        TxnHandler.close(rs, stmt, null);
        return commitHighWaterMark;
    }

    @Override
    public void updateTransactionStatistics(UpdateTransactionalStatsRequest req) throws MetaException {
        String queryText = "UPDATE \"MV_TABLES_USED\" SET \"INSERTED_COUNT\"=\"INSERTED_COUNT\"+?,\"UPDATED_COUNT\"=\"UPDATED_COUNT\"+?,\"DELETED_COUNT\"=\"DELETED_COUNT\"+? WHERE \"TBL_ID\"=?";
        try (Connection dbConn = this.getDbConn(2);
             PreparedStatement pstmt = dbConn.prepareStatement(queryText);){
            pstmt.setLong(1, req.getInsertCount());
            pstmt.setLong(2, req.getUpdatedCount());
            pstmt.setLong(3, req.getDeletedCount());
            pstmt.setLong(4, req.getTableId());
            LOG.debug("Going to execute query <{}>", (Object)queryText);
            int res = pstmt.executeUpdate();
            dbConn.commit();
            LOG.debug("Updated {} records tblId={}", (Object)res, (Object)req.getTableId());
        }
        catch (SQLException ex) {
            LOG.warn("Unable to update transactional statistics tblId=" + req.getTableId(), (Throwable)ex);
            throw new MetaException("Unable to update transactional statistics " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
        }
    }

    @Override
    public Materialization getMaterializationInvalidationInfo(CreationMetadata creationMetadata, String validTxnListStr) throws MetaException {
        if (creationMetadata.getTablesUsed().isEmpty()) {
            LOG.warn("Materialization creation metadata does not contain any table");
            return null;
        }
        MaterializationSnapshot mvSnapshot = MaterializationSnapshot.fromJson((String)creationMetadata.getValidTxnList());
        if (mvSnapshot.getTableSnapshots() != null && !mvSnapshot.getTableSnapshots().isEmpty()) {
            return null;
        }
        ValidTxnWriteIdList validReaderWriteIdList = new ValidTxnWriteIdList(mvSnapshot.getValidTxnList());
        ValidReadTxnList currentValidTxnList = new ValidReadTxnList(validTxnListStr);
        ArrayList<TableValidWriteIds> currentTblValidWriteIdsList = new ArrayList<TableValidWriteIds>();
        Connection dbConn = null;
        for (String fullTableName : creationMetadata.getTablesUsed()) {
            try {
                dbConn = this.getDbConn(2);
                currentTblValidWriteIdsList.add(this.getValidWriteIdsForTable(dbConn, fullTableName, (ValidTxnList)currentValidTxnList));
            }
            catch (SQLException ex) {
                String errorMsg = "Unable to query Valid writeIds of table " + fullTableName;
                LOG.warn(errorMsg, (Throwable)ex);
                throw new MetaException(errorMsg + " " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
            }
            finally {
                TxnHandler.closeDbConn(dbConn);
            }
        }
        ValidTxnWriteIdList currentValidReaderWriteIdList = TxnUtils.createValidTxnWriteIdList(currentValidTxnList.getHighWatermark(), currentTblValidWriteIdsList);
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder queryUpdateDelete = new StringBuilder();
        StringBuilder queryCompletedCompactions = new StringBuilder();
        StringBuilder queryCompactionQueue = new StringBuilder();
        queryUpdateDelete.append("SELECT \"CTC_UPDATE_DELETE\" FROM \"COMPLETED_TXN_COMPONENTS\" WHERE \"CTC_UPDATE_DELETE\" ='Y' AND (");
        queryCompletedCompactions.append("SELECT 1 FROM \"COMPLETED_COMPACTIONS\" WHERE (");
        queryCompactionQueue.append("SELECT 1 FROM \"COMPACTION_QUEUE\" WHERE (");
        int i = 0;
        for (String fullyQualifiedName : creationMetadata.getTablesUsed()) {
            ValidWriteIdList tblValidWriteIdList = validReaderWriteIdList.getTableValidWriteIdList(fullyQualifiedName);
            if (tblValidWriteIdList == null) {
                LOG.warn("ValidWriteIdList for table {} not present in creation metadata, this should not happen", (Object)fullyQualifiedName);
                return null;
            }
            ValidWriteIdList currentTblValidWriteIdList = currentValidReaderWriteIdList.getTableValidWriteIdList(fullyQualifiedName);
            if (currentTblValidWriteIdList == null) {
                LOG.warn("Current ValidWriteIdList for table {} not present in creation metadata, this should not happen", (Object)fullyQualifiedName);
                return null;
            }
            if (!Objects.equals(currentTblValidWriteIdList.getMinOpenWriteId(), tblValidWriteIdList.getMinOpenWriteId())) {
                LOG.debug("Minimum open write id do not match for table {}", (Object)fullyQualifiedName);
                return null;
            }
            if (i != 0) {
                queryUpdateDelete.append("OR");
                queryCompletedCompactions.append("OR");
                queryCompactionQueue.append("OR");
            }
            String[] names = TxnUtils.getDbTableName(fullyQualifiedName);
            assert (names.length == 2);
            queryUpdateDelete.append(" (\"CTC_DATABASE\"=? AND \"CTC_TABLE\"=?");
            queryCompletedCompactions.append(" (\"CC_DATABASE\"=? AND \"CC_TABLE\"=?");
            queryCompactionQueue.append(" (\"CQ_DATABASE\"=? AND \"CQ_TABLE\"=?");
            params.add(names[0]);
            params.add(names[1]);
            queryUpdateDelete.append(" AND (\"CTC_WRITEID\" > " + tblValidWriteIdList.getHighWatermark());
            queryCompletedCompactions.append(" AND (\"CC_HIGHEST_WRITE_ID\" > " + tblValidWriteIdList.getHighWatermark());
            queryUpdateDelete.append(tblValidWriteIdList.getInvalidWriteIds().length == 0 ? ") " : " OR \"CTC_WRITEID\" IN(" + org.apache.hadoop.util.StringUtils.join((CharSequence)",", Arrays.asList(ArrayUtils.toObject((long[])tblValidWriteIdList.getInvalidWriteIds()))) + ") ) ");
            queryCompletedCompactions.append(tblValidWriteIdList.getInvalidWriteIds().length == 0 ? ") " : " OR \"CC_HIGHEST_WRITE_ID\" IN(" + org.apache.hadoop.util.StringUtils.join((CharSequence)",", Arrays.asList(ArrayUtils.toObject((long[])tblValidWriteIdList.getInvalidWriteIds()))) + ") ) ");
            queryUpdateDelete.append(") ");
            queryCompletedCompactions.append(") ");
            queryCompactionQueue.append(") ");
            ++i;
        }
        queryUpdateDelete.append(") AND \"CTC_TXNID\" <= " + currentValidTxnList.getHighWatermark());
        queryUpdateDelete.append(currentValidTxnList.getInvalidTransactions().length == 0 ? " " : " AND \"CTC_TXNID\" NOT IN(" + org.apache.hadoop.util.StringUtils.join((CharSequence)",", Arrays.asList(ArrayUtils.toObject((long[])currentValidTxnList.getInvalidTransactions()))) + ") ");
        queryCompletedCompactions.append(")");
        queryCompactionQueue.append(") ");
        boolean hasUpdateDelete = this.executeBoolean(queryUpdateDelete.toString(), params, "Unable to retrieve materialization invalidation information: completed transaction components.");
        queryCompletedCompactions.append(" UNION ");
        queryCompletedCompactions.append(queryCompactionQueue.toString());
        ArrayList<String> paramsTwice = new ArrayList<String>(params);
        paramsTwice.addAll(params);
        boolean hasCompaction = this.executeBoolean(queryCompletedCompactions.toString(), paramsTwice, "Unable to retrieve materialization invalidation information: compactions");
        return new Materialization(hasUpdateDelete, hasCompaction);
    }

    private boolean executeBoolean(String queryText, List<String> params, String errorMessage) throws MetaException {
        boolean bl;
        Connection dbConn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            LOG.debug("Going to execute query <{}>", (Object)queryText);
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, queryText, params);
            pst.setMaxRows(1);
            rs = pst.executeQuery();
            bl = rs.next();
        }
        catch (SQLException ex) {
            try {
                LOG.warn(errorMessage, (Throwable)ex);
                throw new MetaException(errorMessage + " " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
            }
            catch (Throwable throwable) {
                TxnHandler.close(rs, pst, dbConn);
                throw throwable;
            }
        }
        TxnHandler.close(rs, pst, dbConn);
        return bl;
    }

    @Override
    public LockResponse lockMaterializationRebuild(String dbName, String tableName, long txnId) throws MetaException {
        LockResponse lockResponse;
        List<String> params;
        ResultSet rs;
        PreparedStatement pst;
        Connection dbConn;
        TxnStore.MutexAPI.LockHandle handle;
        block11: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Acquiring lock for materialization rebuild with txnId={} for {}", (Object)JavaUtils.txnIdToString(txnId), (Object)TableName.getDbTable((String)dbName, (String)tableName));
            }
            handle = null;
            dbConn = null;
            pst = null;
            rs = null;
            this.lockInternal();
            handle = this.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.MaterializationRebuild.name());
            dbConn = this.getDbConn(2);
            params = Arrays.asList(dbName, tableName);
            String selectQ = "SELECT \"MRL_TXN_ID\" FROM \"MATERIALIZATION_REBUILD_LOCKS\" WHERE \"MRL_DB_NAME\" = ? AND \"MRL_TBL_NAME\" = ?";
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, selectQ, params);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to execute query <" + selectQ.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tableName));
            }
            if (!(rs = pst.executeQuery()).next()) break block11;
            LOG.info("Ignoring request to rebuild {}/{} since it is already being rebuilt", (Object)dbName, (Object)tableName);
            LockResponse lockResponse2 = new LockResponse(txnId, LockState.NOT_ACQUIRED);
            TxnHandler.close(rs, pst, dbConn);
            if (handle != null) {
                handle.releaseLocks();
            }
            this.unlockInternal();
            return lockResponse2;
        }
        try {
            String insertQ = "INSERT INTO \"MATERIALIZATION_REBUILD_LOCKS\" (\"MRL_TXN_ID\", \"MRL_DB_NAME\", \"MRL_TBL_NAME\", \"MRL_LAST_HEARTBEAT\") VALUES (" + txnId + ", ?, ?, " + Instant.now().toEpochMilli() + ")";
            TxnHandler.closeStmt(pst);
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, insertQ, params);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to execute update <" + insertQ.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tableName));
            }
            pst.executeUpdate();
            LOG.debug("Going to commit");
            dbConn.commit();
            lockResponse = new LockResponse(txnId, LockState.ACQUIRED);
        }
        catch (SQLException ex) {
            try {
                LOG.warn("lockMaterializationRebuild failed due to " + TxnHandler.getMessage(ex), (Throwable)ex);
                throw new MetaException("Unable to retrieve materialization invalidation information due to " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
            }
            catch (Throwable throwable) {
                TxnHandler.close(rs, pst, dbConn);
                if (handle != null) {
                    handle.releaseLocks();
                }
                this.unlockInternal();
                throw throwable;
            }
        }
        TxnHandler.close(rs, pst, dbConn);
        if (handle != null) {
            handle.releaseLocks();
        }
        this.unlockInternal();
        return lockResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean heartbeatLockMaterializationRebuild(String dbName, String tableName, long txnId) throws MetaException {
        try {
            boolean bl;
            PreparedStatement pst;
            Connection dbConn;
            block8: {
                int rc;
                dbConn = null;
                pst = null;
                this.lockInternal();
                dbConn = this.getDbConn(2);
                String s = "UPDATE \"MATERIALIZATION_REBUILD_LOCKS\" SET \"MRL_LAST_HEARTBEAT\" = " + Instant.now().toEpochMilli() + " WHERE \"MRL_TXN_ID\" = " + txnId + " AND \"MRL_DB_NAME\" = ? AND \"MRL_TBL_NAME\" = ?";
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, Arrays.asList(dbName, tableName));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Going to execute update <" + s.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tableName));
                }
                if ((rc = pst.executeUpdate()) >= 1) break block8;
                LOG.debug("Going to rollback");
                dbConn.rollback();
                LOG.info("No lock found for rebuild of {} when trying to heartbeat", (Object)TableName.getDbTable((String)dbName, (String)tableName));
                boolean bl2 = false;
                TxnHandler.close(null, pst, dbConn);
                this.unlockInternal();
                return bl2;
            }
            try {
                LOG.debug("Going to commit");
                dbConn.commit();
                bl = true;
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback: ", (Throwable)e);
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "heartbeatLockMaterializationRebuild(" + TableName.getDbTable((String)dbName, (String)tableName) + ", " + txnId + ")");
                    throw new MetaException("Unable to heartbeat rebuild lock due to " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, pst, dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.close(null, pst, dbConn);
            this.unlockInternal();
            return bl;
        }
        catch (RetryException e2) {
            return this.heartbeatLockMaterializationRebuild(dbName, tableName, txnId);
        }
    }

    @Override
    public long cleanupMaterializationRebuildLocks(ValidTxnList validTxnList, long timeout) throws MetaException {
        long l;
        long cnt = 0L;
        ArrayList<Long> txnIds = new ArrayList<Long>();
        long timeoutTime = Instant.now().toEpochMilli() - timeout;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.lockInternal();
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String selectQ = "SELECT \"MRL_TXN_ID\", \"MRL_LAST_HEARTBEAT\" FROM \"MATERIALIZATION_REBUILD_LOCKS\"";
            LOG.debug("Going to execute query <{}>", (Object)selectQ);
            rs = stmt.executeQuery(selectQ);
            while (rs.next()) {
                long txnId;
                long lastHeartbeat = rs.getLong(2);
                if (lastHeartbeat >= timeoutTime || !validTxnList.isTxnValid(txnId = rs.getLong(1)) && !validTxnList.isTxnAborted(txnId)) continue;
                txnIds.add(txnId);
            }
            if (!txnIds.isEmpty()) {
                String deleteQ = "DELETE FROM \"MATERIALIZATION_REBUILD_LOCKS\" WHERE \"MRL_TXN_ID\" IN(" + org.apache.hadoop.util.StringUtils.join((CharSequence)",", txnIds) + ") ";
                LOG.debug("Going to execute update <{}>", (Object)deleteQ);
                cnt = stmt.executeUpdate(deleteQ);
            }
            LOG.debug("Going to commit");
            dbConn.commit();
            l = cnt;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback: ", (Throwable)e);
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "cleanupMaterializationRebuildLocks");
                    throw new MetaException("Unable to clean rebuild locks due to " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(rs, stmt, dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.cleanupMaterializationRebuildLocks(validTxnList, timeout);
            }
        }
        TxnHandler.close(rs, stmt, dbConn);
        this.unlockInternal();
        return l;
    }

    @Override
    @RetrySemantics.CannotRetry
    public LockResponse lock(LockRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        ConnectionLockIdPair connAndLockId = this.enqueueLockWithRetry(rqst);
        try {
            return this.checkLockWithRetry(connAndLockId.dbConn, connAndLockId.extLockId, rqst.getTxnid(), rqst.isZeroWaitReadEnabled(), rqst.isExclusiveCTAS());
        }
        catch (NoSuchLockException e) {
            throw new MetaException("Couldn't find a lock we just created! " + e.getMessage());
        }
    }

    private TxnType getOpenTxnTypeAndLock(Statement stmt, long txnId) throws SQLException, MetaException {
        String query = "SELECT \"TXN_TYPE\" FROM \"TXNS\" WHERE \"TXN_ID\" = " + txnId + " AND \"TXN_STATE\" = " + (Object)((Object)TxnStatus.OPEN);
        try (ResultSet rs = stmt.executeQuery(sqlGenerator.addForUpdateClause(query));){
            TxnType txnType = rs.next() ? TxnType.findByValue(rs.getInt(1)) : null;
            return txnType;
        }
    }

    private ConnectionLockIdPair enqueueLockWithRetry(LockRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        ConnectionLockIdPair connectionLockIdPair;
        boolean success = false;
        Connection dbConn = null;
        Statement stmt = null;
        try {
            TxnType txnType;
            this.lockInternal();
            dbConn = this.getDbConn(2);
            long txnid = rqst.getTxnid();
            stmt = dbConn.createStatement();
            if (TxnHandler.isValidTxn(txnid) && (txnType = this.getOpenTxnTypeAndLock(stmt, txnid)) == null) {
                TxnHandler.ensureValidTxn(dbConn, txnid, stmt);
                TxnHandler.shouldNeverHappen(txnid);
            }
            this.insertTxnComponents(txnid, rqst, dbConn);
            long tempExtLockId = this.insertHiveLocksWithTemporaryExtLockId(txnid, dbConn, rqst);
            long extLockId = this.getNextLockIdForUpdate(dbConn, stmt);
            this.incrementLockIdAndUpdateHiveLocks(stmt, extLockId, tempExtLockId);
            dbConn.commit();
            success = true;
            connectionLockIdPair = new ConnectionLockIdPair(dbConn, extLockId);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.error("enqueueLock failed for request: {}. Exception msg: {}", (Object)rqst, (Object)TxnHandler.getMessage(e));
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "enqueueLockWithRetry(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeStmt(stmt);
                    if (!success) {
                        TxnHandler.closeDbConn(dbConn);
                    }
                    this.unlockInternal();
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                LOG.debug("Going to retry enqueueLock for request: {}, after catching RetryException with message: {}", (Object)rqst, (Object)e2.getMessage());
                return this.enqueueLockWithRetry(rqst);
            }
        }
        TxnHandler.closeStmt(stmt);
        if (!success) {
            TxnHandler.closeDbConn(dbConn);
        }
        this.unlockInternal();
        return connectionLockIdPair;
    }

    private long getNextLockIdForUpdate(Connection dbConn, Statement stmt) throws SQLException, MetaException {
        String s = sqlGenerator.addForUpdateClause("SELECT \"NL_NEXT\" FROM \"NEXT_LOCK_ID\"");
        LOG.debug("Going to execute query <{}>", (Object)s);
        try (ResultSet rs = stmt.executeQuery(s);){
            if (!rs.next()) {
                LOG.error("Failure to get next lock ID for update! SELECT query returned empty ResultSet.");
                dbConn.rollback();
                throw new MetaException("Transaction tables not properly initialized, no record found in next_lock_id");
            }
            long l = rs.getLong(1);
            return l;
        }
    }

    private void incrementLockIdAndUpdateHiveLocks(Statement stmt, long extLockId, long tempId) throws SQLException {
        String incrCmd = String.format(INCREMENT_NEXT_LOCK_ID_QUERY, extLockId + 1L);
        String updateLocksCmd = String.format(UPDATE_HIVE_LOCKS_EXT_ID_QUERY, extLockId, tempId);
        LOG.debug("Going to execute updates in batch: <{}>, and <{}>", (Object)incrCmd, (Object)updateLocksCmd);
        stmt.addBatch(incrCmd);
        stmt.addBatch(updateLocksCmd);
        stmt.executeBatch();
    }

    private void insertTxnComponents(long txnid, LockRequest rqst, Connection dbConn) throws SQLException {
        if (txnid > 0L) {
            HashMap<Pair<String, String>, Optional<Long>> writeIdCache = new HashMap<Pair<String, String>, Optional<Long>>();
            try (PreparedStatement pstmt = dbConn.prepareStatement(TXN_COMPONENTS_INSERT_QUERY);){
                int insertCounter = 0;
                Predicate<LockComponent> isDynPart = lc -> lc.isSetIsDynamicPartitionWrite() && lc.isIsDynamicPartitionWrite();
                Function<LockComponent, Pair> groupKey = lc -> Pair.of((Object)TxnHandler.normalizeCase(lc.getDbname()), (Object)TxnHandler.normalizeCase(lc.getTablename()));
                Set isDynPartUpdate = rqst.getComponent().stream().filter(isDynPart).filter(lc -> lc.getOperationType() == DataOperationType.UPDATE || lc.getOperationType() == DataOperationType.DELETE).map(groupKey).collect(Collectors.toSet());
                for (LockComponent lc2 : rqst.getComponent()) {
                    if (lc2.isSetIsTransactional() && !lc2.isIsTransactional() || !this.shouldUpdateTxnComponent(txnid, rqst, lc2)) continue;
                    String dbName = TxnHandler.normalizeCase(lc2.getDbname());
                    String tblName = TxnHandler.normalizeCase(lc2.getTablename());
                    String partName = TxnHandler.normalizePartitionCase(lc2.getPartitionname());
                    OperationType opType = OperationType.fromDataOperationType(lc2.getOperationType());
                    if (isDynPart.test(lc2)) {
                        partName = null;
                        if (writeIdCache.containsKey(groupKey.apply(lc2))) continue;
                        opType = isDynPartUpdate.contains(groupKey.apply(lc2)) ? OperationType.UPDATE : OperationType.INSERT;
                    }
                    Optional<Long> writeId = this.getWriteId(writeIdCache, dbName, tblName, txnid, dbConn);
                    pstmt.setLong(1, txnid);
                    pstmt.setString(2, dbName);
                    pstmt.setString(3, tblName);
                    pstmt.setString(4, partName);
                    pstmt.setString(5, opType.getSqlConst());
                    pstmt.setObject(6, writeId.orElse(null));
                    pstmt.addBatch();
                    if (++insertCounter % this.maxBatchSize != 0) continue;
                    LOG.debug("Executing a batch of <{}> queries. Batch size: {}", (Object)TXN_COMPONENTS_INSERT_QUERY, (Object)this.maxBatchSize);
                    pstmt.executeBatch();
                }
                if (insertCounter % this.maxBatchSize != 0) {
                    LOG.debug("Executing a batch of <{}> queries. Batch size: {}", (Object)TXN_COMPONENTS_INSERT_QUERY, (Object)(insertCounter % this.maxBatchSize));
                    pstmt.executeBatch();
                }
            }
        }
    }

    private Optional<Long> getWriteId(Map<Pair<String, String>, Optional<Long>> writeIdCache, String dbName, String tblName, long txnid, Connection dbConn) throws SQLException {
        Pair dbAndTable = Pair.of((Object)dbName, (Object)tblName);
        if (writeIdCache.containsKey(dbAndTable)) {
            return writeIdCache.get(dbAndTable);
        }
        Optional<Long> writeId = this.getWriteIdFromDb(txnid, dbConn, dbName, tblName);
        writeIdCache.put((Pair<String, String>)dbAndTable, writeId);
        return writeId;
    }

    private Optional<Long> getWriteIdFromDb(long txnid, Connection dbConn, String dbName, String tblName) throws SQLException {
        if (tblName != null) {
            try (PreparedStatement pstmt = dbConn.prepareStatement(SELECT_WRITE_ID_QUERY);){
                pstmt.setString(1, dbName);
                pstmt.setString(2, tblName);
                pstmt.setLong(3, txnid);
                LOG.debug("Going to execute query <{}>", (Object)SELECT_WRITE_ID_QUERY);
                try (ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        Optional<Long> optional = Optional.of(rs.getLong(1));
                        return optional;
                    }
                }
            }
        }
        return Optional.empty();
    }

    private boolean shouldUpdateTxnComponent(long txnid, LockRequest rqst, LockComponent lc) {
        if (!lc.isSetOperationType()) {
            return true;
        }
        switch (lc.getOperationType()) {
            case INSERT: 
            case UPDATE: 
            case DELETE: {
                return true;
            }
            case SELECT: {
                return false;
            }
            case NO_TXN: {
                return false;
            }
        }
        throw new IllegalStateException("Unexpected DataOperationType: " + (Object)((Object)lc.getOperationType()) + " agentInfo=" + rqst.getAgentInfo() + " " + JavaUtils.txnIdToString(txnid));
    }

    private long insertHiveLocksWithTemporaryExtLockId(long txnid, Connection dbConn, LockRequest rqst) throws MetaException, SQLException {
        String lastHB = TxnHandler.isValidTxn(txnid) ? "0" : TxnUtils.getEpochFn(dbProduct);
        String insertLocksQuery = String.format(HIVE_LOCKS_INSERT_QRY, lastHB);
        long intLockId = 0L;
        long tempExtLockId = this.generateTemporaryId();
        try (PreparedStatement pstmt = dbConn.prepareStatement(insertLocksQuery);){
            for (LockComponent lc : rqst.getComponent()) {
                if (lc.isSetOperationType() && lc.getOperationType() == DataOperationType.UNSET && (MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEST) || MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEZ_TEST)) && !MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.HIVE_IN_TEST_ICEBERG)) {
                    throw new IllegalStateException("Bug: operationType=" + (Object)((Object)lc.getOperationType()) + " for component " + lc + " agentInfo=" + rqst.getAgentInfo());
                }
                String lockType = LockTypeUtil.getEncodingAsStr(lc.getType());
                pstmt.setLong(1, tempExtLockId);
                pstmt.setLong(2, ++intLockId);
                pstmt.setLong(3, txnid);
                pstmt.setString(4, TxnHandler.normalizeCase(lc.getDbname()));
                pstmt.setString(5, TxnHandler.normalizeCase(lc.getTablename()));
                pstmt.setString(6, TxnHandler.normalizePartitionCase(lc.getPartitionname()));
                pstmt.setString(7, Character.toString('w'));
                pstmt.setString(8, lockType);
                pstmt.setString(9, rqst.getUser());
                pstmt.setString(10, rqst.getHostname());
                pstmt.setString(11, rqst.getAgentInfo());
                pstmt.addBatch();
                if (intLockId % (long)this.maxBatchSize != 0L) continue;
                LOG.debug("Executing a batch of <{}> queries. Batch size: {}", (Object)insertLocksQuery, (Object)this.maxBatchSize);
                pstmt.executeBatch();
            }
            if (intLockId % (long)this.maxBatchSize != 0L) {
                LOG.debug("Executing a batch of <{}> queries. Batch size: {}", (Object)insertLocksQuery, (Object)(intLockId % (long)this.maxBatchSize));
                pstmt.executeBatch();
            }
        }
        return tempExtLockId;
    }

    private long generateTemporaryId() {
        return -1L * ThreadLocalRandom.current().nextLong();
    }

    private static String normalizeCase(String s) {
        return s == null ? null : s.toLowerCase();
    }

    private static String normalizePartitionCase(String s) {
        if (s == null) {
            return null;
        }
        Map map = Splitter.on((String)"/").withKeyValueSeparator('=').split((CharSequence)s);
        return FileUtils.makePartName(new ArrayList<String>(map.keySet()), new ArrayList<String>(map.values()));
    }

    private LockResponse checkLockWithRetry(Connection dbConn, long extLockId, long txnId, boolean zeroWaitReadEnabled, boolean isExclusiveCTAS) throws NoSuchLockException, TxnAbortedException, MetaException {
        LockResponse lockResponse;
        try {
            this.lockInternal();
            if (dbConn.isClosed()) {
                dbConn = this.getDbConn(2);
            }
            lockResponse = this.checkLock(dbConn, extLockId, txnId, zeroWaitReadEnabled, isExclusiveCTAS);
            this.unlockInternal();
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.error("checkLock failed for extLockId={}/txnId={}. Exception msg: {}", new Object[]{extLockId, txnId, TxnHandler.getMessage(e)});
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "checkLockWithRetry(" + extLockId + "," + txnId + ")");
                    throw new MetaException("Unable to update transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.unlockInternal();
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                LOG.debug("Going to retry checkLock for extLockId={}/txnId={} after catching RetryException with message: {}", new Object[]{extLockId, txnId, e2.getMessage()});
                return this.checkLockWithRetry(dbConn, extLockId, txnId, zeroWaitReadEnabled, isExclusiveCTAS);
            }
        }
        TxnHandler.closeDbConn(dbConn);
        return lockResponse;
    }

    @Override
    @RetrySemantics.SafeToRetry
    public LockResponse checkLock(CheckLockRequest rqst) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException {
        LockResponse lockResponse;
        Connection dbConn = null;
        long extLockId = rqst.getLockid();
        try {
            this.lockInternal();
            dbConn = this.getDbConn(2);
            LockInfo lockInfo = this.getLockFromLockId(dbConn, extLockId).orElseThrow(() -> new NoSuchLockException("No such lock " + JavaUtils.lockIdToString(extLockId)));
            if (lockInfo.txnId > 0L) {
                this.heartbeatTxn(dbConn, lockInfo.txnId);
            } else {
                this.heartbeatLock(dbConn, extLockId);
            }
            lockResponse = this.checkLock(dbConn, extLockId, lockInfo.txnId, false, false);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.error("checkLock failed for request={}. Exception msg: {}", (Object)rqst, (Object)TxnHandler.getMessage(e));
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "checkLock(" + rqst + " )");
                    throw new MetaException("Unable to update transaction database " + JavaUtils.lockIdToString(extLockId) + " " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                LOG.debug("Going to retry checkLock for request={} after catching RetryException with message: {}", (Object)rqst, (Object)e2.getMessage());
                return this.checkLock(rqst);
            }
        }
        TxnHandler.closeDbConn(dbConn);
        this.unlockInternal();
        return lockResponse;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @RetrySemantics.Idempotent
    public void unlock(UnlockRequest rqst) throws TxnOpenException, MetaException {
        try {
            block8: {
                dbConn = null;
                stmt = null;
                extLockId = rqst.getLockid();
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                s = "DELETE FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = " + extLockId + " AND (\"HL_TXNID\" = 0 OR (\"HL_TXNID\" <> 0 AND \"HL_LOCK_STATE\" = '" + 'w' + "'))";
                TxnHandler.LOG.debug("Going to execute update <{}>", (Object)s);
                rc = stmt.executeUpdate(s);
                if (rc >= 1) ** GOTO lbl30
                TxnHandler.LOG.info("Failure to unlock any locks with extLockId={}.", (Object)extLockId);
                dbConn.rollback();
                optLockInfo = this.getLockFromLockId(dbConn, extLockId);
                if (optLockInfo.isPresent()) break block8;
                TxnHandler.LOG.info("No lock in {} mode found for unlock({})", (Object)Character.valueOf('w'), (Object)JavaUtils.lockIdToString(rqst.getLockid()));
                TxnHandler.closeStmt(stmt);
                TxnHandler.closeDbConn(dbConn);
                return;
            }
            try {
                lockInfo = optLockInfo.get();
                if (TxnHandler.isValidTxn(LockInfo.access$300(lockInfo))) {
                    msg = "Unlocking locks associated with transaction not permitted.  " + lockInfo;
                    TxnHandler.LOG.error(msg);
                    throw new TxnOpenException(msg);
                }
                msg = "Found lock in unexpected state " + lockInfo;
                TxnHandler.LOG.error(msg);
                throw new MetaException(msg);
lbl30:
                // 1 sources

                TxnHandler.LOG.debug("Successfully unlocked at least 1 lock with extLockId={}", (Object)extLockId);
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    TxnHandler.LOG.error("Unlock failed for request={}. Exception msg: {}", (Object)rqst, (Object)TxnHandler.getMessage(e));
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "unlock(" + rqst + ")");
                    throw new MetaException("Unable to update transaction database " + JavaUtils.lockIdToString(extLockId) + " " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable var11_13) {
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    throw var11_13;
                }
            }
            TxnHandler.closeStmt(stmt);
            TxnHandler.closeDbConn(dbConn);
        }
        catch (RetryException e) {
            this.unlock(rqst);
        }
    }

    @Override
    @RetrySemantics.ReadOnly
    public ShowLocksResponse showLocks(ShowLocksRequest rqst) throws MetaException {
        try {
            Connection dbConn = null;
            ShowLocksResponse rsp = new ShowLocksResponse();
            ArrayList<ShowLocksResponseElement> elems = new ArrayList<ShowLocksResponseElement>();
            ArrayList<LockInfoExt> sortedList = new ArrayList<LockInfoExt>();
            PreparedStatement pst = null;
            try {
                String whereClause;
                dbConn = this.getDbConn(2);
                String s = "SELECT \"HL_LOCK_EXT_ID\", \"HL_TXNID\", \"HL_DB\", \"HL_TABLE\", \"HL_PARTITION\", \"HL_LOCK_STATE\", \"HL_LOCK_TYPE\", \"HL_LAST_HEARTBEAT\", \"HL_ACQUIRED_AT\", \"HL_USER\", \"HL_HOST\", \"HL_LOCK_INT_ID\",\"HL_BLOCKEDBY_EXT_ID\", \"HL_BLOCKEDBY_INT_ID\", \"HL_AGENT_INFO\" FROM \"HIVE_LOCKS\"";
                String dbName = rqst.getDbname();
                String tableName = rqst.getTablename();
                String partName = rqst.getPartname();
                ArrayList<String> params = new ArrayList<String>();
                StringBuilder filter = new StringBuilder();
                if (dbName != null && !dbName.isEmpty()) {
                    filter.append("\"HL_DB\"=?");
                    params.add(dbName);
                }
                if (tableName != null && !tableName.isEmpty()) {
                    if (filter.length() > 0) {
                        filter.append(" and ");
                    }
                    filter.append("\"HL_TABLE\"=?");
                    params.add(tableName);
                }
                if (partName != null && !partName.isEmpty()) {
                    if (filter.length() > 0) {
                        filter.append(" and ");
                    }
                    filter.append("\"HL_PARTITION\"=?");
                    params.add(partName);
                }
                if (rqst.isSetTxnid()) {
                    if (filter.length() > 0) {
                        filter.append(" and ");
                    }
                    filter.append("\"HL_TXNID\"=" + rqst.getTxnid());
                }
                if (!(whereClause = filter.toString()).isEmpty()) {
                    s = s + " where " + whereClause;
                }
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, params);
                LOG.debug("Going to execute query <{}>", (Object)s);
                ResultSet rs = pst.executeQuery();
                while (rs.next()) {
                    ShowLocksResponseElement e = new ShowLocksResponseElement();
                    e.setLockid(rs.getLong(1));
                    long txnid = rs.getLong(2);
                    if (!rs.wasNull()) {
                        e.setTxnid(txnid);
                    }
                    e.setDbname(rs.getString(3));
                    e.setTablename(rs.getString(4));
                    String partition = rs.getString(5);
                    if (partition != null) {
                        e.setPartname(partition);
                    }
                    switch (rs.getString(6).charAt(0)) {
                        case 'a': {
                            e.setState(LockState.ACQUIRED);
                            break;
                        }
                        case 'w': {
                            e.setState(LockState.WAITING);
                            break;
                        }
                        default: {
                            throw new MetaException("Unknown lock state " + rs.getString(6).charAt(0));
                        }
                    }
                    char lockChar = rs.getString(7).charAt(0);
                    LockType lockType = LockTypeUtil.getLockTypeFromEncoding(lockChar).orElseThrow(() -> new MetaException("Unknown lock type: " + lockChar));
                    e.setType(lockType);
                    e.setLastheartbeat(rs.getLong(8));
                    long acquiredAt = rs.getLong(9);
                    if (!rs.wasNull()) {
                        e.setAcquiredat(acquiredAt);
                    }
                    e.setUser(rs.getString(10));
                    e.setHostname(rs.getString(11));
                    e.setLockIdInternal(rs.getLong(12));
                    long id = rs.getLong(13);
                    if (!rs.wasNull()) {
                        e.setBlockedByExtId(id);
                    }
                    id = rs.getLong(14);
                    if (!rs.wasNull()) {
                        e.setBlockedByIntId(id);
                    }
                    e.setAgentInfo(rs.getString(15));
                    sortedList.add(new LockInfoExt(e));
                }
            }
            catch (SQLException e) {
                try {
                    this.checkRetryable(e, "showLocks(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeStmt(pst);
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            TxnHandler.closeStmt(pst);
            TxnHandler.closeDbConn(dbConn);
            Collections.sort(sortedList, new LockInfoComparator());
            for (LockInfoExt lockInfoExt : sortedList) {
                elems.add(lockInfoExt.e);
            }
            rsp.setLocks(elems);
            return rsp;
        }
        catch (RetryException e) {
            return this.showLocks(rqst);
        }
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void heartbeat(HeartbeatRequest ids) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException {
        try {
            Connection dbConn = null;
            try {
                dbConn = this.getDbConn(2);
                this.heartbeatLock(dbConn, ids.getLockid());
                this.heartbeatTxn(dbConn, ids.getTxnid());
            }
            catch (SQLException e) {
                LOG.debug("Going to rollback: ", (Throwable)e);
                TxnHandler.rollbackDBConn(dbConn);
                this.checkRetryable(e, "heartbeat(" + ids + ")");
                throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            }
            finally {
                TxnHandler.closeDbConn(dbConn);
            }
        }
        catch (RetryException e) {
            this.heartbeat(ids);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.SafeToRetry
    public HeartbeatTxnRangeResponse heartbeatTxnRange(HeartbeatTxnRangeRequest rqst) throws MetaException {
        try {
            HeartbeatTxnRangeResponse heartbeatTxnRangeResponse;
            HashSet<Long> aborted;
            HashSet<Long> nosuch;
            HeartbeatTxnRangeResponse rsp;
            Statement stmt;
            Connection dbConn;
            block13: {
                dbConn = null;
                stmt = null;
                rsp = new HeartbeatTxnRangeResponse();
                nosuch = new HashSet<Long>();
                aborted = new HashSet<Long>();
                rsp.setNosuch(nosuch);
                rsp.setAborted(aborted);
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                ArrayList<String> queries = new ArrayList<String>();
                int numTxnsToHeartbeat = (int)(rqst.getMax() - rqst.getMin() + 1L);
                ArrayList<Long> txnIds = new ArrayList<Long>(numTxnsToHeartbeat);
                for (long txn = rqst.getMin(); txn <= rqst.getMax(); ++txn) {
                    txnIds.add(txn);
                }
                TxnUtils.buildQueryWithINClause(this.conf, queries, new StringBuilder("UPDATE \"TXNS\" SET \"TXN_LAST_HEARTBEAT\" = " + TxnUtils.getEpochFn(dbProduct) + " WHERE \"TXN_STATE\" = " + (Object)((Object)TxnStatus.OPEN) + " AND "), new StringBuilder(""), txnIds, "\"TXN_ID\"", true, false);
                int updateCnt = 0;
                for (String query : queries) {
                    LOG.debug("Going to execute update <{}>", (Object)query);
                    updateCnt += stmt.executeUpdate(query);
                }
                if (updateCnt != numTxnsToHeartbeat) break block13;
                dbConn.commit();
                HeartbeatTxnRangeResponse heartbeatTxnRangeResponse2 = rsp;
                TxnHandler.close(null, stmt, dbConn);
                return heartbeatTxnRangeResponse2;
            }
            try {
                dbConn.rollback();
                for (long txn = rqst.getMin(); txn <= rqst.getMax(); ++txn) {
                    try {
                        this.heartbeatTxn(dbConn, txn);
                        continue;
                    }
                    catch (NoSuchTxnException e) {
                        nosuch.add(txn);
                        continue;
                    }
                    catch (TxnAbortedException e) {
                        aborted.add(txn);
                    }
                }
                heartbeatTxnRangeResponse = rsp;
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback: ", (Throwable)e);
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "heartbeatTxnRange(" + rqst + ")");
                    throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, stmt, dbConn);
                    throw throwable;
                }
            }
            TxnHandler.close(null, stmt, dbConn);
            return heartbeatTxnRangeResponse;
        }
        catch (RetryException e2) {
            return this.heartbeatTxnRange(rqst);
        }
    }

    long generateCompactionQueueId(Statement stmt) throws SQLException, MetaException {
        String s = sqlGenerator.addForUpdateClause("SELECT \"NCQ_NEXT\" FROM \"NEXT_COMPACTION_QUEUE_ID\"");
        LOG.debug("going to execute query <{}>", (Object)s);
        try (ResultSet rs = stmt.executeQuery(s);){
            if (!rs.next()) {
                throw new IllegalStateException("Transaction tables not properly initiated, no record found in next_compaction_queue_id");
            }
            long id = rs.getLong(1);
            s = "UPDATE \"NEXT_COMPACTION_QUEUE_ID\" SET \"NCQ_NEXT\" = " + (id + 1L) + " WHERE \"NCQ_NEXT\" = " + id;
            LOG.debug("Going to execute update <{}>", (Object)s);
            if (stmt.executeUpdate(s) != 1) {
                LOG.info("The returned compaction ID ({}) already taken, obtaining new", (Object)id);
                long l = this.generateCompactionQueueId(stmt);
                return l;
            }
            long l = id;
            return l;
        }
    }

    @Override
    @RetrySemantics.ReadOnly
    public long getTxnIdForWriteId(String dbName, String tblName, long writeId) throws MetaException {
        long l;
        Connection dbConn = null;
        PreparedStatement pst = null;
        try {
            dbConn = this.getDbConn(2);
            String query = "SELECT \"T2W_TXNID\" FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_DATABASE\" = ? AND \"T2W_TABLE\" = ? AND \"T2W_WRITEID\" = " + writeId;
            pst = sqlGenerator.prepareStmtWithParameters(dbConn, query, Arrays.asList(dbName, tblName));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Going to execute query <" + query.replace("?", "{}") + ">", (Object)TxnHandler.quoteString(dbName), (Object)TxnHandler.quoteString(tblName));
            }
            ResultSet rs = pst.executeQuery();
            long txnId = -1L;
            if (rs.next()) {
                txnId = rs.getLong(1);
            }
            l = txnId;
        }
        catch (SQLException e) {
            try {
                try {
                    this.checkRetryable(e, "getTxnIdForWriteId");
                    throw new MetaException("Unable to select from transaction database, " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, pst, dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getTxnIdForWriteId(dbName, tblName, writeId);
            }
        }
        TxnHandler.close(null, pst, dbConn);
        return l;
    }

    /*
     * Exception decompiling
     */
    @Override
    @RetrySemantics.Idempotent
    public CompactionResponse compact(CompactionRequest rqst) throws MetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @RetrySemantics.SafeToRetry
    public boolean submitForCleanup(final CompactionRequest rqst, long highestWriteId, long txnId) throws MetaException {
        boolean bl;
        Connection dbConn = null;
        try {
            long cqId;
            dbConn = this.getDbConn(2);
            this.lockInternal();
            ArrayList<String> params = new ArrayList<String>(){
                {
                    this.add(rqst.getDbname());
                    this.add(rqst.getTablename());
                }
            };
            try (Statement stmt = dbConn.createStatement();){
                cqId = this.generateCompactionQueueId(stmt);
            }
            StringBuilder buf = new StringBuilder("INSERT INTO \"COMPACTION_QUEUE\" (\"CQ_ID\", \"CQ_HIGHEST_WRITE_ID\", \"CQ_TXN_ID\", \"CQ_ENQUEUE_TIME\", \"CQ_DATABASE\", \"CQ_TABLE\", ");
            String partName = rqst.getPartitionname();
            if (partName != null) {
                buf.append("\"CQ_PARTITION\", ");
                params.add(partName);
            }
            buf.append("\"CQ_STATE\", \"CQ_TYPE\"");
            params.add(String.valueOf('r'));
            params.add(TxnUtils.thriftCompactionType2DbType(rqst.getType()).toString());
            if (rqst.getProperties() != null) {
                buf.append(", \"CQ_TBLPROPERTIES\"");
                params.add(new StringableMap(rqst.getProperties()).toString());
            }
            if (rqst.getRunas() != null) {
                buf.append(", \"CQ_RUN_AS\"");
                params.add(rqst.getRunas());
            }
            buf.append(") values (").append(Stream.of(Long.valueOf(cqId), highestWriteId, txnId, TxnUtils.getEpochFn(dbProduct)).map(Object::toString).collect(Collectors.joining(", "))).append(org.apache.commons.lang3.StringUtils.repeat((String)", ?", (int)params.size())).append(")");
            String s = buf.toString();
            try (PreparedStatement pst = sqlGenerator.prepareStmtWithParameters(dbConn, s, (List<String>)params);){
                LOG.debug("Going to execute update <{}>", (Object)s);
                pst.executeUpdate();
            }
            LOG.debug("Going to commit");
            dbConn.commit();
            bl = true;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.debug("Going to rollback: ", (Throwable)e);
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "submitForCleanup(" + rqst + ")");
                    throw new MetaException("Failed to submit cleanup request: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.submitForCleanup(rqst, highestWriteId, txnId);
            }
        }
        TxnHandler.closeDbConn(dbConn);
        this.unlockInternal();
        return bl;
    }

    protected static String compactorStateToResponse(char s) {
        switch (s) {
            case 'i': {
                return "initiated";
            }
            case 'w': {
                return "working";
            }
            case 'r': {
                return "ready for cleaning";
            }
            case 'f': {
                return "failed";
            }
            case 's': {
                return "succeeded";
            }
            case 'a': {
                return "did not initiate";
            }
            case 'c': {
                return "refused";
            }
        }
        return Character.toString(s);
    }

    @Override
    @RetrySemantics.ReadOnly
    public ShowCompactResponse showCompact(ShowCompactRequest rqst) throws MetaException {
        try {
            ShowCompactResponse response = new ShowCompactResponse(new ArrayList<ShowCompactResponseElement>());
            StringBuilder query = new StringBuilder("SELECT XX.* FROM ( SELECT   \"CQ_DATABASE\" AS \"CC_DATABASE\", \"CQ_TABLE\" AS \"CC_TABLE\", \"CQ_PARTITION\" AS \"CC_PARTITION\",   \"CQ_STATE\" AS \"CC_STATE\", \"CQ_TYPE\" AS \"CC_TYPE\", \"CQ_WORKER_ID\" AS \"CC_WORKER_ID\",   \"CQ_START\" AS \"CC_START\", -1 \"CC_END\", \"CQ_RUN_AS\" AS \"CC_RUN_AS\",   \"CQ_HADOOP_JOB_ID\" AS \"CC_HADOOP_JOB_ID\", \"CQ_ID\" AS \"CC_ID\", \"CQ_ERROR_MESSAGE\" AS \"CC_ERROR_MESSAGE\",   \"CQ_ENQUEUE_TIME\" AS \"CC_ENQUEUE_TIME\", \"CQ_WORKER_VERSION\" AS \"CC_WORKER_VERSION\",   \"CQ_INITIATOR_ID\" AS \"CC_INITIATOR_ID\", \"CQ_INITIATOR_VERSION\" AS \"CC_INITIATOR_VERSION\",   \"CQ_CLEANER_START\" AS \"CC_CLEANER_START\", \"CQ_POOL_NAME\" AS \"CC_POOL_NAME\", \"CQ_TXN_ID\" AS \"CC_TXN_ID\",   \"CQ_NEXT_TXN_ID\" AS \"CC_NEXT_TXN_ID\", \"CQ_COMMIT_TIME\" AS \"CC_COMMIT_TIME\",   \"CQ_HIGHEST_WRITE_ID\" AS \"CC_HIGHEST_WRITE_ID\" FROM   \"COMPACTION_QUEUE\" UNION ALL SELECT   \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\", \"CC_STATE\", \"CC_TYPE\", \"CC_WORKER_ID\",   \"CC_START\", \"CC_END\", \"CC_RUN_AS\", \"CC_HADOOP_JOB_ID\", \"CC_ID\", \"CC_ERROR_MESSAGE\",   \"CC_ENQUEUE_TIME\", \"CC_WORKER_VERSION\", \"CC_INITIATOR_ID\", \"CC_INITIATOR_VERSION\",    -1 , \"CC_POOL_NAME\", \"CC_TXN_ID\", \"CC_NEXT_TXN_ID\", \"CC_COMMIT_TIME\",   \"CC_HIGHEST_WRITE_ID\"FROM   \"COMPLETED_COMPACTIONS\" ) XX ").append(this.getShowCompactionFilterClause(rqst)).append(" ORDER BY CASE    WHEN \"CC_END\" > \"CC_START\" and \"CC_END\" > \"CC_COMMIT_TIME\"      THEN \"CC_END\"    WHEN \"CC_START\" > \"CC_COMMIT_TIME\"      THEN \"CC_START\"    ELSE \"CC_COMMIT_TIME\"  END desc , \"CC_ENQUEUE_TIME\" asc");
            try (Connection dbConn = this.getDbConn(2);
                 PreparedStatement stmt = sqlGenerator.prepareStmtWithParameters(dbConn, query.toString(), this.getShowCompactionQueryParamList(rqst));){
                LOG.debug("Going to execute query <" + query + ">");
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        String poolName;
                        long endTime;
                        ShowCompactResponseElement e = new ShowCompactResponseElement();
                        e.setDbname(rs.getString(1));
                        e.setTablename(rs.getString(2));
                        e.setPartitionname(rs.getString(3));
                        e.setState(TxnHandler.compactorStateToResponse(rs.getString(4).charAt(0)));
                        try {
                            e.setType(TxnUtils.dbCompactionType2ThriftType(rs.getString(5).charAt(0)));
                        }
                        catch (MetaException metaException) {
                            // empty catch block
                        }
                        e.setWorkerid(rs.getString(6));
                        long start = rs.getLong(7);
                        if (!rs.wasNull()) {
                            e.setStart(start);
                        }
                        if ((endTime = rs.getLong(8)) != -1L) {
                            e.setEndTime(endTime);
                        }
                        e.setRunAs(rs.getString(9));
                        e.setHadoopJobId(rs.getString(10));
                        e.setId(rs.getLong(11));
                        e.setErrorMessage(rs.getString(12));
                        long enqueueTime = rs.getLong(13);
                        if (!rs.wasNull()) {
                            e.setEnqueueTime(enqueueTime);
                        }
                        e.setWorkerVersion(rs.getString(14));
                        e.setInitiatorId(rs.getString(15));
                        e.setInitiatorVersion(rs.getString(16));
                        long cleanerStart = rs.getLong(17);
                        if (!rs.wasNull() && cleanerStart != -1L) {
                            e.setCleanerStart(cleanerStart);
                        }
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(poolName = rs.getString(18)))) {
                            e.setPoolName(DEFAULT_POOL_NAME);
                        } else {
                            e.setPoolName(poolName);
                        }
                        e.setTxnId(rs.getLong(19));
                        e.setNextTxnId(rs.getLong(20));
                        e.setCommitTime(rs.getLong(21));
                        e.setHightestTxnId(rs.getLong(22));
                        response.addToCompacts(e);
                    }
                }
            }
            catch (SQLException e) {
                this.checkRetryable(e, "showCompact(" + rqst + ")");
                throw new MetaException("Unable to select from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            }
            return response;
        }
        catch (RetryException e) {
            return this.showCompact(rqst);
        }
    }

    private List<String> getShowCompactionQueryParamList(ShowCompactRequest request) throws MetaException {
        String poolName = request.getPoolName();
        ArrayList<String> params = new ArrayList<String>();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)poolName)) {
            params.add(poolName);
        }
        return params;
    }

    private String getShowCompactionFilterClause(ShowCompactRequest request) {
        StringBuilder filter = new StringBuilder();
        String poolName = request.getPoolName();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)poolName)) {
            filter.append("\"CC_POOL_NAME\"=?");
        }
        return filter.length() > 0 ? " where " + filter.toString() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.ReadOnly
    public GetLatestCommittedCompactionInfoResponse getLatestCommittedCompactionInfo(GetLatestCommittedCompactionInfoRequest rqst) throws MetaException {
        GetLatestCommittedCompactionInfoResponse response = new GetLatestCommittedCompactionInfoResponse(new ArrayList<CompactionInfoStruct>());
        Connection dbConn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            try {
                dbConn = this.getDbConn(2);
                ArrayList<String> params = new ArrayList<String>();
                StringBuilder sb = new StringBuilder().append("SELECT * FROM (").append("   SELECT").append("   \"CC_ID\", \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\", \"CC_TYPE\"").append("   FROM \"COMPLETED_COMPACTIONS\"").append("     WHERE \"CC_STATE\" = " + TxnHandler.quoteChar('s')).append("   UNION ALL").append("   SELECT").append("   \"CQ_ID\" AS \"CC_ID\", \"CQ_DATABASE\" AS \"CC_DATABASE\"").append("   ,\"CQ_TABLE\" AS \"CC_TABLE\", \"CQ_PARTITION\" AS \"CC_PARTITION\"").append("   ,\"CQ_TYPE\" AS \"CC_TYPE\"").append("   FROM \"COMPACTION_QUEUE\"").append("     WHERE \"CQ_STATE\" = " + TxnHandler.quoteChar('r')).append(") AS compactions ").append(" WHERE \"CC_DATABASE\" = ? AND \"CC_TABLE\" = ?");
                params.add(rqst.getDbname());
                params.add(rqst.getTablename());
                if (rqst.getPartitionnamesSize() > 0) {
                    sb.append(" AND \"CC_PARTITION\" IN (");
                    sb.append(String.join((CharSequence)",", Collections.nCopies(rqst.getPartitionnamesSize(), "?")));
                    sb.append(")");
                    params.addAll(rqst.getPartitionnames());
                }
                if (rqst.isSetLastCompactionId()) {
                    sb.append(" AND \"CC_ID\" > ?");
                }
                sb.append(" ORDER BY \"CC_ID\" DESC");
                pst = sqlGenerator.prepareStmtWithParameters(dbConn, sb.toString(), params);
                if (rqst.isSetLastCompactionId()) {
                    pst.setLong(params.size() + 1, rqst.getLastCompactionId());
                }
                LOG.debug("Going to execute query <{}>", (Object)sb);
                rs = pst.executeQuery();
                HashSet<String> partitionSet = new HashSet<String>();
                while (rs.next()) {
                    CompactionInfoStruct lci = new CompactionInfoStruct();
                    lci.setId(rs.getLong(1));
                    lci.setDbname(rs.getString(2));
                    lci.setTablename(rs.getString(3));
                    String partition = rs.getString(4);
                    if (!rs.wasNull()) {
                        lci.setPartitionname(partition);
                    }
                    lci.setType(TxnUtils.dbCompactionType2ThriftType(rs.getString(5).charAt(0)));
                    if (partitionSet.contains(partition)) continue;
                    response.addToCompactions(lci);
                    partitionSet.add(partition);
                }
                TxnHandler.close(rs, pst, dbConn);
            }
            catch (SQLException e) {
                LOG.error("Unable to execute query", (Throwable)e);
                this.checkRetryable(e, "getLatestCommittedCompactionInfo");
            }
            finally {
                TxnHandler.close(rs, pst, dbConn);
            }
            return response;
        }
        catch (RetryException e) {
            return this.getLatestCommittedCompactionInfo(rqst);
        }
    }

    @Override
    public MetricsInfo getMetricsInfo() throws MetaException {
        Object pstmt;
        Connection dbConn = null;
        MetricsInfo metrics = new MetricsInfo();
        String s = MessageFormat.format(SELECT_METRICS_INFO_QUERY, TxnUtils.getEpochFn(dbProduct));
        try {
            dbConn = this.getDbConn(2);
            try (Statement stmt = dbConn.createStatement();){
                ResultSet rs = stmt.executeQuery(s);
                if (rs.next()) {
                    metrics.setTxnToWriteIdCount(rs.getInt(1));
                    metrics.setCompletedTxnsCount(rs.getInt(2));
                    metrics.setOpenReplTxnsCount(rs.getInt(3));
                    metrics.setOldestOpenReplTxnId(rs.getInt(4));
                    metrics.setOldestOpenReplTxnAge(rs.getInt(5));
                    metrics.setOpenNonReplTxnsCount(rs.getInt(6));
                    metrics.setOldestOpenNonReplTxnId(rs.getInt(7));
                    metrics.setOldestOpenNonReplTxnAge(rs.getInt(8));
                    metrics.setAbortedTxnsCount(rs.getInt(9));
                    metrics.setOldestAbortedTxnId(rs.getInt(10));
                    metrics.setOldestAbortedTxnAge(rs.getInt(11));
                    metrics.setLocksCount(rs.getInt(12));
                    metrics.setOldestLockAge(rs.getInt(13));
                    metrics.setOldestReadyForCleaningAge(rs.getInt(14));
                }
            }
            pstmt = dbConn.prepareStatement(SELECT_TABLES_WITH_X_ABORTED_TXNS);
            var5_7 = null;
            try {
                TreeSet<String> resourceNames = new TreeSet<String>();
                pstmt.setInt(1, MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_TABLES_WITH_ABORTED_TXNS_THRESHOLD));
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    String resourceName = rs.getString(1) + "." + rs.getString(2);
                    String partName = rs.getString(3);
                    resourceName = partName != null ? resourceName + "#" + partName : resourceName;
                    resourceNames.add(resourceName);
                }
                metrics.setTablesWithXAbortedTxnsCount(resourceNames.size());
                metrics.setTablesWithXAbortedTxns(resourceNames);
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (pstmt != null) {
                    if (var5_7 != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        pstmt.close();
                    }
                }
            }
            pstmt = metrics;
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.error("Unable to getMetricsInfo", (Throwable)e);
                    this.checkRetryable(e, "getMetricsInfo");
                    throw new MetaException("Unable to execute getMetricsInfo() " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (RetryException e2) {
                return this.getMetricsInfo();
            }
        }
        TxnHandler.closeDbConn(dbConn);
        return pstmt;
    }

    private static void shouldNeverHappen(long txnid) {
        throw new RuntimeException("This should never happen: " + JavaUtils.txnIdToString(txnid));
    }

    private static void shouldNeverHappen(long txnid, long extLockId, long intLockId) {
        throw new RuntimeException("This should never happen: " + JavaUtils.txnIdToString(txnid) + " " + JavaUtils.lockIdToString(extLockId) + " " + intLockId);
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void addDynamicPartitions(AddDynamicPartitions rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        try {
            try {
                this.lockInternal();
                dbConn = this.getDbConn(2);
                stmt = dbConn.createStatement();
                TxnType txnType = this.getOpenTxnTypeAndLock(stmt, rqst.getTxnid());
                if (txnType == null) {
                    TxnHandler.ensureValidTxn(dbConn, rqst.getTxnid(), stmt);
                    TxnHandler.shouldNeverHappen(rqst.getTxnid());
                }
                OperationType ot = OperationType.UPDATE;
                if (rqst.isSetOperationType()) {
                    ot = OperationType.fromDataOperationType(rqst.getOperationType());
                }
                Long writeId = rqst.getWriteid();
                try (PreparedStatement pstmt = dbConn.prepareStatement(TXN_COMPONENTS_INSERT_QUERY);){
                    int insertCounter = 0;
                    for (String partName : rqst.getPartitionnames()) {
                        pstmt.setLong(1, rqst.getTxnid());
                        pstmt.setString(2, TxnHandler.normalizeCase(rqst.getDbname()));
                        pstmt.setString(3, TxnHandler.normalizeCase(rqst.getTablename()));
                        pstmt.setString(4, partName);
                        pstmt.setString(5, ot.getSqlConst());
                        pstmt.setObject(6, writeId);
                        pstmt.addBatch();
                        if (++insertCounter % this.maxBatchSize != 0) continue;
                        LOG.debug("Executing a batch of <{}> queries. Batch size: {}", (Object)TXN_COMPONENTS_INSERT_QUERY, (Object)this.maxBatchSize);
                        pstmt.executeBatch();
                    }
                    if (insertCounter % this.maxBatchSize != 0) {
                        LOG.debug("Executing a batch of <{}> queries. Batch size: {}", (Object)TXN_COMPONENTS_INSERT_QUERY, (Object)(insertCounter % this.maxBatchSize));
                        pstmt.executeBatch();
                    }
                }
                pstmt = dbConn.prepareStatement(TXN_COMPONENTS_DP_DELETE_QUERY);
                var8_10 = null;
                try {
                    pstmt.setLong(1, rqst.getTxnid());
                    pstmt.setString(2, TxnHandler.normalizeCase(rqst.getDbname()));
                    pstmt.setString(3, TxnHandler.normalizeCase(rqst.getTablename()));
                    pstmt.execute();
                }
                catch (Throwable throwable) {
                    var8_10 = throwable;
                    throw throwable;
                }
                finally {
                    if (pstmt != null) {
                        if (var8_10 != null) {
                            try {
                                pstmt.close();
                            }
                            catch (Throwable throwable) {
                                var8_10.addSuppressed(throwable);
                            }
                        } else {
                            pstmt.close();
                        }
                    }
                }
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.debug("Going to rollback: ", (Throwable)e);
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "addDynamicPartitions(" + rqst + ")");
                    throw new MetaException("Unable to insert into from transaction database " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    TxnHandler.close(null, stmt, dbConn);
                    this.unlockInternal();
                    throw throwable;
                }
            }
            TxnHandler.close(null, stmt, dbConn);
            this.unlockInternal();
        }
        catch (RetryException e) {
            this.addDynamicPartitions(rqst);
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void cleanupRecords(HiveObjectType type, Database db, Table table, Iterator<Partition> partitionIterator, boolean keepTxnToWriteIdMetaData) throws MetaException {
        this.cleanupRecords(type, db, table, partitionIterator, keepTxnToWriteIdMetaData, 0L);
    }

    @Override
    @RetrySemantics.Idempotent
    public void cleanupRecords(HiveObjectType type, Database db, Table table, Iterator<Partition> partitionIterator, long txnId) throws MetaException {
        this.cleanupRecords(type, db, table, partitionIterator, false, txnId);
    }

    /*
     * Exception decompiling
     */
    private void cleanupRecords(HiveObjectType type, Database db, Table table, Iterator<Partition> partitionIterator, boolean keepTxnToWriteIdMetaData, long txnId) throws MetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 7[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRename(String oldCatName, String oldDbName, String oldTabName, String oldPartName, String newCatName, String newDbName, String newTabName, String newPartName) throws MetaException {
        block36: {
            String callSig = "onRename(" + oldCatName + "," + oldDbName + "," + oldTabName + "," + oldPartName + "," + newCatName + "," + newDbName + "," + newTabName + "," + newPartName + ")";
            if (newPartName != null) assert (oldPartName != null && oldTabName != null && oldDbName != null && oldCatName != null) : callSig;
            if (newTabName != null) assert (oldTabName != null && oldDbName != null && oldCatName != null) : callSig;
            if (newDbName != null) assert (oldDbName != null && oldCatName != null) : callSig;
            try {
                Connection dbConn = null;
                Statement stmt = null;
                try {
                    dbConn = this.getDbConn(2);
                    stmt = dbConn.createStatement();
                    ArrayList<String> queries = new ArrayList<String>();
                    String update = "UPDATE \"TXN_COMPONENTS\" SET ";
                    String where = " WHERE ";
                    if (oldPartName != null) {
                        update = update + "\"TC_PARTITION\" = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "\"TC_PARTITION\" = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "\"TC_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"TC_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"TC_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"TC_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "UPDATE \"COMPLETED_TXN_COMPONENTS\" SET ";
                    where = " WHERE ";
                    if (oldPartName != null) {
                        update = update + "\"CTC_PARTITION\" = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "\"CTC_PARTITION\" = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "\"CTC_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"CTC_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"CTC_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"CTC_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "UPDATE \"HIVE_LOCKS\" SET ";
                    where = " WHERE ";
                    if (oldPartName != null) {
                        update = update + "\"HL_PARTITION\" = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "\"HL_PARTITION\" = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "\"HL_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"HL_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"HL_DB\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"HL_DB\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "UPDATE \"COMPACTION_QUEUE\" SET ";
                    where = " WHERE ";
                    if (oldPartName != null) {
                        update = update + "\"CQ_PARTITION\" = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "\"CQ_PARTITION\" = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "\"CQ_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"CQ_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"CQ_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"CQ_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "UPDATE \"COMPLETED_COMPACTIONS\" SET ";
                    where = " WHERE ";
                    if (oldPartName != null) {
                        update = update + "\"CC_PARTITION\" = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "\"CC_PARTITION\" = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "\"CC_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"CC_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"CC_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"CC_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "UPDATE \"WRITE_SET\" SET ";
                    where = " WHERE ";
                    if (oldPartName != null) {
                        update = update + "\"WS_PARTITION\" = " + TxnHandler.quoteString(newPartName) + ", ";
                        where = where + "\"WS_PARTITION\" = " + TxnHandler.quoteString(oldPartName) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "\"WS_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"WS_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"WS_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"WS_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "UPDATE \"TXN_TO_WRITE_ID\" SET ";
                    where = " WHERE ";
                    if (oldTabName != null) {
                        update = update + "\"T2W_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"T2W_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"T2W_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"T2W_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "UPDATE \"NEXT_WRITE_ID\" SET ";
                    where = " WHERE ";
                    if (oldTabName != null) {
                        update = update + "\"NWI_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"NWI_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"NWI_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"NWI_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    update = "UPDATE \"COMPACTION_METRICS_CACHE\" SET";
                    where = " WHERE ";
                    if (oldPartName != null) {
                        update = update + "\"CMC_PARTITION\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newPartName)) + ", ";
                        where = where + "\"CMC_PARTITION\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldPartName)) + " AND ";
                    }
                    if (oldTabName != null) {
                        update = update + "\"CMC_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newTabName)) + ", ";
                        where = where + "\"CMC_TABLE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldTabName)) + " AND ";
                    }
                    if (oldDbName != null) {
                        update = update + "\"CMC_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(newDbName));
                        where = where + "\"CMC_DATABASE\" = " + TxnHandler.quoteString(TxnHandler.normalizeCase(oldDbName));
                    }
                    queries.add(update + where);
                    for (String query : queries) {
                        LOG.debug("Going to execute update <{}>", (Object)query);
                        stmt.executeUpdate(query);
                    }
                    LOG.debug("Going to commit: {}", (Object)callSig);
                    dbConn.commit();
                }
                catch (SQLException e) {
                    try {
                        LOG.debug("Going to rollback: {}", (Object)callSig);
                        TxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(e, callSig);
                        if (!e.getMessage().contains("does not exist")) {
                            throw new MetaException("Unable to " + callSig + ":" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                        }
                        LOG.warn("Cannot perform {} since metastore table does not exist", (Object)callSig);
                    }
                    catch (Throwable throwable) {
                        TxnHandler.closeStmt(stmt);
                        TxnHandler.closeDbConn(dbConn);
                        throw throwable;
                    }
                    TxnHandler.closeStmt(stmt);
                    TxnHandler.closeDbConn(dbConn);
                    break block36;
                }
                TxnHandler.closeStmt(stmt);
                TxnHandler.closeDbConn(dbConn);
            }
            catch (RetryException e) {
                this.onRename(oldCatName, oldDbName, oldTabName, oldPartName, newCatName, newDbName, newTabName, newPartName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public int numLocksInLockTable() throws SQLException, MetaException {
        int n;
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2);
            stmt = dbConn.createStatement();
            String s = "SELECT COUNT(*) FROM \"HIVE_LOCKS\"";
            LOG.debug("Going to execute query <{}>", (Object)s);
            rs = stmt.executeQuery(s);
            rs.next();
            int rc = rs.getInt(1);
            dbConn.rollback();
            n = rc;
        }
        catch (Throwable throwable) {
            TxnHandler.close(rs, stmt, dbConn);
            throw throwable;
        }
        TxnHandler.close(rs, stmt, dbConn);
        return n;
    }

    @Override
    public long setTimeout(long milliseconds) {
        long previous_timeout = this.timeout;
        this.timeout = milliseconds;
        return previous_timeout;
    }

    Connection getDbConn(int isolationLevel) throws SQLException {
        return this.getDbConn(isolationLevel, connPool);
    }

    protected Connection getDbConn(int isolationLevel, DataSource connPool) throws SQLException {
        int rc = doRetryOnConnPool ? 10 : 1;
        Connection dbConn = null;
        while (true) {
            try {
                dbConn = connPool.getConnection();
                dbConn.setAutoCommit(false);
                dbConn.setTransactionIsolation(isolationLevel);
                return dbConn;
            }
            catch (SQLException e) {
                TxnHandler.closeDbConn(dbConn);
                if (--rc <= 0) {
                    throw e;
                }
                LOG.error("There is a problem with a connection from the pool, retrying(rc=" + rc + "): " + TxnHandler.getMessage(e), (Throwable)e);
                continue;
            }
            break;
        }
    }

    static void rollbackDBConn(Connection dbConn) {
        try {
            if (dbConn != null && !dbConn.isClosed()) {
                dbConn.rollback();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to rollback db connection " + TxnHandler.getMessage(e));
        }
    }

    protected static void closeDbConn(Connection dbConn) {
        try {
            if (dbConn != null && !dbConn.isClosed()) {
                dbConn.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to close db connection " + TxnHandler.getMessage(e));
        }
    }

    protected static void closeStmt(Statement stmt) {
        try {
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to close statement " + TxnHandler.getMessage(e));
        }
    }

    static void close(ResultSet rs) {
        try {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
        }
        catch (SQLException ex) {
            LOG.warn("Failed to close statement " + TxnHandler.getMessage(ex));
        }
    }

    static void close(ResultSet rs, Statement stmt, Connection dbConn) {
        TxnHandler.close(rs);
        TxnHandler.closeStmt(stmt);
        TxnHandler.closeDbConn(dbConn);
    }

    private boolean waitForRetry(String caller, String errMsg) {
        if (this.retryNum++ < this.retryLimit) {
            LOG.warn("Retryable error detected in {}. Will wait {} ms and retry up to {} times. Error: {}", new Object[]{caller, this.retryInterval, this.retryLimit - this.retryNum + 1, errMsg});
            try {
                Thread.sleep(this.retryInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
        LOG.error("Fatal error in {}. Retry limit ({}) reached. Last error: {}", new Object[]{caller, this.retryLimit, errMsg});
        return false;
    }

    void checkRetryable(SQLException e, String caller) throws RetryException {
        this.checkRetryable(e, caller, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkRetryable(SQLException e, String caller, boolean retryOnDuplicateKey) throws RetryException {
        boolean sendRetrySignal;
        block14: {
            sendRetrySignal = false;
            try {
                if (dbProduct == null) {
                    throw new IllegalStateException("DB Type not determined yet.");
                }
                if (DatabaseProduct.isDeadlock(dbProduct, e)) {
                    if (this.deadlockCnt++ < 10) {
                        long waitInterval = this.deadlockRetryInterval * (long)this.deadlockCnt;
                        LOG.warn("Deadlock detected in {}. Will wait {} ms try again up to {} times.", new Object[]{caller, waitInterval, 10 - this.deadlockCnt + 1});
                        try {
                            Thread.sleep(waitInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        sendRetrySignal = true;
                        break block14;
                    }
                    LOG.error("Too many repeated deadlocks in {}, giving up.", (Object)caller);
                    break block14;
                }
                if (TxnHandler.isRetryable(this.conf, e)) {
                    sendRetrySignal = this.waitForRetry(caller, e.getMessage());
                } else if (retryOnDuplicateKey && this.isDuplicateKeyError(e)) {
                    sendRetrySignal = this.waitForRetry(caller, e.getMessage());
                } else {
                    LOG.info("Non-retryable error in {} : {}", (Object)caller, (Object)TxnHandler.getMessage(e));
                }
            }
            finally {
                if (!sendRetrySignal) {
                    this.deadlockCnt = 0;
                    this.retryNum = 0;
                }
            }
        }
        if (sendRetrySignal) {
            throw new RetryException();
        }
    }

    protected long getDbTime(Connection conn) throws MetaException {
        Statement stmt = null;
        try {
            String s;
            stmt = conn.createStatement();
            switch (dbProduct) {
                case DERBY: {
                    s = "values current_timestamp";
                    break;
                }
                case MYSQL: 
                case POSTGRES: 
                case SQLSERVER: {
                    s = "select current_timestamp";
                    break;
                }
                case ORACLE: {
                    s = "select current_timestamp from dual";
                    break;
                }
                default: {
                    String msg = "Unknown database product: " + dbProduct.toString();
                    LOG.error(msg);
                    throw new MetaException(msg);
                }
            }
            LOG.debug("Going to execute query <{}>", (Object)s);
            ResultSet rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("No results from date query");
            }
            long l = rs.getTimestamp(1).getTime();
            return l;
        }
        catch (SQLException e) {
            String msg = "Unable to determine current time: " + e.getMessage();
            LOG.error(msg);
            throw new MetaException(msg);
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    protected String isWithinCheckInterval(String expr, long interval) throws MetaException {
        String condition;
        switch (dbProduct) {
            case DERBY: {
                condition = " {fn TIMESTAMPDIFF(sql_tsi_second, " + expr + ", current_timestamp)} <= " + interval;
                break;
            }
            case MYSQL: 
            case POSTGRES: {
                condition = expr + " >= current_timestamp - interval '" + interval + "' second";
                break;
            }
            case SQLSERVER: {
                condition = "DATEDIFF(second, " + expr + ", current_timestamp) <= " + interval;
                break;
            }
            case ORACLE: {
                condition = expr + " >= current_timestamp - numtodsinterval(" + interval + " , 'second')";
                break;
            }
            default: {
                String msg = "Unknown database product: " + dbProduct.toString();
                LOG.error(msg);
                throw new MetaException(msg);
            }
        }
        return condition;
    }

    protected String getIdentifierQuoteString(Connection conn) throws SQLException {
        if (this.identifierQuoteString == null) {
            this.identifierQuoteString = conn.getMetaData().getIdentifierQuoteString();
        }
        return this.identifierQuoteString;
    }

    private void determineDatabaseProduct(Connection conn) {
        try {
            String s = conn.getMetaData().getDatabaseProductName();
            dbProduct = DatabaseProduct.determineDatabaseProduct(s);
            if (dbProduct == DatabaseProduct.OTHER) {
                String msg = "Unrecognized database product name <" + s + ">";
                LOG.error(msg);
                throw new IllegalStateException(msg);
            }
        }
        catch (SQLException e) {
            String msg = "Unable to get database product name";
            LOG.error(msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
    }

    private int abortTxns(Connection dbConn, List<Long> txnids, boolean skipCount, boolean isReplReplayed, TxnErrorMsg txnErrorMsg) throws SQLException, MetaException {
        return this.abortTxns(dbConn, txnids, false, skipCount, isReplReplayed, txnErrorMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int abortTxns(Connection dbConn, List<Long> txnids, boolean checkHeartbeat, boolean skipCount, boolean isReplReplayed, TxnErrorMsg txnErrorMsg) throws SQLException, MetaException {
        Statement stmt = null;
        if (txnids.isEmpty()) {
            return 0;
        }
        Collections.sort(txnids);
        LOG.debug("Aborting {} transaction(s) {} due to {}", new Object[]{txnids.size(), txnids, txnErrorMsg});
        this.removeTxnsFromMinHistoryLevel(dbConn, txnids);
        this.removeWriteIdsFromMinHistory(dbConn, txnids);
        try {
            stmt = dbConn.createStatement();
            ArrayList<String> queries = new ArrayList<String>();
            StringBuilder prefix = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            prefix.append("UPDATE \"TXNS\" SET \"TXN_STATE\" = ").append((Object)TxnStatus.ABORTED).append(" , \"TXN_META_INFO\" = ").append(txnErrorMsg.toSqlString()).append(" WHERE \"TXN_STATE\" = ").append((Object)TxnStatus.OPEN).append(" AND ");
            if (checkHeartbeat) {
                suffix.append(" AND \"TXN_LAST_HEARTBEAT\" < ").append(TxnUtils.getEpochFn(dbProduct)).append("-").append(this.timeout);
            }
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnids, "\"TXN_ID\"", true, false);
            int numUpdateQueries = queries.size();
            suffix.setLength(0);
            prefix.setLength(0);
            prefix.append("DELETE FROM \"HIVE_LOCKS\" WHERE ");
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnids, "\"HL_TXNID\"", false, false);
            prefix.setLength(0);
            suffix.setLength(0);
            prefix.append("DELETE FROM \"MATERIALIZATION_REBUILD_LOCKS\" WHERE ");
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnids, "\"MRL_TXN_ID\"", false, false);
            if (!isReplReplayed) {
                for (String database : this.getDbNamesForReplayedTxns(dbConn, txnids)) {
                    this.markDbAsReplIncompatible(dbConn, database);
                }
                prefix.setLength(0);
                suffix.setLength(0);
                prefix.append("DELETE FROM \"REPL_TXN_MAP\" WHERE ");
                TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, txnids, "\"RTM_TARGET_TXN_ID\"", false, false);
            }
            int numAborted = 0;
            if (skipCount) {
                TxnUtils.executeQueriesInBatchNoCount(dbProduct, stmt, queries, this.maxBatchSize);
            } else {
                List<Integer> affectedRowsByQuery = TxnUtils.executeQueriesInBatch(stmt, queries, this.maxBatchSize);
                numAborted = this.getUpdateCount(numUpdateQueries, affectedRowsByQuery);
            }
            if (MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_EXT_ON)) {
                Metrics.getOrCreateCounter("total_num_aborted_transactions").inc((long)txnids.size());
            }
            LOG.warn("Aborted {} transaction(s) {} due to {}", new Object[]{txnids.size(), txnids, txnErrorMsg});
            int n = numAborted;
            return n;
        }
        finally {
            TxnHandler.closeStmt(stmt);
        }
    }

    private int getUpdateCount(int numUpdateQueries, List<Integer> affectedRowsByQuery) {
        return affectedRowsByQuery.stream().limit(numUpdateQueries).mapToInt(Integer::intValue).sum();
    }

    private static boolean isValidTxn(long txnId) {
        return txnId != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RetrySemantics.SafeToRetry(value={"See @SafeToRetry"})
    private LockResponse checkLock(Connection dbConn, long extLockId, long txnId, boolean zeroWaitReadEnabled, boolean isExclusiveCTAS) throws NoSuchLockException, TxnAbortedException, MetaException, SQLException {
        List<LockInfo> locksBeingChecked;
        LockResponse response;
        ResultSet rs;
        Statement stmt;
        block14: {
            long intLockId;
            LockInfo blockedBy;
            block15: {
                LockResponse lockResponse;
                stmt = null;
                rs = null;
                response = new LockResponse();
                boolean isPartOfDynamicPartitionInsert = true;
                try {
                    locksBeingChecked = this.getLocksFromLockId(dbConn, extLockId);
                    response.setLockid(extLockId);
                    ArrayList<LockInfo> writeSet = new ArrayList<LockInfo>();
                    for (LockInfo lockInfo : locksBeingChecked) {
                        if (isPartOfDynamicPartitionInsert || lockInfo.type != LockType.SHARED_WRITE) continue;
                        writeSet.add(lockInfo);
                    }
                    if (!writeSet.isEmpty()) {
                        if (((LockInfo)writeSet.get(0)).txnId == 0L) {
                            throw new IllegalStateException("Found Write lock for " + JavaUtils.lockIdToString(extLockId) + " but no txnid");
                        }
                        stmt = dbConn.createStatement();
                        StringBuilder sb = new StringBuilder(" \"WS_DATABASE\", \"WS_TABLE\", \"WS_PARTITION\", \"WS_TXNID\", \"WS_COMMIT_ID\" FROM \"WRITE_SET\" WHERE WS_COMMIT_ID >= " + ((LockInfo)writeSet.get(0)).txnId + " AND (");
                        for (LockInfo info : writeSet) {
                            sb.append("(\"WS_DATABASE\" = ").append(TxnHandler.quoteString(info.db)).append(" AND \"WS_TABLE\" = ").append(TxnHandler.quoteString(info.table)).append(" AND \"WS_PARTITION\" ").append(info.partition == null ? "IS NULL" : "= " + TxnHandler.quoteString(info.partition)).append(") OR ");
                        }
                        sb.setLength(sb.length() - 4);
                        sb.append(")");
                        rs = stmt.executeQuery(sqlGenerator.addLimitClause(1, sb.toString()));
                        if (rs.next()) {
                            void var15_17;
                            String string = rs.getString(1) + '/' + rs.getString(2);
                            String partName = rs.getString(3);
                            if (partName != null) {
                                String string2 = string + '/' + partName;
                            }
                            String msg = "Aborting " + JavaUtils.txnIdToString(((LockInfo)writeSet.get(0)).txnId) + " since a concurrent committed transaction [" + JavaUtils.txnIdToString(rs.getLong(4)) + "," + rs.getLong(5) + "] has already updated resource '" + (String)var15_17 + "'";
                            LOG.info(msg);
                            if (this.abortTxns(dbConn, Collections.singletonList(((LockInfo)writeSet.get(0)).txnId), false, false, TxnErrorMsg.ABORT_CONCURRENT) != 1) {
                                throw new IllegalStateException(msg + " FAILED!");
                            }
                            dbConn.commit();
                            throw new TxnAbortedException(msg);
                        }
                        TxnHandler.close(rs, stmt, null);
                    }
                    String queryStr = " \"EX\".*, \"REQ\".\"HL_LOCK_INT_ID\" \"LOCK_INT_ID\", \"REQ\".\"HL_LOCK_TYPE\" \"LOCK_TYPE\" FROM ( SELECT \"HL_LOCK_EXT_ID\", \"HL_LOCK_INT_ID\", \"HL_TXNID\", \"HL_DB\", \"HL_TABLE\", \"HL_PARTITION\", \"HL_LOCK_STATE\", \"HL_LOCK_TYPE\" FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" < " + extLockId + ") \"EX\" INNER JOIN ( SELECT \"HL_LOCK_INT_ID\", \"HL_TXNID\", \"HL_DB\", \"HL_TABLE\", \"HL_PARTITION\", \"HL_LOCK_TYPE\" FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = " + extLockId + ") \"REQ\" ON \"EX\".\"HL_DB\" = \"REQ\".\"HL_DB\" AND (\"EX\".\"HL_TABLE\" IS NULL OR \"REQ\".\"HL_TABLE\" IS NULL OR \"EX\".\"HL_TABLE\" = \"REQ\".\"HL_TABLE\" AND (\"EX\".\"HL_PARTITION\" IS NULL OR \"REQ\".\"HL_PARTITION\" IS NULL OR \"EX\".\"HL_PARTITION\" = \"REQ\".\"HL_PARTITION\")) WHERE (\"REQ\".\"HL_TXNID\" = 0 OR \"EX\".\"HL_TXNID\" != \"REQ\".\"HL_TXNID\") AND ";
                    String[] stringArray = new String[]{" \"REQ\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.sharedRead() + " AND \"EX\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.exclusive() + " AND NOT (\"EX\".\"HL_TABLE\" IS NOT NULL AND \"REQ\".\"HL_TABLE\" IS NULL)", " \"REQ\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.exclusive() + " AND NOT (\"EX\".\"HL_TABLE\" IS NULL AND \"EX\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.sharedRead() + " AND \"REQ\".\"HL_TABLE\" IS NOT NULL)", " \"REQ\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.sharedWrite() + " AND \"EX\".\"HL_LOCK_TYPE\" IN (" + LockTypeUtil.exclWrite() + "," + LockTypeUtil.exclusive() + ")", " \"REQ\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.exclWrite() + " AND \"EX\".\"HL_LOCK_TYPE\"!=" + LockTypeUtil.sharedRead()};
                    ArrayList<String> subQuery = new ArrayList<String>();
                    for (String subCond : stringArray) {
                        subQuery.add("(" + sqlGenerator.addLimitClause(1, queryStr + subCond) + ")");
                    }
                    String query = String.join((CharSequence)" UNION ALL ", subQuery);
                    stmt = dbConn.createStatement();
                    LOG.debug("Going to execute query <{}>", (Object)query);
                    rs = stmt.executeQuery(query);
                    if (!rs.next()) break block14;
                    blockedBy = new LockInfo(rs);
                    intLockId = rs.getLong("LOCK_INT_ID");
                    char lockChar = rs.getString("LOCK_TYPE").charAt(0);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failure to acquire lock({} intLockId:{} {}), blocked by ({})", new Object[]{JavaUtils.lockIdToString(extLockId), intLockId, JavaUtils.txnIdToString(txnId), blockedBy});
                    }
                    LockType lockType = LockTypeUtil.getLockTypeFromEncoding(lockChar).orElseThrow(() -> new MetaException("Unknown lock type: " + lockChar));
                    if ((!zeroWaitReadEnabled || LockType.SHARED_READ != lockType) && !isExclusiveCTAS || !TxnHandler.isValidTxn(txnId)) break block15;
                    String cleanupQuery = "DELETE FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = " + extLockId;
                    LOG.debug("Going to execute query: <{}>", (Object)cleanupQuery);
                    stmt.executeUpdate(cleanupQuery);
                    dbConn.commit();
                    response.setErrorMessage(String.format(isExclusiveCTAS ? EXCL_CTAS_ERR_MSG : ZERO_WAIT_READ_ERR_MSG, blockedBy));
                    response.setState(LockState.NOT_ACQUIRED);
                    lockResponse = response;
                }
                catch (Throwable throwable) {
                    TxnHandler.close(rs, stmt, null);
                    throw throwable;
                }
                TxnHandler.close(rs, stmt, null);
                return lockResponse;
            }
            String updateBlockedByQuery = "UPDATE \"HIVE_LOCKS\" SET \"HL_BLOCKEDBY_EXT_ID\" = " + blockedBy.extLockId + ", \"HL_BLOCKEDBY_INT_ID\" = " + blockedBy.intLockId + " WHERE \"HL_LOCK_EXT_ID\" = " + extLockId + " AND \"HL_LOCK_INT_ID\" = " + intLockId;
            LOG.debug("Going to execute query: <{}>", (Object)updateBlockedByQuery);
            int updCnt = stmt.executeUpdate(updateBlockedByQuery);
            if (updCnt != 1) {
                LOG.error("Failure to update lock (extLockId={}, intLockId={}) with the blocking lock's IDs (extLockId={}, intLockId={})", new Object[]{extLockId, intLockId, blockedBy.extLockId, blockedBy.intLockId});
                TxnHandler.shouldNeverHappen(txnId, extLockId, intLockId);
            }
            dbConn.commit();
            response.setState(LockState.WAITING);
            LockResponse lockResponse = response;
            TxnHandler.close(rs, stmt, null);
            return lockResponse;
        }
        this.acquire(dbConn, stmt, locksBeingChecked);
        LOG.debug("Successfully acquired locks: {}", locksBeingChecked);
        dbConn.commit();
        response.setState(LockState.ACQUIRED);
        TxnHandler.close(rs, stmt, null);
        return response;
    }

    private void acquire(Connection dbConn, Statement stmt, List<LockInfo> locksBeingChecked) throws SQLException, NoSuchLockException, MetaException {
        if (locksBeingChecked == null || locksBeingChecked.isEmpty()) {
            return;
        }
        long txnId = locksBeingChecked.get(0).txnId;
        long extLockId = locksBeingChecked.get(0).extLockId;
        String s = "UPDATE \"HIVE_LOCKS\" SET \"HL_LOCK_STATE\" = 'a', \"HL_LAST_HEARTBEAT\" = " + (TxnHandler.isValidTxn(txnId) ? Integer.valueOf(0) : TxnUtils.getEpochFn(dbProduct)) + ",\"HL_ACQUIRED_AT\" = " + TxnUtils.getEpochFn(dbProduct) + ",\"HL_BLOCKEDBY_EXT_ID\"=NULL,\"HL_BLOCKEDBY_INT_ID\"=NULL WHERE \"HL_LOCK_EXT_ID\" = " + extLockId;
        LOG.debug("Going to execute update <{}>", (Object)s);
        int rc = stmt.executeUpdate(s);
        if (rc < locksBeingChecked.size()) {
            LOG.error("Failure to acquire all locks (acquired: {}, total needed: {}).", (Object)rc, (Object)locksBeingChecked.size());
            dbConn.rollback();
            String errorMsgTemplate = "No such lock(s): (%s: %s) %s";
            Set notFoundIds = locksBeingChecked.stream().map(lockInfo -> Long.toString(((LockInfo)lockInfo).intLockId)).collect(Collectors.toSet());
            String getIntIdsQuery = "SELECT \"HL_LOCK_INT_ID\" FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = " + extLockId;
            LOG.debug("Going to execute query: <{}>", (Object)getIntIdsQuery);
            try (ResultSet rs = stmt.executeQuery(getIntIdsQuery);){
                while (rs.next()) {
                    notFoundIds.remove(rs.getString(1));
                }
            }
            String errorMsg = String.format(errorMsgTemplate, JavaUtils.lockIdToString(extLockId), String.join((CharSequence)", ", notFoundIds), JavaUtils.txnIdToString(txnId));
            throw new NoSuchLockException(errorMsg);
        }
    }

    private void heartbeatLock(Connection dbConn, long extLockId) throws NoSuchLockException, SQLException, MetaException {
        if (extLockId == 0L) {
            return;
        }
        try (Statement stmt = dbConn.createStatement();){
            String updateHeartbeatQuery = "UPDATE \"HIVE_LOCKS\" SET \"HL_LAST_HEARTBEAT\" = " + TxnUtils.getEpochFn(dbProduct) + " WHERE \"HL_LOCK_EXT_ID\" = " + extLockId;
            LOG.debug("Going to execute update <{}>", (Object)updateHeartbeatQuery);
            int rc = stmt.executeUpdate(updateHeartbeatQuery);
            if (rc < 1) {
                LOG.error("Failure to update last heartbeat for extLockId={}.", (Object)extLockId);
                dbConn.rollback();
                throw new NoSuchLockException("No such lock: " + JavaUtils.lockIdToString(extLockId));
            }
            LOG.debug("Successfully heartbeated for extLockId={}", (Object)extLockId);
            dbConn.commit();
        }
    }

    private void heartbeatTxn(Connection dbConn, long txnid) throws NoSuchTxnException, TxnAbortedException, SQLException, MetaException {
        if (txnid == 0L) {
            return;
        }
        try (Statement stmt = dbConn.createStatement();){
            String s = "UPDATE \"TXNS\" SET \"TXN_LAST_HEARTBEAT\" = " + TxnUtils.getEpochFn(dbProduct) + " WHERE \"TXN_ID\" = " + txnid + " AND \"TXN_STATE\" = " + (Object)((Object)TxnStatus.OPEN);
            LOG.debug("Going to execute update <{}>", (Object)s);
            int rc = stmt.executeUpdate(s);
            if (rc < 1) {
                TxnHandler.ensureValidTxn(dbConn, txnid, stmt);
                LOG.error("Can neither heartbeat txn (txnId={}) nor confirm it as invalid.", (Object)txnid);
                dbConn.rollback();
                throw new NoSuchTxnException("No such txn: " + txnid);
            }
            LOG.debug("Successfully heartbeated for txnId={}", (Object)txnid);
            dbConn.commit();
        }
    }

    private TxnStatus findTxnState(long txnid, Statement stmt) throws SQLException, MetaException {
        String s = "SELECT \"TXN_STATE\" FROM \"TXNS\" WHERE \"TXN_ID\" = " + txnid;
        LOG.debug("Going to execute query <{}>", (Object)s);
        try (ResultSet rs = stmt.executeQuery(s);){
            if (!rs.next()) {
                s = sqlGenerator.addLimitClause(1, "1 FROM \"COMPLETED_TXN_COMPONENTS\" WHERE \"CTC_TXNID\" = " + txnid);
                LOG.debug("Going to execute query <{}>", (Object)s);
                try (ResultSet rs2 = stmt.executeQuery(s);){
                    if (rs2.next()) {
                        TxnStatus txnStatus = TxnStatus.COMMITTED;
                        return txnStatus;
                    }
                }
                TxnStatus txnStatus = TxnStatus.UNKNOWN;
                return txnStatus;
            }
            TxnStatus txnStatus = TxnStatus.fromString(rs.getString(1));
            return txnStatus;
        }
    }

    private boolean isTxnsOpenAndNotReadOnly(List<Long> txnIds, Statement stmt) throws SQLException {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        prefix.append("SELECT COUNT(*) FROM \"TXNS\" WHERE \"TXN_STATE\" = " + (Object)((Object)TxnStatus.OPEN) + " AND \"TXN_TYPE\" != " + TxnType.READ_ONLY.getValue() + " AND ");
        TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, new StringBuilder(), txnIds, "\"TXN_ID\"", false, false);
        long count = 0L;
        for (String query : queries) {
            LOG.debug("Going to execute query <{}>", (Object)query);
            ResultSet rs = stmt.executeQuery(query);
            Throwable throwable = null;
            try {
                if (!rs.next()) continue;
                count += rs.getLong(1);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs == null) continue;
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rs.close();
            }
        }
        return count == (long)txnIds.size();
    }

    private String getAbortedAndReadOnlyTxns(List<Long> txnIds, Statement stmt) throws SQLException {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        prefix.append("SELECT \"TXN_ID\", \"TXN_STATE\", \"TXN_TYPE\" FROM \"TXNS\" WHERE ");
        TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, new StringBuilder(), txnIds, "\"TXN_ID\"", false, false);
        StringBuilder txnInfo = new StringBuilder();
        for (String query : queries) {
            LOG.debug("Going to execute query <{}>", (Object)query);
            ResultSet rs = stmt.executeQuery(query);
            Throwable throwable = null;
            try {
                while (rs.next()) {
                    long txnId = rs.getLong(1);
                    TxnStatus txnState = TxnStatus.fromString(rs.getString(2));
                    TxnType txnType = TxnType.findByValue(rs.getInt(3));
                    if (txnState != TxnStatus.OPEN) {
                        txnInfo.append("{").append(txnId).append(",").append((Object)txnState).append("}");
                        continue;
                    }
                    if (txnType != TxnType.READ_ONLY) continue;
                    txnInfo.append("{").append(txnId).append(",read-only}");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs == null) continue;
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rs.close();
            }
        }
        return txnInfo.toString();
    }

    private String getCommittedTxns(List<Long> txnIds, Statement stmt) throws SQLException {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        prefix.append("SELECT \"CTC_TXNID\" FROM \"COMPLETED_TXN_COMPONENTS\" WHERE ");
        TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, new StringBuilder(), txnIds, "\"CTC_TXNID\"", false, false);
        StringBuilder txnInfo = new StringBuilder();
        for (String query : queries) {
            LOG.debug("Going to execute query <{}>", (Object)query);
            ResultSet rs = stmt.executeQuery(query);
            Throwable throwable = null;
            try {
                while (rs.next()) {
                    long txnId = rs.getLong(1);
                    txnInfo.append("{").append(txnId).append(",c}");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs == null) continue;
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rs.close();
            }
        }
        return txnInfo.toString();
    }

    private static void raiseTxnUnexpectedState(TxnStatus actualStatus, long txnid) throws NoSuchTxnException, TxnAbortedException {
        switch (actualStatus) {
            case ABORTED: {
                throw new TxnAbortedException("Transaction " + JavaUtils.txnIdToString(txnid) + " already aborted");
            }
            case COMMITTED: {
                throw new NoSuchTxnException("Transaction " + JavaUtils.txnIdToString(txnid) + " is already committed.");
            }
            case UNKNOWN: {
                throw new NoSuchTxnException("No such transaction " + JavaUtils.txnIdToString(txnid));
            }
            case OPEN: {
                throw new NoSuchTxnException(JavaUtils.txnIdToString(txnid) + " is " + (Object)((Object)TxnStatus.OPEN));
            }
        }
        throw new IllegalArgumentException("Unknown TxnStatus " + (Object)((Object)actualStatus));
    }

    private static void ensureValidTxn(Connection dbConn, long txnid, Statement stmt) throws SQLException, NoSuchTxnException, TxnAbortedException {
        String s = "SELECT \"TXN_STATE\" FROM \"TXNS\" WHERE \"TXN_ID\" = " + txnid;
        LOG.debug("Going to execute query <{}>", (Object)s);
        try (ResultSet rs = stmt.executeQuery(s);){
            if (!rs.next()) {
                s = "SELECT COUNT(*) FROM \"COMPLETED_TXN_COMPONENTS\" WHERE \"CTC_TXNID\" = " + txnid;
                ResultSet rs2 = stmt.executeQuery(s);
                Throwable throwable = null;
                try {
                    try {
                        boolean alreadyCommitted = rs2.next() && rs2.getInt(1) > 0;
                        LOG.debug("Going to rollback");
                        TxnHandler.rollbackDBConn(dbConn);
                        if (alreadyCommitted) {
                            throw new NoSuchTxnException("Transaction " + JavaUtils.txnIdToString(txnid) + " is already committed.");
                        }
                        throw new NoSuchTxnException("No such transaction " + JavaUtils.txnIdToString(txnid));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                    throw throwable3;
                }
            }
            if (TxnStatus.fromString(rs.getString(1)) == TxnStatus.ABORTED) {
                LOG.debug("Going to rollback");
                TxnHandler.rollbackDBConn(dbConn);
                throw new TxnAbortedException("Transaction " + JavaUtils.txnIdToString(txnid) + " already aborted");
            }
        }
    }

    /*
     * Exception decompiling
     */
    private Optional<LockInfo> getLockFromLockId(Connection dbConn, long extLockId) throws MetaException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<LockInfo> getLocksFromLockId(Connection dbConn, long extLockId) throws MetaException, SQLException {
        try (PreparedStatement pstmt = dbConn.prepareStatement(SELECT_LOCKS_FOR_LOCK_ID_QUERY);){
            ArrayList<LockInfo> locks = new ArrayList<LockInfo>();
            pstmt.setLong(1, extLockId);
            LOG.debug("Going to execute query <{}> for extLockId={}", (Object)SELECT_LOCKS_FOR_LOCK_ID_QUERY, (Object)extLockId);
            try (ResultSet rs = pstmt.executeQuery();){
                while (rs.next()) {
                    locks.add(new LockInfo(rs));
                }
            }
            if (locks.isEmpty()) {
                throw new MetaException("This should never happen!  We already checked the lock(" + JavaUtils.lockIdToString(extLockId) + ") existed but now we can't find it!");
            }
            LOG.debug("Found {} locks for extLockId={}. Locks: {}", new Object[]{locks.size(), extLockId, locks});
            ArrayList<LockInfo> arrayList = locks;
            return arrayList;
        }
    }

    private void timeOutLocks(Connection dbConn) {
        TreeSet<Long> timedOutLockIds = new TreeSet<Long>();
        try (PreparedStatement pstmt = dbConn.prepareStatement(String.format(SELECT_TIMED_OUT_LOCKS_QUERY, TxnUtils.getEpochFn(dbProduct)));){
            pstmt.setLong(1, this.timeout);
            LOG.debug("Going to execute query: <{}>", (Object)SELECT_TIMED_OUT_LOCKS_QUERY);
            try (ResultSet rs = pstmt.executeQuery();){
                while (rs.next()) {
                    timedOutLockIds.add(rs.getLong(1));
                }
                dbConn.commit();
                if (timedOutLockIds.isEmpty()) {
                    LOG.debug("Did not find any timed-out locks, therefore retuning.");
                    return;
                }
            }
            ArrayList<String> queries = new ArrayList<String>();
            StringBuilder prefix = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            prefix.append("DELETE FROM \"HIVE_LOCKS\" WHERE \"HL_LAST_HEARTBEAT\" < ");
            prefix.append(TxnUtils.getEpochFn(dbProduct)).append("-").append(this.timeout);
            prefix.append(" AND \"HL_TXNID\" = 0 AND ");
            suffix.append("");
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, suffix, timedOutLockIds, "\"HL_LOCK_EXT_ID\"", true, false);
            try (Statement stmt = dbConn.createStatement();){
                int deletedLocks = 0;
                for (String query : queries) {
                    LOG.debug("Going to execute update: <{}>", (Object)query);
                    deletedLocks += stmt.executeUpdate(query);
                }
                if (deletedLocks > 0) {
                    LOG.info("Deleted {} locks due to timed-out. Lock ids: {}", (Object)deletedLocks, timedOutLockIds);
                }
                dbConn.commit();
            }
        }
        catch (SQLException ex) {
            LOG.error("Failed to purge timed-out locks: " + TxnHandler.getMessage(ex), (Throwable)ex);
        }
        catch (Exception ex) {
            LOG.error("Failed to purge timed-out locks: " + ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.Idempotent
    public void performTimeOuts() {
        dbConn = null;
        stmt = null;
        rs = null;
        try {
            dbConn = this.getDbConn(2);
            this.timeOutLocks(dbConn);
lbl7:
            // 3 sources

            while (true) {
                stmt = dbConn.createStatement();
                s = " \"TXN_ID\", \"TXN_TYPE\" FROM \"TXNS\" WHERE \"TXN_STATE\" = " + (Object)TxnStatus.OPEN + " AND (\"TXN_TYPE\" != " + TxnType.REPL_CREATED.getValue() + " AND \"TXN_LAST_HEARTBEAT\" <  " + TxnUtils.getEpochFn(TxnHandler.dbProduct) + "-" + this.timeout + " OR  \"TXN_TYPE\" = " + TxnType.REPL_CREATED.getValue() + " AND \"TXN_LAST_HEARTBEAT\" <  " + TxnUtils.getEpochFn(TxnHandler.dbProduct) + "-" + this.replicationTxnTimeout + ")";
                s = TxnHandler.sqlGenerator.addLimitClause(500000, s);
                TxnHandler.LOG.debug("Going to execute query <{}>", (Object)s);
                rs = stmt.executeQuery(s);
                if (rs.next()) ** GOTO lbl-1000
                ** GOTO lbl26
                break;
            }
        }
        catch (SQLException ex) {
            TxnHandler.LOG.warn("Aborting timed out transactions failed due to " + TxnHandler.getMessage(ex), (Throwable)ex);
            TxnHandler.close(rs, stmt, dbConn);
            return;
        }
        catch (MetaException e) {
            try {
                TxnHandler.LOG.warn("Aborting timed out transactions failed due to " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable var13_15) {
                TxnHandler.close(rs, stmt, dbConn);
                throw var13_15;
            }
lbl26:
            // 1 sources

            TxnHandler.close(rs, stmt, dbConn);
            return;
lbl-1000:
            // 1 sources

            {
                timedOutTxns = new ArrayList<HashMap<K, V>>();
                currentBatch = new HashMap<Long, TxnType>(50000);
                timedOutTxns.add(currentBatch);
                do {
                    if (currentBatch.size() == 50000) {
                        currentBatch = new HashMap<K, V>(50000);
                        timedOutTxns.add(currentBatch);
                    }
                    currentBatch.put(rs.getLong(1), TxnType.findByValue(rs.getInt(2)));
                } while (rs.next());
                dbConn.commit();
                TxnHandler.close(rs, stmt, null);
                numTxnsAborted = 0;
                for (Map var9_11 : timedOutTxns) {
                    if (this.abortTxns(dbConn, new ArrayList<Long>(var9_11.keySet()), true, false, false, TxnErrorMsg.ABORT_TIMEOUT) == var9_11.size()) {
                        dbConn.commit();
                        numTxnsAborted += var9_11.size();
                        TxnHandler.LOG.info("Aborted the following transactions due to timeout: {}", (Object)var9_11);
                        if (this.transactionalListeners != null) {
                            for (Map.Entry<K, V> txnEntry : var9_11.entrySet()) {
                                dbsUpdated = this.getTxnDbsUpdated((Long)txnEntry.getKey(), dbConn);
                                MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.ABORT_TXN, new AbortTxnEvent((Long)txnEntry.getKey(), (TxnType)txnEntry.getValue(), null), dbConn, TxnHandler.sqlGenerator);
                                dbConn.commit();
                            }
                            TxnHandler.LOG.debug("Added Notifications for the transactions that are aborted due to timeout: {}", (Object)var9_11);
                        }
                        TxnHandler.LOG.info("Aborted the following transactions due to timeout: " + var9_11.toString());
                        continue;
                    }
                    dbConn.rollback();
                }
                TxnHandler.LOG.info("Aborted {} transaction(s) due to timeout", (Object)numTxnsAborted);
                if (!MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_EXT_ON)) ** GOTO lbl7
                Metrics.getOrCreateCounter("total_num_timed_out_transactions").inc((long)numTxnsAborted);
                ** continue;
            }
            TxnHandler.close(rs, stmt, dbConn);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.ReadOnly
    public void countOpenTxns() throws MetaException {
        block9: {
            Connection dbConn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                block8: {
                    try {
                        dbConn = this.getDbConn(2);
                        stmt = dbConn.createStatement();
                        String s = "SELECT COUNT(*) FROM \"TXNS\" WHERE \"TXN_STATE\" = " + (Object)((Object)TxnStatus.OPEN);
                        LOG.debug("Going to execute query <{}>", (Object)s);
                        rs = stmt.executeQuery(s);
                        if (!rs.next()) {
                            LOG.error("Transaction database not properly configured, can't find txn_state from TXNS.");
                            break block8;
                        }
                        Long numOpen = rs.getLong(1);
                        if (numOpen > Integer.MAX_VALUE) {
                            LOG.error("Open transaction count above {}, can't count that high!", (Object)Integer.MAX_VALUE);
                            break block8;
                        }
                        this.numOpenTxns.set(numOpen.intValue());
                    }
                    catch (SQLException e) {
                        try {
                            LOG.info("Failed to update number of open transactions");
                            this.checkRetryable(e, "countOpenTxns()");
                        }
                        catch (Throwable throwable) {
                            TxnHandler.close(rs, stmt, dbConn);
                            throw throwable;
                        }
                        TxnHandler.close(rs, stmt, dbConn);
                        break block9;
                    }
                }
                TxnHandler.close(rs, stmt, dbConn);
            }
            catch (RetryException e) {
                this.countOpenTxns();
            }
        }
    }

    @Deprecated
    private void addTxnToMinHistoryLevel(Connection dbConn, List<Long> txnIds, long minOpenTxnId) throws SQLException {
        if (!useMinHistoryLevel) {
            return;
        }
        try (Statement stmt = dbConn.createStatement();){
            List<String> rows = txnIds.stream().map(txnId -> txnId + ", " + minOpenTxnId).collect(Collectors.toList());
            List<String> inserts = sqlGenerator.createInsertValuesStmt("\"MIN_HISTORY_LEVEL\" (\"MHL_TXNID\", \"MHL_MIN_OPEN_TXNID\")", rows);
            for (String insert : inserts) {
                LOG.debug("Going to execute insert <{}>", (Object)insert);
                stmt.execute(insert);
            }
            LOG.info("Added entries to MIN_HISTORY_LEVEL for current txns: ({}) with min_open_txn: {}", txnIds, (Object)minOpenTxnId);
        }
        catch (SQLException e) {
            if (DatabaseProduct.isTableNotExistsError(dbProduct, e)) {
                useMinHistoryLevel = false;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.SafeToRetry
    public void addWriteIdsToMinHistory(long txnid, Map<String, Long> minOpenWriteIds) throws MetaException {
        block24: {
            if (!useMinHistoryWriteId) {
                return;
            }
            try {
                Connection dbConn = null;
                try {
                    dbConn = this.getDbConn(2);
                    try (PreparedStatement pstmt = dbConn.prepareStatement(MIN_HISTORY_WRITE_ID_INSERT_QUERY);){
                        int writeId = 0;
                        for (Map.Entry<String, Long> validWriteId : minOpenWriteIds.entrySet()) {
                            String[] names = TxnUtils.getDbTableName(validWriteId.getKey());
                            pstmt.setLong(1, txnid);
                            pstmt.setString(2, names[0]);
                            pstmt.setString(3, names[1]);
                            pstmt.setLong(4, validWriteId.getValue());
                            pstmt.addBatch();
                            if (++writeId % this.maxBatchSize != 0) continue;
                            LOG.debug("Executing a batch of <INSERT INTO \"TXN_TO_WRITE_ID\" (\"T2W_TXNID\", \"T2W_DATABASE\", \"T2W_TABLE\", \"T2W_WRITEID\") VALUES (?, ?, ?, ?)> queries. Batch size: " + this.maxBatchSize);
                            pstmt.executeBatch();
                        }
                        if (writeId % this.maxBatchSize != 0) {
                            LOG.debug("Executing a batch of <INSERT INTO \"TXN_TO_WRITE_ID\" (\"T2W_TXNID\", \"T2W_DATABASE\", \"T2W_TABLE\", \"T2W_WRITEID\") VALUES (?, ?, ?, ?)> queries. Batch size: " + writeId % this.maxBatchSize);
                            pstmt.executeBatch();
                        }
                    }
                    dbConn.commit();
                    LOG.info("Added entries to MIN_HISTORY_WRITE_ID for current txn: {} with min_open_write_ids: ({})", (Object)txnid, minOpenWriteIds);
                }
                catch (SQLException e) {
                    if (DatabaseProduct.isTableNotExistsError(dbProduct, e)) {
                        useMinHistoryWriteId = false;
                        break block24;
                    }
                    LOG.error("Caught exception while storing minOpenWriteIds: ", (Throwable)e);
                    TxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "addWriteIdsToMinHistory");
                    throw new MetaException(e.getMessage());
                }
                finally {
                    TxnHandler.closeDbConn(dbConn);
                }
            }
            catch (RetryException e) {
                this.addWriteIdsToMinHistory(txnid, minOpenWriteIds);
            }
        }
    }

    @Deprecated
    private void removeTxnsFromMinHistoryLevel(Connection dbConn, List<Long> txnids) throws SQLException {
        if (!useMinHistoryLevel) {
            return;
        }
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder("DELETE FROM \"MIN_HISTORY_LEVEL\" WHERE ");
        try (Statement stmt = dbConn.createStatement();){
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, new StringBuilder(), txnids, "\"MHL_TXNID\"", false, false);
            TxnUtils.executeQueriesInBatchNoCount(dbProduct, stmt, queries, this.maxBatchSize);
            LOG.info("Removed transactions: ({}) from MIN_HISTORY_LEVEL", txnids);
        }
        catch (SQLException e) {
            if (DatabaseProduct.isTableNotExistsError(dbProduct, e)) {
                useMinHistoryLevel = false;
            }
            throw e;
        }
    }

    private void removeWriteIdsFromMinHistory(Connection dbConn, List<Long> txnids) throws SQLException {
        if (!useMinHistoryWriteId) {
            return;
        }
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder("DELETE FROM \"MIN_HISTORY_WRITE_ID\" WHERE ");
        try (Statement stmt = dbConn.createStatement();){
            TxnUtils.buildQueryWithINClause(this.conf, queries, prefix, new StringBuilder(), txnids, "\"MH_TXNID\"", false, false);
            TxnUtils.executeQueriesInBatchNoCount(dbProduct, stmt, queries, this.maxBatchSize);
            LOG.info("Removed transactions: ({}) from MIN_HISTORY_WRITE_ID", txnids);
        }
        catch (SQLException e) {
            if (DatabaseProduct.isTableNotExistsError(dbProduct, e)) {
                useMinHistoryWriteId = false;
            }
            throw e;
        }
    }

    protected static synchronized DataSource setupJdbcConnectionPool(Configuration conf, int maxPoolSize) {
        DataSourceProvider dsp = DataSourceProviderFactory.tryGetDataSourceProviderOrNull(conf);
        if (dsp != null) {
            try {
                doRetryOnConnPool = dsp.mayReturnClosedConnection();
                return dsp.create(conf, maxPoolSize);
            }
            catch (SQLException e) {
                LOG.error("Unable to instantiate JDBC connection pooling", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        String connectionPooler = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.CONNECTION_POOLING_TYPE).toLowerCase();
        if ("none".equals(connectionPooler)) {
            LOG.info("Choosing not to pool JDBC connections");
            return new NoPoolConnectionPool(conf);
        }
        throw new RuntimeException("Unknown JDBC connection pooling " + connectionPooler);
    }

    static boolean isRetryable(Configuration conf, Exception ex) {
        if (ex instanceof SQLException) {
            SQLException sqlException = (SQLException)ex;
            if ("08S01".equalsIgnoreCase(sqlException.getSQLState())) {
                return true;
            }
            if ("ORA-08176".equalsIgnoreCase(sqlException.getSQLState()) || sqlException.getMessage().contains("consistent read failure; rollback data not available")) {
                return true;
            }
            String regex = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.TXN_RETRYABLE_SQLEX_REGEX);
            if (regex != null && !regex.isEmpty()) {
                String[] patterns = regex.split(",(?=\\S)");
                String message = TxnHandler.getMessage((SQLException)ex);
                for (String p : patterns) {
                    if (!Pattern.matches(p, message)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isDuplicateKeyError(SQLException ex) {
        return DatabaseProduct.isDuplicateKeyError(dbProduct, ex);
    }

    private static String getMessage(SQLException ex) {
        return ex.getMessage() + " (SQLState=" + ex.getSQLState() + ", ErrorCode=" + ex.getErrorCode() + ")";
    }

    static String quoteString(String input) {
        return "'" + input + "'";
    }

    static String quoteChar(char c) {
        return "'" + c + "'";
    }

    protected void lockInternal() {
        if (dbProduct == DatabaseProduct.DERBY) {
            derbyLock.lock();
        }
    }

    protected void unlockInternal() {
        if (dbProduct == DatabaseProduct.DERBY) {
            derbyLock.unlock();
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public TxnStore.MutexAPI getMutexAPI() {
        return this;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TxnStore.MutexAPI.LockHandle acquireLock(String key) throws MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        boolean needToCloseConn = true;
        try {
            LockHandleImpl lockHandleImpl;
            block15: {
                try {
                    String sqlStmt = sqlGenerator.addForUpdateClause("SELECT \"MT_COMMENT\", \"MT_KEY2\" FROM \"AUX_TABLE\" WHERE \"MT_KEY1\"=" + TxnHandler.quoteString(key));
                    this.lockInternal();
                    dbConn = this.getDbConn(2, connPoolMutex);
                    stmt = dbConn.createStatement();
                    LOG.debug("About to execute SQL: {}", (Object)sqlStmt);
                    rs = stmt.executeQuery(sqlStmt);
                    if (!rs.next()) {
                        TxnHandler.close(rs);
                        try {
                            stmt.executeUpdate("INSERT INTO \"AUX_TABLE\" (\"MT_KEY1\", \"MT_KEY2\") VALUES(" + TxnHandler.quoteString(key) + ", 0)");
                            dbConn.commit();
                        }
                        catch (SQLException ex) {
                            if (!this.isDuplicateKeyError(ex)) {
                                throw new RuntimeException("Unable to lock " + TxnHandler.quoteString(key) + " due to: " + TxnHandler.getMessage(ex), ex);
                            }
                            dbConn.rollback();
                        }
                        rs = stmt.executeQuery(sqlStmt);
                        if (!rs.next()) {
                            throw new IllegalStateException("Unable to lock " + TxnHandler.quoteString(key) + ".  Expected row in AUX_TABLE is missing.");
                        }
                    }
                    Semaphore derbySemaphore = null;
                    if (dbProduct == DatabaseProduct.DERBY) {
                        derbyKey2Lock.putIfAbsent(key, new Semaphore(1));
                        derbySemaphore = derbyKey2Lock.get(key);
                        derbySemaphore.acquire();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} locked by {}", (Object)TxnHandler.quoteString(key), (Object)TxnHandler.quoteString(hostname));
                    }
                    needToCloseConn = false;
                    lockHandleImpl = new LockHandleImpl(dbConn, stmt, rs, key, derbySemaphore);
                    if (!needToCloseConn) break block15;
                }
                catch (SQLException ex) {
                    try {
                        this.checkRetryable(ex, "acquireLock(" + key + ")");
                        throw new MetaException("Unable to lock " + TxnHandler.quoteString(key) + " due to: " + TxnHandler.getMessage(ex) + "; " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex));
                        catch (InterruptedException ex2) {
                            throw new MetaException("Unable to lock " + TxnHandler.quoteString(key) + " due to: " + ex2.getMessage() + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)ex2));
                        }
                    }
                    catch (Throwable throwable) {
                        if (needToCloseConn) {
                            TxnHandler.rollbackDBConn(dbConn);
                            TxnHandler.close(rs, stmt, dbConn);
                        }
                        this.unlockInternal();
                        throw throwable;
                    }
                }
                TxnHandler.rollbackDBConn(dbConn);
                TxnHandler.close(rs, stmt, dbConn);
            }
            this.unlockInternal();
            return lockHandleImpl;
        }
        catch (RetryException ex) {
            return this.acquireLock(key);
        }
    }

    @Override
    public void acquireLock(String key, TxnStore.MutexAPI.LockHandle handle) {
        throw new NotImplementedException();
    }

    static {
        doRetryOnConnPool = false;
        SELECT_METRICS_INFO_QUERY = "SELECT * FROM (SELECT COUNT(*) FROM \"TXN_TO_WRITE_ID\") \"TTWID\" CROSS JOIN (SELECT COUNT(*) FROM \"COMPLETED_TXN_COMPONENTS\") \"CTC\" CROSS JOIN (SELECT COUNT(*), MIN(\"TXN_ID\"), ({0} - MIN(\"TXN_STARTED\"))/1000 FROM \"TXNS\" WHERE \"TXN_STATE\"='" + (Object)((Object)TxnStatus.OPEN) + "' AND \"TXN_TYPE\" = " + TxnType.REPL_CREATED.getValue() + ") \"TR\" CROSS JOIN (SELECT COUNT(*), MIN(\"TXN_ID\"), ({0} - MIN(\"TXN_STARTED\"))/1000 FROM \"TXNS\" WHERE \"TXN_STATE\"='" + (Object)((Object)TxnStatus.OPEN) + "' AND \"TXN_TYPE\" != " + TxnType.REPL_CREATED.getValue() + ") \"T\" CROSS JOIN (SELECT COUNT(*), MIN(\"TXN_ID\"), ({0} - MIN(\"TXN_STARTED\"))/1000 FROM \"TXNS\" WHERE \"TXN_STATE\"='" + (Object)((Object)TxnStatus.ABORTED) + "') \"A\" CROSS JOIN (SELECT COUNT(*), ({0} - MIN(\"HL_ACQUIRED_AT\"))/1000 FROM \"HIVE_LOCKS\") \"HL\" CROSS JOIN (SELECT ({0} - MIN(\"CQ_COMMIT_TIME\"))/1000 from \"COMPACTION_QUEUE\" WHERE \"CQ_STATE\"=''" + 'r' + "'') OLDEST_CLEAN";
        SELECT_TABLES_WITH_X_ABORTED_TXNS = "SELECT \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\" FROM \"TXN_COMPONENTS\" INNER JOIN \"TXNS\" ON \"TC_TXNID\" = \"TXN_ID\" WHERE \"TXN_STATE\" = " + (Object)((Object)TxnStatus.ABORTED) + " GROUP BY \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\" HAVING COUNT(\"TXN_ID\") > ?";
        maxOpenTxns = 0;
        tooManyOpenTxns = false;
        derbyLock = new ReentrantLock(true);
        derbyKey2Lock = new ConcurrentHashMap();
        hostname = JavaUtils.hostname();
    }

    private static class NoPoolConnectionPool
    implements DataSource {
        private final Configuration conf;
        private Driver driver;
        private String connString;
        private String user;
        private String passwd;

        public NoPoolConnectionPool(Configuration conf) {
            this.conf = conf;
        }

        @Override
        public Connection getConnection() throws SQLException {
            if (this.user == null) {
                this.user = DataSourceProvider.getMetastoreJdbcUser(this.conf);
                this.passwd = DataSourceProvider.getMetastoreJdbcPasswd(this.conf);
            }
            return this.getConnection(this.user, this.passwd);
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            if (this.driver == null) {
                String driverName = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.CONNECTION_DRIVER);
                if (driverName == null || driverName.equals("")) {
                    String msg = "JDBC driver for transaction db not set in configuration file, need to set " + MetastoreConf.ConfVars.CONNECTION_DRIVER.getVarname();
                    LOG.error(msg);
                    throw new RuntimeException(msg);
                }
                try {
                    LOG.info("Going to load JDBC driver {}", (Object)driverName);
                    this.driver = (Driver)Class.forName(driverName).newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Unable to instantiate driver " + driverName + ", " + e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Unable to access driver " + driverName + ", " + e.getMessage(), e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to find driver " + driverName + ", " + e.getMessage(), e);
                }
                this.connString = MetastoreConf.getVar(this.conf, MetastoreConf.ConfVars.CONNECT_URL_KEY);
            }
            try {
                LOG.info("Connecting to transaction db with connection string {}", (Object)this.connString);
                Properties connectionProps = new Properties();
                connectionProps.setProperty("user", username);
                connectionProps.setProperty("password", password);
                Connection conn = this.driver.connect(this.connString, connectionProps);
                if (dbProduct == DatabaseProduct.MYSQL) {
                    try (Statement stmt = conn.createStatement();){
                        stmt.execute("SET @@session.sql_mode=ANSI_QUOTES");
                    }
                }
                conn.setAutoCommit(false);
                return conn;
            }
            catch (SQLException e) {
                throw new RuntimeException("Unable to connect to transaction manager using " + this.connString + ", " + e.getMessage(), e);
            }
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw new UnsupportedOperationException();
        }
    }

    private static final class LockHandleImpl
    implements TxnStore.MutexAPI.LockHandle {
        private final Connection dbConn;
        private final Statement stmt;
        private final ResultSet rs;
        private final Semaphore derbySemaphore;
        private final String key;
        private final Long lastUpdateTime;

        LockHandleImpl(Connection conn, Statement stmt, ResultSet rs, String key, Semaphore derbySemaphore) {
            Long lastUpdateTime;
            this.dbConn = conn;
            this.stmt = stmt;
            this.rs = rs;
            this.derbySemaphore = derbySemaphore;
            if (derbySemaphore != null) assert (derbySemaphore.availablePermits() == 0) : "Expected locked Semaphore";
            this.key = key;
            try {
                lastUpdateTime = rs.getLong("MT_KEY2");
            }
            catch (SQLException e) {
                LOG.warn("Couldn't resolve MT_KEY2 for MT_KEY1=" + TxnHandler.quoteString(this.key), (Throwable)e);
                lastUpdateTime = -1L;
            }
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public void releaseLocks() {
            TxnHandler.rollbackDBConn(this.dbConn);
            TxnHandler.close(this.rs, this.stmt, this.dbConn);
            if (this.derbySemaphore != null) {
                this.derbySemaphore.release();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} unlocked by {}", (Object)TxnHandler.quoteString(this.key), (Object)TxnHandler.quoteString(hostname));
            }
        }

        @Override
        public Long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public void releaseLocks(Long timestamp) {
            try {
                this.stmt.executeUpdate("UPDATE \"AUX_TABLE\" SET \"MT_KEY2\" = " + timestamp + " WHERE \"MT_KEY1\"=" + TxnHandler.quoteString(this.key));
                this.dbConn.commit();
            }
            catch (SQLException ex) {
                LOG.warn("Unable to update MT_KEY2 value for MT_KEY1=" + this.key, (Throwable)ex);
                TxnHandler.rollbackDBConn(this.dbConn);
            }
            TxnHandler.close(this.rs, this.stmt, this.dbConn);
            if (this.derbySemaphore != null) {
                this.derbySemaphore.release();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} unlocked by {}", (Object)TxnHandler.quoteString(this.key), (Object)TxnHandler.quoteString(hostname));
            }
        }
    }

    private static enum LockAction {
        ACQUIRE,
        WAIT,
        KEEP_LOOKING;

    }

    private static class LockInfoComparator
    implements Comparator<LockInfo>,
    Serializable {
        private LockTypeComparator lockTypeComparator = new LockTypeComparator();

        private LockInfoComparator() {
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }

        @Override
        public int compare(LockInfo info1, LockInfo info2) {
            if (info1.state == LockState.ACQUIRED && info2.state != LockState.ACQUIRED) {
                return -1;
            }
            if (info1.state != LockState.ACQUIRED && info2.state == LockState.ACQUIRED) {
                return 1;
            }
            int sortByType = this.lockTypeComparator.compare(info1.type, info2.type);
            if (sortByType != 0) {
                return sortByType;
            }
            if (info1.extLockId < info2.extLockId) {
                return -1;
            }
            if (info1.extLockId > info2.extLockId) {
                return 1;
            }
            if (info1.intLockId < info2.intLockId) {
                return -1;
            }
            if (info1.intLockId > info2.intLockId) {
                return 1;
            }
            return 0;
        }
    }

    private static class LockInfo {
        private final long extLockId;
        private final long intLockId;
        private final long txnId;
        private final String db;
        private final String table;
        private final String partition;
        private final LockState state;
        private final LockType type;

        LockInfo(ResultSet rs) throws SQLException, MetaException {
            this.extLockId = rs.getLong("HL_LOCK_EXT_ID");
            this.intLockId = rs.getLong("HL_LOCK_INT_ID");
            this.db = rs.getString("HL_DB");
            String t = rs.getString("HL_TABLE");
            this.table = rs.wasNull() ? null : t;
            String p = rs.getString("HL_PARTITION");
            this.partition = rs.wasNull() ? null : p;
            switch (rs.getString("HL_LOCK_STATE").charAt(0)) {
                case 'w': {
                    this.state = LockState.WAITING;
                    break;
                }
                case 'a': {
                    this.state = LockState.ACQUIRED;
                    break;
                }
                default: {
                    throw new MetaException("Unknown lock state " + rs.getString("HL_LOCK_STATE").charAt(0));
                }
            }
            char lockChar = rs.getString("HL_LOCK_TYPE").charAt(0);
            this.type = LockTypeUtil.getLockTypeFromEncoding(lockChar).orElseThrow(() -> new MetaException("Unknown lock type: " + lockChar));
            this.txnId = rs.getLong("HL_TXNID");
        }

        LockInfo(ShowLocksResponseElement e) {
            this.extLockId = e.getLockid();
            this.intLockId = e.getLockIdInternal();
            this.txnId = e.getTxnid();
            this.db = e.getDbname();
            this.table = e.getTablename();
            this.partition = e.getPartname();
            this.state = e.getState();
            this.type = e.getType();
        }

        public boolean equals(Object other) {
            if (!(other instanceof LockInfo)) {
                return false;
            }
            LockInfo o = (LockInfo)other;
            return this.extLockId == o.extLockId && this.intLockId == o.intLockId;
        }

        public String toString() {
            return JavaUtils.lockIdToString(this.extLockId) + " intLockId:" + this.intLockId + " " + JavaUtils.txnIdToString(this.txnId) + " db:" + this.db + " table:" + this.table + " partition:" + this.partition + " state:" + (this.state == null ? "null" : this.state.toString()) + " type:" + (this.type == null ? "null" : this.type.toString());
        }

        private boolean isDbLock() {
            return this.db != null && this.table == null && this.partition == null;
        }

        private boolean isTableLock() {
            return this.db != null && this.table != null && this.partition == null;
        }

        private boolean isPartitionLock() {
            return !this.isDbLock() && !this.isTableLock();
        }
    }

    protected class RetryException
    extends Exception {
        protected RetryException() {
        }
    }

    private static class LockInfoExt
    extends LockInfo {
        private final ShowLocksResponseElement e;

        LockInfoExt(ShowLocksResponseElement e) {
            super(e);
            this.e = e;
        }
    }

    private static final class ConnectionLockIdPair {
        private final Connection dbConn;
        private final long extLockId;

        private ConnectionLockIdPair(Connection dbConn, long extLockId) {
            this.dbConn = dbConn;
            this.extLockId = extLockId;
        }
    }
}

