/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.RetrySemantics;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.MetaStoreListenerNotifier;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.FindNextCompactRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.datasource.DataSourceProvider;
import org.apache.hadoop.hive.metastore.events.CommitCompactionEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.CompactionMetricsData;
import org.apache.hadoop.hive.metastore.txn.OperationType;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompactionTxnHandler
extends TxnHandler {
    private static final String CLASS_NAME = CompactionTxnHandler.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final String DB_FAILED_TO_CONNECT = "Unable to connect to transaction database: ";
    private static DataSource connPoolCompaction;
    private static final String SELECT_COMPACTION_QUEUE_BY_TXN_ID = "SELECT \"CQ_ID\", \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\", \"CQ_STATE\", \"CQ_TYPE\", \"CQ_TBLPROPERTIES\", \"CQ_WORKER_ID\", \"CQ_START\", \"CQ_RUN_AS\", \"CQ_HIGHEST_WRITE_ID\", \"CQ_META_INFO\", \"CQ_HADOOP_JOB_ID\", \"CQ_ERROR_MESSAGE\", \"CQ_ENQUEUE_TIME\", \"CQ_WORKER_VERSION\", \"CQ_INITIATOR_ID\", \"CQ_INITIATOR_VERSION\", \"CQ_RETRY_RETENTION\", \"CQ_NEXT_TXN_ID\", \"CQ_TXN_ID\", \"CQ_COMMIT_TIME\", \"CQ_POOL_NAME\", \"CQ_NUMBER_OF_BUCKETS\", \"CQ_ORDER_BY\" FROM \"COMPACTION_QUEUE\" WHERE \"CQ_TXN_ID\" = ?";
    private static final String SELECT_COMPACTION_METRICS_CACHE_QUERY = "SELECT \"CMC_METRIC_VALUE\", \"CMC_VERSION\" FROM \"COMPACTION_METRICS_CACHE\" WHERE \"CMC_DATABASE\" = ? AND \"CMC_TABLE\" = ? AND \"CMC_METRIC_TYPE\" = ?";
    private static final String NO_SELECT_COMPACTION_METRICS_CACHE_FOR_TYPE_QUERY = "\"CMC_DATABASE\", \"CMC_TABLE\", \"CMC_PARTITION\", \"CMC_METRIC_VALUE\", \"CMC_VERSION\" FROM \"COMPACTION_METRICS_CACHE\" WHERE \"CMC_METRIC_TYPE\" = ? ORDER BY \"CMC_METRIC_VALUE\" DESC";
    private static final String UPDATE_COMPACTION_METRICS_CACHE_QUERY = "UPDATE \"COMPACTION_METRICS_CACHE\" SET \"CMC_METRIC_VALUE\" = ?, \"CMC_VERSION\" = ? WHERE \"CMC_DATABASE\" = ? AND \"CMC_TABLE\" = ? AND \"CMC_METRIC_TYPE\" = ? AND \"CMC_VERSION\" = ?";
    private static final String INSERT_COMPACTION_METRICS_CACHE_QUERY = "INSERT INTO \"COMPACTION_METRICS_CACHE\" ( \"CMC_DATABASE\", \"CMC_TABLE\", \"CMC_PARTITION\", \"CMC_METRIC_TYPE\", \"CMC_METRIC_VALUE\", \"CMC_VERSION\" ) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String DELETE_COMPACTION_METRICS_CACHE_QUERY = "DELETE FROM \"COMPACTION_METRICS_CACHE\" WHERE \"CMC_DATABASE\" = ? AND \"CMC_TABLE\" = ? AND \"CMC_METRIC_TYPE\" = ?";
    private static final String DELETE_FAILED_TXNS_SQL;
    private static final String SELECT_ABORTS_WITH_MIN_OPEN_WRITETXN_QUERY;
    private static final String DELETE_CQ_ENTRIES = "DELETE FROM \"COMPACTION_QUEUE\" WHERE \"CQ_ID\" = ?";
    private static final String DELETE_CQ_AND_ABORT_ENTRIES;
    private static final String INSERT_ABORT_RETRY_ENTRY_INTO_COMPACTION_QUEUE = "INSERT INTO \"COMPACTION_QUEUE\" (\"CQ_ID\", \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\",  \"CQ_TYPE\", \"CQ_STATE\", \"CQ_RETRY_RETENTION\", \"CQ_ERROR_MESSAGE\", \"CQ_COMMIT_TIME\")  VALUES (?, ?, ?, ?, ?, ?, ?, ?, %s)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        Class<CompactionTxnHandler> clazz = CompactionTxnHandler.class;
        synchronized (CompactionTxnHandler.class) {
            if (connPoolCompaction == null) {
                int maxPoolSize = MetastoreConf.getIntVar(conf, MetastoreConf.ConfVars.HIVE_COMPACTOR_CONNECTION_POOLING_MAX_CONNECTIONS);
                try (DataSourceProvider.DataSourceNameConfigurator configurator = new DataSourceProvider.DataSourceNameConfigurator(conf, "compactor");){
                    connPoolCompaction = CompactionTxnHandler.setupJdbcConnectionPool(conf, maxPoolSize);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    @RetrySemantics.ReadOnly
    public Set<CompactionInfo> findPotentialCompactions(int abortedThreshold, long abortedTimeThreshold) throws MetaException {
        return this.findPotentialCompactions(abortedThreshold, abortedTimeThreshold, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.ReadOnly
    public Set<CompactionInfo> findPotentialCompactions(int abortedThreshold, long abortedTimeThreshold, long lastChecked) throws MetaException {
        Connection dbConn = null;
        HashSet<CompactionInfo> response = new HashSet<CompactionInfo>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            block8: {
                try {
                    dbConn = this.getDbConn(2, connPoolCompaction);
                    stmt = dbConn.createStatement();
                    long startedAt = System.currentTimeMillis();
                    long checkInterval = lastChecked <= 0L ? lastChecked : (startedAt - lastChecked + 500L) / 1000L;
                    String s = "SELECT DISTINCT \"TC\".\"CTC_DATABASE\", \"TC\".\"CTC_TABLE\", \"TC\".\"CTC_PARTITION\" FROM \"COMPLETED_TXN_COMPONENTS\" \"TC\" " + (checkInterval > 0L ? "LEFT JOIN (   SELECT \"C1\".* FROM \"COMPLETED_COMPACTIONS\" \"C1\"   INNER JOIN (     SELECT MAX(\"CC_ID\") \"CC_ID\" FROM \"COMPLETED_COMPACTIONS\"     GROUP BY \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\"  ) \"C2\"   ON \"C1\".\"CC_ID\" = \"C2\".\"CC_ID\"   WHERE \"C1\".\"CC_STATE\" IN (" + CompactionTxnHandler.quoteChar('a') + "," + CompactionTxnHandler.quoteChar('f') + ")) \"C\" ON \"TC\".\"CTC_DATABASE\" = \"C\".\"CC_DATABASE\" AND \"TC\".\"CTC_TABLE\" = \"C\".\"CC_TABLE\"   AND (\"TC\".\"CTC_PARTITION\" = \"C\".\"CC_PARTITION\" OR (\"TC\".\"CTC_PARTITION\" IS NULL AND \"C\".\"CC_PARTITION\" IS NULL)) WHERE \"C\".\"CC_ID\" IS NOT NULL OR " + this.isWithinCheckInterval("\"TC\".\"CTC_TIMESTAMP\"", checkInterval) : "");
                    LOG.debug("Going to execute query <{}>", (Object)s);
                    rs = stmt.executeQuery(s);
                    while (rs.next()) {
                        CompactionInfo info = new CompactionInfo();
                        info.dbname = rs.getString(1);
                        info.tableName = rs.getString(2);
                        info.partName = rs.getString(3);
                        response.add(info);
                    }
                    rs.close();
                    if (MetastoreConf.getBoolVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_CLEAN_ABORTS_USING_CLEANER)) break block8;
                    boolean checkAbortedTimeThreshold = abortedTimeThreshold >= 0L;
                    String sCheckAborted = "SELECT \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", MIN(\"TXN_STARTED\"), COUNT(*) FROM \"TXNS\", \"TXN_COMPONENTS\"    WHERE \"TXN_ID\" = \"TC_TXNID\" AND \"TXN_STATE\" = " + (Object)((Object)TxnStatus.ABORTED) + " GROUP BY \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\" " + (checkAbortedTimeThreshold ? "" : " HAVING COUNT(*) > " + abortedThreshold);
                    LOG.debug("Going to execute query <{}>", (Object)sCheckAborted);
                    rs = stmt.executeQuery(sCheckAborted);
                    long systemTime = System.currentTimeMillis();
                    while (rs.next()) {
                        boolean pastTimeThreshold = checkAbortedTimeThreshold && rs.getLong(4) + abortedTimeThreshold < systemTime;
                        int numAbortedTxns = rs.getInt(5);
                        if (numAbortedTxns <= abortedThreshold && !pastTimeThreshold) continue;
                        CompactionInfo info = new CompactionInfo();
                        info.dbname = rs.getString(1);
                        info.tableName = rs.getString(2);
                        info.partName = rs.getString(3);
                        info.tooManyAborts = numAbortedTxns > abortedThreshold;
                        info.hasOldAbort = pastTimeThreshold;
                        LOG.debug("Found potential compaction: {}", (Object)info);
                        response.add(info);
                    }
                }
                catch (SQLException e) {
                    try {
                        LOG.error(DB_FAILED_TO_CONNECT + e.getMessage());
                        this.checkRetryable(e, "findPotentialCompactions(maxAborted:" + abortedThreshold + ", abortedTimeThreshold:" + abortedTimeThreshold + ")");
                    }
                    catch (Throwable throwable) {
                        CompactionTxnHandler.close(rs, stmt, dbConn);
                        throw throwable;
                    }
                    CompactionTxnHandler.close(rs, stmt, dbConn);
                }
            }
            CompactionTxnHandler.close(rs, stmt, dbConn);
            return response;
        }
        catch (TxnHandler.RetryException e) {
            return this.findPotentialCompactions(abortedThreshold, abortedTimeThreshold, lastChecked);
        }
    }

    @Override
    @Deprecated
    @RetrySemantics.SafeToRetry
    public CompactionInfo findNextToCompact(String workerId) throws MetaException {
        FindNextCompactRequest findNextCompactRequest = new FindNextCompactRequest();
        findNextCompactRequest.setWorkerId(workerId);
        return this.findNextToCompact(findNextCompactRequest);
    }

    /*
     * Exception decompiling
     */
    @Override
    @RetrySemantics.SafeToRetry
    public CompactionInfo findNextToCompact(FindNextCompactRequest rqst) throws MetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void markCompacted(CompactionInfo info) throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2, connPoolCompaction);
                stmt = dbConn.createStatement();
                String s = "UPDATE \"COMPACTION_QUEUE\" SET \"CQ_STATE\" = 'r', \"CQ_WORKER_ID\" = NULL WHERE \"CQ_ID\" = " + info.id;
                LOG.debug("Going to execute update <{}>", (Object)s);
                int updCnt = stmt.executeUpdate(s);
                if (updCnt != 1) {
                    LOG.error("Unable to set cq_state={} for compaction record: {}. updCnt={}", new Object[]{Character.valueOf('r'), info, updCnt});
                    LOG.debug("Going to rollback");
                    dbConn.rollback();
                }
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to update compaction queue " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "markCompacted(" + info + ")");
                    throw new MetaException(DB_FAILED_TO_CONNECT + e.getMessage());
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.closeStmt(stmt);
                    CompactionTxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.closeStmt(stmt);
            CompactionTxnHandler.closeDbConn(dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.markCompacted(info);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @RetrySemantics.ReadOnly
    public List<CompactionInfo> findReadyToClean(long minOpenTxnWaterMark, long retentionTime) throws MetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @RetrySemantics.ReadOnly
    public List<CompactionInfo> findReadyToCleanAborts(long abortedTimeThreshold, int abortedThreshold) throws MetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @RetrySemantics.ReadOnly
    public void markCleanerStart(CompactionInfo info) throws MetaException {
        LOG.debug("Running markCleanerStart with CompactionInfo: {}", (Object)info);
        try {
            Connection dbConn = null;
            try {
                dbConn = this.getDbConn(2);
                long now = this.getDbTime(dbConn);
                this.setCleanerStart(dbConn, info, now);
            }
            catch (SQLException e) {
                LOG.error("Unable to set the cleaner start time for compaction record  " + e.getMessage());
                LOG.debug("Going to rollback");
                CompactionTxnHandler.rollbackDBConn(dbConn);
                this.checkRetryable(e, "markCleanerStart(" + info + ")");
                throw new MetaException(DB_FAILED_TO_CONNECT + e.getMessage());
            }
            finally {
                CompactionTxnHandler.closeDbConn(dbConn);
            }
        }
        catch (TxnHandler.RetryException e) {
            this.markCleanerStart(info);
        }
    }

    @Override
    @RetrySemantics.ReadOnly
    public void clearCleanerStart(CompactionInfo info) throws MetaException {
        LOG.debug("Running clearCleanerStart with CompactionInfo: {}", (Object)info);
        try {
            Connection dbConn = null;
            try {
                dbConn = this.getDbConn(2);
                this.setCleanerStart(dbConn, info, -1L);
            }
            catch (SQLException e) {
                LOG.error("Unable to clear the cleaner start time for compaction record  " + e.getMessage());
                LOG.debug("Going to rollback");
                CompactionTxnHandler.rollbackDBConn(dbConn);
                this.checkRetryable(e, "clearCleanerStart(" + info + ")");
                throw new MetaException(DB_FAILED_TO_CONNECT + e.getMessage());
            }
            finally {
                CompactionTxnHandler.closeDbConn(dbConn);
            }
        }
        catch (TxnHandler.RetryException e) {
            this.clearCleanerStart(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCleanerStart(Connection dbConn, CompactionInfo info, Long timestamp) throws SQLException {
        PreparedStatement pStmt;
        block3: {
            long id = info.id;
            pStmt = null;
            try {
                String query = " UPDATE   \"COMPACTION_QUEUE\"  SET   \"CQ_CLEANER_START\" = " + timestamp + " WHERE   \"CQ_ID\" = " + id + " AND   \"CQ_STATE\"='" + 'r' + "'";
                pStmt = dbConn.prepareStatement(query);
                LOG.debug("Going to execute update <{}> for CQ_ID={}", (Object)query, (Object)id);
                int updCount = pStmt.executeUpdate();
                if (updCount != 1) {
                    LOG.error("Unable to update compaction record: {}.  Update count={}", (Object)info, (Object)updCount);
                    LOG.debug("Going to rollback");
                    dbConn.rollback();
                    break block3;
                }
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (Throwable throwable) {
                CompactionTxnHandler.closeStmt(pStmt);
                throw throwable;
            }
        }
        CompactionTxnHandler.closeStmt(pStmt);
    }

    @Override
    @RetrySemantics.CannotRetry
    public void markCleaned(CompactionInfo info) throws MetaException {
        LOG.debug("Running markCleaned with CompactionInfo: {}", (Object)info);
        try {
            Connection dbConn = null;
            PreparedStatement pStmt = null;
            ResultSet rs = null;
            try {
                dbConn = this.getDbConn(2, connPoolCompaction);
                if (!info.isAbortedTxnCleanup()) {
                    String s = "INSERT INTO \"COMPLETED_COMPACTIONS\"(\"CC_ID\", \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\", \"CC_STATE\", \"CC_TYPE\", \"CC_TBLPROPERTIES\", \"CC_WORKER_ID\", \"CC_START\", \"CC_END\", \"CC_RUN_AS\", \"CC_HIGHEST_WRITE_ID\", \"CC_META_INFO\", \"CC_HADOOP_JOB_ID\", \"CC_ERROR_MESSAGE\", \"CC_ENQUEUE_TIME\", \"CC_WORKER_VERSION\", \"CC_INITIATOR_ID\", \"CC_INITIATOR_VERSION\", \"CC_NEXT_TXN_ID\", \"CC_TXN_ID\", \"CC_COMMIT_TIME\", \"CC_POOL_NAME\", \"CC_NUMBER_OF_BUCKETS\",\"CC_ORDER_BY\") SELECT \"CQ_ID\", \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\", " + CompactionTxnHandler.quoteChar('s') + ", \"CQ_TYPE\", \"CQ_TBLPROPERTIES\", \"CQ_WORKER_ID\", \"CQ_START\", " + TxnUtils.getEpochFn(dbProduct) + ", \"CQ_RUN_AS\", \"CQ_HIGHEST_WRITE_ID\", \"CQ_META_INFO\", \"CQ_HADOOP_JOB_ID\", \"CQ_ERROR_MESSAGE\", \"CQ_ENQUEUE_TIME\", \"CQ_WORKER_VERSION\", \"CQ_INITIATOR_ID\", \"CQ_INITIATOR_VERSION\", \"CQ_NEXT_TXN_ID\", \"CQ_TXN_ID\", \"CQ_COMMIT_TIME\", \"CQ_POOL_NAME\", \"CQ_NUMBER_OF_BUCKETS\", \"CQ_ORDER_BY\" FROM \"COMPACTION_QUEUE\" WHERE \"CQ_ID\" = ?";
                    pStmt = dbConn.prepareStatement(s);
                    pStmt.setLong(1, info.id);
                    LOG.debug("Going to execute update <{}> for CQ_ID={}", (Object)s, (Object)info.id);
                    pStmt.executeUpdate();
                }
                this.removeCompactionAndAbortRetryEntries(dbConn, info);
                if (!info.isAbortedTxnCleanup()) {
                    String query = "DELETE FROM \"COMPLETED_TXN_COMPONENTS\"  WHERE \"CTC_DATABASE\" = ? AND \"CTC_TABLE\" = ?";
                    if (info.partName != null) {
                        query = query + " AND \"CTC_PARTITION\" = ?";
                    }
                    if (info.highestWriteId != 0L) {
                        query = query + " AND \"CTC_WRITEID\" <= ?";
                    }
                    pStmt = dbConn.prepareStatement(query);
                    int paramCount = 1;
                    pStmt.setString(paramCount++, info.dbname);
                    pStmt.setString(paramCount++, info.tableName);
                    if (info.partName != null) {
                        pStmt.setString(paramCount++, info.partName);
                    }
                    if (info.highestWriteId != 0L) {
                        pStmt.setLong(paramCount, info.highestWriteId);
                    }
                    LOG.debug("Going to execute update <{}>", (Object)query);
                    int updCount = pStmt.executeUpdate();
                    if (updCount < 1) {
                        LOG.warn("Expected to remove at least one row from completed_txn_components when marking compaction entry as clean!");
                    }
                    LOG.debug("Removed {} records from completed_txn_components", (Object)updCount);
                }
                this.removeTxnComponents(dbConn, info);
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                LOG.error("Unable to delete from compaction queue " + e.getMessage());
                LOG.debug("Going to rollback");
                CompactionTxnHandler.rollbackDBConn(dbConn);
                this.checkRetryable(e, "markCleaned(" + info + ")");
                throw new MetaException(DB_FAILED_TO_CONNECT + e.getMessage());
            }
            finally {
                CompactionTxnHandler.close(rs, pStmt, dbConn);
            }
        }
        catch (TxnHandler.RetryException e) {
            this.markCleaned(info);
        }
    }

    private void removeTxnComponents(Connection dbConn, CompactionInfo info) throws MetaException, TxnHandler.RetryException {
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            String s = "DELETE FROM \"TXN_COMPONENTS\" WHERE \"TC_TXNID\" IN ( SELECT \"TXN_ID\" FROM \"TXNS\" WHERE \"TXN_STATE\" = " + (Object)((Object)TxnStatus.ABORTED) + ") AND \"TC_DATABASE\" = ? AND \"TC_TABLE\" = ? AND \"TC_PARTITION\" " + TxnUtils.nvl(info.partName);
            ArrayList<String> queries = new ArrayList<String>();
            Iterator<Long> writeIdsIter = null;
            List<Integer> counts = null;
            if (info.writeIds != null && !info.writeIds.isEmpty()) {
                StringBuilder prefix = new StringBuilder(s).append(" AND ");
                List<String> questions = Collections.nCopies(info.writeIds.size(), "?");
                counts = TxnUtils.buildQueryWithINClauseStrings(this.conf, queries, prefix, new StringBuilder(), questions, "\"TC_WRITEID\"", false, false);
                writeIdsIter = info.writeIds.iterator();
            } else if (!info.hasUncompactedAborts) {
                if (info.highestWriteId != 0L) {
                    s = s + " AND \"TC_WRITEID\" <= ?";
                }
                queries.add(s);
            }
            for (int i = 0; i < queries.size(); ++i) {
                String query = (String)queries.get(i);
                int writeIdCount = counts != null ? (Integer)counts.get(i) : 0;
                LOG.debug("Going to execute update <{}>", (Object)query);
                pStmt = dbConn.prepareStatement(query);
                int paramCount = 1;
                pStmt.setString(paramCount++, info.dbname);
                pStmt.setString(paramCount++, info.tableName);
                if (info.partName != null) {
                    pStmt.setString(paramCount++, info.partName);
                }
                if (info.highestWriteId != 0L && writeIdCount == 0) {
                    pStmt.setLong(paramCount, info.highestWriteId);
                }
                for (int j = 0; j < writeIdCount; ++j) {
                    if (!writeIdsIter.hasNext()) continue;
                    pStmt.setLong(paramCount + j, writeIdsIter.next());
                }
                int rc = pStmt.executeUpdate();
                LOG.debug("Removed {} records from txn_components", (Object)rc);
            }
        }
        catch (SQLException e) {
            LOG.error("Unable to delete from txn components due to {}", (Object)e.getMessage());
            LOG.debug("Going to rollback");
            CompactionTxnHandler.rollbackDBConn(dbConn);
            this.checkRetryable(e, "markCleanedForAborts(" + info + ")");
            throw new MetaException(DB_FAILED_TO_CONNECT + e.getMessage());
        }
        finally {
            CompactionTxnHandler.close(rs);
            CompactionTxnHandler.closeStmt(pStmt);
        }
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void cleanTxnToWriteIdTable() throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                long minTxnIdSeenOpen = this.findMinTxnIdSeenOpen();
                dbConn = this.getDbConn(2, connPoolCompaction);
                stmt = dbConn.createStatement();
                String s = "SELECT MIN(\"RES\".\"ID\") AS \"ID\" FROM ( SELECT MIN(\"NTXN_NEXT\") AS \"ID\" FROM \"NEXT_TXN_ID\"" + (useMinHistoryLevel ? "" : "   UNION SELECT MIN(\"WS_TXNID\") AS \"ID\" FROM \"WRITE_SET\"") + "   UNION SELECT MIN(\"TXN_ID\") AS \"ID\" FROM \"TXNS\" WHERE \"TXN_STATE\" = " + (Object)((Object)TxnStatus.ABORTED) + (useMinHistoryLevel ? "" : "   OR \"TXN_STATE\" = " + (Object)((Object)TxnStatus.OPEN)) + " ) \"RES\"";
                LOG.debug("Going to execute query <{}>", (Object)s);
                rs = stmt.executeQuery(s);
                if (!rs.next()) {
                    throw new MetaException("Transaction tables not properly initialized, no record found in NEXT_TXN_ID");
                }
                long minUncommitedTxnid = Math.min(rs.getLong(1), minTxnIdSeenOpen);
                s = "DELETE FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_TXNID\" < " + minUncommitedTxnid;
                LOG.debug("Going to execute delete <{}>", (Object)s);
                int rc = stmt.executeUpdate(s);
                LOG.info("Removed {} rows from TXN_TO_WRITE_ID with Txn Low-Water-Mark: {}", (Object)rc, (Object)minUncommitedTxnid);
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to delete from TXN_TO_WRITE_ID table " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "cleanTxnToWriteIdTable");
                    throw new MetaException(DB_FAILED_TO_CONNECT + e.getMessage());
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, stmt, dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.close(rs, stmt, dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.cleanTxnToWriteIdTable();
        }
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void removeDuplicateCompletedTxnComponents() throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                String s;
                dbConn = this.getDbConn(2, connPoolCompaction);
                stmt = dbConn.createStatement();
                switch (dbProduct) {
                    case MYSQL: 
                    case SQLSERVER: {
                        s = "DELETE tc FROM \"COMPLETED_TXN_COMPONENTS\" tc INNER JOIN (    SELECT \"CTC_DATABASE\", \"CTC_TABLE\", \"CTC_PARTITION\",        MAX(\"CTC_WRITEID\") highestWriteId,        MAX(CASE WHEN \"CTC_UPDATE_DELETE\" = 'Y' THEN \"CTC_WRITEID\" END) updateWriteId    FROM \"COMPLETED_TXN_COMPONENTS\"    GROUP BY \"CTC_DATABASE\", \"CTC_TABLE\", \"CTC_PARTITION\") c ON       tc.\"CTC_DATABASE\" = c.\"CTC_DATABASE\"       AND tc.\"CTC_TABLE\" = c.\"CTC_TABLE\"      AND (tc.\"CTC_PARTITION\" = c.\"CTC_PARTITION\" OR (tc.\"CTC_PARTITION\" IS NULL AND c.\"CTC_PARTITION\" IS NULL)) WHERE tc.\"CTC_WRITEID\" < c.\"highestWriteId\" " + (DatabaseProduct.MYSQL == dbProduct ? "  AND NOT tc.\"CTC_WRITEID\" <=> c.updateWriteId" : "  AND (tc.\"CTC_WRITEID\" != c.updateWriteId OR c.updateWriteId IS NULL)");
                        break;
                    }
                    case DERBY: 
                    case ORACLE: 
                    case POSTGRES: {
                        String existsSubQuery = "EXISTS (    SELECT 1    FROM \"COMPLETED_TXN_COMPONENTS\" c    WHERE tc.\"CTC_DATABASE\" = c.\"CTC_DATABASE\"      AND tc.\"CTC_TABLE\" = c.\"CTC_TABLE\"      AND %s      AND (tc.\"CTC_UPDATE_DELETE\" = 'N' OR c.\"CTC_UPDATE_DELETE\" = 'Y')      AND tc.\"CTC_WRITEID\" < c.\"CTC_WRITEID\")";
                        s = "DELETE FROM \"COMPLETED_TXN_COMPONENTS\" tc WHERE " + String.format(existsSubQuery, "tc.\"CTC_PARTITION\" = c.\"CTC_PARTITION\"") + " OR " + String.format(existsSubQuery, "tc.\"CTC_PARTITION\" IS NULL AND c.\"CTC_PARTITION\" IS NULL");
                        break;
                    }
                    default: {
                        String msg = "Unknown database product: " + (Object)((Object)dbProduct);
                        LOG.error(msg);
                        throw new MetaException(msg);
                    }
                }
                LOG.debug("Going to execute delete <{}>", (Object)s);
                int rc = stmt.executeUpdate(s);
                LOG.info("Removed {} rows from COMPLETED_TXN_COMPONENTS", (Object)rc);
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to delete from COMPLETED_TXN_COMPONENTS table " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "removeDuplicateCompletedTxnComponents");
                    throw new MetaException(DB_FAILED_TO_CONNECT + e.getMessage());
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(null, stmt, dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.close(null, stmt, dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.removeDuplicateCompletedTxnComponents();
        }
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void cleanEmptyAbortedTxns() throws MetaException {
        try {
            try (Connection dbConn = this.getDbConn(2, connPoolCompaction);){
                try (PreparedStatement stmt = dbConn.prepareStatement(DELETE_FAILED_TXNS_SQL);){
                    LOG.debug("Going to execute query <{}>", (Object)DELETE_FAILED_TXNS_SQL);
                    int rc = stmt.executeUpdate();
                    LOG.debug("Removed {} empty Aborted and Committed transactions from TXNS", (Object)rc);
                    LOG.debug("Going to commit");
                    dbConn.commit();
                }
                catch (SQLException e) {
                    LOG.error("Unable to delete from txns table " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "cleanEmptyAbortedTxns");
                    throw new MetaException("Unable to delete from txns table " + e.getMessage());
                }
            }
            catch (SQLException e) {
                LOG.error(DB_FAILED_TO_CONNECT + e.getMessage());
                this.checkRetryable(e, "cleanEmptyAbortedTxns");
                throw new MetaException(DB_FAILED_TO_CONNECT + e.getMessage());
            }
        }
        catch (TxnHandler.RetryException e) {
            this.cleanEmptyAbortedTxns();
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void revokeFromLocalWorkers(String hostname) throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2, connPoolCompaction);
                stmt = dbConn.createStatement();
                String s = "UPDATE \"COMPACTION_QUEUE\" SET \"CQ_WORKER_ID\" = NULL, \"CQ_START\" = NULL, \"CQ_STATE\" = 'i' WHERE \"CQ_STATE\" = 'w' AND \"CQ_WORKER_ID\" LIKE '" + hostname + "%'";
                LOG.debug("Going to execute update <{}>", (Object)s);
                int updated = stmt.executeUpdate(s);
                LOG.debug("Set {} compaction queue entries to {} state for host {}", new Object[]{updated, "initiated", hostname});
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to change dead worker's records back to initiated state " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "revokeFromLocalWorkers(hostname:" + hostname + ")");
                    throw new MetaException(DB_FAILED_TO_CONNECT + e.getMessage());
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.closeStmt(stmt);
                    CompactionTxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.closeStmt(stmt);
            CompactionTxnHandler.closeDbConn(dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.revokeFromLocalWorkers(hostname);
        }
    }

    @Override
    @RetrySemantics.Idempotent
    public void revokeTimedoutWorkers(long timeout) throws MetaException {
        try {
            Connection dbConn = null;
            Statement stmt = null;
            try {
                dbConn = this.getDbConn(2, connPoolCompaction);
                long latestValidStart = this.getDbTime(dbConn) - timeout;
                stmt = dbConn.createStatement();
                String s = "UPDATE \"COMPACTION_QUEUE\" SET \"CQ_WORKER_ID\" = NULL, \"CQ_START\" = NULL, \"CQ_STATE\" = 'i' WHERE \"CQ_STATE\" = 'w' AND \"CQ_START\" < " + latestValidStart;
                LOG.debug("Going to execute update <{}", (Object)s);
                int updated = stmt.executeUpdate(s);
                LOG.info("{} compaction queue entries timed out, set back to {} state. Latest valid start: {}", new Object[]{updated, "initiated", latestValidStart});
                LOG.debug("Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.error("Unable to change dead worker's records back to initiated state " + e.getMessage());
                    LOG.debug("Going to rollback");
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "revokeTimedoutWorkers(timeout:" + timeout + ")");
                    throw new MetaException(DB_FAILED_TO_CONNECT + e.getMessage());
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.closeStmt(stmt);
                    CompactionTxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.closeStmt(stmt);
            CompactionTxnHandler.closeDbConn(dbConn);
        }
        catch (TxnHandler.RetryException e) {
            this.revokeTimedoutWorkers(timeout);
        }
    }

    @Override
    @RetrySemantics.ReadOnly
    public List<String> findColumnsWithStats(CompactionInfo ci) throws MetaException {
        ArrayList<String> arrayList;
        LOG.debug("Finding columns with statistics info for CompactionInfo: {}", (Object)ci);
        Connection dbConn = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2, connPoolCompaction);
            String quote = this.getIdentifierQuoteString(dbConn);
            StringBuilder bldr = new StringBuilder();
            bldr.append("SELECT ").append(quote).append("COLUMN_NAME").append(quote).append(" FROM ").append(quote).append(ci.partName == null ? "TAB_COL_STATS" : "PART_COL_STATS").append(quote).append(" WHERE ").append(quote).append("DB_NAME").append(quote).append(" = ?").append(" AND ").append(quote).append("TABLE_NAME").append(quote).append(" = ?");
            if (ci.partName != null) {
                bldr.append(" AND ").append(quote).append("PARTITION_NAME").append(quote).append(" = ?");
            }
            String s = bldr.toString();
            pStmt = dbConn.prepareStatement(s);
            pStmt.setString(1, ci.dbname);
            pStmt.setString(2, ci.tableName);
            if (ci.partName != null) {
                pStmt.setString(3, ci.partName);
            }
            LOG.debug("Going to execute <{}>", (Object)s);
            rs = pStmt.executeQuery();
            ArrayList<String> columns = new ArrayList<String>();
            while (rs.next()) {
                columns.add(rs.getString(1));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found columns to update stats: {} on {}{}", new Object[]{columns, ci.tableName, ci.partName == null ? "" : "/" + ci.partName});
            }
            dbConn.commit();
            arrayList = columns;
        }
        catch (SQLException e) {
            try {
                try {
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "findColumnsWithStats(" + ci.tableName + (ci.partName == null ? "" : "/" + ci.partName) + ")");
                    throw new MetaException(DB_FAILED_TO_CONNECT + e.getMessage());
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, pStmt, dbConn);
                    throw throwable;
                }
            }
            catch (TxnHandler.RetryException ex) {
                return this.findColumnsWithStats(ci);
            }
        }
        CompactionTxnHandler.close(rs, pStmt, dbConn);
        return arrayList;
    }

    @Override
    public void updateCompactorState(CompactionInfo ci, long compactionTxnId) throws MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        try {
            try {
                dbConn = this.getDbConn(2, connPoolCompaction);
                stmt = dbConn.createStatement();
                String sqlText = "UPDATE \"COMPACTION_QUEUE\" SET \"CQ_HIGHEST_WRITE_ID\" = " + ci.highestWriteId + ", \"CQ_RUN_AS\" = " + CompactionTxnHandler.quoteString(ci.runAs) + ", \"CQ_TXN_ID\" = " + compactionTxnId + " WHERE \"CQ_ID\" = " + ci.id;
                LOG.debug("About to execute: {}", (Object)sqlText);
                int updCount = stmt.executeUpdate(sqlText);
                if (updCount != 1) {
                    throw new IllegalStateException("Could not find record in COMPACTION_QUEUE for " + ci);
                }
                sqlText = "INSERT INTO \"TXN_COMPONENTS\"(\"TC_TXNID\", \"TC_DATABASE\", \"TC_TABLE\", " + (ci.partName == null ? "" : "\"TC_PARTITION\", ") + "\"TC_WRITEID\", \"TC_OPERATION_TYPE\") VALUES(" + compactionTxnId + "," + CompactionTxnHandler.quoteString(ci.dbname) + "," + CompactionTxnHandler.quoteString(ci.tableName) + "," + (ci.partName == null ? "" : CompactionTxnHandler.quoteString(ci.partName) + ",") + ci.highestWriteId + ", " + (Object)((Object)OperationType.COMPACT) + ")";
                LOG.debug("About to execute: {}", (Object)sqlText);
                updCount = stmt.executeUpdate(sqlText);
                if (updCount != 1) {
                    throw new IllegalStateException("Could not find record in COMPACTION_QUEUE for " + ci);
                }
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "updateCompactorState(" + ci + "," + compactionTxnId + ")");
                    throw new MetaException(DB_FAILED_TO_CONNECT + e.getMessage());
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(null, stmt, dbConn);
                    throw throwable;
                }
            }
            CompactionTxnHandler.close(null, stmt, dbConn);
        }
        catch (TxnHandler.RetryException ex) {
            this.updateCompactorState(ci, compactionTxnId);
        }
    }

    private void checkForDeletion(List<Long> deleteSet, CompactionInfo ci, RetentionCounters rc, long timeoutThreshold) {
        switch (ci.state) {
            case 'a': {
                if (--rc.didNotInitiateRetention >= 0 && !CompactionTxnHandler.timedOut(ci, rc, timeoutThreshold)) break;
                deleteSet.add(ci.id);
                break;
            }
            case 'f': {
                if (--rc.failedRetention >= 0 && !CompactionTxnHandler.timedOut(ci, rc, timeoutThreshold)) break;
                deleteSet.add(ci.id);
                break;
            }
            case 's': {
                if (--rc.succeededRetention < 0) {
                    deleteSet.add(ci.id);
                }
                if (ci.type == CompactionType.MAJOR) {
                    rc.hasSucceededMajorCompaction = true;
                    break;
                }
                rc.hasSucceededMinorCompaction = true;
                break;
            }
            case 'c': {
                if (--rc.refusedRetention >= 0 && !CompactionTxnHandler.timedOut(ci, rc, timeoutThreshold)) break;
                deleteSet.add(ci.id);
                break;
            }
        }
    }

    private static boolean timedOut(CompactionInfo ci, RetentionCounters rc, long pastTimeout) {
        return ci.start < pastTimeout && (rc.hasSucceededMajorCompaction || rc.hasSucceededMinorCompaction && ci.type == CompactionType.MINOR);
    }

    private void removeCompactionAndAbortRetryEntries(Connection dbConn, CompactionInfo info) throws MetaException, TxnHandler.RetryException {
        if (info.id == 0L) {
            return;
        }
        String query = info.isAbortedTxnCleanup() ? DELETE_CQ_ENTRIES : String.format(DELETE_CQ_AND_ABORT_ENTRIES, TxnUtils.nvl(info.partName));
        LOG.debug("Going to execute update <{}>", (Object)query);
        try (PreparedStatement pStmt = dbConn.prepareStatement(query);){
            int paramCnt = 1;
            pStmt.setLong(paramCnt++, info.id);
            if (!info.isAbortedTxnCleanup()) {
                pStmt.setString(paramCnt++, info.dbname);
                pStmt.setString(paramCnt++, info.tableName);
                if (info.partName != null) {
                    pStmt.setString(paramCnt, info.partName);
                }
            }
            int rc = pStmt.executeUpdate();
            LOG.debug("Removed {} records in COMPACTION_QUEUE", (Object)rc);
        }
        catch (SQLException e) {
            LOG.error("Unable to delete compaction or abort retry entries from COMPACTION_QUEUE due to {}", (Object)e.getMessage());
            LOG.debug("Going to rollback");
            CompactionTxnHandler.rollbackDBConn(dbConn);
            this.checkRetryable(e, "removeCompactionAndAbortRetryEntries(" + info + ")");
            throw new MetaException(DB_FAILED_TO_CONNECT + e.getMessage());
        }
    }

    private void insertAbortRetryRetentionTimeOnError(Connection dbConn, CompactionInfo info) throws MetaException, SQLException {
        String query = String.format(INSERT_ABORT_RETRY_ENTRY_INTO_COMPACTION_QUEUE, TxnUtils.getEpochFn(dbProduct));
        TxnStore.MutexAPI.LockHandle handle = null;
        try (PreparedStatement pStmt = dbConn.prepareStatement(query);
             Statement stmt = dbConn.createStatement();){
            this.lockInternal();
            handle = this.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.CompactionScheduler.name());
            long id = this.generateCompactionQueueId(stmt);
            pStmt.setLong(1, id);
            pStmt.setString(2, info.dbname);
            pStmt.setString(3, info.tableName);
            if (info.partName != null) {
                pStmt.setString(4, info.partName);
            } else {
                pStmt.setNull(4, 12);
            }
            pStmt.setString(5, Character.toString(TxnUtils.thriftCompactionType2DbType(info.type).charValue()));
            pStmt.setString(6, Character.toString(info.state));
            pStmt.setLong(7, info.retryRetention);
            pStmt.setString(8, info.errorMessage);
            int updCnt = pStmt.executeUpdate();
            if (updCnt == 0) {
                LOG.error("Unable to update/insert compaction queue record: {}. updCnt={}", (Object)info, (Object)updCnt);
                dbConn.rollback();
                throw new MetaException("Unable to insert abort retry entry into COMPACTION QUEUE:  CQ_DATABASE=" + info.dbname + ", CQ_TABLE=" + info.tableName + ", CQ_PARTITION" + info.partName);
            }
            LOG.debug("Going to commit");
            dbConn.commit();
        }
        catch (SQLException e) {
            LOG.error("Unable to update compaction queue: {}", (Object)e.getMessage());
            CompactionTxnHandler.rollbackDBConn(dbConn);
            throw e;
        }
        finally {
            if (handle != null) {
                handle.releaseLocks();
            }
            this.unlockInternal();
        }
    }

    @Override
    @RetrySemantics.SafeToRetry
    public void purgeCompactionHistory() throws MetaException {
        Connection dbConn = null;
        Statement stmt = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        ArrayList<Long> deleteSet = new ArrayList<Long>();
        RetentionCounters rc = null;
        long timeoutThreshold = System.currentTimeMillis() - MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_TIMEOUT, TimeUnit.MILLISECONDS);
        int didNotInitiateRetention = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_DID_NOT_INITIATE);
        int failedRetention = this.getFailedCompactionRetention();
        int succeededRetention = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_SUCCEEDED);
        int refusedRetention = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_REFUSED);
        try {
            block12: {
                dbConn = this.getDbConn(2, connPoolCompaction);
                stmt = dbConn.createStatement();
                rs = stmt.executeQuery("SELECT \"CC_ID\", \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\", \"CC_STATE\" , \"CC_START\", \"CC_TYPE\" FROM \"COMPLETED_COMPACTIONS\" ORDER BY \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\",\"CC_ID\" DESC");
                String lastCompactedEntity = null;
                while (rs.next()) {
                    CompactionInfo ci = new CompactionInfo(rs.getLong(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5).charAt(0));
                    ci.start = rs.getLong(6);
                    ci.type = TxnUtils.dbCompactionType2ThriftType(rs.getString(7).charAt(0));
                    if (!ci.getFullPartitionName().equals(lastCompactedEntity)) {
                        lastCompactedEntity = ci.getFullPartitionName();
                        rc = new RetentionCounters(didNotInitiateRetention, failedRetention, succeededRetention, refusedRetention);
                    }
                    this.checkForDeletion(deleteSet, ci, rc, timeoutThreshold);
                }
                CompactionTxnHandler.close(rs);
                if (deleteSet.size() > 0) break block12;
                CompactionTxnHandler.close(rs, stmt, dbConn);
                CompactionTxnHandler.closeStmt(pStmt);
                return;
            }
            try {
                ArrayList<String> queries = new ArrayList<String>();
                StringBuilder prefix = new StringBuilder();
                StringBuilder suffix = new StringBuilder();
                prefix.append("DELETE FROM \"COMPLETED_COMPACTIONS\" WHERE ");
                ArrayList<String> questions = new ArrayList<String>(deleteSet.size());
                for (int i = 0; i < deleteSet.size(); ++i) {
                    questions.add("?");
                }
                List<Integer> counts = TxnUtils.buildQueryWithINClauseStrings(this.conf, queries, prefix, suffix, questions, "\"CC_ID\"", false, false);
                int totalCount = 0;
                for (int i = 0; i < queries.size(); ++i) {
                    String query = (String)queries.get(i);
                    long insertCount = counts.get(i).intValue();
                    LOG.debug("Going to execute update <{}>", (Object)query);
                    pStmt = dbConn.prepareStatement(query);
                    int j = 0;
                    while ((long)j < insertCount) {
                        pStmt.setLong(j + 1, (Long)deleteSet.get(totalCount + j));
                        ++j;
                    }
                    totalCount = (int)((long)totalCount + insertCount);
                    int count = pStmt.executeUpdate();
                    LOG.debug("Removed {} records from COMPLETED_COMPACTIONS", (Object)count);
                }
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "purgeCompactionHistory()");
                    throw new MetaException(DB_FAILED_TO_CONNECT + e.getMessage());
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.close(rs, stmt, dbConn);
                    CompactionTxnHandler.closeStmt(pStmt);
                    throw throwable;
                }
            }
            CompactionTxnHandler.close(rs, stmt, dbConn);
            CompactionTxnHandler.closeStmt(pStmt);
        }
        catch (TxnHandler.RetryException ex) {
            this.purgeCompactionHistory();
        }
    }

    private int getFailedCompactionRetention() {
        int failedThreshold = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD);
        int failedRetention = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED);
        if (failedRetention < failedThreshold) {
            LOG.warn("Invalid configuration {}={} < {}={}.  Will use {}={}", new Object[]{MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD.getVarname(), failedRetention, MetastoreConf.ConfVars.COMPACTOR_HISTORY_RETENTION_FAILED, failedRetention, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD.getVarname(), failedRetention});
            failedRetention = failedThreshold;
        }
        return failedRetention;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.ReadOnly
    public boolean checkFailedCompactions(CompactionInfo ci) {
        boolean bl;
        Connection dbConn = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            dbConn = this.getDbConn(2, connPoolCompaction);
            pStmt = dbConn.prepareStatement("SELECT \"CC_STATE\", \"CC_ENQUEUE_TIME\" FROM \"COMPLETED_COMPACTIONS\" WHERE \"CC_DATABASE\" = ? AND \"CC_TABLE\" = ? " + (ci.partName != null ? "AND \"CC_PARTITION\" = ?" : "") + " AND \"CC_STATE\" != " + CompactionTxnHandler.quoteChar('a') + " ORDER BY \"CC_ID\" DESC");
            pStmt.setString(1, ci.dbname);
            pStmt.setString(2, ci.tableName);
            if (ci.partName != null) {
                pStmt.setString(3, ci.partName);
            }
            rs = pStmt.executeQuery();
            int numFailed = 0;
            int numTotal = 0;
            long lastEnqueueTime = -1L;
            int failedThreshold = MetastoreConf.getIntVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD);
            while (rs.next() && ++numTotal <= failedThreshold) {
                long enqueueTime = rs.getLong(2);
                if (!rs.wasNull() && enqueueTime > lastEnqueueTime) {
                    lastEnqueueTime = enqueueTime;
                }
                if (rs.getString(1).charAt(0) == 'f') {
                    ++numFailed;
                    continue;
                }
                --numFailed;
            }
            long retryTime = MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_RETRY_TIME, TimeUnit.MILLISECONDS);
            boolean needsRetry = retryTime > 0L && lastEnqueueTime > 0L && lastEnqueueTime + retryTime < System.currentTimeMillis();
            bl = numFailed == failedThreshold && !needsRetry;
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                LOG.error("Unable to check for failed compactions " + e.getMessage());
                LOG.debug("Going to rollback");
                CompactionTxnHandler.rollbackDBConn(dbConn);
                this.checkRetryable(e, "checkFailedCompactions(" + ci + ")");
                LOG.error(DB_FAILED_TO_CONNECT, (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    CompactionTxnHandler.close(rs, pStmt, dbConn);
                    throw throwable;
                }
                catch (TxnHandler.RetryException e2) {
                    return this.checkFailedCompactions(ci);
                }
            }
            CompactionTxnHandler.close(rs, pStmt, dbConn);
            return bl2;
        }
        CompactionTxnHandler.close(rs, pStmt, dbConn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus(CompactionInfo ci) throws MetaException {
        block11: {
            String strState = CompactionTxnHandler.compactorStateToResponse(ci.state);
            LOG.debug("Marking as {}: CompactionInfo: {}", (Object)strState, (Object)ci);
            try {
                Connection dbConn = null;
                Statement stmt = null;
                PreparedStatement pStmt = null;
                ResultSet rs = null;
                try {
                    dbConn = this.getDbConn(2, connPoolCompaction);
                    stmt = dbConn.createStatement();
                    pStmt = dbConn.prepareStatement("SELECT \"CQ_ID\", \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\", \"CQ_STATE\", \"CQ_TYPE\", \"CQ_TBLPROPERTIES\", \"CQ_WORKER_ID\", \"CQ_START\", \"CQ_RUN_AS\", \"CQ_HIGHEST_WRITE_ID\", \"CQ_META_INFO\", \"CQ_HADOOP_JOB_ID\", \"CQ_ERROR_MESSAGE\", \"CQ_ENQUEUE_TIME\", \"CQ_WORKER_VERSION\", \"CQ_INITIATOR_ID\", \"CQ_INITIATOR_VERSION\", \"CQ_RETRY_RETENTION\", \"CQ_NEXT_TXN_ID\", \"CQ_TXN_ID\", \"CQ_COMMIT_TIME\", \"CQ_POOL_NAME\", \"CQ_NUMBER_OF_BUCKETS\", \"CQ_ORDER_BY\" FROM \"COMPACTION_QUEUE\" WHERE \"CQ_ID\" = ?");
                    pStmt.setLong(1, ci.id);
                    rs = pStmt.executeQuery();
                    if (rs.next()) {
                        String errorMessage = ci.errorMessage;
                        char state = ci.state;
                        ci = CompactionInfo.loadFullFromCompactionQueue(rs);
                        ci.errorMessage = errorMessage;
                        ci.state = state;
                        pStmt = dbConn.prepareStatement(DELETE_CQ_ENTRIES);
                        pStmt.setLong(1, ci.id);
                        LOG.debug("Going to execute update <{}>", (Object)DELETE_CQ_ENTRIES);
                        pStmt.executeUpdate();
                    } else if (ci.id > 0L) {
                        throw new IllegalStateException("No record with CQ_ID=" + ci.id + " found in COMPACTION_QUEUE");
                    }
                    if (ci.id == 0L) {
                        ci.id = this.generateCompactionQueueId(stmt);
                        if (ci.type == null) {
                            ci.type = CompactionType.MINOR;
                        }
                        ci.start = this.getDbTime(dbConn);
                        LOG.debug("The failure occurred before we even made an entry in COMPACTION_QUEUE. Generated ID so that we can make an entry in COMPLETED_COMPACTIONS. New Id: {}", (Object)ci.id);
                    }
                    CompactionTxnHandler.close(rs, stmt, null);
                    CompactionTxnHandler.closeStmt(pStmt);
                    pStmt = dbConn.prepareStatement("INSERT INTO \"COMPLETED_COMPACTIONS\"    (\"CC_ID\", \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\", \"CC_STATE\", \"CC_TYPE\",    \"CC_TBLPROPERTIES\", \"CC_WORKER_ID\", \"CC_START\", \"CC_END\", \"CC_RUN_AS\",    \"CC_HIGHEST_WRITE_ID\", \"CC_META_INFO\", \"CC_HADOOP_JOB_ID\", \"CC_ERROR_MESSAGE\",    \"CC_ENQUEUE_TIME\", \"CC_WORKER_VERSION\", \"CC_INITIATOR_ID\", \"CC_INITIATOR_VERSION\",   \"CC_NEXT_TXN_ID\", \"CC_TXN_ID\", \"CC_COMMIT_TIME\", \"CC_POOL_NAME\", \"CC_NUMBER_OF_BUCKETS\",    \"CC_ORDER_BY\")    VALUES(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    CompactionInfo.insertIntoCompletedCompactions(pStmt, ci, this.getDbTime(dbConn));
                    int updCount = pStmt.executeUpdate();
                    LOG.debug("Inserted {} entries into COMPLETED_COMPACTIONS", (Object)updCount);
                    CompactionTxnHandler.closeStmt(pStmt);
                    dbConn.commit();
                }
                catch (SQLException e) {
                    try {
                        LOG.error("Failed to mark compaction request as " + strState + ", rolling back transaction: " + ci, (Throwable)e);
                        CompactionTxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(e, "updateStatus(" + ci + ")");
                    }
                    catch (Throwable throwable) {
                        CompactionTxnHandler.close(rs, stmt, null);
                        CompactionTxnHandler.close(null, pStmt, dbConn);
                        throw throwable;
                    }
                    CompactionTxnHandler.close(rs, stmt, null);
                    CompactionTxnHandler.close(null, pStmt, dbConn);
                    break block11;
                }
                CompactionTxnHandler.close(rs, stmt, null);
                CompactionTxnHandler.close(null, pStmt, dbConn);
            }
            catch (TxnHandler.RetryException e) {
                this.updateStatus(ci);
            }
        }
    }

    @Override
    @RetrySemantics.CannotRetry
    public void markFailed(CompactionInfo ci) throws MetaException {
        ci.state = (char)(ci.id == 0L ? 97 : 102);
        this.updateStatus(ci);
    }

    @Override
    @RetrySemantics.CannotRetry
    public void markRefused(CompactionInfo info) throws MetaException {
        info.state = (char)99;
        this.updateStatus(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetrySemantics.Idempotent
    public void setHadoopJobId(String hadoopJobId, long id) {
        block6: {
            try {
                Connection dbConn = null;
                Statement stmt = null;
                try {
                    dbConn = this.getDbConn(2);
                    stmt = dbConn.createStatement();
                    String s = "UPDATE \"COMPACTION_QUEUE\" SET \"CQ_HADOOP_JOB_ID\" = " + CompactionTxnHandler.quoteString(hadoopJobId) + " WHERE \"CQ_ID\" = " + id;
                    LOG.debug("Going to execute <" + s + ">  with jobId: " + hadoopJobId + " and CQ id: " + id);
                    int updateCount = stmt.executeUpdate(s);
                    LOG.debug("Going to commit");
                    CompactionTxnHandler.closeStmt(stmt);
                    dbConn.commit();
                }
                catch (SQLException e) {
                    try {
                        LOG.warn("setHadoopJobId(" + hadoopJobId + "," + id + "):" + e.getMessage());
                        LOG.debug("Going to rollback");
                        CompactionTxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(e, "setHadoopJobId(" + hadoopJobId + "," + id + ")");
                        LOG.error("setHadoopJobId(" + hadoopJobId + "," + id + ") failed: " + e.getMessage(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        CompactionTxnHandler.close(null, stmt, dbConn);
                        throw throwable;
                    }
                    CompactionTxnHandler.close(null, stmt, dbConn);
                    break block6;
                }
                CompactionTxnHandler.close(null, stmt, dbConn);
            }
            catch (TxnHandler.RetryException e) {
                this.setHadoopJobId(hadoopJobId, id);
            }
        }
    }

    @Override
    @RetrySemantics.CannotRetry
    public void setCleanerRetryRetentionTimeOnError(CompactionInfo info) throws MetaException {
        block32: {
            try {
                try (Connection dbConn = this.getDbConn(2, connPoolCompaction);){
                    if (info.isAbortedTxnCleanup() && info.id == 0L) {
                        this.insertAbortRetryRetentionTimeOnError(dbConn, info);
                        break block32;
                    }
                    try (PreparedStatement stmt = dbConn.prepareStatement("UPDATE \"COMPACTION_QUEUE\" SET \"CQ_RETRY_RETENTION\" = ?, \"CQ_ERROR_MESSAGE\"= ? WHERE \"CQ_ID\" = ?");){
                        stmt.setLong(1, info.retryRetention);
                        stmt.setString(2, info.errorMessage);
                        stmt.setLong(3, info.id);
                        int updCnt = stmt.executeUpdate();
                        if (updCnt != 1) {
                            LOG.error("Unable to update compaction queue record: {}. updCnt={}", (Object)info, (Object)updCnt);
                            dbConn.rollback();
                            throw new MetaException("No record with CQ_ID=" + info.id + " found in COMPACTION_QUEUE");
                        }
                        LOG.debug("Going to commit");
                        dbConn.commit();
                    }
                    catch (SQLException e) {
                        LOG.error("Unable to update compaction queue: " + e.getMessage());
                        CompactionTxnHandler.rollbackDBConn(dbConn);
                        this.checkRetryable(e, "insertOrSetCleanerRetryRetentionTimeOnError(" + info + ")");
                        throw new MetaException("Unable to update compaction queue: " + e.getMessage());
                    }
                }
                catch (SQLException e) {
                    LOG.error(DB_FAILED_TO_CONNECT + e.getMessage());
                    this.checkRetryable(e, "insertOrSetCleanerRetryRetentionTimeOnError(" + info + ")");
                    throw new MetaException(DB_FAILED_TO_CONNECT + e.getMessage());
                }
            }
            catch (TxnHandler.RetryException e) {
                this.setCleanerRetryRetentionTimeOnError(info);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.Idempotent
    public long findMinOpenTxnIdForCleaner() throws MetaException {
        if (useMinHistoryWriteId) {
            return Long.MAX_VALUE;
        }
        try {
            try (Connection dbConn = this.getDbConn(2, connPoolCompaction);){
                long l = this.getMinOpenTxnIdWaterMark(dbConn);
                return l;
            }
            catch (SQLException e) {
                LOG.error("Unable to fetch minOpenTxnId for Cleaner", (Throwable)e);
                this.checkRetryable(e, "findMinOpenTxnIdForCleaner");
                throw new MetaException("Unable to execute findMinOpenTxnIdForCleaner() " + e.getMessage());
            }
        }
        catch (TxnHandler.RetryException e) {
            return this.findMinOpenTxnIdForCleaner();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RetrySemantics.Idempotent
    @Deprecated
    public long findMinTxnIdSeenOpen() throws MetaException {
        if (!useMinHistoryLevel) return Long.MAX_VALUE;
        if (useMinHistoryWriteId) {
            return Long.MAX_VALUE;
        }
        try {
            try (Connection dbConn = this.getDbConn(2, connPoolCompaction);){
                long minOpenTxn;
                try (Statement stmt = dbConn.createStatement();
                     ResultSet rs = stmt.executeQuery("SELECT MIN(\"MHL_MIN_OPEN_TXNID\") FROM \"MIN_HISTORY_LEVEL\"");){
                    if (!rs.next()) {
                        throw new IllegalStateException("Scalar query returned no rows?!");
                    }
                    minOpenTxn = rs.getLong(1);
                    if (rs.wasNull()) {
                        minOpenTxn = Long.MAX_VALUE;
                    }
                }
                long l = minOpenTxn;
                return l;
            }
            catch (SQLException e) {
                if (DatabaseProduct.isTableNotExistsError(dbProduct, e)) {
                    useMinHistoryLevel = false;
                    return Long.MAX_VALUE;
                }
                LOG.error("Unable to execute findMinTxnIdSeenOpen", (Throwable)e);
                this.checkRetryable(e, "findMinTxnIdSeenOpen");
                throw new MetaException("Unable to execute findMinTxnIdSeenOpen() " + e.getMessage());
            }
        }
        catch (TxnHandler.RetryException e) {
            return this.findMinTxnIdSeenOpen();
        }
    }

    @Override
    protected void updateCommitIdAndCleanUpMetadata(Statement stmt, long txnid, TxnType txnType, Long commitId, long tempId) throws SQLException, MetaException {
        super.updateCommitIdAndCleanUpMetadata(stmt, txnid, txnType, commitId, tempId);
        if (txnType == TxnType.SOFT_DELETE || txnType == TxnType.COMPACTION) {
            stmt.executeUpdate("UPDATE \"COMPACTION_QUEUE\" SET \"CQ_NEXT_TXN_ID\" = " + commitId + ", \"CQ_COMMIT_TIME\" = " + TxnUtils.getEpochFn(dbProduct) + " WHERE \"CQ_TXN_ID\" = " + txnid);
        }
    }

    private Optional<CompactionInfo> getCompactionByTxnId(Connection dbConn, long txnid) throws SQLException, MetaException {
        CompactionInfo info = null;
        try (PreparedStatement pStmt = dbConn.prepareStatement(SELECT_COMPACTION_QUEUE_BY_TXN_ID);){
            pStmt.setLong(1, txnid);
            try (ResultSet rs = pStmt.executeQuery();){
                if (rs.next()) {
                    info = CompactionInfo.loadFullFromCompactionQueue(rs);
                }
            }
        }
        return Optional.ofNullable(info);
    }

    @Override
    public Optional<CompactionInfo> getCompactionByTxnId(long txnId) throws MetaException {
        Optional<CompactionInfo> optional;
        Connection dbConn = null;
        try {
            dbConn = this.getDbConn(2, connPoolCompaction);
            optional = this.getCompactionByTxnId(dbConn, txnId);
        }
        catch (SQLException e) {
            try {
                try {
                    LOG.error("Unable to getCompactionByTxnId", (Throwable)e);
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "getCompactionByTxnId");
                    throw new MetaException("Unable to execute getCompactionByTxnId() " + e.getMessage());
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (TxnHandler.RetryException e2) {
                return this.getCompactionByTxnId(txnId);
            }
        }
        CompactionTxnHandler.closeDbConn(dbConn);
        return optional;
    }

    @Override
    protected void createCommitNotificationEvent(Connection dbConn, long txnid, TxnType txnType) throws MetaException, SQLException {
        super.createCommitNotificationEvent(dbConn, txnid, txnType);
        if (this.transactionalListeners != null) {
            Optional<CompactionInfo> compactionInfo = this.getCompactionByTxnId(dbConn, txnid);
            if (compactionInfo.isPresent()) {
                MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.COMMIT_COMPACTION, new CommitCompactionEvent(txnid, compactionInfo.get()), dbConn, sqlGenerator);
            } else {
                LOG.warn("No compaction queue record found for Compaction type transaction commit. txnId:" + txnid);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateCompactionMetricsData(CompactionMetricsData data) throws MetaException {
        Connection dbConn = null;
        try {
            try {
                boolean updateRes;
                dbConn = this.getDbConn(2);
                CompactionMetricsData prevMetricsData = this.getCompactionMetricsData(data, dbConn);
                if (data.getMetricValue() >= data.getThreshold()) {
                    updateRes = prevMetricsData != null ? this.updateCompactionMetricsData(dbConn, data, prevMetricsData) : this.createCompactionMetricsData(dbConn, data);
                } else {
                    if (prevMetricsData == null) {
                        boolean bl = true;
                        return bl;
                    }
                    updateRes = this.removeCompactionMetricsData(dbConn, data.getDbName(), data.getTblName(), data.getPartitionName(), data.getMetricType());
                }
                boolean bl = updateRes;
                return bl;
            }
            catch (SQLException e) {
                CompactionTxnHandler.rollbackDBConn(dbConn);
                this.checkRetryable(e, "updateCompactionMetricsData(" + data + ")");
                throw new MetaException("Unable to execute updateCompactionMetricsData()" + e.getMessage());
            }
            finally {
                CompactionTxnHandler.closeDbConn(dbConn);
            }
        }
        catch (TxnHandler.RetryException e2) {
            this.updateCompactionMetricsData(data);
            return false;
        }
    }

    @Override
    public List<CompactionMetricsData> getTopCompactionMetricsDataPerType(int limit) throws MetaException {
        Connection dbConn = null;
        ArrayList<CompactionMetricsData> metricsDataList = new ArrayList<CompactionMetricsData>();
        try {
            try {
                dbConn = this.getDbConn(2);
                for (CompactionMetricsData.MetricType type : CompactionMetricsData.MetricType.values()) {
                    String query = sqlGenerator.addLimitClause(limit, NO_SELECT_COMPACTION_METRICS_CACHE_FOR_TYPE_QUERY);
                    try (PreparedStatement pstmt = dbConn.prepareStatement(query);){
                        pstmt.setString(1, type.toString());
                        ResultSet resultSet = pstmt.executeQuery();
                        while (resultSet.next()) {
                            CompactionMetricsData.Builder builder = new CompactionMetricsData.Builder();
                            metricsDataList.add(builder.dbName(resultSet.getString(1)).tblName(resultSet.getString(2)).partitionName(resultSet.getString(3)).metricType(type).metricValue(resultSet.getInt(4)).version(resultSet.getInt(5)).build());
                        }
                    }
                }
            }
            catch (SQLException e) {
                LOG.error("Unable to getCompactionMetricsDataForType");
                this.checkRetryable(e, "getCompactionMetricsDataForType");
                throw new MetaException("Unable to execute getCompactionMetricsDataForType()" + e.getMessage());
            }
            finally {
                CompactionTxnHandler.closeDbConn(dbConn);
            }
        }
        catch (TxnHandler.RetryException e) {
            return this.getTopCompactionMetricsDataPerType(limit);
        }
        return metricsDataList;
    }

    @Override
    public CompactionMetricsData getCompactionMetricsData(String dbName, String tblName, String partitionName, CompactionMetricsData.MetricType type) throws MetaException {
        CompactionMetricsData compactionMetricsData;
        Connection dbConn = null;
        try {
            dbConn = this.getDbConn(2);
            compactionMetricsData = this.getCompactionMetricsData(new CompactionMetricsData.Builder().dbName(dbName).tblName(tblName).partitionName(partitionName).metricType(type).build(), dbConn);
        }
        catch (SQLException e) {
            try {
                try {
                    CompactionTxnHandler.rollbackDBConn(dbConn);
                    this.checkRetryable(e, "getCompactionMetricsData(" + dbName + ", " + tblName + ", " + partitionName + ", " + (Object)((Object)type) + ")");
                    throw new MetaException("Unable to execute getCompactionMetricsData()" + e.getMessage());
                }
                catch (Throwable throwable) {
                    CompactionTxnHandler.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (TxnHandler.RetryException e2) {
                this.getCompactionMetricsData(dbName, tblName, partitionName, type);
                return null;
            }
        }
        CompactionTxnHandler.closeDbConn(dbConn);
        return compactionMetricsData;
    }

    private CompactionMetricsData getCompactionMetricsData(CompactionMetricsData data, Connection dbConn) throws SQLException {
        String query = SELECT_COMPACTION_METRICS_CACHE_QUERY;
        query = data.getPartitionName() != null ? query + " AND \"CMC_PARTITION\" = ?" : query + " AND \"CMC_PARTITION\" IS NULL";
        try (PreparedStatement pstmt = dbConn.prepareStatement(query);){
            pstmt.setString(1, data.getDbName());
            pstmt.setString(2, data.getTblName());
            pstmt.setString(3, data.getMetricType().toString());
            if (data.getPartitionName() != null) {
                pstmt.setString(4, data.getPartitionName());
            }
            ResultSet resultSet = pstmt.executeQuery();
            CompactionMetricsData.Builder builder = new CompactionMetricsData.Builder();
            if (resultSet.next()) {
                CompactionMetricsData compactionMetricsData = builder.dbName(data.getDbName()).tblName(data.getTblName()).partitionName(data.getPartitionName()).metricType(data.getMetricType()).metricValue(resultSet.getInt(1)).version(resultSet.getInt(2)).build();
                return compactionMetricsData;
            }
            CompactionMetricsData compactionMetricsData = null;
            return compactionMetricsData;
        }
    }

    @Override
    public void removeCompactionMetricsData(String dbName, String tblName, String partitionName, CompactionMetricsData.MetricType type) throws MetaException {
        Connection dbConn = null;
        try {
            try {
                dbConn = this.getDbConn(2);
                this.removeCompactionMetricsData(dbConn, dbName, tblName, partitionName, type);
            }
            catch (SQLException e) {
                CompactionTxnHandler.rollbackDBConn(dbConn);
                this.checkRetryable(e, "removeCompactionMetricsData(" + dbName + ", " + tblName + ", " + partitionName + ", " + (Object)((Object)type) + ")");
                throw new MetaException("Unable to execute removeCompactionMetricsData()" + e.getMessage());
            }
            finally {
                CompactionTxnHandler.closeDbConn(dbConn);
            }
        }
        catch (TxnHandler.RetryException e) {
            this.removeCompactionMetricsData(dbName, tblName, partitionName, type);
        }
    }

    private boolean removeCompactionMetricsData(Connection dbConn, String dbName, String tblName, String partitionName, CompactionMetricsData.MetricType type) throws SQLException {
        boolean removeRes;
        String query = DELETE_COMPACTION_METRICS_CACHE_QUERY;
        query = partitionName != null ? query + " AND \"CMC_PARTITION\" = ?" : query + " AND \"CMC_PARTITION\" IS NULL";
        try (PreparedStatement pstmt = dbConn.prepareStatement(query);){
            pstmt.setString(1, dbName);
            pstmt.setString(2, tblName);
            pstmt.setString(3, type.toString());
            if (partitionName != null) {
                pstmt.setString(4, partitionName);
            }
            removeRes = pstmt.executeUpdate() > 0;
            dbConn.commit();
        }
        return removeRes;
    }

    private boolean updateCompactionMetricsData(Connection dbConn, CompactionMetricsData data, CompactionMetricsData prevData) throws SQLException {
        boolean updateRes;
        String query = UPDATE_COMPACTION_METRICS_CACHE_QUERY;
        query = data.getPartitionName() != null ? query + " AND \"CMC_PARTITION\" = ?" : query + " AND \"CMC_PARTITION\" IS NULL";
        try (PreparedStatement pstmt = dbConn.prepareStatement(query);){
            pstmt.setInt(1, data.getMetricValue());
            pstmt.setInt(2, prevData.getVersion() + 1);
            pstmt.setString(3, data.getDbName());
            pstmt.setString(4, data.getTblName());
            pstmt.setString(5, data.getMetricType().toString());
            pstmt.setInt(6, prevData.getVersion());
            if (data.getPartitionName() != null) {
                pstmt.setString(7, data.getPartitionName());
            }
            updateRes = pstmt.executeUpdate() > 0;
            dbConn.commit();
        }
        return updateRes;
    }

    private boolean createCompactionMetricsData(Connection dbConn, CompactionMetricsData data) throws SQLException {
        boolean createRes;
        try (PreparedStatement pstmt = dbConn.prepareStatement(INSERT_COMPACTION_METRICS_CACHE_QUERY);){
            pstmt.setString(1, data.getDbName());
            pstmt.setString(2, data.getTblName());
            pstmt.setString(3, data.getPartitionName());
            pstmt.setString(4, data.getMetricType().toString());
            pstmt.setInt(5, data.getMetricValue());
            pstmt.setInt(6, 1);
            createRes = pstmt.executeUpdate() > 0;
            dbConn.commit();
        }
        return createRes;
    }

    static {
        DELETE_FAILED_TXNS_SQL = "DELETE FROM \"TXNS\" WHERE \"TXN_ID\" NOT IN (SELECT \"TC_TXNID\" FROM \"TXN_COMPONENTS\") AND \"TXN_STATE\" = " + (Object)((Object)TxnStatus.ABORTED);
        SELECT_ABORTS_WITH_MIN_OPEN_WRITETXN_QUERY = "SELECT  \"res1\".\"TC_DATABASE\" AS \"DB\", \"res1\".\"TC_TABLE\" AS \"TBL\", \"res1\".\"TC_PARTITION\" AS \"PART\",  \"res1\".\"MIN_TXN_START_TIME\" AS \"MIN_TXN_START_TIME\", \"res1\".\"ABORTED_TXN_COUNT\" AS \"ABORTED_TXN_COUNT\",  \"res2\".\"MIN_OPEN_WRITE_TXNID\" AS \"MIN_OPEN_WRITE_TXNID\", \"res3\".\"RETRY_RETENTION\" AS \"RETRY_RETENTION\",  \"res3\".\"ID\" AS \"RETRY_CQ_ID\"  FROM  ( SELECT \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", MIN(\"TXN_STARTED\") AS \"MIN_TXN_START_TIME\",  COUNT(*) AS \"ABORTED_TXN_COUNT\" FROM \"TXNS\", \"TXN_COMPONENTS\"  WHERE \"TXN_ID\" = \"TC_TXNID\" AND \"TXN_STATE\" = " + (Object)((Object)TxnStatus.ABORTED) + " GROUP BY \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\" %s ) \"res1\"  LEFT JOIN( SELECT \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", MIN(\"TC_TXNID\") AS \"MIN_OPEN_WRITE_TXNID\"  FROM \"TXNS\", \"TXN_COMPONENTS\"  WHERE \"TXN_ID\" = \"TC_TXNID\" AND \"TXN_STATE\" = " + (Object)((Object)TxnStatus.OPEN) + " GROUP BY \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\" ) \"res2\" ON \"res1\".\"TC_DATABASE\" = \"res2\".\"TC_DATABASE\" AND \"res1\".\"TC_TABLE\" = \"res2\".\"TC_TABLE\" AND (\"res1\".\"TC_PARTITION\" = \"res2\".\"TC_PARTITION\"  OR (\"res1\".\"TC_PARTITION\" IS NULL AND \"res2\".\"TC_PARTITION\" IS NULL))  LEFT JOIN ( SELECT \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\", MAX(\"CQ_ID\") AS \"ID\",  MAX(\"CQ_RETRY_RETENTION\") AS \"RETRY_RETENTION\",  MIN(\"CQ_COMMIT_TIME\") - %s + MAX(\"CQ_RETRY_RETENTION\") AS \"RETRY_RECORD_CHECK\" FROM \"COMPACTION_QUEUE\"  WHERE \"CQ_TYPE\" = " + CompactionTxnHandler.quoteChar('c') + " GROUP BY \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\") \"res3\"  ON \"res1\".\"TC_DATABASE\" = \"res3\".\"CQ_DATABASE\"  AND \"res1\".\"TC_TABLE\" = \"res3\".\"CQ_TABLE\"  AND (\"res1\".\"TC_PARTITION\" = \"res3\".\"CQ_PARTITION\"  OR (\"res1\".\"TC_PARTITION\" IS NULL AND \"res3\".\"CQ_PARTITION\" IS NULL)) WHERE \"res3\".\"RETRY_RECORD_CHECK\" <= 0 OR \"res3\".\"RETRY_RECORD_CHECK\" IS NULL";
        DELETE_CQ_AND_ABORT_ENTRIES = "DELETE FROM \"COMPACTION_QUEUE\" WHERE \"CQ_ID\" = ? OR ( \"CQ_DATABASE\" = ? AND \"CQ_TABLE\" = ?  AND \"CQ_PARTITION\" %s AND \"CQ_TYPE\" = " + CompactionTxnHandler.quoteChar('c') + " )";
    }

    private static class RetentionCounters {
        int didNotInitiateRetention;
        int failedRetention;
        int succeededRetention;
        int refusedRetention;
        boolean hasSucceededMajorCompaction = false;
        boolean hasSucceededMinorCompaction = false;

        RetentionCounters(int didNotInitiateRetention, int failedRetention, int succeededRetention, int refusedRetention) {
            this.didNotInitiateRetention = didNotInitiateRetention;
            this.failedRetention = failedRetention;
            this.succeededRetention = succeededRetention;
            this.refusedRetention = refusedRetention;
        }
    }
}

