/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.thrift;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCustomSocket
extends TSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TCustomSocket.class.getName());
    private final int bufferSize;

    public TCustomSocket(Socket socket, int bufferSize) throws TTransportException {
        super(socket);
        this.bufferSize = bufferSize;
        LOGGER.info("Buffer size for TSocket is: " + bufferSize);
        if (this.isOpen()) {
            try {
                if (bufferSize == -1) {
                    this.inputStream_ = this.getSocket().getInputStream();
                    this.outputStream_ = this.getSocket().getOutputStream();
                } else {
                    this.inputStream_ = new BufferedInputStream(this.getSocket().getInputStream(), bufferSize);
                    this.outputStream_ = new BufferedOutputStream(this.getSocket().getOutputStream(), bufferSize);
                }
            }
            catch (IOException iox) {
                this.close();
                throw new TTransportException(1, (Throwable)iox);
            }
        }
    }

    public TCustomSocket(String host, int port, int socketTimeout, int connectTimeout, int bufferSize) throws TTransportException {
        super(new TConfiguration(), host, port, socketTimeout, connectTimeout);
        this.bufferSize = bufferSize;
        LOGGER.info("Buffer size for TSocket is: " + bufferSize);
    }

    public void open() throws TTransportException {
        super.open();
        try {
            if (this.bufferSize == -1) {
                this.inputStream_ = this.getSocket().getInputStream();
                this.outputStream_ = this.getSocket().getOutputStream();
            } else {
                this.inputStream_ = new BufferedInputStream(this.getSocket().getInputStream(), this.bufferSize);
                this.outputStream_ = new BufferedOutputStream(this.getSocket().getOutputStream(), this.bufferSize);
            }
        }
        catch (IOException iox) {
            this.close();
            throw new TTransportException(1, (Throwable)iox);
        }
    }
}

