/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.thrift;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.hadoop.hive.metastore.thrift.TCustomSocket;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCustomServerSocket
extends TServerSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TCustomServerSocket.class.getName());
    private int timeout;
    private int bufferSize;

    public TCustomServerSocket(ServerSocket serverSocket, int timeout, int bufferSize) throws TTransportException {
        super(serverSocket, timeout);
        this.timeout = timeout;
        this.bufferSize = bufferSize;
    }

    public TCustomServerSocket(InetSocketAddress bindAddr, int bufferSize) throws TTransportException {
        super(bindAddr);
        this.bufferSize = bufferSize;
        this.timeout = 0;
    }

    protected TSocket acceptImpl() throws TTransportException {
        ServerSocket serverSocket = this.getServerSocket();
        if (serverSocket == null) {
            throw new TTransportException(1, "No underlying server socket.");
        }
        try {
            Socket result = serverSocket.accept();
            TCustomSocket result2 = new TCustomSocket(result, this.bufferSize);
            result2.setTimeout(this.timeout);
            return result2;
        }
        catch (IOException iox) {
            throw new TTransportException((Throwable)iox);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }
}

