/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.metasummary;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.metasummary.SummaryMapBuilder;

public class MetadataTableSummary {
    private String catalogName;
    private String dbName;
    private String tblName;
    private String owner;
    private int colCount;
    private int partitionColumnCount;
    private int partitionCount;
    private long totalSize;
    private long numRows;
    private long numFiles;
    private String tableType;
    private String fileFormat;
    private String compressionType;
    private int arrayColumnCount;
    private int structColumnCount;
    private int mapColumnCount;
    private Map<String, Object> summary;
    private transient boolean dropped = false;
    private transient long tableId;

    public MetadataTableSummary(String catalogName, String db, String tableName, String owner) {
        this.catalogName = catalogName;
        this.owner = owner;
        this.dbName = db;
        this.tblName = tableName;
    }

    public MetadataTableSummary() {
    }

    public MetadataTableSummary columnSummary(int columnCount, int arrayColCount, int structColCount, int mapColCount) {
        this.colCount = columnCount;
        this.arrayColumnCount = arrayColCount;
        this.structColumnCount = structColCount;
        this.mapColumnCount = mapColCount;
        return this;
    }

    public MetadataTableSummary partitionSummary(int partColCount, int partCount) {
        this.partitionCount = partCount;
        this.partitionColumnCount = partColCount;
        return this;
    }

    public MetadataTableSummary tableFormatSummary(String tblType, String compression, String fileFormat) {
        this.tableType = tblType;
        this.compressionType = compression;
        this.fileFormat = fileFormat;
        return this;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getTblName() {
        return this.tblName;
    }

    public void setTblName(String tblName) {
        this.tblName = tblName;
    }

    public int getColCount() {
        return this.colCount;
    }

    public void setColCount(int colCount) {
        this.colCount = colCount;
    }

    public int getPartitionColumnCount() {
        return this.partitionColumnCount;
    }

    public void setPartitionColumnCount(int partitionColumnCount) {
        this.partitionColumnCount = partitionColumnCount;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(int partitionCount) {
        this.partitionCount = partitionCount;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public long getNumRows() {
        return this.numRows;
    }

    public void setNumRows(long numRows) {
        this.numRows = numRows;
    }

    public long getNumFiles() {
        return this.numFiles;
    }

    public void setNumFiles(long numFiles) {
        this.numFiles = numFiles;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public void setArrayColumnCount(int arrayColumnCount) {
        this.arrayColumnCount = arrayColumnCount;
    }

    public int getArrayColumnCount() {
        return this.arrayColumnCount;
    }

    public void setStructColumnCount(int structColumnCount) {
        this.structColumnCount = structColumnCount;
    }

    public int getStructColumnCount() {
        return this.structColumnCount;
    }

    public void setMapColumnCount(int mapColumnCount) {
        this.mapColumnCount = mapColumnCount;
    }

    public int getMapColumnCount() {
        return this.mapColumnCount;
    }

    public Map<String, Object> getExtraSummary() {
        return this.summary;
    }

    public MetadataTableSummary addExtra(String key, SummaryMapBuilder builder) {
        if (this.summary == null) {
            this.summary = new HashMap<String, Object>();
        }
        this.summary.put(key, builder.build());
        return this;
    }

    public void addExtra(SummaryMapBuilder builder) {
        if (this.summary == null) {
            this.summary = new HashMap<String, Object>();
        }
        this.summary.putAll(builder.build());
    }

    public String toString() {
        return "TableSummary {owner='" + this.owner + '\'' + ", db_name='" + this.dbName + '\'' + ", table_name='" + this.tblName + '\'' + ", column_count=" + this.colCount + ", partition_count=" + this.partitionCount + ", table_type='" + this.tableType + '\'' + ", file_format='" + this.fileFormat + '\'' + ", compression_type='" + this.compressionType + ", numRows=" + this.numRows + ", numFiles=" + this.numFiles + ", size_bytes=" + this.totalSize + ", partition_column_count=" + this.partitionColumnCount + ", array_column_count=" + this.arrayColumnCount + ", struct_column_count=" + this.structColumnCount + ", map_column_count=" + this.mapColumnCount + '}';
    }

    public String toCSV(List<String> fields) {
        StringBuilder csv = new StringBuilder().append(this.dbName).append(",").append(this.tblName).append(",").append(this.owner).append(",").append(this.colCount).append(",").append(this.partitionCount).append(",").append(this.tableType).append(",").append(this.fileFormat).append(",").append(this.compressionType).append(",").append(this.numRows).append(",").append(this.numFiles).append(",").append(this.totalSize).append(",").append(this.partitionColumnCount).append(",").append(this.arrayColumnCount).append(",").append(this.structColumnCount).append(",").append(this.mapColumnCount).append(",");
        if (!fields.isEmpty()) {
            csv.append(fields.stream().map(key -> {
                Object value;
                Object object = value = this.summary != null ? this.summary.get(key) : null;
                if (value == null) {
                    return "";
                }
                return String.valueOf(value);
            }).collect(Collectors.joining(",")));
            csv.append(",");
        }
        return csv.toString();
    }

    public boolean isDropped() {
        return this.dropped;
    }

    public void setDropped(boolean dropped) {
        this.dropped = dropped;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public long getTableId() {
        return this.tableId;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }
}

