/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.messaging.MessageEncoder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageEncoder;
import org.apache.hadoop.hive.metastore.messaging.json.gzip.GzipJSONMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)MessageFactory.class.getName());
    protected static final Configuration conf = MetastoreConf.newMetastoreConf();
    private static final Map<String, Method> registry = new HashMap<String, Method>();

    public static void register(String messageFormat, Class clazz) {
        Method method = MessageFactory.requiredMethod(clazz);
        registry.put(messageFormat, method);
    }

    private static Method requiredMethod(Class clazz) {
        if (MessageEncoder.class.isAssignableFrom(clazz)) {
            try {
                Method methodInstance = clazz.getMethod("getInstance", new Class[0]);
                if (MessageEncoder.class.isAssignableFrom(methodInstance.getReturnType())) {
                    int modifiers = methodInstance.getModifiers();
                    if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers)) {
                        return methodInstance;
                    }
                    throw new NoSuchMethodException("modifier for getInstance() method is not 'public static' in " + clazz.getCanonicalName());
                }
                throw new NoSuchMethodException("return type is not assignable to " + MessageEncoder.class.getCanonicalName());
            }
            catch (NoSuchMethodException e) {
                String message = clazz.getCanonicalName() + " does not implement the required 'public static MessageEncoder getInstance()' method ";
                LOG.error(message, (Throwable)e);
                throw new IllegalArgumentException(message, e);
            }
        }
        String message = clazz.getCanonicalName() + " is not assignable to " + MessageEncoder.class.getCanonicalName();
        LOG.error(message);
        throw new IllegalArgumentException(message);
    }

    public static MessageEncoder getInstance(String compressionFormat) throws InvocationTargetException, IllegalAccessException {
        Method methodInstance = registry.get(compressionFormat.toLowerCase());
        if (methodInstance == null) {
            LOG.error("received incorrect CompressionFormat " + compressionFormat);
            throw new RuntimeException("compressionFormat: " + compressionFormat + " is not supported.");
        }
        return (MessageEncoder)methodInstance.invoke(null, new Object[0]);
    }

    public static MessageEncoder getDefaultInstanceForReplMetrics(Configuration conf) {
        return MessageFactory.getInstance(conf, MetastoreConf.ConfVars.REPL_MESSAGE_FACTORY.getVarname());
    }

    public static MessageEncoder getDefaultInstance(Configuration conf) {
        return MessageFactory.getInstance(conf, MetastoreConf.ConfVars.EVENT_MESSAGE_FACTORY.getVarname());
    }

    public static MessageEncoder getInstance(Configuration conf, String config) {
        String clazz = MetastoreConf.get(conf, config);
        try {
            Class<?> clazzObject = MessageFactory.class.getClassLoader().loadClass(clazz);
            return (MessageEncoder)MessageFactory.requiredMethod(clazzObject).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            String message = "could not load the configured class " + clazz;
            LOG.error(message, (Throwable)e);
            throw new IllegalStateException(message, e);
        }
    }

    static {
        MessageFactory.register("gzip(json-2.0)", GzipJSONMessageEncoder.class);
        MessageFactory.register("json-0.2", JSONMessageEncoder.class);
        MessageFactory.register(supportedCompressionFormats.GZIP.toString().toLowerCase(), GzipJSONMessageEncoder.class);
    }

    public static enum supportedCompressionFormats {
        GZIP;

    }
}

