/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.localcache;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hive.metastore.HMSConverter;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.localcache.HMSPartitionConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionCacheHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionCacheHelper.class);
    private final GetPartitionsByNamesRequest rqst;
    private final Level level;
    private final List<Partition> partitionsInCache;
    private final List<String> partitionNamesMissing;
    private final HMSConverter hmsConverter;
    private final HMSPartitionConverter partitionConverter;
    private final Table table;

    public PartitionCacheHelper(GetPartitionsByNamesRequest rqst, HMSConverter hmsConverter, Table table, Level level) throws MetaException {
        this(null, rqst, hmsConverter, table, level);
    }

    public PartitionCacheHelper(CacheValue cachedValue, GetPartitionsByNamesRequest rqst, HMSConverter hmsConverter, Table table, Level level) throws MetaException {
        this.rqst = rqst;
        this.level = level;
        Pair<List<Partition>, List<String>> foundAndMissingPartitionPair = this.analyzePartitionsInCache(rqst, cachedValue);
        this.partitionsInCache = (List)foundAndMissingPartitionPair.getLeft();
        this.partitionNamesMissing = (List)foundAndMissingPartitionPair.getRight();
        this.hmsConverter = hmsConverter;
        this.partitionConverter = hmsConverter == null ? null : hmsConverter.getPartitionConverter(rqst, table);
        this.table = table;
    }

    public boolean cacheContainsAllPartitions() {
        return this.partitionNamesMissing.isEmpty();
    }

    public GetPartitionsByNamesRequest getMissingNamesRequest() {
        GetPartitionsByNamesRequest newRqst = new GetPartitionsByNamesRequest(this.rqst);
        newRqst.setNames(this.partitionNamesMissing);
        return newRqst;
    }

    public void addToCache(GetPartitionsByNamesRequest missingNamesRequest, GetPartitionsByNamesResult missingNamesResult, CacheValue cacheValue) throws MetaException {
        Preconditions.checkState((missingNamesRequest.getNames().size() == missingNamesResult.getPartitions().size() ? 1 : 0) != 0);
        for (int i = 0; i < missingNamesRequest.getNames().size(); ++i) {
            String name = missingNamesRequest.getNames().get(i);
            Partition partition = missingNamesResult.getPartitions().get(i);
            cacheValue.partitionsMap.put(name, partition);
        }
        if (this.partitionConverter != null) {
            this.partitionConverter.addToPartitionCache(missingNamesRequest, cacheValue, missingNamesResult);
        }
    }

    private Pair<List<Partition>, List<String>> analyzePartitionsInCache(GetPartitionsByNamesRequest rqst, CacheValue cachedValue) throws MetaException {
        ArrayList<Partition> partitionsFound = new ArrayList<Partition>();
        ArrayList<String> partitionNamesMissing = new ArrayList<String>();
        ArrayList<String> partitionNamesFound = new ArrayList<String>();
        if (cachedValue == null || cachedValue.partitionsMap.size() == 0) {
            partitionNamesMissing.addAll(rqst.getNames());
            return Pair.of(partitionsFound, partitionNamesMissing);
        }
        for (String partitionName : rqst.getNames()) {
            Partition cachedPartition = cachedValue.partitionsMap.get(partitionName);
            if (cachedPartition == null) {
                partitionNamesMissing.add(partitionName);
                continue;
            }
            partitionsFound.add(cachedPartition);
            partitionNamesFound.add(partitionName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} level HMS cache: method=analyzePartitionsInCache, dbName={}, tblName={}, fileMetadata={}, partitionNames hit={}", new Object[]{this.level, rqst.getDb_name(), rqst.getTbl_name(), rqst.isGetFileMetadata(), partitionNamesFound});
            LOG.debug("{} level HMS cache miss: method=analyzePartitionsInCache, dbName={}, tblName={}, fileMetadata={}, partitionNames missing={}", new Object[]{this.level, rqst.getDb_name(), rqst.getTbl_name(), rqst.isGetFileMetadata(), partitionNamesMissing});
        }
        return Pair.of(partitionsFound, partitionNamesMissing);
    }

    public GetPartitionsByNamesResult fetchRequestedResultFromCache(CacheValue cacheValue) throws MetaException {
        ArrayList<Partition> resultPartitions = new ArrayList<Partition>();
        for (String partitionName : this.rqst.getNames()) {
            resultPartitions.add(cacheValue.partitionsMap.get(partitionName));
        }
        GetPartitionsByNamesResult result = new GetPartitionsByNamesResult(resultPartitions);
        if (this.partitionConverter != null) {
            result = this.partitionConverter.createPartitionsByNamesResult(result, cacheValue);
        }
        return result;
    }

    public GetPartitionsByNamesResult fetchRequestedResult(GetPartitionsByNamesResult result) throws MetaException {
        if (this.partitionConverter == null) {
            return result;
        }
        CacheValue cacheValue = PartitionCacheHelper.createCacheValue(this.rqst, this.hmsConverter, this.table, false);
        this.partitionConverter.addToPartitionCache(this.rqst, cacheValue, result);
        return this.partitionConverter.createPartitionsByNamesResult(result, cacheValue);
    }

    public static CacheValue createCacheValue(GetPartitionsByNamesRequest rqst, HMSConverter converter, Table table, boolean isConcurrent) {
        if (converter == null) {
            return new CacheValue();
        }
        HMSPartitionConverter partitionConverter = converter.getPartitionConverter(rqst, table);
        return partitionConverter == null ? new CacheValue() : partitionConverter.createConverterPartitionCacheValue(isConcurrent);
    }

    public static class CacheValue {
        public ConcurrentHashMap<String, Partition> partitionsMap = new ConcurrentHashMap();
    }

    public static enum Level {
        HS2,
        QUERY;

    }
}

