/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.leader;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.leader.LeaderElection;
import org.apache.hadoop.hive.metastore.leader.LeaseLeaderElection;
import org.apache.hadoop.hive.metastore.leader.StaticLeaderElection;

public class LeaderElectionFactory {
    public static LeaderElection create(Configuration conf) throws IOException {
        String method = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_ELECTION);
        switch (method.toLowerCase()) {
            case "host": {
                return new StaticLeaderElection();
            }
            case "lock": {
                return new LeaseLeaderElection();
            }
        }
        throw new UnsupportedOperationException(method + " is not supported for electing the leader");
    }
}

